/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jsbchart.core.ChartManager;
import jsbugs.DialogMatchAnalysts;
import jsbugs.DialogMatchIGDScheme;
import jsbugs.DialogPermissions;
import jsbugs.FrameInterpretations;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOrganiser;
import jsbugs.SbugsMLdocument;
import jsbugs.list.RestrictableListRenderer;
import jsbugs.model2.igdscheme.DialogIGDScheme;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDScheme;
import model3.Lastval;
import model3.SBRestrictable;
import model3.SBdb;
import org.jdom2.Document;
import util.SBException;
import util.SbugsFileFilter;
import util.exception.StackError;

public class DialogChronSchemes
extends JDialog {
    private final DefaultListModel model = new DefaultListModel();
    private final SBdb sbdb;
    private final FrameInterpretations parent;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonPermission;
    private JButton jButtonRead;
    private JButton jButtonWrite;
    private JList jListSchemes;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public DialogChronSchemes(FrameInterpretations parent, boolean modal, SBdb sbdb) throws SQLException {
        super((Frame)parent, modal);
        this.sbdb = sbdb;
        this.parent = parent;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Magnetostratigraphy Schemes");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.refreshModel();
        if (!SBRestrictable.canWrite(this.sbdb)) {
            this.jButtonDelete.setEnabled(false);
            this.jButtonDelete.setToolTipText(SBRestrictable.getDeniedReason(false));
        }
        this.jListSchemes.setCellRenderer(new RestrictableListRenderer());
    }

    private void refreshModel() throws SQLException {
        this.model.removeAllElements();
        for (IGDScheme scheme : this.sbdb.getMagnetoSchemes()) {
            this.model.addElement(scheme);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListSchemes = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonWrite = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonPermission = new JButton();
        this.setDefaultCloseOperation(2);
        this.jListSchemes.setModel(this.model);
        this.jListSchemes.setSelectionMode(0);
        this.jListSchemes.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogChronSchemes this$0;
            {
                DialogChronSchemes dialogChronSchemes = this$0;
                Objects.requireNonNull(dialogChronSchemes);
                this.this$0 = dialogChronSchemes;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListSchemesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListSchemes);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChronSchemes this$0;
            {
                DialogChronSchemes dialogChronSchemes = this$0;
                Objects.requireNonNull(dialogChronSchemes);
                this.this$0 = dialogChronSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChronSchemes this$0;
            {
                DialogChronSchemes dialogChronSchemes = this$0;
                Objects.requireNonNull(dialogChronSchemes);
                this.this$0 = dialogChronSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChronSchemes this$0;
            {
                DialogChronSchemes dialogChronSchemes = this$0;
                Objects.requireNonNull(dialogChronSchemes);
                this.this$0 = dialogChronSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChronSchemes this$0;
            {
                DialogChronSchemes dialogChronSchemes = this$0;
                Objects.requireNonNull(dialogChronSchemes);
                this.this$0 = dialogChronSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChronSchemes this$0;
            {
                DialogChronSchemes dialogChronSchemes = this$0;
                Objects.requireNonNull(dialogChronSchemes);
                this.this$0 = dialogChronSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChronSchemes this$0;
            {
                DialogChronSchemes dialogChronSchemes = this$0;
                Objects.requireNonNull(dialogChronSchemes);
                this.this$0 = dialogChronSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonWrite.setText("Write...");
        this.jButtonWrite.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChronSchemes this$0;
            {
                DialogChronSchemes dialogChronSchemes = this$0;
                Objects.requireNonNull(dialogChronSchemes);
                this.this$0 = dialogChronSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWriteActionPerformed(evt);
            }
        });
        this.jButtonPermission.setText("Permissions...");
        this.jButtonPermission.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonPermission.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChronSchemes this$0;
            {
                DialogChronSchemes dialogChronSchemes = this$0;
                Objects.requireNonNull(dialogChronSchemes);
                this.this$0 = dialogChronSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPermissionActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 207, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonPermission, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonEdit, GroupLayout.Alignment.TRAILING, -2, 87, -2)).addComponent(this.jButtonAdd, GroupLayout.Alignment.TRAILING, -2, 87, -2)).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -2, 87, -2)).addComponent(this.jButtonRead, GroupLayout.Alignment.TRAILING, -2, 87, -2)).addComponent(this.jButtonWrite, GroupLayout.Alignment.TRAILING, -2, 87, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPermission).addGap(10, 10, 10).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonWrite).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 115, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogIGDScheme dialog = new DialogIGDScheme(this, true, this.sbdb, null, 26, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.refreshModel();
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = (IGDScheme)this.jListSchemes.getSelectedValue();
        try {
            DialogIGDScheme dialog = new DialogIGDScheme(this, true, this.sbdb, scheme, 26, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.refreshModel();
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
    }

    private void jListSchemesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = (IGDScheme)this.jListSchemes.getSelectedValue();
        try {
            if (JOptionPane.showConfirmDialog(this, "Really delete '" + String.valueOf(scheme) + "'?", this.getTitle(), 0, 3) == 0) {
                if (!ChartManager.checkDeleteIGDScheme(this.sbdb, scheme.getID())) {
                    JOptionPane.showMessageDialog(this, "You can't delete this scheme because it is used in charts.", "Delete Scheme", 2);
                    return;
                }
                this.sbdb.deleteIGDScheme(scheme);
                this.sbdb.commit();
                this.model.removeElement(scheme);
            }
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("magnetostrat.html");
    }

    private void jButtonWriteActionPerformed(ActionEvent evt) {
        this.writeXML();
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        this.readXML();
    }

    private void jButtonPermissionActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select scheme(s)", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = (IGDScheme)this.jListSchemes.getSelectedValue();
        try {
            DialogPermissions dialog = new DialogPermissions(this.parent, true, this.sbdb, (SBRestrictable)scheme, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.jListSchemes.repaint();
            }
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this, sbe.toString(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXML() {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select scheme(s)", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = (IGDScheme)this.jListSchemes.getSelectedValue();
        JFileChooser jFileChooserXML = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("xml");
        filter.setDescription("XML files");
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "JXMLFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            jFileChooserXML.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        jFileChooserXML.setFileFilter((FileFilter)filter);
        jFileChooserXML.setSelectedFile(new File(scheme.toString()));
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (0 == jFileChooserXML.showSaveDialog(this)) {
                if (jFileChooserXML.getSelectedFile().exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                File file = jFileChooserXML.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith("xml")) {
                    file = new File(file.getPath() + ".xml");
                }
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
                SBdb ws = new SBdb(this.sbdb);
                ws.addIGDScheme(IGDScheme.copyToWorkspace(ws, scheme));
                ws.writeXML(out, new HashSet<Integer>(), this.sbdb, null, true, false);
                Lastval.putString(this.sbdb, "JXMLFILE", file.getPath());
                this.sbdb.commit();
            }
        }
        catch (IOException se) {
            JOptionPane.showMessageDialog(this.parent, se.getMessage(), "IGD Scheme", 2);
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXML() {
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Scheme files (xml, sbg)", "xml", "sbg");
        jFileChooser.setFileFilter(filter);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "JXMLFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                File file = jFileChooser.getSelectedFile();
                Document xmlDocument = SbugsMLdocument.getXmlDocument(file);
                HashSet<Integer> dTypes = new HashSet<Integer>();
                SBdb ws = new SBdb(this.sbdb);
                LinkedList<SBException> exceptions = new LinkedList<SBException>();
                Logger logger = Logger.getLogger(FrameOrganiser.class.getName() + " XML File Read");
                ws.parseXMLDocument(xmlDocument, dTypes, null, "", 0, exceptions);
                if (!exceptions.isEmpty()) {
                    Object msg = "The following errors were found while reading the file ...";
                    int exCount = 0;
                    for (SBException sb : exceptions) {
                        if (++exCount < 20) {
                            msg = (String)msg + "\n" + sb.getMessage();
                        }
                        logger.log(Level.WARNING, sb.getMessage(), sb);
                    }
                    JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                }
                System.out.println("File read successful...");
                if (!ws.getUsers().isEmpty()) {
                    DialogMatchAnalysts dialog = new DialogMatchAnalysts(this.parent, true, ws, this.sbdb, true);
                    dialog.setLocationRelativeTo(this.parent);
                    dialog.setVisible(true);
                    if (!dialog.isOK()) {
                        return;
                    }
                }
                for (IGDScheme scheme : ws.getIGDSchemes(26)) {
                    DialogMatchIGDScheme dialog = new DialogMatchIGDScheme(this.parent, true, scheme, this.sbdb, false);
                    dialog.setLocationRelativeTo(this.parent);
                    dialog.setVisible(true);
                }
                this.refreshModel();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            catch (Exception e) {
                StackError.showStackError((String)"Error reading file", (Throwable)e);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

