/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import model3.SBdb;
import model3.project.Project;
import util.SB;

public class DialogDBInfo
extends JDialog {
    private static final String[] TABLES = new String[]{"Wells", "Projects", "Well Lists", "Samples", "Analyses", "Occurrences", "Images", "Versions", "Depth/Age Curves", "Stratigraphic Intervals", "Environment Intervals", "Events", "Biostratigraphic Comments", "Sequence Picks", "Interval Comments", "Faults", "Wireline Log Curves", "Users/analysts", "Species", "Genera", "Categories", "Taxon Groups", "Stratigraphic Schemes", "Composite Standards", "Palaeoenvironment Schemes", "Age Curves", "Charts", "Block Templates", "Panel Templates", "Correlation Templates"};
    private static final String[] BLANK_AFTER = new String[]{"Images", "Wireline Log Curves", "Taxon Groups", "Age Curves"};
    private static final String[] PROJECT_TABLES = new String[]{"Wells", "Taxon Groups", "Group Sets", "Charts", "Block Templates", "Panel Templates", "Correlation Templates"};
    private final TableModelInfo model = new TableModelInfo();
    private final SBdb db;
    private JButton jButtonClose;
    private JScrollPane jScrollPane1;
    private JTable jTableInfo;

    public DialogDBInfo(Frame parent, boolean modal, SBdb db) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(null);
    }

    public DialogDBInfo(Dialog parent, boolean modal, SBdb db, Integer projID) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(projID);
    }

    private void init(Integer projID) throws SQLException {
        String info;
        this.setTitle("Database Statistics");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.model.items = new LinkedList<InfoItem>();
        String string = info = projID != null ? this.db.getProjectInfo(projID) : this.db.getDatabaseInfo();
        if (projID != null) {
            Project project = this.db.getProject(projID);
            this.setTitle(project.getName());
        }
        String[] tokens = info.split(",");
        assert (tokens.length == (projID != null ? PROJECT_TABLES.length : TABLES.length));
        for (int i = 0; i < tokens.length; ++i) {
            this.model.items.add(new InfoItem(projID != null ? PROJECT_TABLES[i] : TABLES[i], Integer.parseInt(tokens[i])));
            if (projID != null) continue;
            for (String blank : BLANK_AFTER) {
                if (!TABLES[i].equals(blank)) continue;
                this.model.items.add(new InfoItem("", 0));
            }
        }
        SB.setTableHeaderBold((JTable)this.jTableInfo);
        TableColumnModel columnModel = this.jTableInfo.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelInfo.titles[i]);
            columnModel.getColumn(i).setWidth(TableModelInfo.widths[i]);
        }
        columnModel.getColumn(1).setCellRenderer(new InfoRenderer());
        this.setCursor(Cursor.getDefaultCursor());
        this.pack();
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableInfo = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 300));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogDBInfo this$0;
            {
                DialogDBInfo dialogDBInfo = this$0;
                Objects.requireNonNull(dialogDBInfo);
                this.this$0 = dialogDBInfo;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableInfo.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableInfo);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 298, Short.MAX_VALUE).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 488, Short.MAX_VALUE).addGap(11, 11, 11).addComponent(this.jButtonClose).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private static class TableModelInfo
    extends AbstractTableModel {
        List<InfoItem> items;
        static String[] titles = new String[]{"Data type", "No. records"};
        static int[] widths = new int[]{100, 30};

        private TableModelInfo() {
        }

        @Override
        public int getRowCount() {
            if (this.items == null) {
                return 0;
            }
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.items == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return " " + this.items.get((int)rowIndex).name;
                }
                case 1: {
                    return " " + this.items.get((int)rowIndex).number;
                }
            }
            return null;
        }
    }

    private static class InfoItem {
        String name;
        int number;

        InfoItem(String name, int number) {
            this.name = name;
            this.number = number;
        }
    }

    private static class InfoRenderer
    extends DefaultTableCellRenderer {
        private InfoRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value.toString().equals(" 0")) {
                this.setText("");
            } else {
                this.setText(String.valueOf(value));
            }
        }
    }
}

