/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jsbchart.block.ChartBlock;
import jsbchart.block.SchemeBlock;
import jsbchart.core.Chart;
import jsbchart.panel.PanelFactory;
import jsbchart.panel.PanelLithostratScheme;
import jsbchart.panel.panelIGDScheme.PanelIGDScheme;
import jsbugs.ChartActions;
import jsbugs.ChartJPanel;
import jsbugs.ZoomAction;
import jsbugs.chart.DialogChartProperties;
import model3.IGDScheme;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SBException;

public class DialogDrawIGDScheme
extends JDialog
implements ChartActions {
    private final ChartJPanel schemeChartJPanel;
    private final SBdb sbdb;
    private JButton jButton1;
    private JButton jButtonClose;
    private JButton jButtonZoomIn;
    private JButton jButtonZoomOut;
    private JScrollPane jScrollPaneSchemeChart;
    private JToolBar jToolBar1;

    public DialogDrawIGDScheme(JDialog parent, boolean modal, IGDScheme scheme1, IGDScheme scheme2, SBdb sbdb) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        if (scheme1 == null || scheme2 == null) {
            throw new IllegalArgumentException("Null scheme");
        }
        this.schemeChartJPanel = new ChartJPanel(new Chart());
        this.init(scheme1, scheme2);
    }

    private void init(IGDScheme scheme1, IGDScheme scheme2) throws SQLException, SBException {
        this.setTitle("Compare Schemes: " + scheme1.toString() + " / " + scheme2.toString());
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.schemeChartJPanel.chart.getProperties().margin = 5.0f;
        this.schemeChartJPanel.chart.getProperties().setPanelHeaderHeight(75.0f);
        this.schemeChartJPanel.chart.getProperties().setPanelCaptionHeight(9.0f);
        this.schemeChartJPanel.chart.getProperties().plotBlockCaptions = false;
        SchemeBlock block = new SchemeBlock(this.sbdb);
        double minAge = Math.min(scheme1.getMinAge(), scheme2.getMinAge());
        double maxAge = Math.max(scheme2.getMaxAge(), scheme2.getMaxAge());
        block.getProp().setLimits((float)minAge, (float)maxAge);
        block.getProp().setScale(SchemeBlock.calcIdealScale(minAge, maxAge));
        switch (scheme1.getIGDType()) {
            case 3: 
            case 4: 
            case 26: {
                block.addPanel(new PanelIGDScheme(scheme1, block));
                block.addPanel(PanelFactory.createBlankPanel(block));
                block.addPanel(new PanelIGDScheme(scheme2, block));
                break;
            }
            case 2: {
                block.addPanel(new PanelLithostratScheme(block, scheme1));
                block.addPanel(new PanelLithostratScheme(block, scheme2));
            }
        }
        this.schemeChartJPanel.chart.addBlock(block);
        this.schemeChartJPanel.chart.calcChartSize();
        this.jScrollPaneSchemeChart.getVerticalScrollBar().setUnitIncrement(20);
        this.jScrollPaneSchemeChart.getViewport().add((Component)this.schemeChartJPanel, null);
        this.setSchemeScrollPaneSize();
        this.initKeyBindings();
    }

    private void setSchemeScrollPaneSize() {
        this.schemeChartJPanel.setSize();
        this.schemeChartJPanel.revalidate();
        this.schemeChartJPanel.repaint();
    }

    private void initKeyBindings() {
        this.jToolBar1.getInputMap(2).put(KeyStroke.getKeyStroke(61, 128), "zoomIn");
        this.jToolBar1.getInputMap(2).put(KeyStroke.getKeyStroke(45, 128), "zoomOut");
        this.jToolBar1.getActionMap().put("zoomIn", new ZoomAction(true, this));
        this.jToolBar1.getActionMap().put("zoomOut", new ZoomAction(false, this));
    }

    private void initComponents() {
        this.jScrollPaneSchemeChart = new JScrollPane();
        this.jButtonClose = new JButton();
        this.jToolBar1 = new JToolBar();
        this.jButtonZoomIn = new JButton();
        this.jButtonZoomOut = new JButton();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 500));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogDrawIGDScheme this$0;
            {
                DialogDrawIGDScheme dialogDrawIGDScheme = this$0;
                Objects.requireNonNull(dialogDrawIGDScheme);
                this.this$0 = dialogDrawIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButtonZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/ZoomIn16.png")));
        this.jButtonZoomIn.setToolTipText("Zoom in (Ctrl + +)");
        this.jButtonZoomIn.setFocusable(false);
        this.jButtonZoomIn.setHorizontalTextPosition(0);
        this.jButtonZoomIn.setVerticalTextPosition(3);
        this.jButtonZoomIn.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogDrawIGDScheme this$0;
            {
                DialogDrawIGDScheme dialogDrawIGDScheme = this$0;
                Objects.requireNonNull(dialogDrawIGDScheme);
                this.this$0 = dialogDrawIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonZoomInActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomIn);
        this.jButtonZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/ZoomOut16.png")));
        this.jButtonZoomOut.setToolTipText("Zoom out (Ctrl + -)");
        this.jButtonZoomOut.setFocusable(false);
        this.jButtonZoomOut.setHorizontalTextPosition(0);
        this.jButtonZoomOut.setVerticalTextPosition(3);
        this.jButtonZoomOut.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogDrawIGDScheme this$0;
            {
                DialogDrawIGDScheme dialogDrawIGDScheme = this$0;
                Objects.requireNonNull(dialogDrawIGDScheme);
                this.this$0 = dialogDrawIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomOut);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/chartProperties16.png")));
        this.jButton1.setToolTipText("Chart Properties");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogDrawIGDScheme this$0;
            {
                DialogDrawIGDScheme dialogDrawIGDScheme = this$0;
                Objects.requireNonNull(dialogDrawIGDScheme);
                this.this$0 = dialogDrawIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPaneSchemeChart, -1, 710, Short.MAX_VALUE).add((Component)this.jToolBar1, -2, -1, -2).add(2, (Component)this.jButtonClose)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, 35, -2).addPreferredGap(0).add((Component)this.jScrollPaneSchemeChart, -1, 586, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jButtonClose).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonZoomInActionPerformed(ActionEvent evt) {
        this.zoom(true);
    }

    private void jButtonZoomOutActionPerformed(ActionEvent evt) {
        this.zoom(false);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.chartProperties();
    }

    @Override
    public void chartProperties() {
        DialogChartProperties dialog = new DialogChartProperties(this, true, this.schemeChartJPanel.chart.getProperties(), this.sbdb, (ChartBlock)this.schemeChartJPanel.chart.getBlockSingle(), false, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.setSchemeScrollPaneSize();
        }
    }

    @Override
    public void zoom(boolean in) {
        if (in) {
            this.schemeChartJPanel.getZoomManager().zoomIn();
        } else {
            this.schemeChartJPanel.getZoomManager().zoomOut();
        }
    }

    @Override
    public void undoRedo(boolean undo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

