/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.ComboCellRenderer;
import jsbugs.DialogList;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.ColourRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.EnvScheme;
import model3.SBdb;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogEnvReassign
extends SBDialog {
    DefaultComboBoxModel modelSchemes = new DefaultComboBoxModel();
    TableModelEnvReassign model;
    boolean inStartup = true;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonShowWells;
    private JComboBox jComboBoxSchemes;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTable jTableEnvReassign;
    private JTextField jTextFieldScheme;

    public DialogEnvReassign(Frame parent, boolean modal, SBdb db, EnvScheme scheme) throws SQLException, SBException {
        super(parent, modal);
        this.model = new TableModelEnvReassign(db, scheme);
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Palaeoenvironment Scheme : Reassign");
        this.jTextFieldScheme.setText(this.model.scheme.toString());
        List<EnvScheme> schemes = this.model.db.getEnvSchemes();
        Collections.sort(schemes);
        for (EnvScheme scheme : schemes) {
            this.modelSchemes.addElement(scheme);
        }
        this.jComboBoxSchemes.repaint();
        this.model.setUpTable(this.jTableEnvReassign);
        this.getDonorOccs(this.model.scheme);
        if ((this.model.db.getUser().getPriv() & 0x40) <= 0) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText("You need to be a super user to do this");
        }
        this.model.fireTableDataChanged();
        this.inStartup = false;
        this.jComboBoxSchemesActionPerformed(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jComboBoxSchemes = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTableEnvReassign = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonShowWells = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Scheme:");
        this.jLabel2.setText("Reassign to scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jComboBoxSchemes.setModel(this.modelSchemes);
        this.jComboBoxSchemes.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnvReassign this$0;
            {
                DialogEnvReassign dialogEnvReassign = this$0;
                Objects.requireNonNull(dialogEnvReassign);
                this.this$0 = dialogEnvReassign;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSchemesActionPerformed(evt);
            }
        });
        this.jTableEnvReassign.setModel(this.model);
        this.jTableEnvReassign.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogEnvReassign this$0;
            {
                DialogEnvReassign dialogEnvReassign = this$0;
                Objects.requireNonNull(dialogEnvReassign);
                this.this$0 = dialogEnvReassign;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableEnvReassignMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableEnvReassign);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnvReassign this$0;
            {
                DialogEnvReassign dialogEnvReassign = this$0;
                Objects.requireNonNull(dialogEnvReassign);
                this.this$0 = dialogEnvReassign;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnvReassign this$0;
            {
                DialogEnvReassign dialogEnvReassign = this$0;
                Objects.requireNonNull(dialogEnvReassign);
                this.this$0 = dialogEnvReassign;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonShowWells.setText("Show wells...");
        this.jButtonShowWells.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnvReassign this$0;
            {
                DialogEnvReassign dialogEnvReassign = this$0;
                Objects.requireNonNull(dialogEnvReassign);
                this.this$0 = dialogEnvReassign;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowWellsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 663, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldScheme, -2, 232, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxSchemes, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonShowWells).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jTextFieldScheme, -2, -1, -2).addComponent(this.jComboBoxSchemes, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 334, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonShowWells)).addContainerGap()));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.model.scheme.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 1);
            return;
        }
        if (this.model.scheme.getLink().getID() == this.model.scheme.getID()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You can't reassign a scheme to itself!", this.getTitle(), 1);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int lastLinkIndex = 0;
            for (int entry = 1; entry <= this.model.scheme.getNClasses(); ++entry) {
                if (this.model.scheme.getNoccs(entry) <= 0) continue;
                Integer linkIndex = this.model.scheme.getLinkTermIndex(entry);
                if (linkIndex == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Not all entries have been assigned.", this.getTitle(), 1);
                    return;
                }
                if (linkIndex < lastLinkIndex) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Entries to be reassigned must be in ascending order, or equal to the previous entry", this.getTitle(), 1);
                    return;
                }
                lastLinkIndex = linkIndex;
            }
            int nRows = this.model.scheme.reassignFromLink();
            if (JOptionPane.showConfirmDialog((Component)((Object)this), "Scheme: " + String.valueOf(this.model.scheme) + " reassigned, " + nRows + " environment intervals updated.\nCommit?", "Scheme Reassignment", 0, 3) == 0) {
                this.model.db.reloadReassignedEnvScheme(this.model.scheme);
                this.model.db.deleteEnvScheme(this.model.scheme);
                this.model.db.commit();
                this.setOK();
                this.dispose();
            } else {
                this.model.db.doRollback();
                JOptionPane.showMessageDialog((Component)((Object)this), "Rollback complete.", this.getTitle(), 1);
            }
        }
        catch (RuntimeException | SQLException | SBException | SBPermissionException ex) {
            this.model.db.doRollback();
            SbugsExceptionHandler.showStackError("Error reassigning: ", ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxSchemesActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        try {
            if (this.jComboBoxSchemes.getSelectedItem() instanceof EnvScheme) {
                this.model.scheme.setLink((EnvScheme)this.jComboBoxSchemes.getSelectedItem());
                this.model.envComboBox.removeAllItems();
                this.model.scheme.getLink().fillCombo(this.model.envComboBox, 0, false);
            } else {
                this.model.scheme.setLink(null);
                this.model.envComboBox.removeAllItems();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.model.fireTableDataChanged();
    }

    private void jButtonShowWellsActionPerformed(ActionEvent evt) {
        if (this.jTableEnvReassign.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No entry selected", this.getTitle(), 1);
            return;
        }
        int entry = this.jTableEnvReassign.getSelectedRow() + 1;
        if (this.model.scheme.getNoccs(entry) == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "'" + this.model.scheme.getTerm(entry) + "' does not occur in any wells.", this.getTitle(), 1);
            return;
        }
        try {
            List wells = this.model.scheme.getOccs(entry);
            DialogList dialog = new DialogList((JDialog)((Object)this), true, this.model.scheme.toString() + " occurrences of " + this.model.scheme.getTerm(entry), new UserPrefsHelper(this.model.db), wells, true, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    private void jTableEnvReassignMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowWellsActionPerformed(null);
        }
    }

    private void getDonorOccs(EnvScheme scheme) throws SQLException, SBException {
        scheme.resetNoccs();
        scheme.setDBOccs();
    }

    private static class TableModelEnvReassign
    extends AbstractTableModel {
        static final int COL_DONOR_ENV = 0;
        static final int COL_DONOR_COLOUR = 1;
        static final int COL_DONOR_OCCS = 2;
        static final int COL_ARROW = 3;
        static final int COL_HOST_ENV = 4;
        static final int COL_HOST_COLOUR = 5;
        final String[] colTitles = new String[]{"Environment", "Colour", "Occs", "", "Environment", "Colour"};
        final int[] colWidths = new int[]{120, 20, 20, 20, 120, 20};
        final SBdb db;
        final EnvScheme scheme;
        JComboBox envComboBox = new JComboBox();

        public TableModelEnvReassign(SBdb db, EnvScheme scheme) {
            this.db = db;
            this.scheme = scheme;
        }

        @Override
        public int getRowCount() {
            if (this.scheme == null) {
                return 0;
            }
            return this.scheme.getNClasses();
        }

        @Override
        public int getColumnCount() {
            return this.colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                switch (columnIndex) {
                    case 0: {
                        return new StringStatus(this.scheme.getTerm(rowIndex + 1), this.scheme.getStatus());
                    }
                    case 2: {
                        return new StringStatus("" + this.scheme.getNoccs(rowIndex + 1), this.scheme.getStatus());
                    }
                    case 1: {
                        return this.scheme.getColour(rowIndex + 1);
                    }
                    case 3: {
                        return new Boolean(this.scheme.getLinkTerm(rowIndex + 1) != null);
                    }
                    case 4: {
                        return this.scheme.getLinkTerm(rowIndex + 1);
                    }
                    case 5: {
                        return this.scheme.getLinkColour(rowIndex + 1);
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 2: {
                    return StringStatus.class;
                }
                case 3: {
                    return Boolean.class;
                }
                case 4: {
                    return String.class;
                }
                case 1: 
                case 5: {
                    return Color.class;
                }
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            switch (col) {
                case 4: {
                    try {
                        String termName;
                        if (obj == null || this.scheme.getLink() == null || (termName = (String)obj).length() <= 0) break;
                        this.scheme.setLinkTerm(row + 1, termName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                default: {
                    return false;
                }
                case 4: 
            }
            return true;
        }

        void setUpTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(this.colTitles[i]);
                columnModel.getColumn(i).setPreferredWidth(this.colWidths[i]);
            }
            columnModel.getColumn(3).setMaxWidth(this.colWidths[3]);
            table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            table.setDefaultRenderer(Color.class, new ColourRenderer(true));
            table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
            columnModel.getColumn(4).setCellEditor(new DefaultCellEditor(this.envComboBox));
            columnModel.getColumn(4).setCellRenderer(new ComboCellRenderer());
        }
    }
}

