/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jsbugs.table.ColourRenderer;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.uiutil.audit.JPanelAuditColumn;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.EnvScheme;
import model3.SBRestrictable;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;
import util.table.ColorEditor;

public class DialogEnvScheme
extends SBDialog {
    private static final int NAME_LEN = 40;
    private final EnvScheme original;
    private final EnvSchemeTableModel model = new EnvSchemeTableModel();
    private final SBdb db;
    EnvScheme newScheme = null;
    private Box.Filler filler1;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonHelp;
    private JButton jButtonInsert;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JPanelAuditColumn jPanelAudit;
    private JScrollPane jScrollPane1;
    private JTable jTableScheme;
    private JTextField jTextFieldName;

    public DialogEnvScheme(Frame parent, boolean modal, SBdb db, EnvScheme scheme) {
        super(parent, modal);
        this.original = scheme;
        this.db = db;
        if (scheme != null) {
            try {
                this.model.scheme = EnvScheme.createCopy(scheme, db);
            }
            catch (SQLException | SBException e) {
                e.printStackTrace();
            }
        } else {
            this.model.scheme = new EnvScheme(db, 0, "");
        }
        this.initComponents();
        this.init();
    }

    public DialogEnvScheme(Dialog parent, boolean modal, SBdb db, EnvScheme scheme) {
        super((Window)parent, modal);
        this.original = scheme;
        this.db = db;
        if (scheme != null) {
            try {
                this.model.scheme = EnvScheme.createCopy(scheme, db);
            }
            catch (SQLException | SBException e) {
                e.printStackTrace();
            }
        } else {
            this.model.scheme = new EnvScheme(db, 0, "");
        }
        this.initComponents();
        this.init();
    }

    private void init() {
        if (this.original != null) {
            this.setTitle("Palaeoenvironment Scheme : " + this.model.scheme.getName());
        } else {
            this.setTitle("Palaeoenvironment Scheme : Add");
        }
        for (int i = 0; i < EnvSchemeTableModel.colTitles.length; ++i) {
            this.jTableScheme.getColumnModel().getColumn(i).setPreferredWidth(EnvSchemeTableModel.colWidths[i]);
            this.jTableScheme.getColumnModel().getColumn(i).setHeaderValue(EnvSchemeTableModel.colTitles[i]);
        }
        this.jTableScheme.setDefaultRenderer(Color.class, new ColourRenderer(true));
        if (this.original != null) {
            this.jPanelAudit.setAuditText(this.original.getCreator(), this.original.getCreated(), this.original.getModifier(), this.original.getModified());
            this.jTextFieldName.setText(this.original.getName());
        } else {
            this.jPanelAudit.setVisible(false);
        }
        ColorEditor.setUpColorEditor((JTable)this.jTableScheme);
        this.jTableScheme.getColumnModel().setColumnMargin(5);
        this.jTableScheme.getTableHeader().setReorderingAllowed(false);
        TableUtils.setTableHeaderBold((JTable)this.jTableScheme);
        this.model.fireTableDataChanged();
        try {
            if (this.original != null && !this.original.canWrite(this.db, null) || this.original == null && !SBRestrictable.canWrite(this.db)) {
                this.jButtonOK.setEnabled(false);
                this.jButtonOK.setToolTipText(this.original != null ? this.original.getDeniedReason(this.db, "scheme", false) : SBRestrictable.getDeniedReason(false));
                this.getRootPane().setDefaultButton(this.jButtonCancel);
            } else {
                this.getRootPane().setDefaultButton(this.jButtonOK);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableScheme = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = TextFieldUtils.buildLimitedLengthTextField(40);
        this.jButtonAdd = new JButton();
        this.jButtonInsert = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanelAudit = new JPanelAuditColumn();
        this.filler1 = new Box.Filler(new Dimension(0, 1), new Dimension(0, 1), new Dimension(Short.MAX_VALUE, 1));
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(375, 375));
        this.jTableScheme.setModel(this.model);
        this.jTableScheme.setGridColor(new Color(204, 204, 204));
        this.jScrollPane1.setViewportView(this.jTableScheme);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnvScheme this$0;
            {
                DialogEnvScheme dialogEnvScheme = this$0;
                Objects.requireNonNull(dialogEnvScheme);
                this.this$0 = dialogEnvScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnvScheme this$0;
            {
                DialogEnvScheme dialogEnvScheme = this$0;
                Objects.requireNonNull(dialogEnvScheme);
                this.this$0 = dialogEnvScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Name:");
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnvScheme this$0;
            {
                DialogEnvScheme dialogEnvScheme = this$0;
                Objects.requireNonNull(dialogEnvScheme);
                this.this$0 = dialogEnvScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonInsert.setText("Insert");
        this.jButtonInsert.setToolTipText("Insert a new row before the selected row");
        this.jButtonInsert.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnvScheme this$0;
            {
                DialogEnvScheme dialogEnvScheme = this$0;
                Objects.requireNonNull(dialogEnvScheme);
                this.this$0 = dialogEnvScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnvScheme this$0;
            {
                DialogEnvScheme dialogEnvScheme = this$0;
                Objects.requireNonNull(dialogEnvScheme);
                this.this$0 = dialogEnvScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnvScheme this$0;
            {
                DialogEnvScheme dialogEnvScheme = this$0;
                Objects.requireNonNull(dialogEnvScheme);
                this.this$0 = dialogEnvScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanelAudit.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(7, 7, 7).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldName)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonHelp)).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonInsert, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete)))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.filler1, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanelAudit, -1, 409, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldName, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonInsert).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 80, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.filler1, -2, 3, -2).addPreferredGap(0).add((Component)this.jPanelAudit, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        String name;
        if (this.jTableScheme.isEditing()) {
            this.jTableScheme.getCellEditor().stopCellEditing();
        }
        if ((name = this.jTextFieldName.getText().trim()).length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter a scheme name", this.getTitle(), 2);
            return;
        }
        for (int i = 0; i < this.model.scheme.getNClasses(); ++i) {
            if (this.model.scheme.getTerm(i + 1).length() != 0) continue;
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter an environment name at row " + i, this.getTitle(), 2);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.model.scheme.setName(name);
            if (this.original != null) {
                int opt;
                String msg = null;
                if (this.original.getNClasses() != this.model.scheme.getNClasses() && this.original.getNoccs() > 0) {
                    msg = "This scheme occurs in wells. Updating the number of classes could seriously affect these well data.\nDo not update if you have reordered the units.\nDo you want to proceed?";
                } else if (this.original.getNoccs() > 0) {
                    msg = "Updating scheme unit names and/or colours or re-ordering the units will affect existing well data. Do not proceed if you have replaced scheme terms if you don't want these wells changed.\nDo you want to proceed?";
                }
                if (msg != null && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), msg, this.getTitle(), 0, 3)) == 1) {
                    return;
                }
                this.original.update(this.model.scheme);
            } else {
                this.db.addEnvScheme(this.model.scheme);
                this.newScheme = this.model.scheme;
            }
            this.db.commit();
            this.setOK();
        }
        catch (RuntimeException | SQLException | SBException | SBPermissionException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            this.model.scheme.addRow();
            this.model.fireTableDataChanged();
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog((Component)((Object)this), sbe.getMessage(), this.getTitle(), 2);
        }
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        if (this.jTableScheme.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a row for insert point", this.getTitle(), 2);
            return;
        }
        try {
            this.model.scheme.insertRow(this.jTableScheme.getSelectedRow());
            this.model.fireTableDataChanged();
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog((Component)((Object)this), sbe.getMessage(), this.getTitle(), 2);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableScheme.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a row to delete", this.getTitle(), 2);
            return;
        }
        try {
            this.model.scheme.deleteRow(this.jTableScheme.getSelectedRow());
            this.jTableScheme.clearSelection();
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException re) {
            SbugsExceptionHandler.showStackError(re, (Component)((Object)this));
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtouseenvschemes.html");
    }

    private static class EnvSchemeTableModel
    extends AbstractTableModel {
        EnvScheme scheme;
        static final String[] colTitles = new String[]{"Environment", "Colour", "Comment"};
        static final int[] colWidths = new int[]{80, 10, 40};
        static final int COL_ENV = 0;
        static final int COL_COLOUR = 1;
        static final int COL_COMMENT = 2;

        private EnvSchemeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public int getRowCount() {
            if (this.scheme == null) {
                return 0;
            }
            return this.scheme.getNClasses();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < this.scheme.getNClasses()) {
                switch (col) {
                    case 0: {
                        return this.scheme.getTerm(row + 1);
                    }
                    case 1: {
                        return this.scheme.getColour(row + 1);
                    }
                    case 2: {
                        return this.scheme.getComment(row + 1);
                    }
                }
                return "";
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            try {
                switch (col) {
                    case 0: {
                        this.scheme.setTerm(row, (String)obj);
                        break;
                    }
                    case 1: {
                        this.scheme.setColour(row, (Color)obj);
                        break;
                    }
                    case 2: {
                        this.scheme.setComment(row, (String)obj);
                    }
                }
            }
            catch (RuntimeException | SQLException | SBException e) {
                System.out.println("Exception setting env table row: " + e.getMessage());
                e.printStackTrace();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 2: {
                    return String.class;
                }
                case 1: {
                    return Color.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }
}

