/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableRowSorter;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelGrainSize;
import jsbugs.io.DialogCSVExporOptions;
import jsbugs.lithography.GrainSizeDepthProcessor;
import jsbugs.uiutil.FileOverwriteCheck;
import model3.GrainSizeDepth;
import model3.GrainSizeList;
import model3.Lastval;
import model3.LithBase;
import model3.LithInterval;
import model3.SBdb;
import model3.Well;
import util.DepthUnits;
import util.DepthUtils;
import util.FilePathUtils;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;
import util.gridreader.GridReaderException;
import util.gridreader.TableData;
import util.gridreader.TableReader;
import util.gridwriter.CSVExportOptions;
import util.gridwriter.GridSheet;
import util.gridwriter.GridWriter;
import util.table.SbugsTable;

public class DialogGrainSize
extends JDialog {
    Well well;
    SBdb db;
    TableModelGrainSize model = new TableModelGrainSize();
    private final GrainSizeDepthProcessor gsdProcessor = new GrainSizeDepthProcessor();
    private JButton jButton1;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonGenerate;
    private JButton jButtonHelp;
    private JButton jButtonInsert;
    private JButton jButtonOK;
    private JButton jButtonSaveAs;
    private JButton jButtonSelectAll;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTable jTableGrainSize;

    public DialogGrainSize(JDialog parent, boolean modal, SBdb db, Well well, char units) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.well = well;
        this.db = db;
        this.model.units = units;
        this.gsdProcessor.setDepthColumnIndex(0);
        this.gsdProcessor.setGrainSizeColumnIndex(1);
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Lithology Grain Size : " + this.well.getWellName());
        this.well.loadGrainSize();
        this.model.grainSize = new GrainSizeList(this.well.getGrainSize());
        this.model.setupTable(this.jTableGrainSize);
        this.jTableGrainSize.setRowSorter(new TableRowSorter<TableModelGrainSize>(this.model));
        new ColumnSortResetHandler(this.jTableGrainSize).attach();
        this.model.fireTableDataChanged();
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
        }
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableGrainSize = new SbugsTable();
        this.jButtonGenerate = new JButton();
        this.jButtonInsert = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonSaveAs = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jButtonSelectAll = new JButton();
        this.jButton1 = new JButton();
        this.jSeparator3 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 400));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogGrainSize this$0;
            {
                DialogGrainSize dialogGrainSize = this$0;
                Objects.requireNonNull(dialogGrainSize);
                this.this$0 = dialogGrainSize;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogGrainSize this$0;
            {
                DialogGrainSize dialogGrainSize = this$0;
                Objects.requireNonNull(dialogGrainSize);
                this.this$0 = dialogGrainSize;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogGrainSize this$0;
            {
                DialogGrainSize dialogGrainSize = this$0;
                Objects.requireNonNull(dialogGrainSize);
                this.this$0 = dialogGrainSize;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jTableGrainSize.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableGrainSize);
        this.jButtonGenerate.setText("Generate");
        this.jButtonGenerate.setToolTipText("Create grain size profile from lithology intervals");
        this.jButtonGenerate.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogGrainSize this$0;
            {
                DialogGrainSize dialogGrainSize = this$0;
                Objects.requireNonNull(dialogGrainSize);
                this.this$0 = dialogGrainSize;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGenerateActionPerformed(evt);
            }
        });
        this.jButtonInsert.setText("Insert");
        this.jButtonInsert.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogGrainSize this$0;
            {
                DialogGrainSize dialogGrainSize = this$0;
                Objects.requireNonNull(dialogGrainSize);
                this.this$0 = dialogGrainSize;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogGrainSize this$0;
            {
                DialogGrainSize dialogGrainSize = this$0;
                Objects.requireNonNull(dialogGrainSize);
                this.this$0 = dialogGrainSize;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected rows from the table");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogGrainSize this$0;
            {
                DialogGrainSize dialogGrainSize = this$0;
                Objects.requireNonNull(dialogGrainSize);
                this.this$0 = dialogGrainSize;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSaveAs.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogGrainSize this$0;
            {
                DialogGrainSize dialogGrainSize = this$0;
                Objects.requireNonNull(dialogGrainSize);
                this.this$0 = dialogGrainSize;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.setToolTipText("Delete selected rows from the table");
        this.jButtonSelectAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogGrainSize this$0;
            {
                DialogGrainSize dialogGrainSize = this$0;
                Objects.requireNonNull(dialogGrainSize);
                this.this$0 = dialogGrainSize;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButton1.setText("Read ...");
        this.jButton1.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogGrainSize this$0;
            {
                DialogGrainSize dialogGrainSize = this$0;
                Objects.requireNonNull(dialogGrainSize);
                this.this$0 = dialogGrainSize;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 241, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSeparator1).addComponent(this.jButtonGenerate, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonInsert, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator2).addComponent(this.jButtonSelectAll, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveAs, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator3, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 537, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonGenerate).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonInsert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveAs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, 10, -2).addGap(2, 2, 2).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.well.storeGrainSize(this.model.grainSize);
            this.db.commit();
            this.dispose();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialoggrainsize.html");
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonGenerateActionPerformed(ActionEvent evt) {
        try {
            if (this.well.getLithIntervals().isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no lithology intervals to use. Load intervals into workspace first.", this.getTitle(), 2);
                return;
            }
            if (this.model.grainSize.size() > 0) {
                if (JOptionPane.showConfirmDialog(this, "Clear current entries?", this.getTitle(), 0, 3) != 0) {
                    return;
                }
                this.model.grainSize.clear();
            }
            Iterator<LithBase> it = this.well.getLithIntervals().iterator();
            float lastEntry = 0.0f;
            while (it.hasNext()) {
                LithInterval zone;
                LithBase base = it.next();
                if (!(base instanceof LithInterval) || (zone = (LithInterval)base).getLithology().getGrainSize() == lastEntry) continue;
                GrainSizeDepth gs = new GrainSizeDepth(zone.getTopDepth(), zone.getLithology().getGrainSize());
                this.model.grainSize.add(gs);
                if (zone.getBaseDepth() > zone.getTopDepth() + 0.01) {
                    gs = new GrainSizeDepth(zone.getBaseDepth() - 0.01, zone.getLithology().getGrainSize());
                    this.model.grainSize.add(gs);
                }
                lastEntry = gs.getGrainSize();
            }
            this.jTableGrainSize.clearSelection();
            this.model.grainSize.setDirty();
            this.model.fireTableDataChanged();
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            String number = JOptionPane.showInputDialog(this, "Number of rows:", this.getTitle(), 3);
            if (number == null || number.length() == 0) {
                return;
            }
            int nRows = Integer.parseInt(number);
            for (int i = 0; i < nRows; ++i) {
                this.model.grainSize.add(this.model.grainSize.size(), new GrainSizeDepth(0.0, 0.0f));
            }
            this.model.fireTableDataChanged();
            this.jTableGrainSize.clearSelection();
        }
        catch (Exception se) {
            JOptionPane.showMessageDialog(this, se.toString(), this.getTitle(), 0);
            se.printStackTrace();
        }
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        int selection = this.jTableGrainSize.getSelectedRow();
        if (selection < 0) {
            JOptionPane.showMessageDialog(this, "No insertion point selected.", this.getTitle(), 2);
            return;
        }
        try {
            String number = JOptionPane.showInputDialog(this, "Number of rows:", this.getTitle(), 3);
            if (number == null || number.length() == 0) {
                return;
            }
            int nRows = Integer.parseInt(number);
            for (int i = 0; i < nRows; ++i) {
                this.model.grainSize.add(this.jTableGrainSize.convertRowIndexToModel(this.jTableGrainSize.getSelectedRow()), new GrainSizeDepth(0.0, 0.0f));
            }
            this.model.fireTableDataChanged();
            this.jTableGrainSize.clearSelection();
        }
        catch (Exception se) {
            JOptionPane.showMessageDialog(this, se.toString(), this.getTitle(), 0);
            se.printStackTrace();
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableGrainSize.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected.", this.getTitle(), 2);
            return;
        }
        LinkedList removals = new LinkedList();
        for (int i = 0; i < selection.length; ++i) {
            removals.add(this.model.grainSize.get(this.jTableGrainSize.convertRowIndexToModel(selection[i])));
        }
        Iterator it = removals.iterator();
        while (it.hasNext()) {
            this.model.grainSize.remove(it.next());
        }
        this.model.fireTableDataChanged();
        this.jTableGrainSize.clearSelection();
        this.model.grainSize.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        File file = FileChooserUtils.saveAsGridDataDialog((Component)this, null);
        if (file == null) return;
        GridWriter gw = new GridWriter();
        if (FilePathUtils.isFileExtension((String)file.getPath(), (String[])FileChooserUtils.CSV_FILTER.getExtensions())) {
            CSVExportOptions options = DialogCSVExporOptions.showNewCSVOptionsDialog(this, (Component)this);
            if (options == null) return;
            gw.setCSVOptions(options);
        } else {
            gw.getXLSOptions().setSheetName(this.well.getWellName());
            gw.getXLSOptions().setAuthorName(this.db.getUser().getName());
        }
        if (!FileOverwriteCheck.checkForGridFileOverwriting(this, (Component)this, file, gw)) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            GridSheet gb = new GridSheet();
            gb.addRow(new Object[]{"Depth (" + DepthUnits.getUnits((char)this.model.units).getFullName() + ")", "Grain Size"});
            for (GrainSizeDepth gs : this.model.grainSize) {
                gb.addRow(new Object[]{DepthUtils.convFromM((double)gs.getDepth(), (char)this.model.units), Float.valueOf(gs.getGrainSize())});
            }
            gw.write(file, gb.getObjectArray());
            JOptionPane.showMessageDialog(this, "The file " + file.getName() + " was successfully written.");
            return;
        }
        catch (IOException ex) {
            FrameJsbugs.showStackError("An error occurred while writing the file " + file.getName() + ".", ex, this.db);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jTableGrainSize.selectAll();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        File file;
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel or CSV file", "csv", "xls", "xlsx");
        File initialDir = null;
        String lastPathOpened = Lastval.tryGetString(this.db, "GSZFILE");
        if (lastPathOpened != null) {
            initialDir = new File(lastPathOpened);
        }
        if ((file = FileChooserUtils.chooseReadableFile((Component)this, (FileNameExtensionFilter)filter, initialDir)) != null) {
            this.readGrainSizes(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readGrainSizes(File file) {
        TableReader reader = new TableReader();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            TableData data = reader.readTableData(file);
            List<GrainSizeDepth> filteredSizes = this.gsdProcessor.buildGrainSizeList(data);
            for (GrainSizeDepth s : filteredSizes) {
                this.model.grainSize.add(s);
            }
            this.model.fireTableDataChanged();
            this.jTableGrainSize.clearSelection();
            Lastval.tryPutString(this.db, "GSZFILE", file.getPath());
            JOptionPane.showMessageDialog(this, "Read " + filteredSizes.size() + " grain sizes from " + file.getName() + ".");
        }
        catch (IOException | GridReaderException ex) {
            StackError.showStackError((String)("An error occurred opening the file " + file.getName() + "."), (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

