/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import jsbugs.FrameJsbugs;
import model3.IPSBathy;
import model3.Lastval;
import model3.SBdb;
import model3.Well;
import util.DepthUtils;
import util.SB;
import util.SbugsFileFilter;

public class DialogIPSBathy
extends JDialog {
    Well well;
    SBdb db;
    char units;
    IPSTableModel model;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonRead;
    private JButton jButtonRemove;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTableIPS;
    private JTextArea jTextArea1;

    public DialogIPSBathy(Frame parent, boolean modal, SBdb db, Well well, char units) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.units = units;
        this.model = new IPSTableModel();
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("IPS Bathymetry");
        this.model.load(this.well.getIPSBathy().get(), this.units);
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableIPS = new JTable();
        this.jButtonRead = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonRemove = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.jScrollPane1.setBorder(null);
        this.jTableIPS.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableIPS);
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIPSBathy this$0;
            {
                DialogIPSBathy dialogIPSBathy = this$0;
                Objects.requireNonNull(dialogIPSBathy);
                this.this$0 = dialogIPSBathy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add row");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIPSBathy this$0;
            {
                DialogIPSBathy dialogIPSBathy = this$0;
                Objects.requireNonNull(dialogIPSBathy);
                this.this$0 = dialogIPSBathy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIPSBathy this$0;
            {
                DialogIPSBathy dialogIPSBathy = this$0;
                Objects.requireNonNull(dialogIPSBathy);
                this.this$0 = dialogIPSBathy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIPSBathy this$0;
            {
                DialogIPSBathy dialogIPSBathy = this$0;
                Objects.requireNonNull(dialogIPSBathy);
                this.this$0 = dialogIPSBathy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Remove selection");
        this.jButtonRemove.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIPSBathy this$0;
            {
                DialogIPSBathy dialogIPSBathy = this$0;
                Objects.requireNonNull(dialogIPSBathy);
                this.this$0 = dialogIPSBathy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jScrollPane2.setBorder(null);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setBackground(SystemColor.control);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Tahoma", 0, 11));
        this.jTextArea1.setForeground(new Color(51, 102, 204));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("Read file or enter\nvalues from IPS \n(Integrated \nPaleontology \nSystem) to display \na curve of derived \nwater depth. The \ncurve can only be \ndisplayed with \nenvironment \nschemes of 9 \nclasses or more.\n\nNote: not restricted\nto current version");
        this.jTextArea1.setBorder(null);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 561, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonRead, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonRemove, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -2, 117, -2).addComponent(this.jButtonAdd, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonAdd, this.jButtonCancel, this.jButtonOK, this.jButtonRead, this.jButtonRemove);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonRead).addGap(4, 4, 4).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRemove).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2).addGap(11, 11, 11).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, -1, 419, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.model.save(this.db, this.well);
            this.db.commit();
            this.dispose();
        }
        catch (SQLException ex) {
            this.db.doRollback();
            FrameJsbugs.showStackError(ex.getMessage(), ex, this.db);
            ex.printStackTrace();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            String rows = JOptionPane.showInputDialog(this, "Enter number of rows to add", new Integer(1));
            if (rows != null) {
                int nRows = Integer.parseInt(rows);
                Double[] oldDepth = this.model.depth;
                Double[] oldBath = this.model.bath;
                Double[] oldBavg = this.model.bavg;
                Double[] oldDivrs = this.model.divrs;
                Integer[] oldBlw = this.model.blw;
                Integer[] oldBno = this.model.bno;
                Integer[] oldCos = this.model.cos;
                Integer[] oldOts = this.model.ots;
                Integer[] oldTotal = this.model.total;
                this.model.setSize(this.model.rowCount + nRows);
                for (int i = 0; i < oldDepth.length; ++i) {
                    this.model.depth[i] = oldDepth[i];
                    this.model.bath[i] = oldBath[i];
                    this.model.bavg[i] = oldBavg[i];
                    this.model.divrs[i] = oldDivrs[i];
                    this.model.blw[i] = oldBlw[i];
                    this.model.bno[i] = oldBno[i];
                    this.model.cos[i] = oldCos[i];
                    this.model.ots[i] = oldOts[i];
                    this.model.total[i] = oldTotal[i];
                }
                this.jTableIPS.clearSelection();
                this.model.fireTableDataChanged();
                this.jTableIPS.setRowSelectionInterval(this.model.rowCount - nRows, this.model.rowCount - 1);
                this.jScrollPane1.getViewport().setViewPosition(new Point(0, this.jTableIPS.getBounds().getSize().height));
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        int[] exclusions = this.jTableIPS.getSelectedRows();
        if (exclusions.length == 0) {
            JOptionPane.showMessageDialog(this, "Select rows to delete");
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Really delete " + (exclusions.length > 1 ? "these " : "this ") + exclusions.length + (exclusions.length > 1 ? " rows?" : " row?"), this.getTitle(), 0, 3) != 0) {
            return;
        }
        int newSize = this.model.rowCount - exclusions.length;
        Double[] newDepth = new Double[newSize];
        Double[] newDivrs = new Double[newSize];
        Double[] newBath = new Double[newSize];
        Double[] newBavg = new Double[newSize];
        Integer[] newBno = new Integer[newSize];
        Integer[] newBlw = new Integer[newSize];
        Integer[] newCos = new Integer[newSize];
        Integer[] newOts = new Integer[newSize];
        Integer[] newTotal = new Integer[newSize];
        for (int i = 0; i < exclusions.length; ++i) {
            this.model.depth[exclusions[i]] = null;
        }
        int j = 0;
        for (int i = 0; i < this.model.rowCount; ++i) {
            if (this.model.depth[i] == null) continue;
            newDepth[j] = this.model.depth[i];
            newDivrs[j] = this.model.divrs[i];
            newBath[j] = this.model.bath[i];
            newBavg[j] = this.model.bavg[i];
            newBno[j] = this.model.bno[i];
            newBlw[j] = this.model.blw[i];
            newCos[j] = this.model.cos[i];
            newOts[j] = this.model.ots[i];
            newTotal[j] = this.model.total[i];
            ++j;
        }
        this.model.depth = newDepth;
        this.model.divrs = newDivrs;
        this.model.bath = newBath;
        this.model.bavg = newBavg;
        this.model.bno = newBno;
        this.model.blw = newBlw;
        this.model.cos = newCos;
        this.model.ots = newOts;
        this.model.total = newTotal;
        this.model.rowCount = newSize;
        this.model.isDirty = true;
        this.jTableIPS.clearSelection();
        this.model.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonReadActionPerformed(ActionEvent evt) {
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.well.getDataModel(), "WINIPSIMP", "UNXIPSIMP"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                String buff;
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.setCursor(Cursor.getPredefinedCursor(3));
                BufferedReader in = new BufferedReader(new FileReader(file));
                double lastDepth = -100.0;
                LinkedList<String> values = new LinkedList<String>();
                while ((buff = in.readLine()) != null) {
                    if (buff.toLowerCase().contains("depth") || buff.toLowerCase().contains("total")) continue;
                    values.add(buff);
                }
                if (values.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "No data available in file", this.getTitle(), 2);
                    return;
                }
                int newSize = values.size();
                this.model.depth = new Double[newSize];
                this.model.divrs = new Double[newSize];
                this.model.bath = new Double[newSize];
                this.model.bavg = new Double[newSize];
                this.model.bno = new Integer[newSize];
                this.model.blw = new Integer[newSize];
                this.model.cos = new Integer[newSize];
                this.model.ots = new Integer[newSize];
                this.model.total = new Integer[newSize];
                this.model.rowCount = newSize;
                this.model.isDirty = true;
                int i = 0;
                for (String s : values) {
                    StringTokenizer tok = new StringTokenizer(s, " ,;\t");
                    if (!tok.hasMoreTokens()) continue;
                    this.model.depth[i] = Double.parseDouble(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    this.model.divrs[i] = Double.parseDouble(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    this.model.bath[i] = Double.parseDouble(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    this.model.bavg[i] = Double.parseDouble(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    this.model.blw[i] = Integer.parseInt(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    this.model.bno[i] = Integer.parseInt(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    this.model.ots[i] = Integer.parseInt(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    this.model.cos[i] = Integer.parseInt(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    this.model.total[i] = Integer.parseInt(tok.nextToken());
                    ++i;
                }
                this.jTableIPS.clearSelection();
                this.model.fireTableDataChanged();
                Lastval.putString(this.well.getDataModel(), "WINIPSIMP", "UNXIPSIMP", file.getPath());
                this.well.getDataModel().commit();
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private static class IPSTableModel
    extends AbstractTableModel {
        Double[] depth;
        Double[] divrs;
        Double[] bath;
        Double[] bavg;
        Integer[] blw;
        Integer[] bno;
        Integer[] ots;
        Integer[] cos;
        Integer[] total;
        static final String[] colTitles = new String[]{"Depth", "Divrs", "Bath", "Bavg", "Blw", "Bno", "Ots", "Cos", "Total"};
        static final int COL_DEPTH = 0;
        static final int COL_DIVRS = 1;
        static final int COL_BATH = 2;
        static final int COL_BAVG = 3;
        static final int COL_BLW = 4;
        static final int COL_BNO = 5;
        static final int COL_OTS = 6;
        static final int COL_COS = 7;
        static final int COL_TOTAL = 8;
        char units;
        boolean isDirty = false;
        int rowCount = 0;

        private IPSTableModel() {
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return colTitles[col] + (this.units == 'M' ? " (m)" : " (ft)");
            }
            return colTitles[col];
        }

        public void setSize(int i) {
            this.depth = new Double[i];
            this.divrs = new Double[i];
            this.bath = new Double[i];
            this.bavg = new Double[i];
            this.blw = new Integer[i];
            this.bno = new Integer[i];
            this.ots = new Integer[i];
            this.cos = new Integer[i];
            this.total = new Integer[i];
            this.rowCount = i;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    if (this.depth[row] == null) {
                        return "";
                    }
                    return SB.floatString((double)this.depth[row], (int)2);
                }
                case 1: {
                    if (this.divrs[row] == null) {
                        return "";
                    }
                    return SB.floatString((double)this.divrs[row], (int)2);
                }
                case 2: {
                    if (this.bath[row] == null) {
                        return "";
                    }
                    return SB.floatString((double)this.bath[row], (int)2);
                }
                case 3: {
                    if (this.bavg[row] == null) {
                        return "";
                    }
                    return SB.floatString((double)this.bavg[row], (int)2);
                }
                case 4: {
                    if (this.blw[row] == null) {
                        return "";
                    }
                    return "" + this.blw[row];
                }
                case 5: {
                    if (this.bno[row] == null) {
                        return "";
                    }
                    return "" + this.bno[row];
                }
                case 6: {
                    if (this.ots[row] == null) {
                        return "";
                    }
                    return "" + this.ots[row];
                }
                case 7: {
                    if (this.cos[row] == null) {
                        return "";
                    }
                    return "" + this.cos[row];
                }
                case 8: {
                    if (this.total[row] == null) {
                        return "";
                    }
                    return "" + this.total[row];
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            try {
                if (obj.getClass().getName().contains("String")) {
                    obj = Double.parseDouble((String)obj);
                }
                switch (col) {
                    case 0: {
                        this.depth[row] = (Double)obj;
                        break;
                    }
                    case 1: {
                        this.divrs[row] = (Double)obj;
                        break;
                    }
                    case 2: {
                        this.bath[row] = (Double)obj;
                        break;
                    }
                    case 3: {
                        this.bavg[row] = (Double)obj;
                        break;
                    }
                    case 4: {
                        this.blw[row] = new Integer(String.valueOf(obj));
                        break;
                    }
                    case 5: {
                        this.bno[row] = new Integer(String.valueOf(obj));
                        break;
                    }
                    case 6: {
                        this.ots[row] = new Integer(String.valueOf(obj));
                        break;
                    }
                    case 7: {
                        this.cos[row] = new Integer(String.valueOf(obj));
                        break;
                    }
                    case 8: {
                        this.total[row] = new Integer(String.valueOf(obj));
                        break;
                    }
                }
                this.isDirty = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void load(List<IPSBathy.IPSBathyDepth> l, char units) {
            this.rowCount = l.size();
            this.setSize(this.rowCount);
            this.units = units;
            for (int i = 0; i < this.rowCount; ++i) {
                IPSBathy.IPSBathyDepth d = l.get(i);
                this.setValueAt(DepthUtils.convFromM((double)d.getDepth(), (char)units), i, 0);
                this.setValueAt(d.getDivrs(), i, 1);
                this.setValueAt(d.getBath(), i, 2);
                this.setValueAt(d.getBavg(), i, 3);
                this.setValueAt(d.getBlw(), i, 4);
                this.setValueAt(d.getBno(), i, 5);
                this.setValueAt(d.getCos(), i, 7);
                this.setValueAt(d.getOts(), i, 6);
                this.setValueAt(d.getTotal(), i, 8);
            }
            this.isDirty = false;
        }

        public void save(SBdb db, Well well) throws SQLException {
            IPSBathy I = new IPSBathy();
            LinkedList<IPSBathy.IPSBathyDepth> list = new LinkedList<IPSBathy.IPSBathyDepth>();
            if (this.rowCount > 0) {
                for (int i = 0; i < this.rowCount; ++i) {
                    try {
                        if (this.depth[i] == null || !(this.depth[i] >= 0.0)) continue;
                        IPSBathy iPSBathy = I;
                        Objects.requireNonNull(iPSBathy);
                        list.add(new IPSBathy.IPSBathyDepth(iPSBathy, DepthUtils.convToM((double)this.depth[i], (char)this.units), this.divrs[i], this.bath[i], this.bavg[i], this.blw[i], this.bno[i], this.ots[i], this.cos[i], this.total[i]));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            well.getIPSBathy().store(db, well.getWellID(), list);
        }
    }
}

