/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.model3.wellinterp.LOCNode;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.DialogSelectIGDType;
import jsbugs.DialogSelectScheme;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDScheme;
import model3.LOC;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.Surface;
import model3.Well;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogLOCSQPicks
extends SBDialog {
    private final WellInterp wellInterp;
    IGDScheme scheme;
    private final Well well;
    private final SBdb db;
    private JCheckBox[] checkBoxes;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSelectScheme;
    private JCheckBox jCheckBoxMFS;
    private JCheckBox jCheckBoxSB;
    private JCheckBox jCheckBoxTS;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonAllPicks;
    private JRadioButton jRadioButtonMajor;
    private JRadioButton jRadioButtonMedium;
    private JSeparator jSeparator1;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldVersion;

    public DialogLOCSQPicks(Frame parent, boolean modal, Well well, int interpID, IGDScheme scheme) throws SBException {
        super(parent, modal);
        this.well = well;
        this.db = well.getDataModel();
        this.wellInterp = well.getInterp(interpID);
        this.scheme = scheme;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Intervals : Create");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldVersion.setText(this.wellInterp.toString());
        if (this.scheme != null) {
            this.jTextFieldScheme.setText(this.scheme.toString());
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldVersion = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jButtonSelectScheme = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jCheckBoxSB = new JCheckBox();
        this.jCheckBoxMFS = new JCheckBox();
        this.jCheckBoxTS = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jRadioButtonMajor = new JRadioButton();
        this.jRadioButtonAllPicks = new JRadioButton();
        this.jRadioButtonMedium = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLOCSQPicks this$0;
            {
                DialogLOCSQPicks dialogLOCSQPicks = this$0;
                Objects.requireNonNull(dialogLOCSQPicks);
                this.this$0 = dialogLOCSQPicks;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLOCSQPicks this$0;
            {
                DialogLOCSQPicks dialogLOCSQPicks = this$0;
                Objects.requireNonNull(dialogLOCSQPicks);
                this.this$0 = dialogLOCSQPicks;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Version:");
        this.jTextFieldVersion.setEditable(false);
        this.jLabel2.setText("Scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jButtonSelectScheme.setText("...");
        this.jButtonSelectScheme.setToolTipText("Select a scheme");
        this.jButtonSelectScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLOCSQPicks this$0;
            {
                DialogLOCSQPicks dialogLOCSQPicks = this$0;
                Objects.requireNonNull(dialogLOCSQPicks);
                this.this$0 = dialogLOCSQPicks;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectSchemeActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Sample options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Note: Always creates LOG (pick) samples at interpolated depths");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(19, 19, 19).add((Component)this.jLabel3).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxSB.setSelected(true);
        this.jCheckBoxSB.setText("Create Sequence Boundaries/Correlative Conformities");
        this.jCheckBoxMFS.setSelected(true);
        this.jCheckBoxMFS.setText("Create Maximum Flooding Surfaces");
        this.jCheckBoxTS.setText("Create Transgressive Surfaces");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Pick magnitude", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroup1.add(this.jRadioButtonMajor);
        this.jRadioButtonMajor.setText("<html>Only <strong>major</strong> MFS  picks</html>");
        this.buttonGroup1.add(this.jRadioButtonAllPicks);
        this.jRadioButtonAllPicks.setText("<html><strong>All</strong> MFS picks</html>");
        this.buttonGroup1.add(this.jRadioButtonMedium);
        this.jRadioButtonMedium.setText("<html>Major and <strong>medium</string></html>");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(22, 22, 22).add((Component)this.jRadioButtonMajor, -2, 142, -2).addPreferredGap(0).add((Component)this.jRadioButtonMedium, -2, 142, -2).addPreferredGap(1).add((Component)this.jRadioButtonAllPicks, -2, 118, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.jRadioButtonAllPicks, this.jRadioButtonMajor, this.jRadioButtonMedium}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap(12, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jRadioButtonMajor, -2, -1, -2).add((Component)this.jRadioButtonAllPicks, -2, -1, -2).add((Component)this.jRadioButtonMedium, -2, -1, -2))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldScheme).addPreferredGap(0).add((Component)this.jButtonSelectScheme, -2, 30, -2)).add((Component)this.jTextFieldVersion).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jCheckBoxMFS).add((Component)this.jCheckBoxSB).add((Component)this.jCheckBoxTS)).add(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.linkSize(new Component[]{this.jCheckBoxMFS, this.jCheckBoxSB, this.jCheckBoxTS}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldScheme, -2, -1, -2).add((Component)this.jButtonSelectScheme)).add(5, 5, 5).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(1).add((Component)this.jCheckBoxSB).addPreferredGap(0).add((Component)this.jCheckBoxMFS).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxTS).add(24, 24, 24).add((Component)this.jPanel1, -2, -1, -2).add(18, 18, 18).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSelectSchemeActionPerformed(ActionEvent evt) {
        DialogSelectIGDType dialog = new DialogSelectIGDType((JDialog)((Object)this), true, false, false, false, false);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            if (dialog.igdType == 20) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You can't select a composite Standard here", this.getTitle(), 2);
                return;
            }
            if (dialog.igdType == 10) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You can't select a sequence scheme here - this generates intervals, not picks.", this.getTitle(), 2);
                return;
            }
            try {
                DialogSelectScheme dialogScheme = new DialogSelectScheme((JDialog)((Object)this), true, this.db, dialog.igdType, null);
                dialogScheme.setLocationRelativeTo((Component)((Object)this));
                dialogScheme.setVisible(true);
                if (dialogScheme.selection != null && dialogScheme.selection != this.scheme) {
                    this.scheme = dialogScheme.selection;
                    this.jTextFieldScheme.setText(this.scheme.toString());
                    this.scheme.loadUnits();
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        block36: {
            int opt;
            try {
                if (!this.well.canWrite(this.db, null)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), this.well.getDeniedReason(this.db, "create intervals", "well", false), this.getTitle(), 2);
                    return;
                }
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError(sql);
            }
            if (this.scheme == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 1);
                return;
            }
            LOC loc = this.wellInterp.getLOC();
            if (loc == null || loc.getSize() < 2) {
                JOptionPane.showMessageDialog((Component)((Object)this), "There is no depth/age curve defined.", this.getTitle(), 1);
                return;
            }
            if (this.buttonGroup1.getSelection() == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select surface pick magnitude.", this.getTitle(), 1);
                return;
            }
            Surface.Magnitude minMagnitude = Surface.Magnitude.MINOR;
            if (this.jRadioButtonMajor.isSelected()) {
                minMagnitude = Surface.Magnitude.MAJOR;
            } else if (this.jRadioButtonMedium.isSelected()) {
                minMagnitude = Surface.Magnitude.MEDIUM;
            }
            List<SQPick> picks = this.wellInterp.getSQPicks();
            if (!picks.isEmpty() && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Do you want to clear all existing picks?", this.getTitle(), 0, 3)) == 0) {
                try {
                    this.wellInterp.delete(picks, this.well.getWellID());
                }
                catch (SQLException | SBException | SBPermissionException sql) {
                    this.db.doRollback();
                    SbugsExceptionHandler.showStackError("Error deleting sequence picks", sql, (Component)((Object)this));
                    return;
                }
            }
            class AgeDepth {
                double age;
                double depth;
                int bnd;
                boolean isObserved;

                AgeDepth(DialogLOCSQPicks this$0, double age) {
                    Objects.requireNonNull(this$0);
                    this.bnd = -1;
                    this.isObserved = true;
                    this.age = age;
                }
            }
            HashMap<Long, AgeDepth> ageDepths = new HashMap<Long, AgeDepth>();
            try {
                for (Surface surface : this.scheme.getSurfaces()) {
                    if (surface.getType() == Surface.SurfaceType.MFS && surface.getMagnitude() < minMagnitude.getValue()) continue;
                    long age = (long)(surface.getAge() * 1.0E7);
                    System.out.println("surface: " + String.valueOf(surface) + " age: " + age);
                    if (ageDepths.get(age) != null) continue;
                    ageDepths.put(age, new AgeDepth(this, surface.getAge()));
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
                return;
            }
            Iterator itAD = ageDepths.values().iterator();
            while (itAD.hasNext()) {
                AgeDepth ad = (AgeDepth)itAD.next();
                double depth = loc.getDepth(ad.age, null, null, true);
                if (depth < 0.0) {
                    itAD.remove();
                    continue;
                }
                ad.depth = depth;
                double minAge = loc.getAge((float)depth, true);
                double maxAge = loc.getAge((float)depth, false);
                if (!(ad.age > minAge + (double)0.0029f) || !(ad.age < maxAge - (double)0.0029f)) continue;
                ad.isObserved = false;
            }
            LOCNode endNode = loc.getNode(0);
            AgeDepth ageDepth = new AgeDepth(this, endNode.getAge());
            ageDepth.depth = endNode.getDepth();
            ageDepth.bnd = endNode.getBnd();
            double youngest = ageDepth.age;
            ageDepths.put((long)(youngest * 1.0E7), ageDepth);
            endNode = loc.getNode(loc.getSize() - 1);
            ageDepth = new AgeDepth(this, endNode.getAge());
            ageDepth.depth = endNode.getDepth();
            ageDepth.bnd = endNode.getBnd();
            double oldest = ageDepth.age;
            ageDepths.put((long)(oldest * 1.0E7), ageDepth);
            for (AgeDepth a : ageDepths.values()) {
                a.bnd = loc.getBoundary(a.depth);
            }
            for (AgeDepth ageDepthX : ageDepths.values()) {
                System.out.println("ageDepth : " + ageDepthX.age + ",\t" + ageDepthX.depth + "\tBnd=" + ageDepthX.bnd);
            }
            LinkedList<SQPick.Builder> toAdd = new LinkedList<SQPick.Builder>();
            LinkedList<Sample> samplesAddedToWell = new LinkedList<Sample>();
            try {
                Sample lastSampleAdded = null;
                for (Surface surface : this.scheme.getSurfaces()) {
                    if (surface.getType() == Surface.SurfaceType.MFS && surface.getMagnitude() < minMagnitude.getValue() || (surface.getType() == Surface.SurfaceType.CC || surface.getType() == Surface.SurfaceType.SB) && !this.jCheckBoxSB.isSelected() || surface.getType() == Surface.SurfaceType.MFS && !this.jCheckBoxMFS.isSelected() || surface.getType() == Surface.SurfaceType.TS && !this.jCheckBoxTS.isSelected()) continue;
                    long age = (long)(surface.getAge() * 1.0E7);
                    if (surface.getAge() < youngest || surface.getAge() > oldest || (ageDepth = (AgeDepth)ageDepths.get(age)) == null) continue;
                    double depth = ageDepth.depth;
                    int bnd = ageDepth.bnd;
                    Sample sample = this.well.getSample(depth, null, true);
                    if (sample == null) {
                        lastSampleAdded = sample = this.well.addSample(depth, SampleType.LOG, "from depth/age");
                        samplesAddedToWell.add(sample);
                    }
                    System.out.println("Creating temporary pick: " + sample.getDepth() + ",,Surface=" + surface.getName() + ", bnd=" + bnd);
                    SQPick.Builder builder = new SQPick.Builder(this.db, surface, sample, this.scheme.getID());
                    builder.bnd(bnd).observed(ageDepth.isObserved);
                    boolean addPick = true;
                    for (SQPick.Builder p : toAdd) {
                        if (builder.getSample() != p.getSample() || builder.getSurface() != p.getSurface()) continue;
                        toAdd.remove(p);
                        break;
                    }
                    if (!addPick) continue;
                    toAdd.add(builder);
                }
                if (!samplesAddedToWell.isEmpty()) {
                    this.well.getDataModel().commit();
                }
            }
            catch (SBPermissionException pe) {
                JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
                return;
            }
            catch (SQLException | SBException sql) {
                if (!samplesAddedToWell.isEmpty()) {
                    try {
                        this.well.deleteSamples(samplesAddedToWell);
                        this.well.getDataModel().commit();
                    }
                    catch (SQLException | SBPermissionException innerE) {
                        FrameJsbugs.showStackError("Error deleting samples", (Exception)innerE, this.db);
                        System.out.println("Earlier error:");
                        sql.printStackTrace();
                        return;
                    }
                }
                FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
                return;
            }
            int nAdded = 0;
            try {
                SQPick pick = null;
                for (SQPick.Builder p : toAdd) {
                    try {
                        pick = this.wellInterp.addSQPick(this.well, p);
                        this.well.getDataModel().commit();
                        ++nAdded;
                    }
                    catch (InvalidFieldException i) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Error adding: " + String.valueOf(p.getSurface()) + " at " + p.getSample().toString() + ":\n" + i.getMessage(), this.getTitle(), 2);
                    }
                }
                if (pick != null) {
                    this.wellInterp.notifyObservers(pick);
                }
                if (!samplesAddedToWell.isEmpty()) {
                    this.well.notifyObservers(samplesAddedToWell.get(0));
                }
                JOptionPane.showMessageDialog((Component)((Object)this), "Number of picks added: " + nAdded, this.getTitle(), 1);
                this.setOK();
            }
            catch (SQLException | SBException | SBPermissionException e) {
                SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
                if (nAdded <= 0) break block36;
                JOptionPane.showMessageDialog((Component)((Object)this), "Number of picks added: " + nAdded, this.getTitle(), 1);
            }
        }
    }
}

