/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.io.FileChooserUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import org.jdesktop.layout.GroupLayout;

public class DialogList<T>
extends JDialog {
    private final UserPrefsHelper userPrefsHelper;
    private final List<T> list;
    private final DefaultListModel<T> model = new DefaultListModel();
    private final boolean multipleSelect;
    private T selection = null;
    private List<T> selected = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSaveAs;
    private JList<T> jList1;
    private JScrollPane jScrollPane1;

    public static void displayListDialog(JDialog parent, String title, UserPrefsHelper uph, List list, ListCellRenderer renderer) {
        DialogList dialog = new DialogList(parent, true, title, uph, list, false, false, renderer);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    public static void displayListDialog(Frame parent, String title, UserPrefsHelper uph, List list, ListCellRenderer renderer) {
        DialogList dialog = new DialogList(parent, true, title, uph, list, false, false, renderer);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    public DialogList(Frame parent, boolean modal, String title, UserPrefsHelper uph, List<T> list, boolean toSelect, boolean multipleSelect) {
        this(parent, modal, title, uph, list, toSelect, multipleSelect, null);
    }

    public DialogList(Frame parent, boolean modal, String title, UserPrefsHelper uph, List<T> list, boolean toSelect, boolean multipleSelect, ListCellRenderer renderer) {
        super(parent, modal);
        this.initComponents();
        this.list = list;
        this.userPrefsHelper = uph;
        this.multipleSelect = multipleSelect;
        this.init(toSelect);
        this.setTitle(title);
        if (renderer != null) {
            this.jList1.setCellRenderer(renderer);
        }
    }

    public DialogList(JDialog parent, boolean modal, String title, UserPrefsHelper uph, List<T> list, boolean toSelect, boolean multipleSelect) {
        this(parent, modal, title, uph, list, toSelect, multipleSelect, null);
    }

    public DialogList(JDialog parent, boolean modal, String title, UserPrefsHelper uph, List<T> list, boolean toSelect, boolean multipleSelect, ListCellRenderer renderer) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.setTitle(title);
        this.list = list;
        this.userPrefsHelper = uph;
        this.multipleSelect = multipleSelect;
        this.init(toSelect);
        if (renderer != null) {
            this.jList1.setCellRenderer(renderer);
        }
    }

    private void init(boolean toSelect) {
        this.model.addAll(this.list);
        if (!toSelect) {
            this.jButtonOK.setVisible(false);
            this.jButtonCancel.setText("Close");
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
            if (!this.multipleSelect) {
                this.jList1.setSelectionMode(0);
            }
        }
        if (this.userPrefsHelper == null) {
            this.jButtonSaveAs.setVisible(false);
        }
    }

    private void initComponents() {
        this.jButtonSaveAs = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(275, 250));
        this.setModal(true);
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setToolTipText("Save the current list as a text file");
        this.jButtonSaveAs.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogList this$0;
            {
                DialogList dialogList = this$0;
                Objects.requireNonNull(dialogList);
                this.this$0 = dialogList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogList this$0;
            {
                DialogList dialogList = this$0;
                Objects.requireNonNull(dialogList);
                this.this$0 = dialogList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogList this$0;
            {
                DialogList dialogList = this$0;
                Objects.requireNonNull(dialogList);
                this.this$0 = dialogList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jList1.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jList1.setModel(this.model);
        this.jList1.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogList this$0;
            {
                DialogList dialogList = this$0;
                Objects.requireNonNull(dialogList);
                this.this$0 = dialogList;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 310, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonSaveAs).addPreferredGap(0, 91, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 344, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonSaveAs).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 2);
            return;
        }
        if (!this.multipleSelect) {
            this.selection = this.model.get(this.jList1.getSelectedIndex());
        } else {
            this.selected = new LinkedList<T>();
            this.selected.addAll(this.jList1.getSelectedValuesList());
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        int opt2;
        File setDir = this.userPrefsHelper.getLastListFile();
        JFileChooser jFileChooser1 = new JFileChooser(setDir);
        jFileChooser1.setFileFilter(FileChooserUtils.TEXT_FILTER);
        int opt = jFileChooser1.showSaveDialog(this);
        if (opt != 0) {
            return;
        }
        File file = jFileChooser1.getSelectedFile();
        Object fileName = file.getPath();
        if (file.exists() && (opt2 = JOptionPane.showConfirmDialog(this, "Overwrite existing file?", "Confirm File Overwrite", 0)) != 0) {
            return;
        }
        if (!((String)fileName).toLowerCase().endsWith(".txt")) {
            fileName = (String)fileName + ".txt";
        }
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        try (FileWriter out = new FileWriter((String)fileName);){
            this.setCursor(Cursor.getPredefinedCursor(3));
            String eol = "\r\n";
            out.write("StrataBugs output: " + df.format(new Date()) + eol);
            out.write(this.getTitle() + eol + eol);
            Iterator<T> it = this.list.iterator();
            while (it.hasNext()) {
                String text = it.next().toString();
                out.write(text + eol);
            }
        }
        catch (IOException ioe) {
            SbugsExceptionHandler.showStackError("Error writing file", ioe);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        JOptionPane.showMessageDialog(this, "File '" + (String)fileName + "' written.", "File Saved", 1);
        this.userPrefsHelper.setLastListFile(file);
    }

    public void setSelectedItems(List items) {
        int[] indices = new int[items.size()];
        int n = 0;
        block0: for (int index = 0; index < this.list.size(); ++index) {
            for (Object o : items) {
                if (this.list.get(index) != o) continue;
                indices[n++] = index;
                continue block0;
            }
        }
        this.jList1.setSelectedIndices(indices);
    }

    public T getSelection() {
        return this.selection;
    }

    public Optional<T> getOptionalSelection() {
        return Optional.ofNullable(this.selection);
    }

    public List<T> getSelected() {
        return this.selected;
    }
}

