/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogLogDef;
import jsbugs.FrameJsbugs;
import jsbugs.table.ColourRenderer;
import model3.LogDef;
import model3.SBRestrictable;
import model3.SBdb;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogLogDefs
extends JDialog {
    private final SBdb db;
    private final TableModelLogdef model = new TableModelLogdef();
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JScrollPane jScrollPane1;
    private JTable jTableLogdef;

    public DialogLogDefs(Frame parent, boolean modal, SBdb db) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.init();
    }

    public DialogLogDefs(JDialog parent, boolean modal, SBdb db) throws SQLException {
        super((Dialog)parent, modal);
        this.initComponents();
        this.db = db;
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Wireline Log Header Defaults");
        this.model.setupTable(this.jTableLogdef);
        ArrayList<String> abrs = this.db.getLogDefAbrs();
        Collections.sort(abrs);
        this.model.logDefs = new LogDef[abrs.size()];
        int i = 0;
        for (String abr : abrs) {
            this.model.logDefs[i++] = this.db.getLogDef(abr);
        }
        this.jTableLogdef.setRowSorter(new TableRowSorter<TableModelLogdef>(this.model));
        new ColumnSortResetHandler(this.jTableLogdef).attach();
        this.model.fireTableDataChanged();
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonDelete.setEnabled(false);
        }
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableLogdef = new JTable();
        this.jButtonAdd = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 250));
        this.jTableLogdef.setModel(this.model);
        this.jTableLogdef.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogLogDefs this$0;
            {
                DialogLogDefs dialogLogDefs = this$0;
                Objects.requireNonNull(dialogLogDefs);
                this.this$0 = dialogLogDefs;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableLogdefMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableLogdef);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogDefs this$0;
            {
                DialogLogDefs dialogLogDefs = this$0;
                Objects.requireNonNull(dialogLogDefs);
                this.this$0 = dialogLogDefs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogDefs this$0;
            {
                DialogLogDefs dialogLogDefs = this$0;
                Objects.requireNonNull(dialogLogDefs);
                this.this$0 = dialogLogDefs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogDefs this$0;
            {
                DialogLogDefs dialogLogDefs = this$0;
                Objects.requireNonNull(dialogLogDefs);
                this.this$0 = dialogLogDefs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogDefs this$0;
            {
                DialogLogDefs dialogLogDefs = this$0;
                Objects.requireNonNull(dialogLogDefs);
                this.this$0 = dialogLogDefs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLogDefs this$0;
            {
                DialogLogDefs dialogLogDefs = this$0;
                Objects.requireNonNull(dialogLogDefs);
                this.this$0 = dialogLogDefs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 654, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, 0, 0, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonAdd, this.jButtonClose, this.jButtonDelete, this.jButtonEdit);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 197, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 330, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogLogDef dialog = new DialogLogDef(this, true, null, this.db);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.refreshModel();
            this.model.fireTableDataChanged();
        }
    }

    private void refreshModel() {
        try {
            Object[] objArr = this.db.getLogDefs().toArray();
            this.model.logDefs = new LogDef[objArr.length];
            for (int i = 0; i < objArr.length; ++i) {
                this.model.logDefs[i] = (LogDef)objArr[i];
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableLogdef.getSelectedRows();
        if (selection.length != 1) {
            JOptionPane.showMessageDialog(this, "Select one row to Edit", this.getTitle(), 1);
            return;
        }
        int index = this.jTableLogdef.convertRowIndexToModel(selection[0]);
        LogDef logDef = this.model.logDefs[index];
        DialogLogDef dialog = new DialogLogDef(this, true, logDef, this.db);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.model.fireTableDataChanged();
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableLogdef.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "Select row(s) to delete", this.getTitle(), 1);
            return;
        }
        LinkedList<LogDef> toDelete = new LinkedList<LogDef>();
        try {
            for (int i = 0; i < selection.length; ++i) {
                LogDef logDef = this.model.logDefs[this.jTableLogdef.convertRowIndexToModel(selection[i])];
                if (logDef.hasCurves()) {
                    JOptionPane.showMessageDialog(this, "You cannot delete the definition of: " + logDef.getAbr() + " because there are imported well curves based on this definition.", this.getTitle(), 2);
                    continue;
                }
                toDelete.add(logDef);
            }
            if (toDelete.isEmpty()) {
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Really delete " + (String)(toDelete.size() == 1 ? "this entry?" : "these " + toDelete.size() + " entries?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
            for (LogDef d : toDelete) {
                this.db.deleteLogdef(d);
            }
            this.db.commit();
            this.refreshModel();
            this.jTableLogdef.clearSelection();
            this.model.fireTableDataChanged();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
            pe.printStackTrace();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            this.db.doRollback();
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jTableLogdefMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtowireline.html");
    }

    private static class TableModelLogdef
    extends AbstractTableModel {
        LogDef[] logDefs = null;
        static String[] colTitle = new String[]{"Abr", "Title", "Units", "Minval", "Maxval", "Log scale?", "Background", "Line Colour", "Trace style", "Pen Style", "Pen width", "Wrap"};
        static int[] colWidth = new int[]{10, 50, 30, 20, 20, 15, 10, 10, 20, 20, 20, 10};

        private TableModelLogdef() {
        }

        @Override
        public int getColumnCount() {
            return colTitle.length;
        }

        @Override
        public int getRowCount() {
            if (this.logDefs == null) {
                return 0;
            }
            return this.logDefs.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.logDefs == null) {
                return "";
            }
            LogDef logDef = this.logDefs[row];
            switch (col) {
                case 0: {
                    return logDef.toString();
                }
                case 1: {
                    return logDef.getTitle();
                }
                case 2: {
                    return logDef.getUnits();
                }
                case 3: {
                    return Float.valueOf(logDef.getMinval());
                }
                case 4: {
                    return Float.valueOf(logDef.getMaxval());
                }
                case 5: {
                    return logDef.isAsLog();
                }
                case 6: {
                    return logDef.getBackColour();
                }
                case 7: {
                    return logDef.getLineColour();
                }
                case 8: {
                    return LogDef.traceStyles[logDef.getTraceStyle()];
                }
                case 9: {
                    return LogDef.penStyles[logDef.getPenStyle()];
                }
                case 10: {
                    return Float.valueOf(logDef.getPenWidth());
                }
                case 11: {
                    return logDef.getWrapTrace();
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: 
                case 2: 
                case 8: 
                case 9: {
                    return String.class;
                }
                case 3: 
                case 4: 
                case 10: {
                    return Float.class;
                }
                case 5: 
                case 11: {
                    return Boolean.class;
                }
                case 6: 
                case 7: {
                    return Color.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                default: 
            }
            return false;
        }

        public void setupTable(JTable jTableLogdef) {
            SB.setTableHeaderBold((JTable)jTableLogdef);
            for (int col = 0; col < colTitle.length; ++col) {
                jTableLogdef.getColumnModel().getColumn(col).setHeaderValue(colTitle[col]);
                jTableLogdef.getColumnModel().getColumn(col).setPreferredWidth(colWidth[col]);
            }
            jTableLogdef.setDefaultRenderer(Color.class, new ColourRenderer(false));
        }
    }
}

