/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeImpl;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeService;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeServiceImpl;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatchDict;
import jsbugs.TableModelSB;
import jsbugs.abnsch.DialogAbnScheme;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.ComboRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.AnalystHeader;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.TaxonOcc;
import model3.Well;
import util.SBException;
import util.exception.StackError;

public class DialogMatchAbundance
extends DialogMatchDict {
    private static final int COL_DONOR_ABR = 0;
    private static final int COL_DONOR_DESCRIPTION = 1;
    private static final int COL_DONOR_MIN = 2;
    private static final int COL_DONOR_OUTPUT = 3;
    private static final int COL_DONOR_OCCS = 4;
    private static final int COL_ARROW = 5;
    private static final int COL_HOST_ABUNDANCE = 6;
    private static final int COL_HOST_MIN = 7;
    private static final int COL_HOST_RW = 8;
    private static final int COL_HOST_CV = 9;
    private static final int COL_HOST_QU = 10;
    private static final int COL_HOST_ADDITIONAL = 11;
    private static final String[] colTitles = new String[]{"Abr.", "Description", "Min", "Output", "Occs", "", "Abundance", "Min", "Rw", "Cv", "?", "+"};
    private static final int[] colWidths = new int[]{15, 40, 20, 20, 20, 20, 60, 20, 20, 20, 20, 20};
    private static final Boolean additional = true;
    private static final Boolean notAdditional = false;
    private static final String ADDITONAL_STRING = "<additional/outside count>";
    private final TableModelMatchAbundance model = new TableModelMatchAbundance(this);
    private final SBdb ws;
    private final SBdb db;
    private final AbundanceSchemeServiceImpl wsService;
    private final AbundanceSchemeService dbService;
    private final AbundanceScheme scheme;
    private final JComboBox comboAbn = new JComboBox();
    private boolean inStartup = true;

    public DialogMatchAbundance(Frame parent, boolean modal, SBdb ws, SBdb db, AbundanceSchemeServiceImpl wsService, AbundanceScheme wsScheme, boolean inWizard) throws SQLException {
        super(parent, modal, inWizard);
        this.ws = ws;
        this.db = db;
        if (wsScheme == null) {
            throw new IllegalArgumentException("Abundance Scheme passed to MatchAbundance Scheme is null");
        }
        this.scheme = wsScheme;
        this.wsService = wsService;
        this.dbService = db.getAbundanceSchemeService();
        this.init();
    }

    private void init() throws SQLException {
        super.init(this.model, "Match Abundance", this.scheme.toString());
        this.model.setupTable(this.jTableMatch, this.comboAbn);
        this.jTableMatch.getTableHeader().setReorderingAllowed(false);
        this.refreshDBCombo();
        this.inStartup = false;
        this.setScheme();
        this.jTableMatch.setRowSorter(new TableRowSorter<TableModelMatchAbundance>(this.model));
        new ColumnSortResetHandler(this.jTableMatch).attach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void OK() {
        if (this.inWizard && this.wsService.getLink(this.scheme.getAbnSchID()) == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must match or add this scheme.", this.getTitle(), 2);
            return;
        }
        if (this.wsService.getLink(this.scheme.getAbnSchID()) != null && !this.checkMatches()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must match all terms.", this.getTitle(), 2);
            return;
        }
        if (this.wsService.getLink(this.scheme.getAbnSchID()) != null) {
            AbundanceScheme linkScheme = (AbundanceScheme)this.dbService.findAbundanceScheme(this.wsService.getLink(this.scheme.getAbnSchID()).intValue()).orElseThrow();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Iterator<Well> wit = this.ws.getWellIterator();
                while (wit.hasNext()) {
                    Well well = wit.next();
                    HashSet<AnalystHeader> selectedAnalystHeaders = new HashSet<AnalystHeader>();
                    Iterator<AnalystHeader> ait = well.getAnalystHeaderIterator();
                    while (ait.hasNext()) {
                        AnalystHeader header = ait.next();
                        if (header.getAbnSchID() <= 0 || header.getAbnSchID() != this.scheme.getAbnSchID()) continue;
                        selectedAnalystHeaders.add(header);
                    }
                    for (Sample sample : well.getSamples()) {
                        for (Smpdtl smpdtl : sample.getSmpdtls()) {
                            if (!selectedAnalystHeaders.contains(smpdtl.getHeader())) continue;
                            Iterator<TaxonOcc> oit = smpdtl.getOccurIterator();
                            block9: while (oit.hasNext()) {
                                TaxonOcc occ = oit.next();
                                if (occ.getSubAbund() == null || occ.getSubAbund().length() <= 0) continue;
                                for (MatchAbnItem item : this.model.data) {
                                    if (!item.abr.equals(occ.getSubAbund())) continue;
                                    if (item.additional || item.dbDesc.equals("Outside the count (+)")) {
                                        occ.setSubjAbund("", false, false, false);
                                        continue block9;
                                    }
                                    String abr = ((AbundanceScheme.AbundanceSchemeEntry)linkScheme.findEntryByName(item.dbDesc).get()).abr();
                                    occ.setSubjAbund(abr, item.rw, item.cv, item.questionable);
                                    continue block9;
                                }
                            }
                        }
                    }
                }
            }
            catch (RuntimeException | SQLException | SBException sql) {
                SbugsExceptionHandler.showStackError("Error updating workspace analyses. Scheme link unset.", sql);
                this.wsService.setLink(this.scheme.getAbnSchID(), null);
                this.dispose();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            ((AbundanceSchemeImpl)this.scheme).clearEntries();
            ((AbundanceSchemeImpl)this.scheme).addEntries((Collection)linkScheme.getEntries());
        }
        this.setOK();
    }

    @Override
    void closeWindow() {
        int opt;
        if (this.inWizard && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Exit guided import?", this.getTitle(), 0)) != 0) {
            return;
        }
        if (this.wsService.getLink(this.scheme.getAbnSchID()) != null && !this.checkMatches()) {
            if (JOptionPane.showConfirmDialog((Component)((Object)this), "Not all terms are matched - scheme will be unmatched. Continue?", this.getTitle(), 0) != 0) {
                return;
            }
            this.wsService.setLink(this.scheme.getAbnSchID(), null);
        }
        this.dispose();
    }

    @Override
    void comboModelActionPerformed() {
        AbundanceScheme abundanceScheme;
        if (this.inStartup) {
            return;
        }
        Object object = this.dbModel.getSelectedItem();
        if (object instanceof AbundanceScheme) {
            AbundanceScheme abnSch = (AbundanceScheme)object;
            abundanceScheme = abnSch;
        } else {
            abundanceScheme = null;
        }
        AbundanceScheme dbScheme = abundanceScheme;
        this.wsService.setLink(this.scheme.getAbnSchID(), dbScheme);
        try {
            for (MatchAbnItem item : this.model.data) {
                if (!item.additional) {
                    item.dbDesc = null;
                    item.rw = false;
                    item.cv = false;
                    item.questionable = false;
                }
                this.comboAbn.removeAllItems();
                if (dbScheme == null) continue;
                int entryIndex = dbScheme.getIndex(item.abr);
                if (entryIndex >= 0) {
                    AbundanceScheme.AbundanceSchemeEntry entry2 = dbScheme.getEntry(entryIndex);
                    String dbDesc = entry2.entryName();
                    int dbMin = entry2.lowBound();
                    if (!(item.desc != null && !item.desc.equalsIgnoreCase(dbDesc) || item.min != 0 && item.min != dbMin)) {
                        item.dbDesc = dbDesc;
                        item.dbMin = dbMin;
                    }
                }
                this.comboAbn.addItem("Outside the count (+)");
                dbScheme.getEntries().forEach(entry -> this.comboAbn.addItem(entry.entryName()));
            }
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    @Override
    void add() {
        DialogAbnScheme dialog = DialogAbnScheme.toAddExistingScheme((JDialog)((Object)this), this.db, this.scheme);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                this.refreshDBCombo();
                this.selectDbSchemeCombo(dialog.getScheme().getAbnSchID());
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError("SQL Error", sql);
            }
        }
    }

    @Override
    String getHelpPage() {
        return "dialogmatchabundance.html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScheme() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.model.data.clear();
        Iterator<Well> wit = this.ws.getWellIterator();
        try {
            while (wit.hasNext()) {
                Well well = wit.next();
                LinkedList<AnalystHeader> selectedAnalystHeaders = null;
                Iterator<AnalystHeader> ait = well.getAnalystHeaderIterator();
                while (ait.hasNext()) {
                    AnalystHeader header = ait.next();
                    if (header.getAbnSchID() <= 0 || header.getAbnSchID() != this.scheme.getAbnSchID()) continue;
                    if (selectedAnalystHeaders == null) {
                        selectedAnalystHeaders = new LinkedList<AnalystHeader>();
                    }
                    selectedAnalystHeaders.add(header);
                }
                for (Sample sample : well.getSamples()) {
                    for (Smpdtl smpdtl : sample.getSmpdtls()) {
                        boolean process = false;
                        if (selectedAnalystHeaders != null) {
                            for (AnalystHeader header : selectedAnalystHeaders) {
                                if (header != smpdtl.getHeader()) continue;
                                process = true;
                                break;
                            }
                        }
                        if (!process) continue;
                        Iterator<TaxonOcc> oit = smpdtl.getOccurIterator();
                        while (oit.hasNext()) {
                            MatchAbnItem item;
                            TaxonOcc occ = oit.next();
                            if (occ.getSubAbund() == null || occ.getSubAbund().length() <= 0) continue;
                            Iterator mit = this.model.data.iterator();
                            boolean found = false;
                            while (mit.hasNext()) {
                                item = (MatchAbnItem)mit.next();
                                if (!item.abr.equals(occ.getSubAbund())) continue;
                                found = true;
                                ++item.occs;
                                break;
                            }
                            if (found) continue;
                            item = new MatchAbnItem();
                            item.abr = occ.getSubAbund();
                            if (item.abr.equals("+")) {
                                item.additional = true;
                                item.dbDesc = ADDITONAL_STRING;
                            }
                            item.occs = 1;
                            if (this.scheme != null) {
                                int index = this.scheme.getIndex(item.abr);
                                if (index >= 0) {
                                    AbundanceScheme.AbundanceSchemeEntry entry = this.scheme.getEntry(index);
                                    item.desc = entry.entryName();
                                    item.min = entry.lowBound();
                                    item.output = entry.outputVal();
                                } else {
                                    System.out.println("Abn abr value not in selected donor Scheme: " + item.abr + ". Selected Scheme: " + String.valueOf(this.scheme));
                                }
                            }
                            this.model.data.add(item);
                        }
                    }
                }
            }
            Collections.sort(this.model.data);
            Integer linkID = this.wsService.getLink(this.scheme.getAbnSchID());
            if (linkID != null) {
                this.selectDbSchemeCombo(linkID);
            } else {
                AbundanceScheme maxScheme = this.suggestScheme();
                if (maxScheme != null) {
                    this.wsService.setLink(this.scheme.getAbnSchID(), maxScheme);
                    this.selectDbSchemeCombo(maxScheme.getAbnSchID());
                }
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError("Error loading well data", e);
        }
        catch (RuntimeException ex) {
            StackError.showStackError((String)"Error: ", (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void selectDbSchemeCombo(int abnSchID) {
        AbundanceScheme toSelect = null;
        for (int i = 0; i < this.dbModel.getSize(); ++i) {
            AbundanceScheme s;
            Object e = this.dbModel.getElementAt(i);
            if (!(e instanceof AbundanceScheme) || (s = (AbundanceScheme)e).getAbnSchID() != abnSchID) continue;
            toSelect = s;
            break;
        }
        this.dbModel.setSelectedItem(toSelect);
    }

    boolean hasAbundance() {
        return !this.model.data.isEmpty();
    }

    private AbundanceScheme suggestScheme() throws SQLException {
        int maxAbrs = 0;
        int maxDesc = 0;
        int maxMin = 0;
        int matchLevel = 0;
        AbundanceScheme bestScheme = null;
        for (AbundanceScheme sch : this.db.getAbundanceSchemeService().getAllAbundanceSchemes()) {
            int matchingAbrs = 0;
            int matchingDesc = 0;
            int matchingBound = 0;
            int nClassesInScheme = this.model.data.size();
            boolean sameSize = this.scheme.getEntryCount() == sch.getEntryCount();
            boolean sameName = this.scheme.getName().equals(sch.getName());
            boolean sameNameCaseInsensitve = this.scheme.getName().equalsIgnoreCase(sch.getName());
            boolean sameEntries = false;
            if (sameSize) {
                sameEntries = true;
                for (int i = 0; i < this.scheme.getEntryCount(); ++i) {
                    AbundanceScheme.AbundanceSchemeEntry entry = this.scheme.getEntry(i);
                    AbundanceScheme.AbundanceSchemeEntry schEntry = sch.findEntryBySubjAbund(entry.abr()).orElse(null);
                    if (schEntry == null) {
                        sameEntries = false;
                        break;
                    }
                    if (!schEntry.entryName().equalsIgnoreCase(entry.entryName())) {
                        sameEntries = false;
                        break;
                    }
                    if (schEntry.lowBound() == entry.lowBound()) continue;
                    sameEntries = false;
                    break;
                }
            }
            if (sameSize && sameName && sameEntries) {
                return sch;
            }
            for (MatchAbnItem item : this.model.data) {
                if (sch.getIndex(item.abr) <= 0) continue;
                ++matchingAbrs;
                if (sch.getEntry(sch.getIndex(item.abr)).lowBound() == item.min) {
                    ++matchingBound;
                }
                if (!sch.getEntry(sch.getIndex(item.abr)).entryName().equalsIgnoreCase(item.desc)) continue;
                ++matchingDesc;
            }
            if (matchingAbrs > maxAbrs && matchLevel < 1) {
                bestScheme = sch;
                maxAbrs = matchingAbrs;
                matchLevel = 1;
            }
            if (matchingAbrs > maxAbrs && matchingDesc > maxDesc && matchLevel < 2) {
                bestScheme = sch;
                maxAbrs = matchingAbrs;
                maxDesc = matchingDesc;
                matchLevel = 2;
            }
            if (matchingAbrs > maxAbrs && matchingDesc > maxDesc && matchingBound > maxMin && matchLevel < 3) {
                bestScheme = sch;
                maxAbrs = matchingAbrs;
                maxDesc = matchingDesc;
                maxMin = matchingBound;
                matchLevel = 3;
            }
            if (sameSize && matchingAbrs > maxAbrs && matchingDesc > maxDesc && matchingBound > maxMin && matchLevel < 4) {
                bestScheme = sch;
                maxAbrs = matchingAbrs;
                maxDesc = matchingDesc;
                maxMin = matchingBound;
                matchLevel = 4;
            }
            if (!sameSize || !sameNameCaseInsensitve || matchingAbrs < maxAbrs || matchingDesc < maxDesc || matchingBound < maxMin || matchLevel >= 5) continue;
            bestScheme = sch;
            maxAbrs = matchingAbrs;
            maxDesc = matchingDesc;
            maxMin = matchingBound;
            matchLevel = 5;
        }
        return bestScheme;
    }

    private void refreshDBCombo() throws SQLException {
        this.dbModel.removeAllElements();
        this.dbModel.addElement("<Select>");
        for (AbundanceScheme abn : this.dbService.getAllAbundanceSchemes()) {
            this.dbModel.addElement(abn);
        }
    }

    private boolean checkMatches() {
        if (this.wsService.getLink(this.scheme.getAbnSchID()) == null) {
            return true;
        }
        for (MatchAbnItem item : this.model.data) {
            if (item.dbDesc != null && item.dbDesc.length() != 0) continue;
            return false;
        }
        return true;
    }

    private class TableModelMatchAbundance
    extends AbstractTableModel {
        LinkedList<MatchAbnItem> data;
        final /* synthetic */ DialogMatchAbundance this$0;

        private TableModelMatchAbundance(DialogMatchAbundance dialogMatchAbundance) {
            DialogMatchAbundance dialogMatchAbundance2 = dialogMatchAbundance;
            Objects.requireNonNull(dialogMatchAbundance2);
            this.this$0 = dialogMatchAbundance2;
            this.data = new LinkedList();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MatchAbnItem item = this.data.get(rowIndex);
            if (item == null) {
                return "";
            }
            try {
                switch (columnIndex) {
                    case 0: {
                        return item.abr;
                    }
                    case 2: {
                        return String.valueOf(item.min > 0 ? Integer.valueOf(item.min) : "");
                    }
                    case 3: {
                        return String.valueOf(item.output > 0 ? Integer.valueOf(item.output) : "");
                    }
                    case 4: {
                        return item.occs;
                    }
                    case 1: {
                        return item.desc;
                    }
                    case 5: {
                        return item.dbDesc != null ? TableModelSB.linked : TableModelSB.unlinked;
                    }
                    case 6: {
                        return item.dbDesc != null ? item.dbDesc : "<select>";
                    }
                    case 7: {
                        return item.dbDesc != null && item.dbMin > 0 ? "" + item.dbMin : "";
                    }
                    case 8: {
                        return item.rw;
                    }
                    case 9: {
                        return item.cv;
                    }
                    case 10: {
                        return item.questionable;
                    }
                    case 11: {
                        return item.additional ? additional : notAdditional;
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                default: {
                    return String.class;
                }
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return Boolean.class;
                }
                case 4: 
            }
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                default: {
                    return false;
                }
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
            }
            return true;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            MatchAbnItem item = this.data.get(rowIndex);
            if (item == null) {
                return;
            }
            try {
                switch (columnIndex) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return;
                    }
                    case 6: {
                        item.dbDesc = (String)value;
                        Integer linkID = this.this$0.wsService.getLink(this.this$0.scheme.getAbnSchID());
                        item.dbMin = linkID != null ? ((AbundanceScheme)this.this$0.dbService.findAbundanceScheme(linkID.intValue()).get()).findEntryByName(item.dbDesc).map(AbundanceScheme.AbundanceSchemeEntry::lowBound).orElse(0) : 0;
                        if (!item.additional) break;
                        item.additional = false;
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                        break;
                    }
                    case 8: {
                        item.rw = (Boolean)value;
                        if (!item.additional) break;
                        item.additional = false;
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                        break;
                    }
                    case 9: {
                        item.cv = (Boolean)value;
                        if (!item.additional) break;
                        item.additional = false;
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                        break;
                    }
                    case 10: {
                        item.questionable = (Boolean)value;
                        if (!item.additional) break;
                        item.additional = false;
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                        break;
                    }
                    case 11: {
                        item.additional = (Boolean)value;
                        if (item.additional) {
                            item.dbDesc = DialogMatchAbundance.ADDITONAL_STRING;
                            item.rw = false;
                            item.cv = false;
                            item.questionable = false;
                        } else {
                            item.dbDesc = null;
                        }
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void setupTable(JTable jTable, JComboBox combo) {
            TableUtils.setTableHeaderBold((JTable)jTable);
            for (int i = 0; i < colTitles.length; ++i) {
                jTable.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
            }
            jTable.getColumnModel().getColumn(5).setCellRenderer(new ArrowCellRenderer());
            jTable.getColumnModel().getColumn(5).setMaxWidth(colWidths[5]);
            jTable.getColumnModel().getColumn(6).setCellEditor(new DefaultCellEditor(combo));
            jTable.getColumnModel().getColumn(6).setCellRenderer(new ComboRenderer());
            jTable.setToolTipText("Click on Database abundance entry to select matching abundance in host database scheme.");
        }
    }

    private static class MatchAbnItem
    implements Comparable<MatchAbnItem> {
        String abr;
        String desc;
        int min;
        int output;
        int occs;
        String dbDesc;
        int dbMin;
        boolean rw;
        boolean cv;
        boolean questionable;
        boolean additional;

        private MatchAbnItem() {
        }

        @Override
        public int compareTo(MatchAbnItem comp) {
            if (this.min < comp.min) {
                return -1;
            }
            if (this.min > comp.min) {
                return 1;
            }
            return this.abr.compareTo(comp.abr);
        }
    }
}

