/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeServiceImpl;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatchAnalystHeaders;
import jsbugs.DialogMatchTaxonOcc;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchAnalyses;
import jsbugs.refresh.RefreshHelper;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.SampleRenderer;
import jsbugs.table.SampleStatusRenderer;
import model3.AnalystHeader;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.TaxonOcc;
import model3.Well;
import model3.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.MatchData;
import util.SB;
import util.SBException;
import util.exception.StackError;
import util.status.SbugsStatus;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchAnalyses
extends JDialog {
    private final TableModelMatchAnalyses model = new TableModelMatchAnalyses();
    WsWell wsWell;
    char discID = '\u0000';
    Image backgroundImage;
    private final Frame parent;
    SBdb db;
    private JButton jButton1;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonHeaders;
    private JButton jButtonHelp;
    private JButton jButtonOccurrences;
    private JButton jButtonSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JTable jTableMatchAnalyses;

    public DialogMatchAnalyses(Frame parent, boolean modal, SBdb ws, SBdb db, WsWell well, char units, char discID) throws SQLException, SBException {
        super(parent, modal);
        this.wsWell = well;
        this.discID = discID;
        this.model.units = units;
        this.model.workspace = ws;
        this.db = db;
        this.parent = parent;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Analyses");
        this.checkLinks();
        if (this.wsWell.getLink() != null) {
            this.wsWell.updateAnalystHeadersStatus();
        }
        this.model.data.init(this.wsWell.getAnalyses(this.discID, null, 0), (List)(this.wsWell.getLink() != null ? this.wsWell.getLink().getAnalyses(this.discID, null, 0) : (List<Smpdtl>)null));
        SB.setTableHeaderBold((JTable)this.jTableMatchAnalyses);
        TableColumnModel columnModel = this.jTableMatchAnalyses.getTableHeader().getColumnModel();
        columnModel.getColumn(15).setMaxWidth(TableModelMatchAnalyses.colWidths[15]);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchAnalyses.colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(TableModelMatchAnalyses.colWidths[i]);
        }
        this.jTableMatchAnalyses.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        columnModel.getColumn(16).setCellRenderer(new SampleRenderer(this.model.units));
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)((Object)new SampleStatusRenderer(this.model.units)));
        this.jTableMatchAnalyses.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        this.jTableMatchAnalyses.setRowSorter(new TableRowSorter<TableModelMatchAnalyses>(this.model));
        new ColumnSortResetHandler(this.jTableMatchAnalyses).attach();
        this.model.fireTableDataChanged();
        this.jTableMatchAnalyses.getTableHeader().setReorderingAllowed(false);
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/resources/icon/matchBG.png"));
    }

    private void checkLinks() throws SQLException, SBException {
        if (this.wsWell.getLink() != null && !this.wsWell.getAnalyses(this.discID, null, 0).isEmpty()) {
            for (Userdef u : this.model.workspace.getUsers()) {
                if (u.getLink() != null) continue;
                throw new SBException("Cannot open dialog; analysts not matched");
            }
            for (Smpdtl dtl : this.wsWell.getAnalyses(this.discID, null, 0)) {
                Iterator<TaxonOcc> it = dtl.getOccurIterator();
                while (it.hasNext()) {
                    TaxonOcc occ = it.next();
                    if (occ.getTaxon() == null) {
                        throw new SBException("Corrupt file - missing species dictionary");
                    }
                    if (occ.getTaxon().getLink() != null) continue;
                    throw new SBException("Cannot open dialog; taxa not matched");
                }
            }
            for (AnalystHeader hdr : this.wsWell.getAnalystHeaders()) {
                if (hdr.getDiscID() != this.discID) continue;
                if (hdr.getAbnSchID() > 0 && ((AbundanceSchemeServiceImpl)this.model.workspace.getAbundanceSchemeService()).getLink(hdr.getAbnSchID()) == null) {
                    throw new SBException("Cannot open dialog; abundance scheme '" + this.model.workspace.getAbundanceSchemeService().findAbundanceScheme(hdr.getAbnSchID()).map(AbundanceScheme::getName).orElse("NULL") + "' not matched");
                }
                if (hdr.getEnvSchID() <= 0 || this.model.workspace.getEnvScheme(hdr.getEnvSchID()) == null || this.model.workspace.getEnvScheme(hdr.getEnvSchID()).getLink() != null) continue;
                throw new SBException("Cannot open dialog; paleoenvironment scheme '" + String.valueOf(this.model.workspace.getEnvScheme(hdr.getEnvSchID())) + "' not matched");
            }
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchAnalyses this$0;
            {
                DialogMatchAnalyses dialogMatchAnalyses = this$0;
                Objects.requireNonNull(dialogMatchAnalyses);
                this.this$0 = dialogMatchAnalyses;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane2 = new JScrollPane();
        this.jTableMatchAnalyses = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOccurrences = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonHeaders = new JButton();
        this.jButtonHelp = new JButton();
        this.jButton1.setText("jButton1");
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.lightGray);
        this.setMinimumSize(new Dimension(600, 300));
        this.setModal(true);
        this.jScrollPane2.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableMatchAnalyses.setModel(this.model);
        this.jTableMatchAnalyses.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogMatchAnalyses this$0;
            {
                DialogMatchAnalyses dialogMatchAnalyses = this$0;
                Objects.requireNonNull(dialogMatchAnalyses);
                this.this$0 = dialogMatchAnalyses;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableMatchAnalysesMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableMatchAnalyses);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonCancel.setText("Close");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchAnalyses this$0;
            {
                DialogMatchAnalyses dialogMatchAnalyses = this$0;
                Objects.requireNonNull(dialogMatchAnalyses);
                this.this$0 = dialogMatchAnalyses;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOccurrences.setText("Occurrences...");
        this.jButtonOccurrences.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonOccurrences.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchAnalyses this$0;
            {
                DialogMatchAnalyses dialogMatchAnalyses = this$0;
                Objects.requireNonNull(dialogMatchAnalyses);
                this.this$0 = dialogMatchAnalyses;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOccurrencesActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save ALL unsaved analyses from workspace into database");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchAnalyses this$0;
            {
                DialogMatchAnalyses dialogMatchAnalyses = this$0;
                Objects.requireNonNull(dialogMatchAnalyses);
                this.this$0 = dialogMatchAnalyses;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected analyses from database");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchAnalyses this$0;
            {
                DialogMatchAnalyses dialogMatchAnalyses = this$0;
                Objects.requireNonNull(dialogMatchAnalyses);
                this.this$0 = dialogMatchAnalyses;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected analyses from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchAnalyses this$0;
            {
                DialogMatchAnalyses dialogMatchAnalyses = this$0;
                Objects.requireNonNull(dialogMatchAnalyses);
                this.this$0 = dialogMatchAnalyses;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonHeaders.setText("Suites...");
        this.jButtonHeaders.setToolTipText("Match analysis suites");
        this.jButtonHeaders.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchAnalyses this$0;
            {
                DialogMatchAnalyses dialogMatchAnalyses = this$0;
                Objects.requireNonNull(dialogMatchAnalyses);
                this.this$0 = dialogMatchAnalyses;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHeadersActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchAnalyses this$0;
            {
                DialogMatchAnalyses dialogMatchAnalyses = this$0;
                Objects.requireNonNull(dialogMatchAnalyses);
                this.this$0 = dialogMatchAnalyses;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 533, Short.MAX_VALUE).add((Component)this.jLabel2)).add(2, (Component)this.jScrollPane2, -1, 712, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2, false).add((Component)this.jButtonExclude, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSave, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOccurrences, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHeaders, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonExclude).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonSave).addPreferredGap(0).add((Component)this.jButtonOccurrences).addPreferredGap(0).add((Component)this.jButtonHeaders).addPreferredGap(0, 297, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane2, -1, 530, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteAnalyses(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteAnalyses(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
            return;
        }
        for (int row = 0; row < this.model.data.size(); ++row) {
            MatchData.MatchPair pair = this.model.data.get(row);
            Smpdtl ws = (Smpdtl)pair.getWs();
            if (ws == null || ws.getStatus() != Smpdtl.CONFLICT) continue;
            JOptionPane.showMessageDialog(this, "Conflicting data in workspace at sample: " + String.valueOf(ws.getSample()), this.getTitle(), 2);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object row = RefreshHelper.REFRESH_LOCK;
            synchronized (row) {
                Statement stmt = null;
                for (int row2 = 0; row2 < this.model.data.size(); ++row2) {
                    MatchData.MatchPair pair = this.model.data.get(row2);
                    Smpdtl wsDtl = (Smpdtl)pair.getWs();
                    Smpdtl dbDtl = (Smpdtl)pair.getDb();
                    if (dbDtl == null) {
                        AnalystHeader hdr;
                        Sample wsSample = wsDtl.getSample();
                        Sample dbSample = this.wsWell.getLink().getSample(wsSample.getTopDepth(), wsSample.getBaseDepth(), wsSample.getType(), false);
                        if (dbSample == null) {
                            if (stmt == null) {
                                stmt = this.wsWell.getLink().getDataModel().getDatabase().createStatement();
                            }
                            dbSample = this.wsWell.getLink().addSampleCopy(stmt, wsSample);
                        }
                        if ((hdr = this.wsWell.getLink().getAnalystHeader(wsDtl.getAnalystAbr(), wsDtl.getDiscID(), wsDtl.getAnalyNo(), false)) == null) {
                            AnalystHeader wsHdr = this.wsWell.getAnalystHeader(wsDtl.getAnalystAbr(), wsDtl.getDiscID(), wsDtl.getAnalyNo(), false);
                            if (wsHdr == null) {
                                hdr = this.wsWell.getLink().getAnalystHeader(wsDtl.getAnalystAbr(), wsDtl.getDiscID(), wsDtl.getAnalyNo(), true);
                            } else {
                                int envSchID = -1;
                                int abnSchID = -1;
                                if (wsHdr.getEnvSchID() > 0) {
                                    envSchID = this.wsWell.getDataModel().getEnvScheme(wsHdr.getEnvSchID()).getLink().getID();
                                }
                                if (wsHdr.getAbnSchID() > 0) {
                                    abnSchID = ((AbundanceSchemeServiceImpl)this.wsWell.getDataModel().getAbundanceSchemeService()).getLink(wsHdr.getAbnSchID());
                                }
                                hdr = this.wsWell.getLink().addAnalystHeader(wsDtl.getAnalystAbr(), wsDtl.getDiscID(), wsDtl.getAnalyNo(), wsHdr.getDepthFrom(), wsHdr.getDepthTo(), wsHdr.getDateFrom(), wsHdr.getDateTo(), wsHdr.getComments() != null ? wsHdr.getComments() : "", envSchID, abnSchID, Color.BLACK);
                            }
                        } else {
                            if (this.wsWell.getAnalystHeader(wsDtl.getAnalystAbr(), wsDtl.getDiscID(), wsDtl.getAnalyNo(), false).getStatus() == SbugsStatus.CONFLICT) {
                                String msg = "Cannot save: conflicting analyst suite header information. Press Suites... to reconcile.";
                                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                                return;
                            }
                            if (wsDtl.hasSemiQuantData() && hdr.getAbnSchID() <= 0) {
                                int wsAbnSchID = this.wsWell.getAnalystHeader(wsDtl.getAnalystAbr(), wsDtl.getDiscID(), wsDtl.getAnalyNo(), false).getAbnSchID();
                                Integer linkAbnSchID = ((AbundanceSchemeServiceImpl)this.wsWell.getDataModel().getAbundanceSchemeService()).getLink(wsAbnSchID);
                                if (linkAbnSchID != null) {
                                    hdr.setAbnScheme(linkAbnSchID);
                                }
                            }
                        }
                        try {
                            dbDtl = new Smpdtl(stmt, this.wsWell.getLink().getDataModel(), this.wsWell.getDataModel(), wsDtl, this.wsWell.getLink().getWellID(), dbSample.getSampID(), hdr);
                            dbSample.addDtl(dbDtl);
                            continue;
                        }
                        catch (SQLException sqle) {
                            if (JOptionPane.showConfirmDialog(this, "Error saving analyses: " + sqle.getMessage() + "\nContinue to save?", this.getTitle(), 0, 3) != 1) continue;
                            throw sqle;
                        }
                    }
                    if (wsDtl == null || wsDtl.getStatus() != Sample.PARTSTORED) continue;
                    dbDtl.update(this.wsWell.getLink().getWellID(), wsDtl);
                }
                if (stmt != null) {
                    stmt.close();
                }
                this.model.data.init(this.wsWell.getAnalyses(this.discID, null, 0), this.wsWell.getLink().getAnalyses(this.discID, null, 0));
                this.model.fireTableDataChanged();
                this.wsWell.getLink().getDataModel().commit();
            }
            this.wsWell.getLink().setDataChanged();
            this.wsWell.getLink().notifyObservers(Smpdtl.class);
            return;
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error saving analyses", (Throwable)e);
            this.wsWell.getLink().getDataModel().doRollback();
            return;
        }
        finally {
            this.model.fireTableDataChanged();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTableMatchAnalysesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOccurrencesActionPerformed(null);
        }
    }

    private void jButtonOccurrencesActionPerformed(ActionEvent evt) {
        if (this.jTableMatchAnalyses.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row", this.getTitle(), 2);
            return;
        }
        MatchData.MatchPair pair = this.model.data.get(this.jTableMatchAnalyses.convertRowIndexToModel(this.jTableMatchAnalyses.getSelectedRow()));
        Smpdtl wsDtl = (Smpdtl)pair.getWs();
        Smpdtl dbDtl = (Smpdtl)pair.getDb();
        try {
            DialogMatchTaxonOcc dialog = new DialogMatchTaxonOcc(this, true, this.wsWell, wsDtl, dbDtl);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (wsDtl != null && dbDtl != null) {
                wsDtl.updateStatus();
                if (wsDtl.getStatus() != SbugsStatus.CONFLICT) {
                    wsDtl.updateStatus(dbDtl);
                }
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("Cannot open dialog - taxa not Matched")) {
                JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 1);
            }
            e.printStackTrace();
            StackError.showStackError((String)"Error opening TaxonOcc dialog", (Throwable)e);
        }
    }

    private void jButtonHeadersActionPerformed(ActionEvent evt) {
        if (this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "Cannot show this dialog before well is matched.", this.getTitle(), 2);
            return;
        }
        DialogMatchAnalystHeaders dialog = new DialogMatchAnalystHeaders(this.parent, true, this.discID, this.wsWell, this.model.workspace, this.db);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.hasChanged) {
            try {
                this.wsWell.updateSampleStatus(true);
                this.model.data.init(this.wsWell.getAnalyses(this.discID, null, 0), this.wsWell.getLink().getAnalyses(this.discID, null, 0));
            }
            catch (Exception e) {
                e.printStackTrace();
                StackError.showStackError((String)"Error: ", (Throwable)e);
            }
            this.model.fireTableDataChanged();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchanalyses.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAnalyses(boolean fromDatabase) {
        if (fromDatabase && this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
            return;
        }
        if (this.jTableMatchAnalyses.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No analyses selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchAnalyses.getSelectedRows();
        LinkedList<Smpdtl> toRemove = new LinkedList<Smpdtl>();
        for (int i : selected) {
            Smpdtl smpdtl = fromDatabase ? (Smpdtl)this.model.data.get(this.jTableMatchAnalyses.convertRowIndexToModel(i)).getDb() : (Smpdtl)this.model.data.get(this.jTableMatchAnalyses.convertRowIndexToModel(i)).getWs();
            if (smpdtl == null) continue;
            toRemove.add(smpdtl);
        }
        if (fromDatabase && toRemove.size() > 0) {
            Object msg = "Really delete ";
            if (JOptionPane.showConfirmDialog(this, msg = (String)msg + (String)(toRemove.size() == 1 ? "this analysis?" : "these " + toRemove.size() + " analyses?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int nSamples = 0;
            Well deleteWell = fromDatabase ? this.wsWell.getLink() : this.wsWell;
            Smpdtl lastSmpdtl = null;
            for (Smpdtl smpdtl : toRemove) {
                Sample sample = smpdtl.getSample();
                sample.deleteDtl(deleteWell.getWellID(), smpdtl.getAnalyID(), smpdtl);
                deleteWell.setDataChanged();
                lastSmpdtl = smpdtl;
                ++nSamples;
            }
            String text = fromDatabase ? "deleted" : "excluded";
            JOptionPane.showMessageDialog(this, "Analyses " + text + ": " + nSamples, this.getTitle(), 1);
            this.wsWell.updateSampleStatus(true);
            this.model.data.init(this.wsWell.getAnalyses(this.discID, null, 0), this.wsWell.getLink() != null ? this.wsWell.getLink().getAnalyses(this.discID, null, 0) : null);
            this.model.fireTableDataChanged();
            if (fromDatabase) {
                deleteWell.getDataModel().commit();
                deleteWell.getDataModel().updateAuditTrail("ANALYSES", "DELETE " + toRemove.size() + " from " + deleteWell.toString() + " [" + deleteWell.getWellID() + "]");
                deleteWell.notifyObservers((Object)lastSmpdtl);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            if (fromDatabase) {
                this.wsWell.getLink().getDataModel().doRollback();
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

