/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.user.User;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.ws.LinkedWorkspace;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatch;
import jsbugs.TableModelMatchSamples;
import jsbugs.TableModelSB;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.ComboRenderer;
import jsbugs.userconnect.DialogUserdef;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import net.miginfocom.swing.MigLayout;
import util.SBException;
import util.status.SbugsStatusRenderer;

public class DialogMatchAnalysts
extends JDialog {
    private final TableModelMatchAnalysts model = new TableModelMatchAnalysts(this);
    private final JComboBox<String> analystComboBox = new JComboBox();
    private final Image backgroundImage = DialogMatch.getBackgroundImage();
    private final boolean inWizard;
    private boolean inStartup = true;
    private boolean OK = false;
    private final SBdb ws;
    private final SBdb db;
    private final LinkedWorkspace linkedWorkspace;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTable jTableAnalysts;
    private JButton jButtonMatchAll;
    private JButton jButtonAdd;
    private JButton jButtonOK;
    private JButton jButtonHelp;
    private JLabel jLabel3;
    private JComboBox<String> jComboBoxSetUnmatched;
    private JButton jButtonAddAll;

    public DialogMatchAnalysts(Frame parent, boolean modal, SBdb ws, SBdb db, boolean inWizard) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.inWizard = inWizard;
        this.ws = ws;
        this.db = db;
        this.linkedWorkspace = null;
        this.init();
    }

    public DialogMatchAnalysts(Frame parent, boolean modal, LinkedWorkspace linkedWorkspace, boolean inWizard) {
        super(parent, modal);
        this.initComponents();
        this.inWizard = inWizard;
        this.linkedWorkspace = linkedWorkspace;
        this.ws = linkedWorkspace.sourceModel;
        this.db = linkedWorkspace.targetModel;
        this.init();
    }

    private void init() {
        this.setupTable();
        this.jTableAnalysts.setRowSorter(new TableRowSorter<TableModelMatchAnalysts>(this.model));
        new ColumnSortResetHandler(this.jTableAnalysts).attach();
        this.model.fireTableDataChanged();
        this.jTableAnalysts.getTableHeader().setReorderingAllowed(false);
        this.jButtonOK.setText(this.inWizard ? "Continue" : "Close");
        this.setTitle("Match Analysts/Personnel");
        this.jComboBoxSetUnmatched.setSelectedIndex(0);
        this.inStartup = false;
    }

    void setupTable() {
        try {
            this.model.sourceUsers = this.ws.getUserService().getAllUsers();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        this.refreshUserCombo();
        JTable table = this.jTableAnalysts;
        for (int i = 0; i < TableModelMatchAnalysts.COL_TITLES.length; ++i) {
            table.getColumnModel().getColumn(i).setHeaderValue(TableModelMatchAnalysts.COL_TITLES[i]);
            table.getColumnModel().getColumn(i).setPreferredWidth(TableModelMatchAnalysts.COL_WIDTHS[i]);
        }
        table.getColumnModel().getColumn(2).setMaxWidth(TableModelMatchSamples.colWidths[2]);
        table.setDefaultRenderer(Userdef.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(this.analystComboBox));
        table.getColumnModel().getColumn(3).setCellRenderer(new ComboRenderer());
        TableUtils.setTableHeaderBold((JTable)table);
        table.setToolTipText("Click on blank database abbreviation to select");
    }

    void refreshUserCombo() {
        this.analystComboBox.removeAllItems();
        this.jComboBoxSetUnmatched.removeAllItems();
        List<String> userAbrs = this.db.getUserService().getAllUsers().stream().map(User::getAbr).toList();
        for (String abr : userAbrs) {
            this.analystComboBox.addItem(abr);
            this.jComboBoxSetUnmatched.addItem(abr);
        }
        this.analystComboBox.insertItemAt("", 0);
        this.jComboBoxSetUnmatched.insertItemAt("", 0);
        this.jComboBoxSetUnmatched.setSelectedIndex(0);
    }

    private Optional<User> getLink(User sourceUser) {
        if (this.linkedWorkspace != null) {
            return this.linkedWorkspace.getUserLink(sourceUser);
        }
        try {
            Userdef sourceUserdef = this.ws.getUser(sourceUser.getUserID());
            Userdef targetUserdef = sourceUserdef.getLink();
            if (targetUserdef != null) {
                return Optional.of(targetUserdef.getUserCopy());
            }
            return Optional.empty();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private void jButtonAddAll(ActionEvent e) {
        try {
            if (this.linkedWorkspace != null) {
                this.linkedWorkspace.addUnmatchedUsers();
            } else {
                for (User sourceUser : this.model.sourceUsers) {
                    Userdef sourceUserdef = this.ws.getUser(sourceUser.getUserID());
                    if (sourceUserdef.getLink() != null) continue;
                    Userdef dbUser = this.db.getUser(sourceUserdef.getAbr());
                    if (dbUser != null) {
                        sourceUserdef.setLink(dbUser);
                        continue;
                    }
                    if (sourceUserdef.getName() == null || sourceUserdef.getDiscipline() == null) continue;
                    sourceUserdef.setLink(this.db.addUser(sourceUserdef.getAbr(), sourceUserdef.getName(), null, sourceUserdef.getDiscipline(), sourceUserdef.getColour(), null, 0));
                }
            }
            this.db.commit();
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError("Error getting personnel", ex, this);
            this.db.doRollback();
        }
        this.model.fireTableDataChanged();
    }

    private void setLink(User sourceUser, String targetUserAbr) {
        if (this.linkedWorkspace != null) {
            this.linkedWorkspace.setUserLink(sourceUser.getUserID(), this.linkedWorkspace.targetModel.getUserService().findUserByAbr(targetUserAbr).map(User::getUserID).orElse(null));
            return;
        }
        try {
            Userdef sourceUserdef = this.ws.getUser(sourceUser.getUserID());
            Userdef dbUser = this.db.getUser(targetUserAbr);
            sourceUserdef.setLink(dbUser);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchAnalysts this$0;
            {
                DialogMatchAnalysts dialogMatchAnalysts = this$0;
                Objects.requireNonNull(dialogMatchAnalysts);
                this.this$0 = dialogMatchAnalysts;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableAnalysts = new JTable();
        this.jButtonMatchAll = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabel3 = new JLabel();
        this.jComboBoxSetUnmatched = new JComboBox();
        this.jButtonAddAll = new JButton();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(400, 250));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogMatchAnalysts this$0;
            {
                DialogMatchAnalysts dialogMatchAnalysts = this$0;
                Objects.requireNonNull(dialogMatchAnalysts);
                this.this$0 = dialogMatchAnalysts;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.windowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new MigLayout("fill,insets 0,hidemode 3", "[fill]", "[fill]"));
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, (float)this.jLabel1.getFont().getSize() + 2.0f));
        this.jLabel1.setForeground(Color.white);
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, (float)this.jLabel2.getFont().getSize() + 2.0f));
        this.jLabel2.setText("...Database");
        this.jScrollPane1.setToolTipText("Select the database abbreviation to match");
        this.jScrollPane1.setViewportBorder(new LineBorder(Color.white));
        this.jTableAnalysts.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableAnalysts);
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(e -> this.jButtonMatchAllActionPerformed(e));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(e -> this.jButtonAddActionPerformed(e));
        this.jButtonOK.setText("Close");
        this.jButtonOK.addActionListener(e -> this.jButtonOKActionPerformed(e));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(e -> this.jButtonHelpActionPerformed(e));
        this.jLabel3.setText("<html>Set <strong>all </strong>unmatched to:</html>");
        this.jComboBoxSetUnmatched.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxSetUnmatched.setToolTipText("");
        this.jComboBoxSetUnmatched.addActionListener(e -> this.jComboBoxSetUnmatchedActionPerformed(e));
        this.jButtonAddAll.setText("Add all...");
        this.jButtonAddAll.addActionListener(e -> this.jButtonAddAll(e));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup().addComponent(this.jScrollPane1, -1, 451, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonMatchAll).addComponent(this.jButtonAdd).addComponent(this.jButtonOK).addComponent(this.jButtonHelp).addComponent(this.jLabel3, -1, -1, -2).addComponent(this.jComboBoxSetUnmatched, -1, -1, -2).addComponent(this.jButtonAddAll, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonAdd, this.jButtonHelp, this.jButtonMatchAll, this.jButtonOK, this.jComboBoxSetUnmatched, this.jLabel3);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 21, -2).addComponent(this.jLabel2, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonMatchAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddAll).addGap(38, 38, 38).addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxSetUnmatched, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 39, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOK)).addComponent(this.jScrollPane1, -1, 249, Short.MAX_VALUE)).addContainerGap()));
        contentPane.add((Component)this.jPanel1, "cell 0 0");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        if (this.linkedWorkspace != null) {
            this.linkedWorkspace.matchUnmatchedUsers();
        } else {
            try {
                for (User sourceUser : this.model.sourceUsers) {
                    Userdef dbUser;
                    Userdef sourceUserdef = this.ws.getUser(sourceUser.getUserID());
                    if (sourceUserdef.getLink() != null || (dbUser = this.db.getUser(sourceUserdef.getAbr())) == null) continue;
                    sourceUserdef.setLink(dbUser);
                }
            }
            catch (RuntimeException | SQLException ex) {
                SbugsExceptionHandler.showStackError("Error getting personnel", ex, this);
            }
        }
        this.model.fireTableDataChanged();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.jTableAnalysts.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row from the table to add", this.getTitle(), 1);
            return;
        }
        User sourceUser = this.model.sourceUsers.get(this.jTableAnalysts.convertRowIndexToModel(this.jTableAnalysts.getSelectedRow()));
        if (this.getLink(sourceUser).isPresent()) {
            JOptionPane.showMessageDialog(this, "This user is already linked", this.getTitle(), 1);
            return;
        }
        this.addUserFromDialog(sourceUser, sourceUser.getName(), sourceUser.getDiscipline());
    }

    private void addUserFromDialog(User wsUser, String name, Discipline discipline) {
        if (this.jTableAnalysts.getCellEditor() != null) {
            this.jTableAnalysts.getCellEditor().cancelCellEditing();
        }
        DialogUserdef dialog = new DialogUserdef(this, true, this.db, wsUser.getAbr(), name, discipline);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                this.setLink(wsUser, dialog.getUser().getAbr());
                this.refreshUserCombo();
                this.jTableAnalysts.repaint();
            }
            catch (RuntimeException sql) {
                SbugsExceptionHandler.showStackError("Error getting personnel", sql, this);
            }
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            for (User sourceUser : this.model.sourceUsers) {
                if (!this.getLink(sourceUser).isEmpty()) continue;
                if (this.inWizard) {
                    JOptionPane.showMessageDialog(this, "You must match all personnel.", this.getTitle(), 2);
                    return;
                }
                Object[] options = new String[]{"Close", "Cancel"};
                int opt = JOptionPane.showOptionDialog(this, "Warning: not all personnel are matched.", this.getTitle(), 1, 3, null, options, null);
                if (opt == 0) break;
                return;
            }
            try {
                if (!this.checkForConflictingMatches()) {
                    return;
                }
            }
            catch (SQLException | SBException e) {
                SbugsExceptionHandler.showStackError("Error checking for match conflicts", e);
                return;
            }
            this.OK = true;
            this.dispose();
        }
        catch (RuntimeException re) {
            SbugsExceptionHandler.showStackError(re);
        }
    }

    public boolean isOK() {
        return this.OK;
    }

    private boolean checkForConflictingMatches() throws SQLException, SBException {
        for (User sourceUser : this.model.sourceUsers) {
            User link = this.getLink(sourceUser).orElse(null);
            if (link == null) continue;
            for (User sourceUser2 : this.model.sourceUsers) {
                User link2 = this.getLink(sourceUser2).orElse(null);
                if (sourceUser2 == sourceUser || link2 == null || link.getUserID() != link2.getUserID() || this.ws.checkAnalystConflicts(sourceUser.getUserID(), sourceUser2.getUserID())) continue;
                JOptionPane.showMessageDialog(this, "You cannot match these two analysts: " + sourceUser.getAbr() + "/" + sourceUser2.getAbr() + " to the same database analyst because it would create conflicting analyses or comment data.", this.getTitle(), 2);
                return false;
            }
        }
        if (this.linkedWorkspace != null) {
            for (User sourceUser : this.model.sourceUsers) {
                sourceUser.setAbr(this.getLink(sourceUser).get().getAbr());
            }
        } else {
            for (User sourceUser : this.model.sourceUsers) {
                Userdef sourceUserdef = this.ws.getUser(sourceUser.getUserID());
                sourceUserdef.setFromLink();
            }
        }
        return true;
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogmatchanalysts.html");
    }

    private void windowClosing(WindowEvent evt) {
        int opt;
        if (this.inWizard && (opt = JOptionPane.showConfirmDialog(this, "Exit guided import?", this.getTitle(), 0)) != 0) {
            return;
        }
        try {
            if (!this.checkForConflictingMatches()) {
                return;
            }
        }
        catch (SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error checking for match conflicts", e, this);
            return;
        }
        this.dispose();
    }

    private void jComboBoxSetUnmatchedActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(this){
            final /* synthetic */ DialogMatchAnalysts this$0;
            {
                DialogMatchAnalysts dialogMatchAnalysts = this$0;
                Objects.requireNonNull(dialogMatchAnalysts);
                this.this$0 = dialogMatchAnalysts;
            }

            @Override
            public void run() {
                try {
                    String analyst = (String)this.this$0.jComboBoxSetUnmatched.getSelectedItem();
                    if (analyst == null || analyst.isEmpty()) {
                        return;
                    }
                    Userdef dbUser = this.this$0.db.getUser(analyst);
                    if (dbUser == null) {
                        JOptionPane.showMessageDialog(this.this$0.jScrollPane1, "Error getting user in Match Analyst");
                        return;
                    }
                    int opt = JOptionPane.showConfirmDialog(this.this$0.jScrollPane1, "Set all unmatched analysts to: " + dbUser.getAbr() + "/" + dbUser.getName() + "?\n(A check will be made for potential conflicts on OK)", this.this$0.getTitle(), 0, 3);
                    if (opt == 1) {
                        return;
                    }
                    for (User sourceUser : this.this$0.model.sourceUsers) {
                        if (!this.this$0.getLink(sourceUser).isEmpty()) continue;
                        this.this$0.setLink(sourceUser, analyst);
                    }
                    this.this$0.model.fireTableDataChanged();
                }
                catch (RuntimeException | SQLException sql) {
                    SbugsExceptionHandler.showStackError("Error getting personnel", sql, this.this$0);
                }
            }
        });
    }

    private class TableModelMatchAnalysts
    extends AbstractTableModel {
        private static final String[] COL_TITLES = new String[]{"Abr.", "Name", "", "Abr.", "Name"};
        static final int COL_DONOR_ABR = 0;
        static final int COL_DONOR_NAME = 1;
        static final int COL_ARROW = 2;
        static final int COL_HOST_ABR = 3;
        static final int COL_HOST_NAME = 4;
        private static final int[] COL_WIDTHS = new int[]{50, 150, 20, 50, 150};
        List<User> sourceUsers;
        final /* synthetic */ DialogMatchAnalysts this$0;

        private TableModelMatchAnalysts(DialogMatchAnalysts dialogMatchAnalysts) {
            DialogMatchAnalysts dialogMatchAnalysts2 = dialogMatchAnalysts;
            Objects.requireNonNull(dialogMatchAnalysts2);
            this.this$0 = dialogMatchAnalysts2;
            this.sourceUsers = new ArrayList<User>();
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public int getRowCount() {
            return this.sourceUsers.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                User sourceUser = this.sourceUsers.get(rowIndex);
                return switch (columnIndex) {
                    case 0 -> sourceUser.getAbr();
                    case 1 -> sourceUser.getName();
                    case 3 -> this.this$0.getLink(sourceUser).map(User::getAbr).orElse("<select>");
                    case 4 -> this.this$0.getLink(sourceUser).map(User::getName).orElse(null);
                    case 2 -> {
                        if (this.this$0.getLink(sourceUser).isPresent()) {
                            yield TableModelSB.linked;
                        }
                        yield TableModelSB.unlinked;
                    }
                    default -> "";
                };
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            return switch (c) {
                case 0 -> User.class;
                case 3, 4 -> String.class;
                case 2 -> Boolean.class;
                default -> Object.class;
            };
        }

        @Override
        public boolean isCellEditable(int row, int columnIndex) {
            return columnIndex == 3;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            if (col == 3) {
                try {
                    User sourceUser = this.sourceUsers.get(row);
                    String targetUserAbr = (String)obj;
                    this.this$0.setLink(sourceUser, targetUserAbr);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

