/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogDrawIGDScheme;
import jsbugs.DialogMatch;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchIGDSchemeSurfaces;
import jsbugs.TableModelMatchIGDSchemeUnits;
import jsbugs.model2.igdscheme.DialogIGDScheme;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.SBdb;
import model3.Surface;
import util.InvalidFieldException;
import util.SBException;
import util.SbugsLink;
import util.exception.StackError;
import util.status.SbugsStatus;

public class DialogMatchIGDScheme
extends SBDialog {
    private final TableModelMatchIGDSchemeUnits model = new TableModelMatchIGDSchemeUnits();
    private final TableModelMatchIGDSchemeSurfaces surfaceModel = new TableModelMatchIGDSchemeSurfaces();
    private Image backgroundImage;
    private final SBdb db;
    private final boolean inWizard;
    private IGDScheme origLink;
    private static final String UNIT_ADD = "Add units";
    private static final String UNIT_UPDATE = "Update units";
    private static final String SURFACE_ADD = "Add surfaces";
    private static final String SURFACE_UPDATE = "Update surfaces";
    private JButton jButtonAddScheme;
    private JButton jButtonAddUnits;
    private JButton jButtonDelete;
    private JButton jButtonDraw;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonUpdate;
    private JComboBox jComboBoxDb;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneSurfaces;
    private JTabbedPane jTabbedPane1;
    private JTable jTableMatchSurfaces;
    private JTable jTableMatchUnits;
    private JTextField jTextFieldScheme;

    public DialogMatchIGDScheme(Frame parent, boolean modal, IGDScheme scheme, SBdb db, boolean inWizard) throws SQLException, SBException {
        super(parent, modal);
        this.model.scheme = scheme;
        this.surfaceModel.scheme = scheme;
        this.db = db;
        this.inWizard = inWizard;
        this.initComponents();
        this.init();
    }

    public DialogMatchIGDScheme(Dialog parent, boolean modal, IGDScheme scheme, SBdb db, boolean inWizard) throws SQLException, SBException {
        super((Window)parent, modal);
        this.model.scheme = scheme;
        this.surfaceModel.scheme = scheme;
        this.db = db;
        this.inWizard = inWizard;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        IGDScheme dbScheme;
        this.setTitle("Match Stratigraphic Scheme : " + this.model.scheme.toString());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.backgroundImage = DialogMatch.getBackgroundImage();
        this.jTextFieldScheme.setText(this.model.scheme.toString());
        this.jComboBoxDb.removeAllItems();
        this.jComboBoxDb.insertItemAt("<Select>", 0);
        this.origLink = this.model.scheme.getLink();
        LinkedList<IGDScheme> list = new LinkedList<IGDScheme>(this.db.getIGDSchemes(this.model.scheme.getIGDType(), true));
        Collections.sort(list);
        for (IGDScheme igd : list) {
            this.jComboBoxDb.addItem(igd);
        }
        this.jTableMatchUnits.setRowSorter(new TableRowSorter<TableModelMatchIGDSchemeUnits>(this.model));
        new ColumnSortResetHandler(this.jTableMatchUnits).attach();
        if (this.model.scheme.getLink() == null && (dbScheme = this.db.getIGDScheme(this.model.scheme.getName(), this.model.scheme.getIGDType())) != null) {
            this.model.scheme.setLink(dbScheme);
            this.jComboBoxDb.setSelectedItem(this.model.scheme.getLink());
            for (IGDUnit unit : this.model.scheme.getLink().getUnits()) {
                unit.getNoccs(true);
            }
            if (this.model.scheme.getIGDType() == 10) {
                for (Surface surface : this.model.scheme.getLink().getSurfaces()) {
                    surface.getNoccs(true);
                }
            }
        }
        this.model.setUpTable(this.jTableMatchUnits, this.model.scheme.getIGDType(), null);
        this.model.initData(this.model.scheme.getUnitBases(), this.model.scheme.getLink() != null ? this.model.scheme.getLink().getUnitBases() : null);
        this.jTableMatchUnits.setRowSorter(new TableRowSorter<TableModelMatchIGDSchemeUnits>(this.model));
        this.model.fireTableDataChanged();
        if (this.model.scheme.getIGDType() != 10) {
            this.jScrollPaneSurfaces.setEnabled(false);
            this.jTabbedPane1.remove(this.jScrollPaneSurfaces);
            this.jButtonAddUnits.setText(UNIT_ADD);
            this.jButtonUpdate.setText(UNIT_UPDATE);
        } else {
            this.jTabbedPane1.setSelectedComponent(this.jScrollPaneSurfaces);
            this.surfaceModel.setUpTable(this.jTableMatchSurfaces);
            this.surfaceModel.data.init(this.model.scheme.getSurfaces(), this.model.scheme.getLink() != null ? this.model.scheme.getLink().getSurfaces() : null);
            this.jTableMatchSurfaces.setRowSorter(new TableRowSorter<TableModelMatchIGDSchemeSurfaces>(this.surfaceModel));
            new ColumnSortResetHandler(this.jTableMatchSurfaces).attach();
            this.surfaceModel.fireTableDataChanged();
        }
        this.jButtonOK.setText(this.inWizard ? "Continue" : "Close");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonDraw = new JButton();
        this.jButtonDelete = new JButton();
        this.jComboBoxDb = new JComboBox();
        this.jTextFieldScheme = new JTextField();
        this.jButtonAddUnits = new JButton();
        this.jButtonUpdate = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonAddScheme = new JButton();
        this.jButtonHelp = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchUnits = new JTable();
        this.jScrollPaneSurfaces = new JScrollPane();
        this.jTableMatchSurfaces = new JTable();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(800, 400));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jPanel1.setMinimumSize(new Dimension(600, 300));
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace:");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("Database:");
        this.jButtonOK.setText("Continue");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonDraw.setText("Draw...");
        this.jButtonDraw.setToolTipText("Plot both schemes for comparison");
        this.jButtonDraw.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDrawActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected units/surfaces from database scheme");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jComboBoxDb.setMaximumRowCount(30);
        this.jComboBoxDb.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxDbActionPerformed(evt);
            }
        });
        this.jTextFieldScheme.setEditable(false);
        this.jButtonAddUnits.setText(SURFACE_ADD);
        this.jButtonAddUnits.setToolTipText("Add selected units/surfaces from workspace to database scheme");
        this.jButtonAddUnits.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddUnitsActionPerformed(evt);
            }
        });
        this.jButtonUpdate.setText(SURFACE_UPDATE);
        this.jButtonUpdate.setToolTipText("Update units/surfaces in database from matching selected units/surfaces in workspace");
        this.jButtonUpdate.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonUpdate.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonUpdateActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit scheme...");
        this.jButtonEdit.setToolTipText("Edit database scheme");
        this.jButtonEdit.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonAddScheme.setText("Add scheme...");
        this.jButtonAddScheme.setToolTipText("Add workspace scheme to database");
        this.jButtonAddScheme.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddSchemeActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jTabbedPane1.addChangeListener(new ChangeListener(this){
            final /* synthetic */ DialogMatchIGDScheme this$0;
            {
                DialogMatchIGDScheme dialogMatchIGDScheme = this$0;
                Objects.requireNonNull(dialogMatchIGDScheme);
                this.this$0 = dialogMatchIGDScheme;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jTabbedPane1StateChanged(evt);
            }
        });
        this.jTableMatchUnits.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTableMatchUnits.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMatchUnits);
        this.jTabbedPane1.addTab("Units", this.jScrollPane1);
        this.jTableMatchSurfaces.setModel(this.surfaceModel);
        this.jScrollPaneSurfaces.setViewportView(this.jTableMatchSurfaces);
        this.jTabbedPane1.addTab("Surfaces", this.jScrollPaneSurfaces);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldScheme, -1, 243, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDb, 0, 238, Short.MAX_VALUE)).addComponent(this.jTabbedPane1, -1, 670, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonAddScheme).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonUpdate, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddUnits, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDraw, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonAddScheme, this.jButtonAddUnits, this.jButtonDelete, this.jButtonDraw, this.jButtonEdit, this.jButtonHelp, this.jButtonOK, this.jButtonUpdate);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldScheme, -2, -1, -2).addComponent(this.jComboBoxDb, -2, -1, -2).addComponent(this.jLabel2)).addGap(30, 30, 30).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jButtonAddScheme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDraw).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddUnits).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOK)).addComponent(this.jTabbedPane1, -1, 490, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jComboBoxDbActionPerformed(ActionEvent evt) {
        try {
            IGDScheme dbScheme;
            Object obj = this.jComboBoxDb.getSelectedItem();
            if (obj instanceof IGDScheme) {
                dbScheme = (IGDScheme)obj;
                dbScheme.loadUnits();
            } else {
                dbScheme = null;
            }
            this.model.scheme.setLink(dbScheme);
            this.model.initData(this.model.scheme.getUnitBases(), dbScheme != null ? dbScheme.getUnitBases() : null);
            if (dbScheme != null) {
                for (IGDUnit unit : dbScheme.getUnits()) {
                    unit.getNoccs(true);
                }
            }
            this.model.fireTableDataChanged();
            if (this.model.scheme.getIGDType() == 10) {
                this.surfaceModel.data.init(this.model.scheme.getSurfaces(), dbScheme != null ? dbScheme.getSurfaces() : null);
                if (dbScheme != null) {
                    for (Surface surface : dbScheme.getSurfaces()) {
                        surface.getNoccs(true);
                    }
                }
                this.surfaceModel.fireTableDataChanged();
            }
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.inWizard && this.model.scheme.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must match this scheme.", this.getTitle(), 2);
            return;
        }
        this.setOK();
    }

    private void formWindowClosing(WindowEvent evt) {
        int opt;
        if (this.inWizard && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Exit guided import?", this.getTitle(), 0)) != 0) {
            return;
        }
        if (this.model.scheme.getLink() != this.origLink && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Cancel match?", this.getTitle(), 0)) != 0) {
            this.cancel();
        }
        this.dispose();
    }

    private void cancel() {
        try {
            this.model.scheme.setLink(this.origLink);
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        boolean units = this.jTabbedPane1.getSelectedComponent() == this.jScrollPane1;
        String unitsString = units ? "units" : "surfaces";
        if ((units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No " + unitsString + " selected", this.getTitle(), 2);
            return;
        }
        int[] selected = (units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRows();
        LinkedList<IGDUnitBase> toRemove = new LinkedList<IGDUnitBase>();
        int nOccs = 0;
        int nCorrLines = 0;
        for (int n : selected) {
            IGDUnitBase unit = units ? this.model.getData(this.jTableMatchUnits.convertRowIndexToModel(n), false) : this.surfaceModel.data.get(this.jTableMatchSurfaces.convertRowIndexToModel(n)).getDb();
            int thisOccs = 0;
            int thisCorrLines = 0;
            try {
                if (unit instanceof IGDUnitBase) {
                    thisOccs += unit.getNoccs(false);
                } else if (unit instanceof Surface) {
                    thisOccs += ((Surface)((Object)unit)).getNoccs(false);
                    thisCorrLines += ((Surface)((Object)unit)).getNCorrLines(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (thisOccs > 0 || thisCorrLines > 0) {
                nOccs += thisOccs;
                nCorrLines += thisCorrLines;
                unit = null;
            }
            if (unit == null) continue;
            toRemove.add(unit);
        }
        if (nOccs > 0 || nCorrLines > 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Some " + unitsString + " cannot be deleted because they occur in " + (units ? "interpreted intervals." : "picks.") + "\nand " + nCorrLines + " correlation line templates.", this.getTitle(), 2);
        }
        if (toRemove.size() > 0) {
            String msg = "Really delete " + (toRemove.size() == 1 ? "this " + (units ? "unit" : "surface") : "these " + unitsString) + "? (no occurrence in database)";
            if (JOptionPane.showConfirmDialog((Component)((Object)this), msg, this.getTitle(), 0, 3) != 0) {
                return;
            }
            int nUnits = 0;
            try {
                for (Object e : toRemove) {
                    if (e instanceof IGDUnitBase) {
                        this.model.scheme.getLink().deleteUnit((IGDUnitBase)e);
                        ++nUnits;
                    } else if (e instanceof Surface) {
                        this.model.scheme.getLink().deleteSurface((Surface)e);
                        ++nUnits;
                    }
                    this.model.scheme.getLink().getDatabase().commit();
                }
            }
            catch (SQLException sql) {
                this.model.scheme.getDatabase().doRollback();
                SbugsExceptionHandler.showStackError("SQL Error deleting units", sql, (Component)((Object)this));
            }
            JOptionPane.showMessageDialog((Component)((Object)this), (units ? "Units" : "Surfaces") + " deleted: " + nUnits, this.getTitle(), 1);
            try {
                this.refreshSchemeLinksAndTable(units);
                this.model.scheme.getLink().notifyObservers();
            }
            catch (RuntimeException | SQLException | SBException ex) {
                SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
            }
        }
    }

    private void jButtonAddUnitsActionPerformed(ActionEvent evt) {
        if (this.model.scheme.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a database scheme", this.getTitle(), 1);
            return;
        }
        boolean units = this.jTabbedPane1.getSelectedComponent() == this.jScrollPane1;
        if ((units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No " + (units ? "units" : "surfaces") + " selected", this.getTitle(), 2);
            return;
        }
        int[] selected = (units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRows();
        LinkedList<IGDUnitBase> toAdd = new LinkedList<IGDUnitBase>();
        for (int i : selected) {
            SbugsLink unit = units ? this.model.getData(this.jTableMatchUnits.convertRowIndexToModel(i), true) : (Surface)this.surfaceModel.data.get(this.jTableMatchSurfaces.convertRowIndexToModel(i)).getWs();
            if (unit == null) continue;
            toAdd.add((IGDUnitBase)unit);
        }
        Object object = toAdd.iterator();
        while (object.hasNext()) {
            SbugsStatus sbugsStatus = (SbugsStatus)object.next();
            if (sbugsStatus.getStatus() == IGDUnit.NOTSTORED) continue;
            JOptionPane.showMessageDialog((Component)((Object)this), "You can only add " + (units ? "units" : "surfaces") + " which are new and do not conflict with the database scheme units", this.getTitle(), 2);
            return;
        }
        try {
            for (Object e : toAdd) {
                try {
                    if (e instanceof IGDUnitBase) {
                        IGDUnitBase wsUnit = (IGDUnitBase)e;
                        IGDUnitBase.Builder copy = IGDUnitBase.Builder.copyOf(wsUnit, this.model.scheme.getLink().getDatabase());
                        this.model.scheme.getLink().checkNewUnit(copy);
                        this.model.scheme.getLink().addUnit(copy);
                    } else {
                        Surface surface = (Surface)e;
                        this.surfaceModel.scheme.getLink().addSurface(Surface.Builder.copyOf(this.db, surface));
                    }
                }
                catch (InvalidFieldException e2) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Cannot add '" + String.valueOf(e) + "':\n" + e2.getMessage(), this.getTitle(), 2);
                    continue;
                }
                catch (SQLException | SBException sql) {
                    this.db.doRollback();
                    SbugsExceptionHandler.showStackError("Error", sql, (Component)((Object)this));
                    continue;
                }
                this.db.commit();
            }
            this.refreshSchemeLinksAndTable(units);
            this.model.scheme.getLink().notifyObservers();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void refreshSchemeLinksAndTable(boolean units) throws SQLException, SBException {
        if (units) {
            this.model.scheme.linkUnits();
            this.model.scheme.updateStatus();
            this.model.initData(this.model.scheme.getUnitBases(), this.model.scheme.getLink().getUnitBases());
            this.model.fireTableDataChanged();
        } else {
            this.surfaceModel.scheme.linkSurfaces();
            this.surfaceModel.scheme.updateStatus();
            this.surfaceModel.data.init(this.model.scheme.getSurfaces(), this.model.scheme.getLink().getSurfaces());
            this.surfaceModel.fireTableDataChanged();
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.model.scheme.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 2);
            return;
        }
        try {
            DialogIGDScheme dialog = new DialogIGDScheme((JDialog)((Object)this), true, this.db, this.model.scheme.getLink(), this.model.scheme.getLink().getIGDType(), null);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.initData(this.model.scheme.getUnitBases(), this.model.scheme.getLink().getUnitBases());
                this.model.scheme.updateStatus();
                this.model.fireTableDataChanged();
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonUpdateActionPerformed(ActionEvent evt) {
        boolean units = this.jTabbedPane1.getSelectedComponent() == this.jScrollPane1;
        if ((units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No " + (units ? "units" : "surfaces") + " selected", this.getTitle(), 2);
            return;
        }
        int[] selected = (units ? this.jTableMatchUnits : this.jTableMatchSurfaces).getSelectedRows();
        LinkedList<Surface> toUpdate = new LinkedList<Surface>();
        for (int i : selected) {
            if (units) {
                IGDUnitBase unit = this.model.getData(this.jTableMatchUnits.convertRowIndexToModel(i), true);
                if (unit == null) continue;
                toUpdate.add((Surface)((Object)unit));
                continue;
            }
            Surface surface = (Surface)this.surfaceModel.data.get(this.jTableMatchSurfaces.convertRowIndexToModel(i)).getWs();
            if (surface == null) continue;
            toUpdate.add(surface);
        }
        try {
            DialogIGDScheme dialog = new DialogIGDScheme((JDialog)((Object)this), true, this.db, this.model.scheme.getLink(), this.model.scheme.getLink().getIGDType(), null);
            dialog.setLocationRelativeTo((Component)((Object)this));
            if (units) {
                dialog.setUpdateUnits(toUpdate, this.model.scheme.getUnitBases());
            } else {
                dialog.setUpdateSurfaces(toUpdate);
            }
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.refreshSchemeLinksAndTable(units);
            }
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private void jButtonDrawActionPerformed(ActionEvent evt) {
        if (this.model.scheme.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a database scheme", this.getTitle(), 1);
            return;
        }
        try {
            DialogDrawIGDScheme dialog = new DialogDrawIGDScheme((JDialog)((Object)this), false, this.model.scheme, this.model.scheme.getLink(), this.db);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private void jButtonAddSchemeActionPerformed(ActionEvent evt) {
        try {
            DialogIGDScheme dialog = new DialogIGDScheme((JDialog)((Object)this), true, this.db, this.model.scheme, this.model.scheme.getIGDType(), null);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.scheme.setLink(dialog.getSchemeAdded());
                this.jComboBoxDb.addItem(this.model.scheme.getLink());
                this.jComboBoxDb.setSelectedItem(this.model.scheme.getLink());
            }
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogmatchigdscheme.html");
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        System.out.println("Component state changed");
        if (this.jTabbedPane1.getSelectedComponent() == this.jScrollPaneSurfaces) {
            this.jButtonAddUnits.setText(SURFACE_ADD);
            this.jButtonUpdate.setText(SURFACE_UPDATE);
        } else {
            this.jButtonAddUnits.setText(UNIT_ADD);
            this.jButtonUpdate.setText(UNIT_UPDATE);
        }
    }
}

