/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatch;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchIntcom;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.DepthRenderer;
import jsbugs.table.DepthStatusRenderer;
import model3.IGDInterval;
import model3.Intcom;
import model3.InterpHdr;
import model3.Lastval;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import model3.WsWell;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.exception.StackError;
import util.status.DoubleStatus;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchIntcom
extends JDialog {
    private final TableModelMatchIntcom model = new TableModelMatchIntcom();
    private final Image backgroundImage = DialogMatch.getBackgroundImage();
    private final WsWell well;
    private final InterpHdr hdr;
    private WellInterp interp = null;
    private WellInterp dbInterp = null;
    private final SBdb db;
    private final Set<Integer> dataTypes;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonRead;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableMatchIntcom;

    public DialogMatchIntcom(Frame parent, boolean modal, SBdb db, WsWell well, char units, InterpHdr hdr, Set<Integer> dataTypes) throws SBException, SQLException {
        super(parent, modal);
        this.well = well;
        this.hdr = hdr;
        this.db = db;
        this.model.units = units;
        this.dataTypes = dataTypes;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.setTitle("Match Interval Comments");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        int interpID = this.hdr.getInterpID();
        if (this.well.hasInterpLoaded(interpID)) {
            this.interp = this.well.getInterp(interpID);
        }
        if (this.well.getLink() != null && this.hdr.getLink() != null) {
            int linkInterpID = this.hdr.getLink().getInterpID();
            this.well.getLink().loadInterps();
            if (this.well.getLink().hasInterpLoaded(linkInterpID)) {
                this.dbInterp = this.well.getLink().getInterp(linkInterpID);
                this.well.getLink().loadInterp(this.dbInterp);
            }
        }
        this.model.data.init(this.interp != null ? this.getIntcoms(this.interp) : null, this.dbInterp != null ? this.getIntcoms(this.dbInterp) : null);
        this.model.wellType = this.well.getType();
        SB.setTableHeaderBold((JTable)this.jTableMatchIntcom);
        TableColumnModel columnModel = this.jTableMatchIntcom.getTableHeader().getColumnModel();
        columnModel.getColumn(4).setMaxWidth(TableModelMatchIntcom.colWidths[4]);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchIntcom.colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(TableModelMatchIntcom.colWidths[i]);
        }
        this.jTableMatchIntcom.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchIntcom.setDefaultRenderer(DoubleStatus.class, (TableCellRenderer)((Object)new DepthStatusRenderer(2)));
        this.jTableMatchIntcom.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        this.jTableMatchIntcom.setDefaultRenderer(Double.class, new DepthRenderer(2));
        this.jTableMatchIntcom.setRowSorter(new TableRowSorter<TableModelMatchIntcom>(this.model));
        new ColumnSortResetHandler(this.jTableMatchIntcom).attach();
        this.model.fireTableDataChanged();
        this.jTableMatchIntcom.getTableHeader().setReorderingAllowed(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchIntcom this$0;
            {
                DialogMatchIntcom dialogMatchIntcom = this$0;
                Objects.requireNonNull(dialogMatchIntcom);
                this.this$0 = dialogMatchIntcom;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchIntcom = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonRead = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 500));
        this.setModal(true);
        this.jTableMatchIntcom.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMatchIntcom);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from database");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIntcom this$0;
            {
                DialogMatchIntcom dialogMatchIntcom = this$0;
                Objects.requireNonNull(dialogMatchIntcom);
                this.this$0 = dialogMatchIntcom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIntcom this$0;
            {
                DialogMatchIntcom dialogMatchIntcom = this$0;
                Objects.requireNonNull(dialogMatchIntcom);
                this.this$0 = dialogMatchIntcom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIntcom this$0;
            {
                DialogMatchIntcom dialogMatchIntcom = this$0;
                Objects.requireNonNull(dialogMatchIntcom);
                this.this$0 = dialogMatchIntcom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIntcom this$0;
            {
                DialogMatchIntcom dialogMatchIntcom = this$0;
                Objects.requireNonNull(dialogMatchIntcom);
                this.this$0 = dialogMatchIntcom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 386, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 565, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonClose, -2, 78, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonRead, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING).addComponent(this.jButtonDelete, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExclude, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 385, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteIntcom(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteIntcom(true);
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.db, "JIGDFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        filter.addExtension("csv");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            try {
                Lastval.putString(this.db, "JIGDFILE", fileName);
                this.db.commit();
                try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
                    this.importTextFile(in);
                }
                this.well.updateIntcomStatus(this.interp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
                this.model.data.init(this.interp != null ? this.getIntcoms(this.interp) : null, this.dbInterp != null ? this.getIntcoms(this.dbInterp) : null);
                this.model.fireTableDataChanged();
            }
            catch (IOException eio) {
                JOptionPane.showMessageDialog(this, "Error reading file: " + eio.getMessage(), this.getTitle(), 2);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
        }
    }

    private List<Intcom> getIntcoms(WellInterp interp) {
        LinkedList<Intcom> list = new LinkedList<Intcom>(interp.getIntcoms());
        try {
            for (int igdType : WellInterp.intcomIgdTypes) {
                if (igdType == 0 || !this.dataTypes.contains(IGDInterval.igdType2dType(igdType))) continue;
                list.addAll(interp.getIntcoms(igdType));
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        return list;
    }

    private void deleteIntcom(boolean fromDatabase) {
        block9: {
            if (fromDatabase && this.well.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMatchIntcom.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchIntcom.getSelectedRows();
            LinkedList<Intcom> toRemove = new LinkedList<Intcom>();
            for (int i : selected) {
                Intcom intcom = fromDatabase ? (Intcom)this.model.data.get(this.jTableMatchIntcom.convertRowIndexToModel(i)).getDb() : (Intcom)this.model.data.get(this.jTableMatchIntcom.convertRowIndexToModel(i)).getWs();
                if (intcom == null) continue;
                toRemove.add(intcom);
            }
            if (fromDatabase && toRemove.size() > 0) {
                Object msg = "Really delete ";
                msg = (String)msg + (String)(toRemove.size() == 1 ? "this comment" : "these " + toRemove.size() + " comment");
                if (JOptionPane.showConfirmDialog(this, msg = (String)msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
                    return;
                }
            }
            try {
                Well deleteFromWell = fromDatabase ? this.well.getLink() : this.well;
                WellInterp deleteFromInterp = fromDatabase ? this.dbInterp : this.interp;
                deleteFromInterp.deleteIntcoms(deleteFromWell.getWellID(), toRemove);
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Comments " + text + ": " + toRemove.size(), this.getTitle(), 1);
                if (fromDatabase) {
                    deleteFromWell.getDataModel().commit();
                    deleteFromInterp.notifyObservers(22);
                } else {
                    this.well.updateIntcomStatus(this.interp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
                }
                this.model.data.init(this.interp != null ? this.getIntcoms(this.interp) : null, this.dbInterp != null ? this.getIntcoms(this.dbInterp) : null);
                this.model.fireTableDataChanged();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block9;
                this.well.getLink().getDataModel().doRollback();
            }
        }
    }

    private void importTextFile(BufferedReader in) throws IOException, SQLException, SBException {
        String buff = in.readLine();
        while (buff != null) {
            String[] splits = buff.split("[\t,;]");
            if (splits.length == 3) {
                try {
                    double topDepth = 0.0;
                    double baseDepth = 0.0;
                    String comment = "";
                    block9: for (int i = 0; i < 3; ++i) {
                        switch (i) {
                            case 0: {
                                topDepth = DepthUtils.convToM((double)Double.parseDouble(splits[i].trim()), (char)this.model.units, (char)this.well.getType());
                                continue block9;
                            }
                            case 1: {
                                baseDepth = DepthUtils.convToM((double)Double.parseDouble(splits[i].trim()), (char)this.model.units, (char)this.well.getType());
                                continue block9;
                            }
                            case 2: {
                                comment = splits[i].trim();
                            }
                        }
                    }
                    Intcom.Builder builder = new Intcom.Builder(this.well.getDataModel(), 0, topDepth).baseDepth(baseDepth).comments(comment);
                    this.interp.addIntcom(this.well, builder);
                }
                catch (InvalidFieldException e) {
                    System.out.println("Did not add comment from line '" + buff + "': " + e.getMessage());
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Number format exception from line '" + buff + "': " + nfe.getMessage());
                }
            } else {
                System.out.println("Did not read line: " + buff);
            }
            buff = in.readLine();
        }
    }
}

