/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.ComboCellRenderer;
import jsbugs.DialogMatch;
import jsbugs.TableModelMatchSamples;
import jsbugs.TableModelSB;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import util.SBException;

public class DialogMatchSampleTypes
extends SBDialog {
    private final TableModelMatchSampleTypes model = new TableModelMatchSampleTypes();
    private Image backgroundImage;
    private final SBdb db;
    private final SBdb ws;
    private JButton jButtonCancel;
    private JButton jButtonMatchAll;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableSampleTypes;

    public DialogMatchSampleTypes(Frame parent, boolean modal, SBdb ws, SBdb db, HashSet<String> donorTypes) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.ws = ws;
        this.initComponents();
        this.init(donorTypes);
    }

    private void init(HashSet<String> donorTypes) throws SQLException {
        this.setTitle("Match Sample Types");
        this.model.setupTable(this.jTableSampleTypes, donorTypes);
        this.jTableSampleTypes.setRowSorter(new TableRowSorter<TableModelMatchSampleTypes>(this.model));
        new ColumnSortResetHandler(this.jTableSampleTypes).attach();
        this.model.fireTableDataChanged();
        this.jTableSampleTypes.getTableHeader().setReorderingAllowed(false);
        this.backgroundImage = DialogMatch.getBackgroundImage();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchSampleTypes this$0;
            {
                DialogMatchSampleTypes dialogMatchSampleTypes = this$0;
                Objects.requireNonNull(dialogMatchSampleTypes);
                this.this$0 = dialogMatchSampleTypes;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSampleTypes = new JTable();
        this.jButtonMatchAll = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 250));
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jScrollPane1.setToolTipText("Select the database abbreviation to match");
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableSampleTypes.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableSampleTypes);
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSampleTypes this$0;
            {
                DialogMatchSampleTypes dialogMatchSampleTypes = this$0;
                Objects.requireNonNull(dialogMatchSampleTypes);
                this.this$0 = dialogMatchSampleTypes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSampleTypes this$0;
            {
                DialogMatchSampleTypes dialogMatchSampleTypes = this$0;
                Objects.requireNonNull(dialogMatchSampleTypes);
                this.this$0 = dialogMatchSampleTypes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSampleTypes this$0;
            {
                DialogMatchSampleTypes dialogMatchSampleTypes = this$0;
                Objects.requireNonNull(dialogMatchSampleTypes);
                this.this$0 = dialogMatchSampleTypes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 406, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 227, Short.MAX_VALUE).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMatchAll, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 21, -2).addComponent(this.jLabel2, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonMatchAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 249, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        try {
            for (SampleTypePair pair : this.model.types) {
                if (pair.dbType != null) continue;
                pair.dbType = SampleType.parseType((String)pair.wsType);
            }
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException re) {
            SbugsExceptionHandler.showStackError(re);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        for (SampleTypePair pair : this.model.types) {
            if (pair.dbType != null) continue;
            JOptionPane.showMessageDialog((Component)((Object)this), "Not all sample types matched: " + pair.wsType, this.getTitle(), 2);
            return;
        }
        try {
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                Well well = it.next();
                for (Sample sample : well.getSamples()) {
                    if (sample.getDonorSampleType() == null) continue;
                    for (SampleTypePair pair : this.model.types) {
                        if (!pair.wsType.equals(sample.getDonorSampleType())) continue;
                        sample.setType(pair.dbType);
                    }
                }
            }
            this.setOK();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    private static class TableModelMatchSampleTypes
    extends AbstractTableModel {
        static final int COL_DONOR = 0;
        static final int COL_ARROW = 1;
        static final int COL_HOST = 2;
        private static final String[] COL_TITLE = new String[]{"Type", "", "Type"};
        private static final int[] COL_WIDTHS = new int[]{50, 20, 50};
        private final JComboBox sampleComboBox = new JComboBox();
        private final List<SampleTypePair> types = new LinkedList<SampleTypePair>();

        private TableModelMatchSampleTypes() {
        }

        @Override
        public int getColumnCount() {
            return COL_TITLE.length;
        }

        @Override
        public int getRowCount() {
            if (this.types == null) {
                return 0;
            }
            return this.types.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.types == null) {
                return null;
            }
            try {
                SampleTypePair pair = this.types.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return pair.wsType;
                    }
                    case 2: {
                        return pair.dbType.getLongName();
                    }
                    case 1: {
                        return pair.dbType != null ? TableModelSB.linked : TableModelSB.unlinked;
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 2: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int columnIndex) {
            switch (columnIndex) {
                case 2: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            SampleTypePair pair = this.types.get(row);
            try {
                switch (col) {
                    default: {
                        break;
                    }
                    case 2: {
                        pair.dbType = (SampleType)obj;
                        break;
                    }
                }
            }
            catch (Exception pe) {
                pe.printStackTrace();
            }
        }

        void setupTable(JTable table, HashSet<String> wsTypes) throws SQLException {
            this.sampleComboBox.removeAllItems();
            for (SampleType t : SampleType.values()) {
                this.sampleComboBox.addItem(t);
            }
            Iterator<String> it = wsTypes.iterator();
            while (it.hasNext()) {
                this.types.add(new SampleTypePair(it.next()));
            }
            for (int i = 0; i < COL_TITLE.length; ++i) {
                table.getColumnModel().getColumn(i).setHeaderValue(COL_TITLE[i]);
                table.getColumnModel().getColumn(i).setPreferredWidth(COL_WIDTHS[i]);
            }
            table.getColumnModel().getColumn(1).setMaxWidth(TableModelMatchSamples.colWidths[1]);
            table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
            table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.sampleComboBox));
            table.getColumnModel().getColumn(2).setCellRenderer(new ComboCellRenderer());
            TableUtils.setTableHeaderBold((JTable)table);
            table.setToolTipText("Click on blank database Abbreviation to select");
        }
    }

    private static class SampleTypePair {
        final String wsType;
        SampleType dbType;

        SampleTypePair(String ws) {
            this.wsType = ws;
        }
    }
}

