/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.WellDatum;
import com.stratadata.model3.well.WellHeader;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jsbugs.table.ColouredRenderer;
import jsbugs.uiutil.DepthStringUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.wellheader.DialogWell;
import model3.SBdb;
import model3.WsWell;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.status.MergeStatus;
import util.status.SbugsStatus;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchWellHeader
extends JDialog {
    private final TableModelMatchWellHeader model;
    private final SBdb ws;
    private final SBdb db;
    private final WsWell well;
    private JButton jButtonClose;
    private JButton jButtonEditDB;
    private JButton jButtonExclude;
    private JButton jButtonReplace;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchWellHeader;

    public DialogMatchWellHeader(Frame parent, boolean modal, SBdb ws, SBdb db, WsWell well) {
        super(parent, modal);
        this.ws = ws;
        this.db = db;
        this.well = well;
        this.model = new TableModelMatchWellHeader(well.getHeader().getWellHeaderCopy(), well.getLink() != null ? well.getLink().getHeader().getWellHeaderCopy() : null, db);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Match Well Headers");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        TableUtils.setTableHeaderBold((JTable)this.jTableMatchWellHeader);
        TableColumnModel columnModel = this.jTableMatchWellHeader.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchWellHeader.COL_TITLES[i]);
            columnModel.getColumn(i).setWidth(TableModelMatchWellHeader.COL_WIDTHS[i]);
        }
        this.jTableMatchWellHeader.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        TableColumn firstColumn = this.jTableMatchWellHeader.getColumnModel().getColumn(0);
        firstColumn.setHeaderValue(" ");
        firstColumn.setPreferredWidth(45);
        firstColumn.setCellRenderer(new ColouredRenderer(false, ColouredRenderer.GREY, 11, true));
        this.jTableMatchWellHeader.setRowHeight(19);
        this.jTableMatchWellHeader.getColumnModel().setColumnMargin(5);
        this.jTableMatchWellHeader.getTableHeader().setReorderingAllowed(false);
        if (this.well.getLink() == null) {
            this.jButtonEditDB.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchWellHeader = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonReplace = new JButton();
        this.jButtonEditDB = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 400));
        this.setModal(true);
        this.jTableMatchWellHeader.setModel(this.model);
        this.jTableMatchWellHeader.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogMatchWellHeader this$0;
            {
                DialogMatchWellHeader dialogMatchWellHeader = this$0;
                Objects.requireNonNull(dialogMatchWellHeader);
                this.this$0 = dialogMatchWellHeader;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableMatchWellHeaderMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMatchWellHeader);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWellHeader this$0;
            {
                DialogMatchWellHeader dialogMatchWellHeader = this$0;
                Objects.requireNonNull(dialogMatchWellHeader);
                this.this$0 = dialogMatchWellHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude values from selected rows from import");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWellHeader this$0;
            {
                DialogMatchWellHeader dialogMatchWellHeader = this$0;
                Objects.requireNonNull(dialogMatchWellHeader);
                this.this$0 = dialogMatchWellHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonReplace.setText("Replace");
        this.jButtonReplace.setToolTipText("Replace database values with selected workspace values");
        this.jButtonReplace.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWellHeader this$0;
            {
                DialogMatchWellHeader dialogMatchWellHeader = this$0;
                Objects.requireNonNull(dialogMatchWellHeader);
                this.this$0 = dialogMatchWellHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReplaceActionPerformed(evt);
            }
        });
        this.jButtonEditDB.setText("Edit database...");
        this.jButtonEditDB.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonEditDB.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWellHeader this$0;
            {
                DialogMatchWellHeader dialogMatchWellHeader = this$0;
                Objects.requireNonNull(dialogMatchWellHeader);
                this.this$0 = dialogMatchWellHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditDBActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 410, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEditDB, GroupLayout.Alignment.TRAILING, -1, 106, Short.MAX_VALUE).addComponent(this.jButtonExclude, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonReplace, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 624, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonEditDB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonReplace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        try {
            this.well.updateHeaderStatus();
        }
        catch (SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
        this.dispose();
    }

    private void jTableMatchWellHeaderMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1 && this.jTableMatchWellHeader.getSelectedColumn() == 2 && this.well.getLink() != null) {
            this.jButtonEditDBActionPerformed(null);
        }
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchWellHeader.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 1);
        }
        try {
            this.model.exclude(this.jTableMatchWellHeader.getSelectedRows());
            this.well.update(this.model.ws);
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException | InvalidFieldException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jButtonReplaceActionPerformed(ActionEvent evt) {
        if (this.jTableMatchWellHeader.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 1);
        }
        try {
            this.model.replace(this.jTableMatchWellHeader.getSelectedRows());
            this.well.getLink().update(this.model.db);
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException | InvalidFieldException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jButtonEditDBActionPerformed(ActionEvent evt) {
        try {
            DialogWell dialog = new DialogWell(this, true, this.db, this.well.getLink());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.db = this.well.getLink().getHeader().getWellHeaderCopy();
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    public void excludeConflictingFields() {
        LinkedList<Integer> rowsWithConflicts = new LinkedList<Integer>();
        for (int rowIndex = 0; rowIndex < this.model.getRowCount(); ++rowIndex) {
            if (rowIndex == 0) continue;
            if (rowIndex == 2 || ((StringStatus)this.model.getValueAt(rowIndex, 1)).getStatus() != StringStatus.CONFLICT) continue;
            rowsWithConflicts.add(rowIndex);
        }
        int[] rowsWithConflictsAsArray = rowsWithConflicts.stream().mapToInt(Integer::intValue).toArray();
        this.model.exclude(rowsWithConflictsAsArray);
        try {
            this.well.update(this.model.ws);
            this.well.updateHeaderStatus();
        }
        catch (RuntimeException | SQLException | InvalidFieldException | SBException | SBPermissionException e) {
            Logger.getLogger(DialogMatchWellHeader.class.getName()).log(Level.WARNING, "Could not exclude conflicting values from well header", e);
        }
    }

    private static class TableModelMatchWellHeader
    extends AbstractTableModel {
        private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd-MMM-yyyy");
        static final int COL_PROPERTY = 0;
        static final int COL_DONOR = 1;
        static final int COL_HOST = 2;
        static final String[] COL_TITLES = new String[]{"Well Property", "Workspace", "Database"};
        static final int[] COL_WIDTHS = new int[]{40, 50, 50};
        static final int ROW_NAME = 0;
        static final int ROW_ALT_NAME = 1;
        static final int ROW_CODE = 2;
        static final int ROW_TYPE = 3;
        static final int ROW_UNITS = 4;
        static final int ROW_OPER = 5;
        static final int ROW_OCS = 6;
        static final int ROW_SPUD = 7;
        static final int ROW_COMP = 8;
        static final int ROW_COUNTRY = 9;
        static final int ROW_COUNTY = 10;
        static final int ROW_LOC_STATE = 11;
        static final int ROW_FIELD = 12;
        static final int ROW_BASIN = 13;
        static final int ROW_AREA = 14;
        static final int ROW_DATUM = 15;
        static final int ROW_GRIDX = 16;
        static final int ROW_GRIDY = 17;
        static final int ROW_UTMZONE = 18;
        static final int ROW_LAT_DEC = 19;
        static final int ROW_LONG_DEC = 20;
        static final int ROW_DEPTH_DATUM = 21;
        static final int ROW_RTE = 22;
        static final int ROW_SL = 23;
        static final int ROW_SB = 24;
        static final int ROW_KICKO = 25;
        static final int ROW_TD = 26;
        static final int ROW_LITH_DEPTHS = 27;
        static final String[] ROW_TITLES = new String[]{"Name: ", "Alternate Name:", "Code: ", "Type: ", "Depth units: ", "Operator: ", "OCS number: ", "Spud: ", "Completed: ", "Country: ", "County: ", "State: ", "Field: ", "Basin: ", "Area: ", "Geodetic datum: ", "Grid X: ", "Grid Y: ", "UTM zone: ", "Latitude: ", "Longitude: ", "Depth datum: ", "Rotary table elevation: ", "Rig Elevation: ", "Sea bed: ", "Kick-off depth: ", "Terminal depth: ", "Lithology depths: "};
        final SBdb sbdb;
        WellHeader ws;
        WellHeader db;

        TableModelMatchWellHeader(WellHeader ws, WellHeader db, SBdb sbdb) {
            this.ws = ws;
            this.db = db;
            this.sbdb = sbdb;
        }

        @Override
        public int getRowCount() {
            return ROW_TITLES.length;
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                switch (columnIndex) {
                    case 0: {
                        boolean isOutcrop = false;
                        if (this.ws != null && this.ws.getSectionType() == SectionType.OUTCROP) {
                            isOutcrop = true;
                        }
                        if (this.db != null && this.db.getSectionType() == SectionType.OUTCROP) {
                            isOutcrop = true;
                        }
                        switch (rowIndex) {
                            default: {
                                return ROW_TITLES[rowIndex];
                            }
                            case 25: {
                                if (isOutcrop) {
                                    return "Top of Section";
                                }
                            }
                            case 23: {
                                if (isOutcrop) {
                                    return "Outcrop Datum";
                                }
                            }
                            case 22: {
                                if (!isOutcrop) break;
                                return "(RTE)";
                            }
                            case 24: 
                        }
                        if (isOutcrop) {
                            return "(SB)";
                        }
                        return ROW_TITLES[rowIndex];
                    }
                    case 1: {
                        if (this.ws == null) {
                            return "";
                        }
                        String donor = this.getWellHeaderField(this.ws, rowIndex);
                        String host = "";
                        if (this.db != null) {
                            host = this.getWellHeaderField(this.db, rowIndex);
                        }
                        MergeStatus status = new MergeStatus(SbugsStatus.STORED);
                        switch (rowIndex) {
                            case 0: 
                            case 2: {
                                break;
                            }
                            default: {
                                status.compareStringField(ROW_TITLES[rowIndex], donor, host, true);
                                break;
                            }
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: {
                                Double hostDouble = null;
                                if (host != null && host.trim().length() > 0) {
                                    hostDouble = Double.parseDouble(host);
                                }
                                Double donorDouble = null;
                                if (donor != null && donor.trim().length() > 0) {
                                    donorDouble = Double.parseDouble(donor);
                                }
                                status.compareNullableDoubleField(ROW_TITLES[rowIndex], donorDouble, hostDouble);
                                break;
                            }
                            case 16: 
                            case 17: 
                            case 26: {
                                status.compareDoubleField(ROW_TITLES[rowIndex], Double.parseDouble(donor), host.length() > 0 ? Double.parseDouble(host) : 0.0);
                            }
                        }
                        return new StringStatus(donor, status.getStatus());
                    }
                    case 2: {
                        if (this.db != null) {
                            return this.getWellHeaderField(this.db, rowIndex);
                        }
                        return "";
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        void replace(int[] selection) {
            if (this.db == null || this.ws == null) {
                return;
            }
            for (int row : selection) {
                Object wsValue = this.getWellHeaderProperty(this.ws, row);
                this.setWellHeaderField(this.db, row, wsValue);
            }
        }

        void exclude(int[] selection) {
            WellHeader defaultValues = new WellHeader();
            for (int row : selection) {
                if (row == 0 || row == 2) continue;
                if (this.db != null) {
                    if (row == 3) {
                        this.ws.setSectionType(this.db.getSectionType());
                        continue;
                    }
                    if (row == 4) {
                        this.ws.setUnits(this.db.getUnits());
                        continue;
                    }
                    if (row == 21) {
                        this.ws.setDatum(this.db.getDatum());
                        continue;
                    }
                    if (row == 27) {
                        this.ws.setLithologyDepthsAreDrilled(this.db.lithologyDepthsAreDrilled());
                        continue;
                    }
                }
                this.setWellHeaderField(this.ws, row, this.getWellHeaderProperty(defaultValues, row));
            }
        }

        public Class getColumnClass(int c) {
            return switch (c) {
                case 1 -> StringStatus.class;
                case 0, 2 -> String.class;
                default -> String.class;
            };
        }

        private Object getWellHeaderProperty(WellHeader wh, int propertyIndex) {
            return switch (propertyIndex) {
                case 0 -> wh.getWellName();
                case 1 -> wh.getWellAltName(false);
                case 2 -> wh.getWellCode();
                case 3 -> wh.getSectionType();
                case 4 -> wh.getUnits();
                case 5 -> wh.getOperator();
                case 6 -> wh.getOcs();
                case 7 -> wh.getSpudDate();
                case 8 -> wh.getCompletionDate();
                case 9 -> wh.getCountry();
                case 10 -> wh.getCounty();
                case 11 -> wh.getLocState();
                case 12 -> wh.getField();
                case 13 -> wh.getBasin();
                case 14 -> wh.getArea();
                case 15 -> wh.getGeoDatum();
                case 16 -> wh.getGridX();
                case 17 -> wh.getGridY();
                case 18 -> wh.getUtmZone();
                case 19 -> wh.getLat_dec();
                case 20 -> wh.getLong_dec();
                case 21 -> wh.getDatum();
                case 22 -> wh.getRotaryTableElevation();
                case 23 -> wh.getSeaLevel();
                case 24 -> wh.getSeaBed();
                case 25 -> wh.getKickOff();
                case 26 -> wh.getTerminalDepth();
                case 27 -> wh.lithologyDepthsAreDrilled();
                default -> "";
            };
        }

        private String getWellHeaderField(WellHeader wh, int propertyIndex) {
            Object o = this.getWellHeaderProperty(wh, propertyIndex);
            if (o == null) {
                return "";
            }
            if (o instanceof SectionType) {
                SectionType sectionType = (SectionType)o;
                return sectionType.getStringType();
            }
            if (o instanceof DepthUnits) {
                DepthUnits depthUnits = (DepthUnits)o;
                return depthUnits.getFullName();
            }
            if (o instanceof LocalDate) {
                LocalDate localDate = (LocalDate)o;
                return localDate.format(DATE_FORMATTER);
            }
            if (o instanceof WellDatum) {
                WellDatum wellDatum = (WellDatum)o;
                return wellDatum.getDescr();
            }
            return switch (propertyIndex) {
                case 16, 17, 19, 20 -> String.valueOf(o);
                case 22, 23, 24, 25 -> DepthStringUtils.getDepthStringValueOrEmpty((Double)o, wh.getUnits(), wh.getSectionType(), 2);
                case 26 -> SB.floatString((double)DepthUtils.convFromM((double)wh.getTerminalDepth(), (DepthUnits)wh.getUnits(), (SectionType)wh.getSectionType()), (int)2).trim();
                case 27 -> {
                    if (wh.lithologyDepthsAreDrilled()) {
                        yield "Drilled";
                    }
                    yield "Logged";
                }
                default -> o.toString();
            };
        }

        private void setWellHeaderField(WellHeader wh, int propertyIndex, Object value) {
            switch (propertyIndex) {
                case 0: {
                    wh.setWellName((String)value);
                    break;
                }
                case 1: {
                    wh.setWellAltName((String)value);
                    break;
                }
                case 2: {
                    wh.setWellCode((String)value);
                    break;
                }
                case 3: {
                    wh.setSectionType((SectionType)value);
                    break;
                }
                case 4: {
                    wh.setUnits((DepthUnits)value);
                    break;
                }
                case 5: {
                    wh.setOperator((String)value);
                    break;
                }
                case 6: {
                    wh.setOcs((String)value);
                    break;
                }
                case 7: {
                    wh.setSpudDate((LocalDate)value);
                    break;
                }
                case 8: {
                    wh.setCompletionDate((LocalDate)value);
                    break;
                }
                case 9: {
                    wh.setCountry((String)value);
                    break;
                }
                case 10: {
                    wh.setCounty((String)value);
                    break;
                }
                case 11: {
                    wh.setLocState((String)value);
                    break;
                }
                case 12: {
                    wh.setField((String)value);
                    break;
                }
                case 13: {
                    wh.setBasin((String)value);
                    break;
                }
                case 14: {
                    wh.setArea((String)value);
                    break;
                }
                case 15: {
                    wh.setGeoDatum((String)value);
                    break;
                }
                case 16: {
                    wh.setGridX(((Double)value).doubleValue());
                    break;
                }
                case 17: {
                    wh.setGridY(((Double)value).doubleValue());
                    break;
                }
                case 18: {
                    wh.setUtmZone((String)value);
                    break;
                }
                case 19: {
                    wh.setLat_dec((Double)value);
                    break;
                }
                case 20: {
                    wh.setLong_dec((Double)value);
                    break;
                }
                case 21: {
                    wh.setDatum((WellDatum)value);
                    break;
                }
                case 22: {
                    wh.setRotaryTableElevation((Double)value);
                    break;
                }
                case 23: {
                    wh.setSeaLevel((Double)value);
                    break;
                }
                case 24: {
                    wh.setSeaBed((Double)value);
                    break;
                }
                case 25: {
                    wh.setKickOff((Double)value);
                    break;
                }
                case 26: {
                    wh.setTerminalDepth(((Double)value).doubleValue());
                    break;
                }
                case 27: {
                    wh.setLithologyDepthsAreDrilled(((Boolean)value).booleanValue());
                }
            }
        }
    }
}

