/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.WellHeader;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatch;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchSamples;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.wellheader.DialogSelectWell;
import jsbugs.wellheader.DialogWell;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.exception.StackError;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchWells
extends SBDialog {
    static String[] colTitle = new String[]{"File", "Name", "Code", "", "Name", "Code"};
    static int[] colWidths = new int[]{80, 60, 60, 20, 60, 60};
    private final WellsTableModel model = new WellsTableModel(this);
    private final SBdb db;
    private final SBdb ws;
    private final Image backgroundImage;
    private final LinkedList<Well> links = new LinkedList();
    private JButton jButton3;
    private JButton jButtonAddAll;
    private JButton jButtonAddEdit;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonMatchAll;
    private JButton jButtonOK;
    private JButton jButtonSelect;
    private JButton jButtonSelectMaster;
    private JButton jButtonUnmatch;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableWells;

    public DialogMatchWells(Frame parent, boolean modal, SBdb ws, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.ws = ws;
        this.db = db;
        this.backgroundImage = DialogMatch.getBackgroundImage();
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Wells");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.model.setupTable(this.jTableWells);
        this.model.fireTableDataChanged();
        if (this.ws.getnLoadedWells() == 1) {
            this.jTableWells.setRowSelectionInterval(0, 0);
        }
        this.jTableWells.getTableHeader().setReorderingAllowed(false);
        this.jTableWells.setRowSorter(new TableRowSorter<WellsTableModel>(this.model));
        new ColumnSortResetHandler(this.jTableWells).attach();
        Iterator<Well> it = this.ws.getWellIterator();
        while (it.hasNext()) {
            WsWell well = (WsWell)it.next();
            this.links.add(well.getLink());
        }
        this.jButtonSelectMaster.setVisible(false);
    }

    private void initComponents() {
        this.jButton3 = new JButton();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableWells = new JTable();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jButtonMatchAll = new JButton();
        this.jButtonSelect = new JButton();
        this.jButtonSelectMaster = new JButton();
        this.jButtonAddEdit = new JButton();
        this.jButtonAddAll = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonUnmatch = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButton3.setText("jButton3");
        this.jLabel2.setText("jLabel2");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 350));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableWells.setModel(this.model);
        this.jTableWells.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableWellsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableWells);
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 1, this.jLabel3.getFont().getSize() + 2));
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText("Workspace...");
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setText("...Database");
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonSelect.setText("Select...");
        this.jButtonSelect.setToolTipText("Select a well from database to match to selected well");
        this.jButtonSelect.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectActionPerformed(evt);
            }
        });
        this.jButtonSelectMaster.setText(" Select master...");
        this.jButtonSelectMaster.setEnabled(false);
        this.jButtonSelectMaster.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSelectMaster.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectMasterActionPerformed(evt);
            }
        });
        this.jButtonAddEdit.setText("Add/Edit...");
        this.jButtonAddEdit.setToolTipText("Add selected workspace well to database");
        this.jButtonAddEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddEditActionPerformed(evt);
            }
        });
        this.jButtonAddAll.setText("Add all");
        this.jButtonAddAll.setToolTipText("Add all workspace wells to database");
        this.jButtonAddAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddAllActionPerformed(evt);
            }
        });
        this.jButtonUnmatch.setText("Unmatch");
        this.jButtonUnmatch.setToolTipText("Reverse all matches made in current session");
        this.jButtonUnmatch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonUnmatchActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchWells this$0;
            {
                DialogMatchWells dialogMatchWells = this$0;
                Objects.requireNonNull(dialogMatchWells);
                this.this$0 = dialogMatchWells;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0, 288, Short.MAX_VALUE).add((Component)this.jLabel1)).add((Component)this.jScrollPane1, -1, 467, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add(2, (Component)this.jButtonUnmatch, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jSeparator1).add(2, (Component)this.jButtonMatchAll, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonSelect, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonAddAll, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonAddEdit, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonSelectMaster, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jLabel1)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonMatchAll).addPreferredGap(0).add((Component)this.jButtonSelect).addPreferredGap(0).add((Component)this.jButtonSelectMaster).addPreferredGap(0).add((Component)this.jButtonAddEdit).addPreferredGap(0).add((Component)this.jButtonAddAll).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonUnmatch).addPreferredGap(0, 25, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 344, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonSelectMasterActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog((Component)((Object)this), "Not implemented", this.getTitle(), 1);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        Iterator<Well> it = this.ws.getWellIterator();
        int i = 0;
        while (it.hasNext()) {
            WsWell well = (WsWell)it.next();
            try {
                well.setLink(this.links.get(i));
            }
            catch (SQLException | SBException e) {
                FrameJsbugs.showStackError("Error updating link/status for well: " + String.valueOf(well), (Exception)e, this.db);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
            ++i;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                if (well.getLink() != null) continue;
                well.match(this.db, true);
                if (well.getLink() == null && !well.getWellCode().isEmpty()) {
                    well.match(this.db, false);
                }
                well.updateHeaderStatus();
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSelectActionPerformed(ActionEvent evt) {
        if (this.jTableWells.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one well to match", this.getTitle(), 1);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            WsWell well = (WsWell)this.ws.getWellAt(this.jTableWells.convertRowIndexToModel(this.jTableWells.getSelectedRow()));
            DialogSelectWell dialog = new DialogSelectWell((JDialog)((Object)this), true, this.db, false, well.getWellName());
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelected() != null) {
                Well dbWell = dialog.getSelected();
                if (well.getType() != dbWell.getType()) {
                    well.setSectionType(dbWell.getType());
                }
                well.setLink(dbWell);
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error linking well", (Exception)e, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonUnmatchActionPerformed(ActionEvent evt) {
        if (this.jTableWells.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select well(s) to unmatch", this.getTitle(), 1);
            return;
        }
        try {
            int[] selection = this.jTableWells.getSelectedRows();
            for (int i = 0; i < selection.length; ++i) {
                WsWell well = (WsWell)this.ws.getWellAt(this.jTableWells.convertRowIndexToModel(selection[i]));
                if (well.getLink() == null) continue;
                well.unMatch();
            }
            this.jTableWells.updateUI();
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonAddEditActionPerformed(ActionEvent evt) {
        if (this.jTableWells.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select well to add/edit", this.getTitle(), 1);
            return;
        }
        try {
            WsWell wsWell = (WsWell)this.ws.getWellAt(this.jTableWells.convertRowIndexToModel(this.jTableWells.getSelectedRow()));
            DialogWell dialog = new DialogWell((JDialog)((Object)this), true, this.db, (Well)wsWell);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                Well dbWell = dialog.getWell();
                try {
                    wsWell.update(dbWell.getHeader().getWellHeaderCopy());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                wsWell.setLink(dbWell);
            }
            this.jTableWells.updateUI();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonAddAllActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Iterator<Well> it = this.ws.getWellIterator();
            boolean countryMissing = false;
            boolean TDderived = false;
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                if (well.getLink() != null) continue;
                WellHeader header = well.getHeader().getWellHeaderCopy();
                if (!well.hasTDorTop()) {
                    double derivedTD = 0.0;
                    for (Sample sample : well.getSamples()) {
                        if (!(sample.getDepth() > derivedTD)) continue;
                        derivedTD = sample.getDepth();
                    }
                    header.setTerminalDepth(derivedTD);
                    TDderived = true;
                }
                if (header.getCountry().isBlank() || !well.hasTDorTop()) {
                    countryMissing = true;
                    continue;
                }
                if (header.getWellCode().isBlank()) {
                    header.setWellCode(Well.makeCode(well.getWellName()));
                }
                Well temp = this.db.addWell(header);
                well.setLink(temp);
                this.db.commit();
            }
            if (countryMissing) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Some well(s) were not added because the country name or TD/top is missing. Add these well(s) using the Add/edit button.", this.getTitle(), 1);
            }
            if (TDderived) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Some well(s) were added with an assumed TD of the depth of the deepest sample.", this.getTitle(), 1);
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException ex) {
            this.db.doRollback();
            ex.printStackTrace();
            JOptionPane.showMessageDialog((Component)((Object)this), ex.getMessage(), this.getTitle(), 0);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        boolean askExclusion = false;
        try {
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                if (well.getLink() != null) continue;
                if (!askExclusion) {
                    int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Not all wells matched. Do you want to exclude unmatched wells?", this.getTitle(), 0, 2);
                    if (opt == 1) {
                        return;
                    }
                    askExclusion = true;
                }
                System.out.println("Excluding well: " + String.valueOf(well));
                it.remove();
                if (well.getLink() == null) continue;
                well.getLink().deleteObservers();
            }
            this.setOK();
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCancelActionPerformed(null);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchwells.html");
    }

    private void jTableWellsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonSelectActionPerformed(null);
        }
    }

    private class WellsTableModel
    extends AbstractTableModel {
        static final int COL_WS_FILE = 0;
        static final int COL_WS_NAME = 1;
        static final int COL_WS_CODE = 2;
        static final int COL_ARROW = 3;
        static final int COL_DB_NAME = 4;
        static final int COL_DB_CODE = 5;
        final /* synthetic */ DialogMatchWells this$0;

        private WellsTableModel(DialogMatchWells dialogMatchWells) {
            DialogMatchWells dialogMatchWells2 = dialogMatchWells;
            Objects.requireNonNull(dialogMatchWells2);
            this.this$0 = dialogMatchWells2;
        }

        @Override
        public int getColumnCount() {
            return colTitle.length;
        }

        @Override
        public int getRowCount() {
            return this.this$0.ws == null ? 0 : this.this$0.ws.getnLoadedWells();
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                WsWell well = (WsWell)this.this$0.ws.getWellAt(row);
                if (well == null) {
                    return "";
                }
                Well link = well.getLink();
                switch (col) {
                    case 0: {
                        return well.fileName == null || well.fileName.isEmpty() ? new StringStatus("", well.getStatus()) : new StringStatus(well.fileName, well.getStatus());
                    }
                    case 1: {
                        return new StringStatus(well.getWellName(), well.getStatus());
                    }
                    case 2: {
                        return new StringStatus(well.getWellCode(), well.getStatus());
                    }
                    case 4: {
                        return link != null ? link.getWellName() : "";
                    }
                    case 5: {
                        return link != null ? link.getWellCode() : "";
                    }
                    case 3: {
                        return link != null;
                    }
                }
                return "";
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                return "";
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: 
                case 2: {
                    return StringStatus.class;
                }
                case 4: 
                case 5: {
                    return String.class;
                }
                case 3: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        void setupTable(JTable jTableWells) {
            for (int i = 0; i < colTitle.length; ++i) {
                jTableWells.getColumnModel().getColumn(i).setHeaderValue(colTitle[i]);
                jTableWells.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
            }
            jTableWells.getColumnModel().getColumn(3).setMaxWidth(TableModelMatchSamples.colWidths[3]);
            jTableWells.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            jTableWells.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
            TableUtils.setTableHeaderBold((JTable)jTableWells);
        }
    }
}

