/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import jsbchart.core.ChartManager;
import jsbugs.DialogMergeOccurrences;
import jsbugs.FrameJsbugs;
import jsbugs.InternalFrameTaxa;
import jsbugs.MergeTaxonTableModel;
import jsbugs.TaxonCount;
import model3.CoOccurrence;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Taxon;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogMergeTaxa
extends SBDialog {
    private final SBdb sbdb;
    private final ChartManager chartManager;
    private final MergeTaxonTableModel model = new MergeTaxonTableModel();
    private Taxon target;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonMerge;
    private JButton jButtonSetTarget;
    private JCheckBox jCheckBoxCreateSynonym;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTable jTableMerge;
    private JTextField jTextFieldReplace;

    public DialogMergeTaxa(Frame parent, boolean modal, SBdb db, List<Taxon> taxa, ChartManager chartManager) throws SQLException {
        super(parent, modal);
        this.sbdb = db;
        this.chartManager = chartManager;
        this.initComponents();
        this.init(taxa, null);
    }

    public DialogMergeTaxa(Dialog parent, boolean modal, SBdb db, List<Taxon> taxa, Taxon target, ChartManager chartManager) throws SQLException {
        super((Window)parent, modal);
        this.sbdb = db;
        this.chartManager = chartManager;
        this.initComponents();
        this.init(taxa, target);
    }

    private void init(List<Taxon> taxa, Taxon setTarget) throws SQLException {
        this.model.setupTable(this.jTableMerge, this.sbdb);
        this.model.taxa = new LinkedList<TaxonCount>();
        for (Taxon taxon : taxa) {
            this.model.taxa.add(new TaxonCount(taxon, taxon.checkOcc(false), taxon.checkOcc(true)));
        }
        this.model.fireTableDataChanged();
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0 && (this.sbdb.getUser().getPriv() & 4) > 0) {
            this.jButtonMerge.setEnabled(false);
            this.jButtonMerge.setToolTipText("As a restricted user you cannot merge taxa");
        }
        this.setTitle("Merge Taxa");
        if (setTarget != null) {
            if (!taxa.contains(setTarget)) {
                throw new IllegalStateException("Cannot set target which is not in list");
            }
            this.target = setTarget;
            this.jTextFieldReplace.setText(this.target.toString(true));
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            this.jButtonMerge.setEnabled(false);
            this.jButtonMerge.setToolTipText(SBRestrictable.getDeniedReason(false));
        }
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonMerge = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldReplace = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMerge = new JTable();
        this.jButtonSetTarget = new JButton();
        this.jCheckBoxCreateSynonym = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 200));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMergeTaxa this$0;
            {
                DialogMergeTaxa dialogMergeTaxa = this$0;
                Objects.requireNonNull(dialogMergeTaxa);
                this.this$0 = dialogMergeTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMergeTaxa this$0;
            {
                DialogMergeTaxa dialogMergeTaxa = this$0;
                Objects.requireNonNull(dialogMergeTaxa);
                this.this$0 = dialogMergeTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonMerge.setText("Merge");
        this.jButtonMerge.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMergeTaxa this$0;
            {
                DialogMergeTaxa dialogMergeTaxa = this$0;
                Objects.requireNonNull(dialogMergeTaxa);
                this.this$0 = dialogMergeTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMergeActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Replace with:");
        this.jTextFieldReplace.setEditable(false);
        this.jTextFieldReplace.setBackground(new Color(255, 255, 204));
        this.jTableMerge.setModel(this.model);
        this.jTableMerge.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogMergeTaxa this$0;
            {
                DialogMergeTaxa dialogMergeTaxa = this$0;
                Objects.requireNonNull(dialogMergeTaxa);
                this.this$0 = dialogMergeTaxa;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableMergeMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMerge);
        this.jButtonSetTarget.setText("Set Keeper");
        this.jButtonSetTarget.setToolTipText("Make selected taxon the one to keep in the database");
        this.jButtonSetTarget.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMergeTaxa this$0;
            {
                DialogMergeTaxa dialogMergeTaxa = this$0;
                Objects.requireNonNull(dialogMergeTaxa);
                this.this$0 = dialogMergeTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSetTargetActionPerformed(evt);
            }
        });
        this.jCheckBoxCreateSynonym.setText("Create synonym(s) from donor (s)");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jTextFieldReplace)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonSetTarget).addPreferredGap(0).add((Component)this.jCheckBoxCreateSynonym, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jButtonMerge).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonMerge}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldReplace, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 218, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonMerge).add((Component)this.jButtonSetTarget).add((Component)this.jCheckBoxCreateSynonym)).addContainerGap()));
        this.pack();
    }

    private void jTableMergeMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonSetTargetActionPerformed(null);
        }
    }

    private void jButtonSetTargetActionPerformed(ActionEvent evt) {
        if (this.jTableMerge.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one row only", this.getTitle(), 1);
            return;
        }
        this.target = this.model.taxa.get((int)this.jTableMerge.getSelectedRow()).taxon;
        this.jTextFieldReplace.setText(this.target.toString(true));
        this.jCheckBoxCreateSynonym.setSelected(false);
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Taxon taxon = this.model.taxa.get((int)i).taxon;
            if (taxon == this.target || this.model.taxa.get((int)i).nOccs <= 0) continue;
            this.jCheckBoxCreateSynonym.setSelected(true);
            this.jCheckBoxCreateSynonym.setEnabled(true);
            break;
        }
        if (!this.jCheckBoxCreateSynonym.isSelected()) {
            this.jCheckBoxCreateSynonym.setEnabled(false);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonMergeActionPerformed(ActionEvent evt) {
        if (this.target == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a taxon to keep, to which the displayed taxon/taxa will be merged.", this.getTitle(), 1);
            return;
        }
        int nCounts = 0;
        try {
            for (TaxonCount taxonCount : this.model.taxa) {
                if (taxonCount.taxon == this.target) continue;
                if (taxonCount.targetSpecType instanceof String) {
                    String s = (String)taxonCount.targetSpecType;
                    taxonCount.specType = s == null || s.isEmpty() ? -1 : this.sbdb.getSpeciesTypeService().findSpeciesType((String)taxonCount.targetSpecType).map(SpeciesType::specTypeID).orElse(-1);
                } else {
                    taxonCount.occType = (Taxon.OccType)((Object)taxonCount.targetSpecType);
                }
                nCounts += taxonCount.nOccs;
                if (taxonCount.specType <= 0 || taxonCount.nSpecTypeOccs <= 0 || taxonCount.taxon.checkOcc(taxonCount.specType) == taxonCount.nSpecTypeOccs) continue;
                String msg = "You cannot change the sub-type of '" + String.valueOf(taxonCount.taxon) + "' because " + taxonCount.nSpecTypeOccs + " occurrences already have a sub-type. \nEdit these occurrences, or do not change the sub-type in the merge.";
                JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 2);
                return;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return;
        }
        if (nCounts > 0) {
            String msg = "WARNING: You will be permanently altering the record of " + nCounts + " taxon occurrence" + (nCounts > 1 ? "s" : "") + ".";
            for (TaxonCount taxonCount : this.model.taxa) {
                if (taxonCount.taxon == this.target || taxonCount.nOccs <= 0) continue;
                msg = msg + "\nAll occurrences of '" + String.valueOf(taxonCount.taxon) + "' will become occurrences of '" + String.valueOf(this.target) + "'";
                if (taxonCount.specType > 0) {
                    msg = msg + " with sub-type '" + String.valueOf(taxonCount.targetSpecType) + "'";
                } else if (taxonCount.occType != null) {
                    msg = msg + " (" + taxonCount.occType.toString() + ")";
                }
                msg = msg + ".";
                if (!this.jCheckBoxCreateSynonym.isSelected()) continue;
                msg = msg + "\n(but retain original as junior synonym)";
            }
            if (JOptionPane.showConfirmDialog((Component)((Object)this), msg = msg + "\n\nAre you sure you want to proceeed?", this.getTitle(), 0, 2) != 0) {
                return;
            }
        }
        try {
            this.setCursor(new Cursor(3));
            int retainJuniorSynonymScheme = 0;
            for (TaxonCount taxonCount : this.model.taxa) {
                Taxon taxon = taxonCount.taxon;
                if (taxon == this.target) continue;
                try {
                    block42: {
                        if (taxonCount.specType > 0) {
                            try {
                                this.sbdb.updateOcc(taxon, taxonCount.specType);
                                break block42;
                            }
                            catch (SBException sbe) {
                                JOptionPane.showMessageDialog((Component)((Object)this), "Merge failed for '" + String.valueOf(taxon) + "':\n" + sbe.getMessage(), this.getTitle(), 2);
                                continue;
                            }
                        }
                        if (taxonCount.occType != null) {
                            try {
                                String field;
                                this.sbdb.updateOcc(taxon, field, switch (taxonCount.occType) {
                                    case Taxon.OccType.REWORKED -> {
                                        field = "status";
                                        yield 'R';
                                    }
                                    case Taxon.OccType.QUESTIONABLE -> {
                                        field = "ident_type";
                                        yield '?';
                                    }
                                    case Taxon.OccType.CAVED -> {
                                        field = "caved";
                                        yield 'C';
                                    }
                                    default -> throw new IllegalStateException("Unrecognised occType: " + String.valueOf((Object)taxonCount.occType));
                                });
                            }
                            catch (SBException sbe) {
                                JOptionPane.showMessageDialog((Component)((Object)this), "Merge failed for '" + String.valueOf(taxon) + "':\n" + sbe.getMessage(), this.getTitle(), 2);
                                continue;
                            }
                        }
                    }
                    ChartManager.TaxonMerge chartMergeResult = this.chartManager.mergeTaxa(taxon, this.target, null);
                    if (this.jCheckBoxCreateSynonym.isSelected() && taxonCount.nOccs > 0) {
                        retainJuniorSynonymScheme = InternalFrameTaxa.getSynSchID(this.sbdb);
                    }
                    this.sbdb.mergeTaxa(taxon, this.target, taxonCount.specType, retainJuniorSynonymScheme);
                    try {
                        this.chartManager.mergeTaxa(taxon, this.target, chartMergeResult);
                    }
                    catch (Exception e) {
                        StackError.showStackError((String)"Success in merge but error updating loaded chart templates", (Throwable)e);
                    }
                }
                catch (SBException ex) {
                    if (ex.getData() != null) {
                        List coOccs = (List)ex.getData();
                        for (CoOccurrence coOcc : coOccs) {
                            if (coOcc.donor.getSpecID() != taxon.getSpecID()) {
                                throw new SBException("Error in getting coOccurrences: donor: " + coOcc.donor.getSpecID() + " / " + taxon.getSpecID());
                            }
                            if (coOcc.target.getSpecID() == this.target.getSpecID()) continue;
                            throw new SBException("Error in getting coOccurrences: target: " + coOcc.target.getSpecID() + " / " + this.target.getSpecID());
                        }
                        DialogMergeOccurrences dialog = new DialogMergeOccurrences((JDialog)((Object)this), true, this.sbdb, coOccs);
                        dialog.setLocationRelativeTo((Component)((Object)this));
                        dialog.setVisible(true);
                        if (!dialog.isOK()) {
                            JOptionPane.showMessageDialog((Component)((Object)this), "Merge of " + String.valueOf(taxon) + " cancelled", this.getTitle(), 1);
                            continue;
                        }
                        this.sbdb.mergeTaxa(taxon, this.target, taxonCount.specType, retainJuniorSynonymScheme);
                        continue;
                    }
                    throw ex;
                }
            }
            this.sbdb.commit();
            this.setOK();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException ex) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error merging", (Exception)ex, this.sbdb);
        }
        catch (RuntimeException re) {
            this.sbdb.doRollback();
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmergetaxa.html");
    }
}

