/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.sbconnect.ICConnection;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogICConnection;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelODMMap;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import jsbugs.wellheader.DialogSelectWellODM;
import model3.Lastval;
import model3.ODMReader;
import model3.SBdb;
import model3.Well;
import model3.WsWell;
import org.apache.commons.lang3.StringUtils;
import util.SBException;
import util.exception.StackError;

public class DialogODM
extends JDialog {
    private final SBdb ws;
    private final Set<Integer> dataTypes;
    private final DefaultListModel wellModel = new DefaultListModel();
    private JCheckBox[] checkBoxes;
    TableModelODMMap model = new TableModelODMMap();
    ICConnection icConnection = null;
    private JButton jButtonCancel;
    private JButton jButtonClearAll;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectDatabase;
    private JButton jButtonSelectProject;
    private JButton jButtonSelectWells;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jListWells;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable jTableTypeMap;
    private JTextField jTextFieldDatabase;

    public DialogODM(Frame parent, boolean modal, SBdb ws, SBdb db, Set<Integer> dataTypes) throws SQLException, SBException {
        super(parent, modal);
        this.ws = ws;
        this.model.db = db;
        this.dataTypes = dataTypes;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("StrataBugs - IC Import");
        this.model.setupTable(this.jTableTypeMap);
        String encodedICString = Lastval.getString(this.model.db, "ICdb");
        if (!StringUtils.isEmpty((CharSequence)encodedICString)) {
            this.icConnection = new ICConnection(encodedICString);
            this.setICDatabase();
        }
        this.jTableTypeMap.setRowSorter(new TableRowSorter<TableModelODMMap>(this.model));
        new ColumnSortResetHandler(this.jTableTypeMap).attach();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldDatabase = new JTextField();
        this.jButtonSelectDatabase = new JButton();
        this.jLabel2 = new JLabel();
        this.jButtonSelectWells = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonSelectProject = new JButton();
        this.jButtonClearAll = new JButton();
        this.jButtonHelp = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jListWells = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jTableTypeMap = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 400));
        this.jLabel1.setText("Database:");
        this.jTextFieldDatabase.setEditable(false);
        this.jButtonSelectDatabase.setText("...");
        this.jButtonSelectDatabase.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogODM this$0;
            {
                DialogODM dialogODM = this$0;
                Objects.requireNonNull(dialogODM);
                this.this$0 = dialogODM;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectDatabaseActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Well(s):");
        this.jButtonSelectWells.setText("Select...");
        this.jButtonSelectWells.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogODM this$0;
            {
                DialogODM dialogODM = this$0;
                Objects.requireNonNull(dialogODM);
                this.this$0 = dialogODM;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectWellsActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogODM this$0;
            {
                DialogODM dialogODM = this$0;
                Objects.requireNonNull(dialogODM);
                this.this$0 = dialogODM;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogODM this$0;
            {
                DialogODM dialogODM = this$0;
                Objects.requireNonNull(dialogODM);
                this.this$0 = dialogODM;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSelectProject.setText("Project...");
        this.jButtonSelectProject.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogODM this$0;
            {
                DialogODM dialogODM = this$0;
                Objects.requireNonNull(dialogODM);
                this.this$0 = dialogODM;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectProjectActionPerformed(evt);
            }
        });
        this.jButtonClearAll.setText("Clear all");
        this.jButtonClearAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogODM this$0;
            {
                DialogODM dialogODM = this$0;
                Objects.requireNonNull(dialogODM);
                this.this$0 = dialogODM;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearAllActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogODM this$0;
            {
                DialogODM dialogODM = this$0;
                Objects.requireNonNull(dialogODM);
                this.this$0 = dialogODM;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(50);
        this.jSplitPane1.setDividerSize(10);
        this.jSplitPane1.setOrientation(0);
        this.jScrollPane1.setPreferredSize(new Dimension(258, 230));
        this.jListWells.setModel(this.wellModel);
        this.jListWells.setMinimumSize(new Dimension(20, 20));
        this.jListWells.setPreferredSize(new Dimension(100, 20));
        this.jScrollPane1.setViewportView(this.jListWells);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jTableTypeMap.setModel(this.model);
        this.jScrollPane2.setViewportView(this.jTableTypeMap);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonClearAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jSplitPane1, -1, 604, Short.MAX_VALUE).addComponent(this.jTextFieldDatabase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSelectDatabase, -2, 30, -2).addComponent(this.jButtonSelectWells, -2, 45, -2).addComponent(this.jButtonSelectProject)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.linkSize(0, this.jButtonSelectProject, this.jButtonSelectWells);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldDatabase, -2, -1, -2)).addComponent(this.jButtonSelectDatabase)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 550, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonSelectWells).addGap(9, 9, 9).addComponent(this.jButtonSelectProject)).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonClearAll)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.model.odmReader == null) {
            JOptionPane.showMessageDialog(this, "You are not connected to an IC database", this.getTitle(), 2);
            return;
        }
        if (this.wellModel.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No well(s) selected", this.getTitle(), 2);
            return;
        }
        Iterator<ODMReader.ODMMetadataEntry> iterator = this.model.odmReader.metadata.iterator();
        while (iterator.hasNext()) {
            ODMReader.ODMMetadataEntry e1;
            ODMReader.ODMMetadataEntry entry1 = e1 = iterator.next();
            for (ODMReader.ODMMetadataEntry oDMMetadataEntry : this.model.odmReader.metadata) {
                ODMReader.ODMMetadataEntry oDMMetadataEntry2 = e1;
                if (entry1 == oDMMetadataEntry2 || entry1.getSbugsName().isEmpty() || !entry1.getSbugsName().equals(oDMMetadataEntry2.getSbugsName()) || entry1.getDtype() == 11 || entry1.getDtype() == 16) continue;
                JOptionPane.showMessageDialog(this, "Duplicate map entry for: " + entry1.getODMColumnDescrip() + "/" + entry1.getSbugsName(), this.getTitle(), 2);
                return;
            }
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Enumeration en = this.wellModel.elements();
            LinkedList<ODMReader.ODMWell> wells = new LinkedList<ODMReader.ODMWell>();
            while (en.hasMoreElements()) {
                wells.add((ODMReader.ODMWell)en.nextElement());
            }
            this.addDataType(1);
            int n = 0;
            HashSet<String> nonImportDataTypes = new HashSet<String>();
            for (ODMReader.ODMMetadataEntry oDMMetadataEntry : this.model.odmReader.metadata) {
                ODMReader.ODMMetadataEntry entry = oDMMetadataEntry;
                if (entry.getIgdType() > 0 || entry.getDtype() > 0) {
                    boolean addType = true;
                    switch (entry.getDtype()) {
                        case 3: {
                            this.model.odmReader.loadBiocom(this.ws, wells, entry.getODMTableName(), entry.getODMDataType(), Discipline.MICRO);
                            break;
                        }
                        case 5: {
                            this.model.odmReader.loadBiocom(this.ws, wells, entry.getODMTableName(), entry.getODMDataType(), Discipline.NANNO);
                            break;
                        }
                        case 7: {
                            this.model.odmReader.loadBiocom(this.ws, wells, entry.getODMTableName(), entry.getODMDataType(), Discipline.PALY);
                            break;
                        }
                        case 9: {
                            this.model.odmReader.loadBiocom(this.ws, wells, entry.getODMTableName(), entry.getODMDataType(), Discipline.MACRO);
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: {
                            this.model.odmReader.loadIntervals(this.ws, wells, entry.getODMTableDescrip(), entry.getODMTableName(), entry.getODMDataType(), entry.getIgdType(), entry.getHier());
                            break;
                        }
                        case 21: {
                            this.model.odmReader.loadLithology(this.ws, wells, entry.getODMTableName());
                            break;
                        }
                        case 16: {
                            this.model.odmReader.loadEvents(this.ws, wells, entry.getODMTableName(), entry.getODMDataType());
                            break;
                        }
                        default: {
                            if (entry.getSbugsName().trim().length() > 0) {
                                nonImportDataTypes.add(entry.getSbugsName());
                            }
                            addType = false;
                        }
                    }
                    if (!addType) continue;
                    String entryString = entry.getODMDataType() + "|" + entry.getODMTableID() + "|" + entry.getDtype() + "|" + entry.getIgdType() + "|" + entry.getHier();
                    Lastval.putString(this.model.db, "ODM2SB" + ++n, entryString);
                    this.addDataType(entry.getDtype());
                    continue;
                }
                if (entry.getSbugsName().trim().length() <= 0) continue;
                nonImportDataTypes.add(entry.getSbugsName());
            }
            Lastval.putInt(this.model.db, "ODM2SBNN", n);
            Lastval.putString(this.model.db, "ICdb", this.icConnection.encodeParams());
            this.model.db.commit();
            this.model.odmReader.close();
            Iterator<Well> iterator2 = this.ws.getWellIterator();
            while (iterator2.hasNext()) {
                WsWell wsWell = (WsWell)iterator2.next();
                wsWell.updateStatus();
            }
            if (!nonImportDataTypes.isEmpty()) {
                void var7_17;
                String string = "The following items were not imported, a method had not been implemented. Contact StrataData if required:\n";
                Iterator it = nonImportDataTypes.iterator();
                while (it.hasNext()) {
                    String string2 = (String)var7_17 + (String)it.next() + "\n";
                }
                JOptionPane.showMessageDialog(this, var7_17, this.getTitle(), 2);
            }
            this.dispose();
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonSelectDatabaseActionPerformed(ActionEvent evt) {
        DialogICConnection dialog = new DialogICConnection(this, true, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.connection != null) {
            this.icConnection = dialog.connection;
            this.setICDatabase();
        } else {
            this.icConnection = null;
        }
    }

    private void setICDatabase() {
        if (this.icConnection != null) {
            try {
                this.model.setOdmReader(new ODMReader(this.icConnection.getConnectionString()));
                this.jTextFieldDatabase.setText(this.icConnection.getServer() + "/" + this.icConnection.getDatabase());
                System.out.println("Connected to IC database");
                this.model.fireTableDataChanged();
            }
            catch (Exception ex) {
                StackError.showStackError((String)ex.toString(), (Throwable)ex);
            }
        }
    }

    private void jButtonSelectWellsActionPerformed(ActionEvent evt) {
        if (this.model.odmReader == null) {
            JOptionPane.showMessageDialog(this, "You are not connected to an IC database", this.getTitle(), 2);
            return;
        }
        try {
            DialogSelectWellODM dialog = new DialogSelectWellODM(this, true, this.model.db, this.model.odmReader);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection().size() > 0) {
                this.wellModel.clear();
                for (ODMReader.ODMWell well : dialog.getSelection()) {
                    this.wellModel.addElement(well);
                }
                this.jListWells.repaint();
            }
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonSelectProjectActionPerformed(ActionEvent evt) {
        if (this.model.odmReader == null) {
            JOptionPane.showMessageDialog(this, "No database selected");
            return;
        }
        try {
            DialogList dialog = new DialogList(this, true, "Select Project", new UserPrefsHelper(this.model.db), this.model.odmReader.getProjects(), true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.wellModel.clear();
                List<ODMReader.ODMWell> wells = ((ODMReader.Project)dialog.getSelection()).getWells();
                for (ODMReader.ODMWell well : wells) {
                    this.wellModel.addElement(well);
                }
                this.jListWells.repaint();
            }
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jButtonClearAllActionPerformed(ActionEvent evt) {
        if (this.model.odmReader != null) {
            Iterator<ODMReader.ODMMetadataEntry> iterator = this.model.odmReader.metadata.iterator();
            while (iterator.hasNext()) {
                ODMReader.ODMMetadataEntry e;
                ODMReader.ODMMetadataEntry entry = e = iterator.next();
                entry.clearSBugs();
            }
            this.model.fireTableDataChanged();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogodm.html");
    }

    private void addDataType(int dataType) {
        if (!this.dataTypes.contains(dataType)) {
            this.dataTypes.add(dataType);
        }
    }
}

