/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.DialogList;
import jsbugs.util.UserPrefsHelper;
import model3.IGDInterval;
import model3.IGDScheme;
import model3.OWXLSReader;
import model3.SBdb;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import util.InvalidFieldException;
import util.SBException;
import util.exception.StackError;

public class DialogOWXLSReader
extends JDialog {
    DefaultComboBoxModel igdTypeModel = new DefaultComboBoxModel();
    DefaultComboBoxModel schemeModel = new DefaultComboBoxModel();
    DefaultComboBoxModel sheetModel = new DefaultComboBoxModel();
    SBdb db;
    SBdb ws;
    File file;
    Set dataTypes;
    OWXLSReader reader;
    private ButtonGroup buttonGroupFormat;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxDataType;
    private JComboBox jComboBoxScheme;
    private JComboBox jComboBoxSheet;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonFormat1;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonformat2;
    private JTextField jTextFieldFileName;

    public DialogOWXLSReader(Frame parent, boolean modal, SBdb db, SBdb ws, File file, Set dataTypes) throws IOException, InvalidFormatException {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.ws = ws;
        this.file = file;
        this.dataTypes = dataTypes;
        this.init();
    }

    private void init() throws IOException, InvalidFormatException {
        String[] sheets;
        this.igdTypeModel.addElement(IGDInterval.getIGDName(2));
        this.igdTypeModel.addElement(IGDInterval.getIGDName(3));
        this.igdTypeModel.addElement(IGDInterval.getIGDName(4));
        this.igdTypeModel.addElement(IGDInterval.getIGDName(10));
        this.jComboBoxSheet.repaint();
        this.jTextFieldFileName.setText(this.file.getAbsolutePath());
        this.setTitle("XLS Reader");
        this.reader = new OWXLSReader(this.ws, this.file);
        for (String s : sheets = this.reader.getSheets()) {
            this.sheetModel.addElement(s);
        }
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupFormat = new ButtonGroup();
        this.jTextFieldFileName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jComboBoxSheet = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxScheme = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jComboBoxDataType = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jRadioButtonFormat1 = new JRadioButton();
        this.jRadioButtonformat2 = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jTextFieldFileName.setEditable(false);
        this.jLabel1.setText("File:");
        this.jComboBoxSheet.setModel(this.sheetModel);
        this.jComboBoxSheet.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOWXLSReader this$0;
            {
                DialogOWXLSReader dialogOWXLSReader = this$0;
                Objects.requireNonNull(dialogOWXLSReader);
                this.this$0 = dialogOWXLSReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSheetActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Worksheet:");
        this.jComboBoxScheme.setMaximumRowCount(30);
        this.jComboBoxScheme.setModel(this.schemeModel);
        this.jLabel3.setText("Scheme:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Units", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setSelected(true);
        this.jRadioButtonMetres.setText("Metres");
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonMetres).addGap(18, 18, 18).addComponent(this.jRadioButtonFeet).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonMetres).addComponent(this.jRadioButtonFeet)).addGap(0, 0, Short.MAX_VALUE)));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOWXLSReader this$0;
            {
                DialogOWXLSReader dialogOWXLSReader = this$0;
                Objects.requireNonNull(dialogOWXLSReader);
                this.this$0 = dialogOWXLSReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOWXLSReader this$0;
            {
                DialogOWXLSReader dialogOWXLSReader = this$0;
                Objects.requireNonNull(dialogOWXLSReader);
                this.this$0 = dialogOWXLSReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jComboBoxDataType.setModel(this.igdTypeModel);
        this.jComboBoxDataType.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOWXLSReader this$0;
            {
                DialogOWXLSReader dialogOWXLSReader = this$0;
                Objects.requireNonNull(dialogOWXLSReader);
                this.this$0 = dialogOWXLSReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxDataTypeActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Data Type:");
        this.buttonGroupFormat.add(this.jRadioButtonFormat1);
        this.jRadioButtonFormat1.setText("Well name/Surface name/obs/depth");
        this.buttonGroupFormat.add(this.jRadioButtonformat2);
        this.jRadioButtonformat2.setText("UWI/Common Well name/Name/Interp/Depth");
        this.jLabel5.setText("Main data columns:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBoxScheme, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxSheet, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldFileName).addComponent(this.jComboBoxDataType, 0, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonFormat1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jRadioButtonformat2)).addGap(0, 0, Short.MAX_VALUE))))).addGap(61, 61, 61)));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFileName, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxSheet, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxDataType, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxScheme, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFormat1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonformat2).addGap(18, 18, 18).addComponent(this.jPanel1, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addGap(25, 25, 25)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            int format;
            int igdType;
            int dataType;
            this.setCursor(Cursor.getPredefinedCursor(3));
            IGDScheme scheme = IGDScheme.copyToWorkspace(this.ws, (IGDScheme)this.jComboBoxScheme.getSelectedItem());
            scheme.clearLink();
            this.ws.addIGDScheme(scheme);
            char units = 'M';
            if (this.jRadioButtonFeet.isSelected()) {
                units = 'F';
            }
            if (!this.dataTypes.contains(dataType = (igdType = IGDInterval.getIGDType((String)this.jComboBoxDataType.getSelectedItem())) == 10 ? 14 : IGDInterval.igdType2dType(igdType))) {
                this.dataTypes.add(dataType);
            }
            if (this.jRadioButtonFormat1.isSelected()) {
                format = 1;
            } else if (this.jRadioButtonformat2.isSelected()) {
                format = 2;
            } else {
                JOptionPane.showMessageDialog(this, "Please select a column format.", this.getTitle(), 2);
                return;
            }
            this.reader.parse(this.jComboBoxSheet.getSelectedIndex(), format, units, scheme, igdType);
            if (!this.reader.getNonInserts().isEmpty()) {
                JOptionPane.showMessageDialog(this, "The following list of intervals were not added to due overlaps or other problems", this.getTitle(), 2);
                DialogList.displayListDialog(this, this.getTitle(), new UserPrefsHelper(this.db), this.reader.getNonInserts(), null);
            }
            this.dispose();
        }
        catch (IOException | RuntimeException | SQLException | InvalidFieldException | SBException ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jComboBoxSheetActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxDataTypeActionPerformed(ActionEvent evt) {
        System.out.println("Action performed on igdType");
        this.schemeModel.removeAllElements();
        int igdType = IGDInterval.getIGDType((String)this.jComboBoxDataType.getSelectedItem());
        try {
            for (IGDScheme scheme : this.db.getIGDSchemes(igdType)) {
                this.schemeModel.addElement(scheme);
            }
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
        this.jComboBoxScheme.repaint();
    }
}

