/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.image.ImageSet;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.DialogTaxonReassign;
import jsbugs.FrameJsbugs;
import jsbugs.image.DialogImageSet;
import jsbugs.image.TableModelImageSet;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.DontAskMeAgainFactory;
import model3.AnalystHeader;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogOccurrence
extends SBDialog {
    private static final int LENPRESERVATION = 20;
    private static final int LENCOLOUR = 20;
    private static final int LENCOMMENT = 255;
    private static final int spinnerLimit = 999999;
    private final SBdb db;
    private TaxonOcc fss;
    private final Smpdtl smpdtl;
    private final Well well;
    private Taxon taxon;
    private AbundanceScheme abn;
    private final TableModelImageSet imageTableModel;
    private final DefaultComboBoxModel specTypeModel = new DefaultComboBoxModel();
    final UndoableEditSupport undoSupport = new UndoableEditSupport();
    private boolean imageSetChanged = false;
    private final int synSchID;
    private ButtonGroup buttonGroupIdentification;
    private ButtonGroup buttonGroupSituation;
    private JButton jButtonCancel;
    private JButton jButtonEditImageSet;
    private JButton jButtonEditTaxon;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxMarker;
    private JCheckBox jCheckBoxPresentOutsideCount;
    private JComboBox jComboBoxAbundance;
    private JComboBox jComboBoxSpecType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabelCoarse;
    private JLabel jLabelFine;
    private JLabel jLabelMedium;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonCaved;
    private JRadioButton jRadioButtonContamination;
    private JRadioButton jRadioButtonInSitu;
    private JRadioButton jRadioButtonPositive;
    private JRadioButton jRadioButtonQuestionable;
    private JRadioButton jRadioButtonReworked;
    private JRadioButton jRadioButtonTransported;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerCoarse;
    private JSpinner jSpinnerFine;
    private JSpinner jSpinnerMedium;
    private JTable jTableImageSet;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldComments;
    private JTextField jTextFieldPreservation;
    private JTextField jTextFieldTaxonName;

    public DialogOccurrence(Frame parent, boolean modal, SBdb db, int synSchID, Well well, Smpdtl smpdtl, TaxonOcc fss, Taxon taxon, Situation situation, boolean questionable, boolean isMarker, boolean showSplits) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.taxon = taxon;
        this.fss = fss;
        this.well = well;
        this.smpdtl = smpdtl;
        this.synSchID = synSchID;
        this.imageTableModel = new TableModelImageSet(db.getImageRecordService(), db.getImageLoader());
        this.initComponents();
        this.init(situation, questionable, isMarker, showSplits);
    }

    private void init(Situation situation, boolean questionable, boolean isMarker, boolean showSplits) throws SQLException, SBException {
        AnalystHeader analystHeader = this.well.getAnalystHeader(this.smpdtl.getAnalyID(), true);
        if (analystHeader.getAbnSchID() > 0) {
            this.abn = this.db.getAbundanceSchemeService().findAbundanceScheme(analystHeader.getAbnSchID()).orElse(null);
        }
        this.jComboBoxAbundance.addItem("");
        if (this.abn != null) {
            for (AbundanceScheme.AbundanceSchemeEntry entry : this.abn.getEntries()) {
                this.jComboBoxAbundance.addItem(entry.entryName());
            }
        }
        this.jComboBoxAbundance.setSelectedIndex(0);
        SpinnerNumberModel modelCoarse = new SpinnerNumberModel(0, 0, 999999, 1);
        SpinnerNumberModel modelMedium = new SpinnerNumberModel(1, 0, 999999, 1);
        SpinnerNumberModel modelFine = new SpinnerNumberModel(0, 0, 999999, 1);
        this.jSpinnerCoarse.setModel(modelCoarse);
        this.jSpinnerMedium.setModel(modelMedium);
        this.jSpinnerFine.setModel(modelFine);
        this.initSpecTypeModel();
        if (this.fss != null) {
            this.initFss(showSplits);
        } else {
            this.jRadioButtonQuestionable.setSelected(questionable);
            this.setSituationRadioButton(situation);
            this.jCheckBoxMarker.setSelected(isMarker);
            this.setTitle("Occurrence: Add - " + this.getWindowCaption());
        }
        this.jTextFieldTaxonName.setText(this.taxon.toString());
        if (!showSplits) {
            this.jSpinnerCoarse.setVisible(false);
            this.jSpinnerFine.setVisible(false);
            this.jLabelMedium.setText("Count:");
            this.jLabelCoarse.setVisible(false);
            this.jLabelFine.setVisible(false);
        }
        this.imageTableModel.setupTable(this.jTableImageSet);
        if (this.fss.getImageSetID() > 0) {
            this.imageTableModel.setImageSet(new ImageSet(this.fss.getImageSetID()));
        }
        this.pack();
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void setSituationRadioButton(Situation situation) {
        switch (situation) {
            case RW: {
                this.jRadioButtonReworked.setSelected(true);
                break;
            }
            case INSITU: {
                this.jRadioButtonInSitu.setSelected(true);
                break;
            }
            case TR: {
                this.jRadioButtonTransported.setSelected(true);
                break;
            }
            case CV: {
                this.jRadioButtonCaved.setSelected(true);
                break;
            }
            case CN: {
                this.jRadioButtonContamination.setSelected(true);
            }
        }
    }

    private Situation getSituationRadioButton() {
        if (this.jRadioButtonReworked.isSelected()) {
            return Situation.RW;
        }
        if (this.jRadioButtonCaved.isSelected()) {
            return Situation.CV;
        }
        if (this.jRadioButtonTransported.isSelected()) {
            return Situation.TR;
        }
        if (this.jRadioButtonContamination.isSelected()) {
            return Situation.CN;
        }
        return Situation.INSITU;
    }

    private boolean initFss(boolean showSplits) throws SQLException, SBException {
        this.taxon = this.fss.getTaxon();
        this.jTextFieldPreservation.setText(this.fss.getPreservation());
        this.jTextFieldColour.setText(this.fss.getColour());
        this.jTextFieldComments.setText(this.fss.getComment());
        if (this.fss.getCoarse() > 0 || this.fss.getFine() > 0) {
            showSplits = true;
        }
        this.jSpinnerCoarse.getModel().setValue(this.fss.getCoarse());
        this.jSpinnerMedium.getModel().setValue(this.fss.getMedium());
        this.jSpinnerFine.getModel().setValue(this.fss.getFine());
        if (this.fss.getIdentType() == '?') {
            this.jRadioButtonQuestionable.setSelected(true);
        }
        this.setSituationRadioButton(this.fss.getSituation());
        this.jCheckBoxMarker.setSelected(this.fss.isMarker());
        if (this.fss.getSubAbund() != null && this.fss.getSubAbund().length() > 0) {
            if (this.abn != null) {
                int index = this.abn.getIndex(this.fss.getSubAbund());
                this.jComboBoxAbundance.setSelectedItem(this.abn.getEntry(index).entryName());
            }
        } else if (this.fss.getTotalCount() == 0) {
            this.jCheckBoxPresentOutsideCount.setSelected(true);
        }
        this.setTitle("Occurrence: Edit - " + this.getWindowCaption());
        this.jComboBoxSpecType.setSelectedItem(this.db.getSpeciesTypeService().getSpeciesType(this.fss.getSpecType()).get());
        return showSplits;
    }

    private String getWindowCaption() throws SQLException, SBException {
        return this.taxon.toString() + " (" + this.smpdtl.getSample().toString() + " " + this.smpdtl.getAnalystAbr() + (String)(this.smpdtl.getAnalyNo() > 1 ? "/" + this.smpdtl.getAnalyNo() : "") + ")";
    }

    private void initSpecTypeModel() throws SQLException {
        this.specTypeModel.removeAllElements();
        this.specTypeModel.addAll(this.db.getSpeciesTypeService().getAllSpeciesTypes());
        this.jComboBoxSpecType.repaint();
    }

    private void initComponents() {
        this.buttonGroupIdentification = new ButtonGroup();
        this.buttonGroupSituation = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel10 = new JPanel();
        this.jRadioButtonReworked = new JRadioButton();
        this.jRadioButtonInSitu = new JRadioButton();
        this.jCheckBoxMarker = new JCheckBox();
        this.jRadioButtonTransported = new JRadioButton();
        this.jRadioButtonCaved = new JRadioButton();
        this.jRadioButtonContamination = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldTaxonName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTextFieldPreservation = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldColour = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldComments = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabelCoarse = new JLabel();
        this.jLabelMedium = new JLabel();
        this.jLabelFine = new JLabel();
        this.jSpinnerCoarse = new JSpinner();
        this.jSpinnerMedium = new JSpinner();
        this.jSpinnerFine = new JSpinner();
        this.jLabel8 = new JLabel();
        this.jComboBoxAbundance = new JComboBox();
        this.jCheckBoxPresentOutsideCount = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jRadioButtonPositive = new JRadioButton();
        this.jRadioButtonQuestionable = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableImageSet = new JTable();
        this.jButtonEditImageSet = new JButton();
        this.jLabel5 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jComboBoxSpecType = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jButtonEditTaxon = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(525, 500));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogOccurrence this$0;
            {
                DialogOccurrence dialogOccurrence = this$0;
                Objects.requireNonNull(dialogOccurrence);
                this.this$0 = dialogOccurrence;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrence this$0;
            {
                DialogOccurrence dialogOccurrence = this$0;
                Objects.requireNonNull(dialogOccurrence);
                this.this$0 = dialogOccurrence;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrence this$0;
            {
                DialogOccurrence dialogOccurrence = this$0;
                Objects.requireNonNull(dialogOccurrence);
                this.this$0 = dialogOccurrence;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel10.setBorder(BorderFactory.createTitledBorder(null, "Situation", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel10.setMinimumSize(new Dimension(480, 600));
        this.buttonGroupSituation.add(this.jRadioButtonReworked);
        this.jRadioButtonReworked.setText("Reworked");
        this.jRadioButtonReworked.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonReworked.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupSituation.add(this.jRadioButtonInSitu);
        this.jRadioButtonInSitu.setSelected(true);
        this.jRadioButtonInSitu.setText("In-situ");
        this.jRadioButtonInSitu.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonInSitu.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxMarker.setText("Marker");
        this.jCheckBoxMarker.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxMarker.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupSituation.add(this.jRadioButtonTransported);
        this.jRadioButtonTransported.setText("Transported");
        this.jRadioButtonTransported.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonTransported.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupSituation.add(this.jRadioButtonCaved);
        this.jRadioButtonCaved.setText("Caved");
        this.jRadioButtonCaved.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCaved.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupSituation.add(this.jRadioButtonContamination);
        this.jRadioButtonContamination.setText("Contamination");
        this.jRadioButtonContamination.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonContamination.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel10Layout = new GroupLayout((Container)this.jPanel10);
        this.jPanel10.setLayout((LayoutManager)jPanel10Layout);
        jPanel10Layout.setHorizontalGroup((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel10Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add((Component)this.jRadioButtonInSitu).add((Component)this.jRadioButtonTransported).add((Component)this.jRadioButtonCaved).add((GroupLayout.Group)jPanel10Layout.createParallelGroup(2, false).add(1, (Component)this.jCheckBoxMarker, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jRadioButtonReworked, -1, -1, Short.MAX_VALUE)).add((Component)this.jRadioButtonContamination)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel10Layout.setVerticalGroup((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel10Layout.createSequentialGroup().add((Component)this.jRadioButtonInSitu).addPreferredGap(0).add((Component)this.jRadioButtonTransported, -2, 18, -2).addPreferredGap(0).add((Component)this.jRadioButtonReworked, -2, 18, -2).addPreferredGap(0).add((Component)this.jRadioButtonCaved).addPreferredGap(0).add((Component)this.jRadioButtonContamination).addPreferredGap(0).add((Component)this.jCheckBoxMarker).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.setText("Taxon:");
        this.jTextFieldTaxonName.setEditable(false);
        this.jTextFieldTaxonName.setText("jTextField2");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Comments", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel2.setText("Preservation:");
        this.jTextFieldPreservation.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogOccurrence this$0;
            {
                DialogOccurrence dialogOccurrence = this$0;
                Objects.requireNonNull(dialogOccurrence);
                this.this$0 = dialogOccurrence;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldPreservationKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Colour:");
        this.jTextFieldColour.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogOccurrence this$0;
            {
                DialogOccurrence dialogOccurrence = this$0;
                Objects.requireNonNull(dialogOccurrence);
                this.this$0 = dialogOccurrence;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldColourKeyTyped(evt);
            }
        });
        this.jLabel4.setText("Comments:");
        this.jTextFieldComments.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogOccurrence this$0;
            {
                DialogOccurrence dialogOccurrence = this$0;
                Objects.requireNonNull(dialogOccurrence);
                this.this$0 = dialogOccurrence;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldCommentsKeyTyped(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel4).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldPreservation).add((Component)this.jTextFieldComments).add((Component)this.jTextFieldColour)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldComments, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldPreservation, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldColour, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Abundance", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabelCoarse.setText("Coarse:");
        this.jLabelMedium.setText("Medium:");
        this.jLabelFine.setText("Fine:");
        this.jLabel8.setText("Semi-quantitative:");
        this.jComboBoxAbundance.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jCheckBoxPresentOutsideCount.setText("Present but outside sample count");
        this.jCheckBoxPresentOutsideCount.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrence this$0;
            {
                DialogOccurrence dialogOccurrence = this$0;
                Objects.requireNonNull(dialogOccurrence);
                this.this$0 = dialogOccurrence;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxPresentOutsideCountActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabelMedium).add((Component)this.jLabelCoarse).add((Component)this.jLabelFine)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jSpinnerFine).add((Component)this.jSpinnerMedium).add((Component)this.jSpinnerCoarse, -2, 79, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jComboBoxAbundance, 0, -1, Short.MAX_VALUE).add((Component)this.jLabel8))).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jCheckBoxPresentOutsideCount, -2, 265, -2).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabelCoarse).add((Component)this.jSpinnerCoarse, -2, -1, -2).add((Component)this.jLabel8)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabelMedium).add((Component)this.jSpinnerMedium, -2, -1, -2).add((Component)this.jComboBoxAbundance, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabelFine).add((Component)this.jSpinnerFine, -2, -1, -2)).addPreferredGap(0, 33, Short.MAX_VALUE).add((Component)this.jCheckBoxPresentOutsideCount).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Identification", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupIdentification.add(this.jRadioButtonPositive);
        this.jRadioButtonPositive.setSelected(true);
        this.jRadioButtonPositive.setText("Positive");
        this.jRadioButtonPositive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonPositive.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupIdentification.add(this.jRadioButtonQuestionable);
        this.jRadioButtonQuestionable.setText("Questionable");
        this.jRadioButtonQuestionable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonQuestionable.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jRadioButtonPositive).add((Component)this.jRadioButtonQuestionable)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jRadioButtonPositive).addPreferredGap(0).add((Component)this.jRadioButtonQuestionable)));
        this.jTableImageSet.setModel(this.imageTableModel);
        this.jScrollPane1.setViewportView(this.jTableImageSet);
        this.jButtonEditImageSet.setText("...");
        this.jButtonEditImageSet.setToolTipText("Edit images");
        this.jButtonEditImageSet.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonEditImageSet.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrence this$0;
            {
                DialogOccurrence dialogOccurrence = this$0;
                Objects.requireNonNull(dialogOccurrence);
                this.this$0 = dialogOccurrence;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditImageSetActionPerformed(evt);
            }
        });
        this.jLabel5.setForeground(new Color(51, 102, 204));
        this.jLabel5.setText("Images:");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrence this$0;
            {
                DialogOccurrence dialogOccurrence = this$0;
                Objects.requireNonNull(dialogOccurrence);
                this.this$0 = dialogOccurrence;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jComboBoxSpecType.setModel(this.specTypeModel);
        this.jComboBoxSpecType.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel6.setText("Sub-type:");
        this.jButtonEditTaxon.setText("Reassign...");
        this.jButtonEditTaxon.setToolTipText("Reassign the occurrences of this taxon to a different taxon");
        this.jButtonEditTaxon.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOccurrence this$0;
            {
                DialogOccurrence dialogOccurrence = this$0;
                Objects.requireNonNull(dialogOccurrence);
                this.this$0 = dialogOccurrence;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditTaxonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jSeparator1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldTaxonName).addPreferredGap(0).add((Component)this.jButtonEditTaxon)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel10, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jLabel6).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jComboBoxSpecType, 0, -1, Short.MAX_VALUE))).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK, -2, 47, -2).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel, -2, 65, -2)).add((Component)this.jButtonEditImageSet, -2, 33, -2)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldTaxonName, -2, -1, -2).add((Component)this.jButtonEditTaxon)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel10, -2, 164, -2).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.jComboBoxSpecType, -2, -1, -2)).add(1, (Component)this.jPanel2, -2, -1, -2))).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 200, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonEditImageSet).add(8, 8, 8).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldCommentsKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldComments, (int)255, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldPreservationKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldPreservation, (int)20, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldColourKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldColour, (int)20, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        try {
            if (this.imageTableModel.getImageSet() != null && this.fss.getImageSetID() == 0) {
                System.out.println("Deleting unlinked image set: ID " + this.imageTableModel.getImageSet().getImageSetID());
                this.db.getImageRecordService().deleteImageRecords(this.imageTableModel.getImageSet().getImageSetID());
            }
            this.dispose();
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    boolean checkSituConfChange(int newSpecType) {
        if (this.fss == null || this.fss.getQuestionable() == this.jRadioButtonQuestionable.isSelected() && this.fss.getSituation() == this.getSituationRadioButton() && this.fss.getSpecType() == newSpecType) {
            return true;
        }
        for (TaxonOcc occ : this.smpdtl.getOccurUnsorted()) {
            if (occ == this.fss || occ.getTaxon().getSpecID() != this.fss.getTaxon().getSpecID() || occ.getSpecType() != newSpecType || occ.getSituation() != this.getSituationRadioButton() || occ.getQuestionable() != this.jRadioButtonQuestionable.isSelected()) continue;
            return false;
        }
        return true;
    }

    boolean checkRwUpdate() throws SQLException, SBException {
        if (this.fss == null) {
            return false;
        }
        if (this.fss.getReworked() != this.jRadioButtonReworked.isSelected()) {
            boolean hasMultiSuites = false;
            boolean isDifferent = false;
            for (Sample sample : this.well.getSamples()) {
                if (sample.getDepth() >= this.smpdtl.getSample().getDepth()) break;
                for (Smpdtl dtl : sample.getSmpdtls()) {
                    for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                        if (occ.getSpecID() != this.fss.getSpecID() || occ.getReworked() == this.jRadioButtonReworked.isSelected()) continue;
                        isDifferent = true;
                        if (dtl.getAnalyID() == this.smpdtl.getAnalyID()) continue;
                        hasMultiSuites = true;
                    }
                }
            }
            if (isDifferent) {
                int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Do you want to set ALL higher occurrences to " + (this.jRadioButtonReworked.isSelected() ? "" : " NOT ") + " reworked?\n" + (hasMultiSuites ? "(Warning: this will affect analyses outside the current suite)" : "(Will affect current suite only)"), "Reworking", 0, 3);
                return opt == 0;
            }
        }
        return false;
    }

    static int doRwUpdate(TaxonOcc fss, Well well, Smpdtl smpdtl, boolean isReworked, boolean includeCurrent, boolean currentOnly) throws SQLException, SBException, FileNotFoundException, IOException {
        if (fss == null) {
            return 0;
        }
        if (!includeCurrent && fss.getReworked() != isReworked) {
            throw new SBException("Unexpected value of Rw flag in doRwUpdate.");
        }
        int nUpdated = 0;
        for (Sample sample : well.getSamples()) {
            if (sample.getDepth() > smpdtl.getSample().getDepth() || !includeCurrent && sample == smpdtl.getSample()) break;
            for (Smpdtl dtl : sample.getSmpdtls()) {
                if (currentOnly && dtl != smpdtl) continue;
                boolean hasSame = false;
                TaxonOcc diffOcc = null;
                for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                    if (occ.getSpecID() != fss.getSpecID()) continue;
                    if (occ.getReworked() != isReworked) {
                        diffOcc = occ;
                        continue;
                    }
                    hasSame = true;
                }
                if (diffOcc == null || hasSame) continue;
                dtl.updateOcc(well.getWellID(), diffOcc, isReworked ? Situation.RW : Situation.INSITU, diffOcc.getQuestionable(), diffOcc.getSpecType(), diffOcc.isMarker(), diffOcc.getCoarse(), diffOcc.getMedium(), diffOcc.getFine(), diffOcc.getSubAbund(), diffOcc.getPreservation(), diffOcc.getColour(), diffOcc.getComment(), diffOcc.getImageSetID());
                ++nUpdated;
            }
        }
        return nUpdated;
    }

    boolean checkCvUpdate() throws SQLException, SBException {
        if (this.fss == null) {
            return false;
        }
        if (this.fss.getCaved() != this.jRadioButtonCaved.isSelected()) {
            boolean hasMultiSuites = false;
            boolean isDifferent = false;
            for (Sample sample : this.well.getSamples()) {
                if (!sample.getTypeString().equalsIgnoreCase("CU") || sample.getDepth() <= this.smpdtl.getSample().getDepth()) continue;
                for (Smpdtl dtl : sample.getSmpdtls()) {
                    for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                        if (occ.getSpecID() != this.fss.getSpecID() || occ.getCaved() == this.jRadioButtonCaved.isSelected()) continue;
                        isDifferent = true;
                        if (dtl.getAnalyID() == this.smpdtl.getAnalyID()) continue;
                        hasMultiSuites = true;
                    }
                }
            }
            if (isDifferent) {
                int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Do you want to set ALL lower occurrences in Cuttings to " + (this.jRadioButtonCaved.isSelected() ? "" : " NOT ") + " caved?\n" + (hasMultiSuites ? "(Warning: this will affect analyses outside the current suite)" : "(Affects current suite only)"), "Caving", 0, 3);
                return opt == 0;
            }
        }
        return false;
    }

    static int doCvUpdate(TaxonOcc fss, Well well, Smpdtl smpdtl, boolean isCaved, boolean includeCurrent, boolean currentOnly) throws SQLException, SBException, FileNotFoundException, IOException {
        if (fss == null) {
            return 0;
        }
        if (!includeCurrent && fss.getCaved() != isCaved) {
            throw new SBException("Unexpected value of Cv flag in doCvUpdate.");
        }
        int nUpdated = 0;
        for (Sample sample : well.getSamples()) {
            if (!sample.getTypeString().equalsIgnoreCase("CU") || sample.getDepth() < smpdtl.getSample().getDepth() || !includeCurrent && sample == smpdtl.getSample()) continue;
            for (Smpdtl dtl : sample.getSmpdtls()) {
                boolean changed = true;
                if (currentOnly && dtl != smpdtl) continue;
                block2: while (changed) {
                    changed = false;
                    for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                        if (occ.getSpecID() != fss.getSpecID() || (isCaved || occ.getSituation() != Situation.CV) && (!isCaved || occ.getSituation() == Situation.CV)) continue;
                        dtl.updateOcc(well.getWellID(), occ, isCaved ? Situation.CV : Situation.INSITU, occ.getQuestionable(), occ.getSpecType(), occ.isMarker(), occ.getCoarse(), occ.getMedium(), occ.getFine(), occ.getSubAbund(), occ.getPreservation(), occ.getColour(), occ.getComment(), occ.getImageSetID());
                        ++nUpdated;
                        changed = true;
                        continue block2;
                    }
                }
            }
        }
        return nUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String subj = "";
            if (this.jComboBoxAbundance.getSelectedIndex() > 0) {
                subj = this.abn.findEntryByName((String)this.jComboBoxAbundance.getSelectedItem()).map(AbundanceScheme.AbundanceSchemeEntry::abr).orElseThrow();
            }
            int speciesType = ((SpeciesType)this.jComboBoxSpecType.getSelectedItem()).specTypeID();
            int coarse = Integer.parseInt(String.valueOf(this.jSpinnerCoarse.getValue()));
            int medium = Integer.parseInt(String.valueOf(this.jSpinnerMedium.getValue()));
            int fine = Integer.parseInt(String.valueOf(this.jSpinnerFine.getValue()));
            String preserv = this.jTextFieldPreservation.getText();
            String colour = this.jTextFieldColour.getText();
            String comment = this.jTextFieldComments.getText();
            if (coarse + medium + fine > 0 && subj.length() > 0 && JOptionPane.showConfirmDialog((Component)((Object)this), "You can't mix semi-quantitative and quantitative abundance.\nIgnore semi-quantitative data?", this.getTitle(), 0, 3) != 0) {
                return;
            }
            if (this.fss == null) {
                TaxonOcc.Builder occ = new TaxonOcc.Builder(this.db, this.taxon, this.getSituationRadioButton(), this.jRadioButtonQuestionable.isSelected(), speciesType);
                occ.count(coarse, medium, fine).subjAbund(subj).marker(this.jCheckBoxMarker.isSelected()).preservation(preserv).colour(colour).comment(comment).imageSet(this.imageTableModel.getImageSet().getImageSetID());
                Smpdtl.OccAddDelete edit = this.smpdtl.insertOccurrence(occ, this.well.getWellID());
                this.undoSupport.postEdit((UndoableEdit)((Object)edit));
            } else {
                int setAsType;
                if (!this.checkSituConfChange(speciesType)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Cannot save - this combination of taxon, situation, confidence and sub-type already exists in the analysis.", this.getTitle(), 2);
                    return;
                }
                boolean rwUpdate = this.checkRwUpdate();
                boolean cvUpdate = this.checkCvUpdate();
                this.smpdtl.updateOcc(this.well.getWellID(), this.fss, this.getSituationRadioButton(), this.jRadioButtonQuestionable.isSelected(), speciesType, this.jCheckBoxMarker.isSelected(), coarse, medium, fine, subj, preserv, colour, comment, this.imageTableModel.getImageSet() != null ? this.imageTableModel.getImageSet().getImageSetID() : 0);
                if (this.imageSetChanged && this.imageTableModel.getImageSet() != null && this.imageTableModel.getImageSet().getImageSetID() > 0 && !this.db.getTaxonImageService().hasTypeImage(this.fss.getTaxon().getSpecID()) && (setAsType = DontAskMeAgainFactory.getConfirmOption("TAXONOCCTYPE", (Window)((Object)this), 0, "There is no type reference image for this taxon. Use this image?", this.fss.getTaxon().toString(false), 1)) == 0) {
                    this.db.getTaxonImageService().setTaxonImageSetType(this.fss.getTaxon().getSpecID(), new TaxonImageSet(this.imageTableModel.getImageSet().getImageSetID(), this.fss.getTaxon().getSpecID(), false), true);
                }
                if (rwUpdate) {
                    JOptionPane.showMessageDialog((Component)((Object)this), DialogOccurrence.doRwUpdate(this.fss, this.well, this.smpdtl, this.jRadioButtonReworked.isSelected(), false, false) + " higher record(s) updated.", "Reworking", 1);
                }
                if (cvUpdate) {
                    JOptionPane.showMessageDialog((Component)((Object)this), DialogOccurrence.doCvUpdate(this.fss, this.well, this.smpdtl, this.jRadioButtonCaved.isSelected(), false, false) + " lower record(s) updated.", "Caving", 1);
                }
            }
            this.db.commit();
            this.smpdtl.notifyObservers();
            this.setOK();
        }
        catch (IOException | SQLException | SBException e) {
            this.db.doRollback();
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jCheckBoxPresentOutsideCountActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxPresentOutsideCount.isSelected()) {
            this.jSpinnerCoarse.setValue(0);
            this.jSpinnerMedium.setValue(0);
            this.jSpinnerFine.setValue(0);
            this.jComboBoxAbundance.setSelectedIndex(0);
        }
    }

    private void jButtonEditImageSetActionPerformed(ActionEvent evt) {
        ImageSet imageSet = null;
        if (this.fss.getImageSetID() > 0) {
            imageSet = new ImageSet(this.fss.getImageSetID());
        }
        try {
            DialogImageSet dialog = new DialogImageSet((Window)((Object)this), true, this.db, imageSet, this.well.canWrite(this.db, null));
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.imageTableModel.setImageSet(new ImageSet(dialog.getImageSetID()));
                this.imageSetChanged = true;
                this.imageTableModel.fireTableDataChanged();
            }
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogoccurrence.html");
    }

    private void jButtonEditTaxonActionPerformed(ActionEvent evt) {
        try {
            if (!this.well.canWrite(this.db, null) && SBRestrictable.canWrite(this.db)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "WARNING: you WILL be permitted to edit the name of a taxon which occurs in this read-only well.", this.getTitle(), 2);
            }
            DialogTaxonReassign dialog = new DialogTaxonReassign((JDialog)((Object)this), true, this.db, this.synSchID, this.well, this.taxon);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.taxon = dialog.target;
                this.jTextFieldTaxonName.setText(this.taxon.toString());
                if (this.fss != null) {
                    boolean foundTarget = false;
                    for (TaxonOcc occ : this.smpdtl.getOccurSorted()) {
                        if (occ.getSpecID() != this.taxon.getSpecID() || occ.getQuestionable() != this.fss.getQuestionable() || occ.getReworked() != this.fss.getReworked()) continue;
                        foundTarget = true;
                        this.fss = occ;
                        break;
                    }
                    if (!foundTarget) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Failed to find reassigned taxon target", this.getTitle(), 1);
                    } else {
                        this.initFss(this.jSpinnerCoarse.isVisible());
                    }
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (Exception ex) {
            StackError.showStackError((String)"Error", (Throwable)ex);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCancelActionPerformed(null);
    }
}

