/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableRowSorter;
import jsbchart.core.BlockTemplate;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelTemplate;
import jsbchart.core.TemplateDescr;
import jsbchart.panel.PanelType;
import jsbugs.DialogChartDesc;
import jsbugs.DialogChartTemplates;
import jsbugs.DialogList;
import jsbugs.DialogPermissions;
import jsbugs.FrameChart;
import jsbugs.FrameJsbugs;
import jsbugs.SbugsIO;
import jsbugs.TableModelPanelTemplates;
import jsbugs.chart.properties.DialogPanelProperties;
import jsbugs.list.RestrictableProjectListCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.SBRestrictable;
import model3.SBdb;
import model3.project.Project;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogPanelTemplates
extends JDialog {
    private static final int NAMELEN = 150;
    private static final String ALL_STRING = "All types";
    private static final String PROJ_ALL = "All";
    private static final String PROJ_GLOABL = "Global";
    private static Object lastType = null;
    private final DefaultComboBoxModel typeModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private final TableModelPanelTemplates model;
    private final FrameChart parent;
    private final ChartManager chartManager;
    private final SBdb sbdb;
    private JButton jButtonClose;
    private JButton jButtonCompare;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonExport;
    private JButton jButtonHelp;
    private JButton jButtonMerge;
    private JButton jButtonPermissions;
    private JButton jButtonProperties;
    private JButton jButtonSearch;
    private JButton jButtonSimilar;
    private JButton jButtonUsages;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTable jTablePanels;
    private JTextField jTextFieldName;

    public DialogPanelTemplates(FrameChart parent, boolean modal, SBdb sbdb, ChartManager chartManager) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.sbdb = sbdb;
        this.chartManager = chartManager;
        this.model = new TableModelPanelTemplates(sbdb, chartManager);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Panel Template Manager");
        this.getRootPane().setDefaultButton(this.jButtonSearch);
        this.initTypeCombo();
        this.initProjectCombo();
        this.model.setupTable(this.jTablePanels);
        this.jTablePanels.setRowSorter(new TableRowSorter<TableModelPanelTemplates>(this.model));
        new ColumnSortResetHandler(this.jTablePanels).attach();
        this.jComboBoxType.setRenderer(new ListCellRenderer(this){
            private final JLabel label;
            {
                Objects.requireNonNull(this$0);
                this.label = new JLabel();
                this.label.setBorder(new EmptyBorder(2, 2, 2, 2));
                this.label.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof PanelType) {
                    this.label.setIcon(((PanelType)value).getIcon());
                } else {
                    this.label.setIcon(null);
                }
                this.label.setText(value.toString());
                this.label.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
                this.label.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                return this.label;
            }
        });
    }

    private void initTypeCombo() {
        for (PanelType t : PanelType.values()) {
            this.typeModel.addElement(t);
        }
        this.typeModel.insertElementAt(ALL_STRING, 0);
        if (lastType != null) {
            this.jComboBoxType.setSelectedItem(lastType);
        } else {
            this.jComboBoxType.setSelectedIndex(0);
        }
    }

    private void initProjectCombo() {
        this.projectModel.addElement(PROJ_ALL);
        this.projectModel.addElement(PROJ_GLOABL);
        try {
            this.sbdb.loadProjectCombo(this.projectModel, false);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTablePanels = new JTable();
        this.jLabel1 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jTextFieldName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jButtonDelete = new JButton();
        this.jButtonSimilar = new JButton();
        this.jButtonUsages = new JButton();
        this.jButtonMerge = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonSearch = new JButton();
        this.jButtonProperties = new JButton();
        this.jButtonPermissions = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jButtonCompare = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonExport = new JButton();
        this.jLabel2.setText("jLabel2");
        this.setDefaultCloseOperation(2);
        this.jTablePanels.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTablePanels);
        this.jLabel1.setText("Type:");
        this.jComboBoxType.setMaximumRowCount(15);
        this.jComboBoxType.setModel(this.typeModel);
        this.jTextFieldName.setText("%");
        this.jTextFieldName.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldNameFocusGained(evt);
            }
        });
        this.jTextFieldName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Name:");
        this.jLabel4.setText("Project:");
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.projectModel);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonSimilar.setText("Find similar...");
        this.jButtonSimilar.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonSimilar.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSimilarActionPerformed(evt);
            }
        });
        this.jButtonUsages.setText("Find usages...");
        this.jButtonUsages.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonUsages.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonUsagesActionPerformed(evt);
            }
        });
        this.jButtonMerge.setText("Merge");
        this.jButtonMerge.setToolTipText("Merge selected panels");
        this.jButtonMerge.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMergeActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonProperties.setText("Properties...");
        this.jButtonProperties.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPropertiesActionPerformed(evt);
            }
        });
        this.jButtonPermissions.setText("Permissions...");
        this.jButtonPermissions.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonPermissions.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPermissionsActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCompare.setText("Compare...");
        this.jButtonCompare.setToolTipText("Compare selected panels' properties side-by-side");
        this.jButtonCompare.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCompareActionPerformed(evt);
            }
        });
        this.jButtonExport.setText("Export...");
        this.jButtonExport.setToolTipText("Export selected templates to SBG file");
        this.jButtonExport.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTemplates this$0;
            {
                DialogPanelTemplates dialogPanelTemplates = this$0;
                Objects.requireNonNull(dialogPanelTemplates);
                this.this$0 = dialogPanelTemplates;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExportActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxProject, 0, 240, Short.MAX_VALUE).addComponent(this.jTextFieldName).addComponent(this.jComboBoxType, 0, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.jButtonSearch).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 494, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonEdit, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMerge, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSimilar, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonUsages, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonProperties, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonPermissions, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCompare, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator2).addComponent(this.jButtonExport, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxType, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxProject, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jButtonSearch)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProperties).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPermissions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonUsages).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSimilar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCompare).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMerge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldNameFocusGained(FocusEvent evt) {
        this.jTextFieldName.setCaretPosition(0);
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)150, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        lastType = this.jComboBoxType.getSelectedItem();
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSearchActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object o = this.jComboBoxType.getSelectedItem();
            LinkedList<PanelTemplate> l = new LinkedList<PanelTemplate>();
            Object pItem = this.jComboBoxProject.getSelectedItem();
            Integer projID = null;
            if (pItem instanceof Project) {
                projID = ((Project)((Object)pItem)).getID();
            } else if (pItem == PROJ_GLOABL) {
                projID = 0;
            }
            l.addAll(this.chartManager.searchPanels(o == ALL_STRING ? null : (PanelType)o, this.jTextFieldName.getText(), projID));
            this.model.setTemplates(l);
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTablePanels.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select a template", this.getTitle(), 2);
            return;
        }
        PanelTemplate templ = this.model.getTemplates().get(this.jTablePanels.convertRowIndexToModel(this.jTablePanels.getSelectedRow()));
        try {
            DialogChartDesc dialog = new DialogChartDesc(this, this.sbdb, (TemplateDescr)templ, templ.canWrite(this.sbdb, null), false);
            dialog.restrictProjectToProject(templ.getProjID(), true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK() && templ.updateDescr(this.sbdb, dialog.name, dialog.comments, dialog.projID)) {
                this.sbdb.commit();
                this.model.fireTableDataChanged();
            }
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), "Edit Panel Template", 2);
        }
        catch (SQLException | SBPermissionException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
    }

    private void jButtonUsagesActionPerformed(ActionEvent evt) {
        if (this.jTablePanels.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select a template", this.getTitle(), 2);
            return;
        }
        PanelTemplate templ = this.model.getTemplates().get(this.jTablePanels.convertRowIndexToModel(this.jTablePanels.getSelectedRow()));
        try {
            List<BlockTemplate> blocks = this.chartManager.searchBlocks(templ.getID());
            if (blocks.isEmpty()) {
                JOptionPane.showMessageDialog(this, "This panel is not used in any blocks.", "Find Panel Usages", 1);
                return;
            }
            templ.resetNusages();
            DialogChartTemplates dialog = new DialogChartTemplates(this, true, this.sbdb, this.chartManager, new LinkedList<ChartTemplateBase>(blocks));
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.parent.openTemplates(dialog.selection);
                this.jButtonCloseActionPerformed(null);
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTablePanels.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select a template", this.getTitle(), 2);
            return;
        }
        ArrayList<PanelTemplate> templs = new ArrayList<PanelTemplate>();
        int[] nArray = this.jTablePanels.getSelectedRows();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            PanelTemplate template = this.model.getTemplates().get(this.jTablePanels.convertRowIndexToModel(i2));
            try {
                if (template.isDefaultTemplate() && this.chartManager.isUniquelyDefaultPanelTemplate(template.getID())) {
                    JOptionPane.showMessageDialog(this, "You can't delete the default template: " + template.getName(), this.getTitle(), 2);
                    continue;
                }
            }
            catch (SQLException | SBException e) {
                FrameJsbugs.showStackError("Error", (Exception)e, this.sbdb);
            }
            templs.add(this.model.getTemplates().get(this.jTablePanels.convertRowIndexToModel(i2)));
        }
        if (templs.isEmpty()) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog(this, "Really delete " + (String)(templs.size() == 1 ? "this template?" : "these " + templs.size() + " templates?"), this.getTitle(), 0);
        if (opt != 0) {
            return;
        }
        int nDeleted = 0;
        try {
            for (PanelTemplate templ : templs) {
                try {
                    this.chartManager.deletePanelTemplate(templ.getID());
                    this.sbdb.commit();
                    this.model.getTemplates().remove(templ);
                    ++nDeleted;
                }
                catch (SBException sbe) {
                    JOptionPane.showMessageDialog(this, "Can't delete '" + templ.getName() + "':\n" + sbe.getMessage(), "Delete Template", 2);
                }
            }
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBPermissionException sql) {
            FrameJsbugs.showStackError("Error", (Exception)((Object)sql), this.sbdb);
        }
        if (nDeleted > 0) {
            JOptionPane.showMessageDialog(this, nDeleted + " template" + (nDeleted > 1 ? "s" : "") + " deleted.", "Delete Panel Templates", 1);
        }
    }

    private void jButtonPropertiesActionPerformed(ActionEvent evt) {
        if (this.jTablePanels.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one template", this.getTitle(), 2);
            return;
        }
        PanelTemplate templ = this.model.getTemplates().get(this.jTablePanels.convertRowIndexToModel(this.jTablePanels.getSelectedRow()));
        DialogPanelProperties dialog = new DialogPanelProperties(this.parent, true, this.sbdb, templ, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonPermissionsActionPerformed(ActionEvent evt) {
        if (this.jTablePanels.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one template", this.getTitle(), 2);
            return;
        }
        PanelTemplate templ = this.model.getTemplates().get(this.jTablePanels.convertRowIndexToModel(this.jTablePanels.getSelectedRow()));
        try {
            DialogPermissions dialog = new DialogPermissions(this, true, this.sbdb, (SBRestrictable)templ, this.chartManager);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.jTablePanels.repaint();
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("SQL Error", (Exception)e, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"charts_panels.html#dialogpaneltemplates");
    }

    private void jButtonSimilarActionPerformed(ActionEvent evt) {
        if (this.jTablePanels.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one template", this.getTitle(), 2);
            return;
        }
        PanelTemplate templ = this.model.getTemplates().get(this.jTablePanels.convertRowIndexToModel(this.jTablePanels.getSelectedRow()));
        try {
            List<PanelTemplate> similar = this.chartManager.findSimilar(templ, null);
            if (similar.isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no similar panel templates.", this.getTitle(), 1);
                return;
            }
            Collections.sort(similar, new ChartManager.TemplateComparator());
            DialogList.displayListDialog(this, "Similar to " + templ.getName(), new UserPrefsHelper(this.sbdb), similar, (ListCellRenderer)new RestrictableProjectListCellRenderer());
        }
        catch (RuntimeException | SQLException | SBException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    private void jButtonCompareActionPerformed(ActionEvent evt) {
        if (this.jTablePanels.getSelectedRowCount() < 2) {
            JOptionPane.showMessageDialog(this, "Select at least two templates of the same type.", this.getTitle(), 2);
            return;
        }
        LinkedList<PanelTemplate> panels = new LinkedList<PanelTemplate>();
        int[] nArray = this.jTablePanels.getSelectedRows();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            PanelTemplate panel = this.model.getTemplates().get(this.jTablePanels.convertRowIndexToModel(i2));
            if (!panels.isEmpty() && ((PanelTemplate)panels.get(0)).getType() != panel.getType()) {
                JOptionPane.showMessageDialog(this, "All panels must be the same type!", this.getTitle(), 2);
                return;
            }
            panels.add(panel);
        }
        DialogPanelProperties dialog = new DialogPanelProperties(this, this.sbdb, panels);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonMergeActionPerformed(ActionEvent evt) {
        if (this.jTablePanels.getSelectedRowCount() < 2) {
            JOptionPane.showMessageDialog(this, "Select at least two templates of the same type.", this.getTitle(), 2);
            return;
        }
        LinkedList<PanelTemplate> panels = new LinkedList<PanelTemplate>();
        int[] nArray = this.jTablePanels.getSelectedRows();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            PanelTemplate panel = this.model.getTemplates().get(this.jTablePanels.convertRowIndexToModel(i2));
            if (!panels.isEmpty() && ((PanelTemplate)panels.get(0)).getType() != panel.getType()) {
                JOptionPane.showMessageDialog(this, "All panels must be the same type!", this.getTitle(), 2);
                return;
            }
            panels.add(panel);
        }
        Object target = JOptionPane.showInputDialog(this, "Select the panel you wish to keep:", "Merge Panels", 1, null, panels.toArray(), panels.get(0));
        if (target == null) {
            return;
        }
        try {
            this.chartManager.mergePanels(panels, (PanelTemplate)target);
            JOptionPane.showMessageDialog(this, "Merge successful.", this.getTitle(), 1);
            panels.remove((PanelTemplate)target);
            this.model.getTemplates().removeAll(panels);
            this.model.fireTableDataChanged();
            int index = this.jTablePanels.convertRowIndexToView(this.model.getTemplates().indexOf(target));
            this.jTablePanels.getSelectionModel().setSelectionInterval(index, index);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), "Permission Error", 2);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            Object msg = sbe.getMessage();
            if (sbe.getData() != null && sbe.getData() instanceof HashMap) {
                HashMap map = (HashMap)sbe.getData();
                for (Object key : map.keySet()) {
                    msg = (String)msg + "\n\nError removing panel '" + String.valueOf(key) + "':";
                    for (Object o : (List)map.get(key)) {
                        msg = (String)msg + "\n\t" + ((Exception)o).getMessage();
                    }
                }
            }
            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            this.sbdb.doRollback();
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonExportActionPerformed(ActionEvent evt) {
        if (this.jTablePanels.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select at least one template.", this.getTitle(), 2);
            return;
        }
        String[] extensions = new String[]{"sbg"};
        String[] descriptions = new String[]{"StrataBugs XML/SBG"};
        String defaultFileName = this.jTablePanels.getSelectedRowCount() == 1 ? this.model.getTemplates().get(this.jTablePanels.convertRowIndexToModel(this.jTablePanels.getSelectedRow())).getName() : "Panels";
        File file = FileChooserUtils.chooseFileToWrite((SBdb)this.sbdb, (Component)this, (String)"WINFILE", (String)"UNXFILE", (String[])extensions, (String[])descriptions, (String)defaultFileName);
        if (file == null) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            SBdb ws = new SBdb(this.sbdb);
            ChartManager wsCM = new ChartManager(ws);
            int[] nArray = this.jTablePanels.getSelectedRows();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer i2 = nArray[i];
                PanelTemplate panel = this.model.getTemplates().get(this.jTablePanels.convertRowIndexToModel(i2));
                ChartManager.copyToWs(this.chartManager, wsCM, panel);
            }
            SbugsIO.saveSBGfile(this.sbdb, wsCM, null, file, this, null, false);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.sbdb);
        }
        catch (IOException fnf) {
            StackError.showStackError((String)"Error writing file", (Throwable)fnf);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

