/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import jsbugs.DialogPrintPreview;
import jsbugs.FrameJsbugs;
import jsbugs.LoggingSheet;
import jsbugs.SBPrint;
import model3.Lastval;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;

public class DialogPrintLoggingSheetProperties
extends JDialog {
    List<? extends SBPrint> prints;
    List<LoggingSheet> logSheets = new LinkedList<LoggingSheet>();
    SBdb db;
    private ButtonGroup buttonGroupFont;
    private ButtonGroup buttonGroupNames;
    private ButtonGroup buttonGroupSort;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAbn;
    private JCheckBox jCheckBoxBSComments;
    private JCheckBox jCheckBoxComments;
    private JCheckBox jCheckBoxImages;
    private JCheckBox jCheckBoxItalics;
    private JCheckBox jCheckBoxSpecType;
    private JCheckBox jCheckBoxWellCode;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonCodes;
    private JRadioButton jRadioButtonLargeFont;
    private JRadioButton jRadioButtonNames;
    private JRadioButton jRadioButtonSmallFont;
    private JRadioButton jRadioButtonSortAbund;
    private JRadioButton jRadioButtonSortCat;
    private JRadioButton jRadioButtonSortCode;
    private JRadioButton jRadioButtonSortGenus;
    private JSeparator jSeparator1;

    public DialogPrintLoggingSheetProperties(DialogPrintPreview parent, boolean modal, List<? extends SBPrint> prints, SBdb db) {
        super((Dialog)parent, modal);
        this.prints = prints;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Logging Sheet Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        for (SBPrint sBPrint : this.prints) {
            if (!(sBPrint instanceof LoggingSheet)) continue;
            this.logSheets.add((LoggingSheet)sBPrint);
        }
        LoggingSheet logSheet = this.logSheets.get(0);
        this.jCheckBoxWellCode.setSelected(logSheet.getDrawWellCode());
        this.jCheckBoxComments.setSelected(logSheet.getDrawComments());
        this.jCheckBoxImages.setSelected(logSheet.getDrawImages());
        this.jCheckBoxItalics.setSelected(logSheet.getDrawItalicNames());
        this.jCheckBoxBSComments.setSelected(logSheet.getDrawBSComments());
        this.jCheckBoxAbn.setSelected(logSheet.getDrawSemiQuant());
        this.jCheckBoxSpecType.setSelected(logSheet.getDrawSpecType());
        if (logSheet.getSmallFont()) {
            this.jRadioButtonSmallFont.setSelected(true);
        } else {
            this.jRadioButtonLargeFont.setSelected(true);
        }
        if (logSheet.getUseCodes()) {
            this.jRadioButtonCodes.setSelected(true);
        } else {
            this.jRadioButtonNames.setSelected(true);
        }
        int n = logSheet.getSort();
        switch (n) {
            case 3: {
                this.jRadioButtonSortCat.setSelected(true);
                break;
            }
            case 4: {
                this.jRadioButtonSortAbund.setSelected(true);
                break;
            }
            case 2: {
                this.jRadioButtonSortCode.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButtonSortGenus.setSelected(true);
            }
        }
    }

    private void initComponents() {
        this.buttonGroupSort = new ButtonGroup();
        this.buttonGroupFont = new ButtonGroup();
        this.buttonGroupNames = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSortCat = new JRadioButton();
        this.jRadioButtonSortAbund = new JRadioButton();
        this.jRadioButtonSortGenus = new JRadioButton();
        this.jRadioButtonSortCode = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jRadioButtonSmallFont = new JRadioButton();
        this.jRadioButtonLargeFont = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jCheckBoxWellCode = new JCheckBox();
        this.jCheckBoxItalics = new JCheckBox();
        this.jCheckBoxComments = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jCheckBoxImages = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jRadioButtonNames = new JRadioButton();
        this.jRadioButtonCodes = new JRadioButton();
        this.jButtonHelp = new JButton();
        this.jCheckBoxBSComments = new JCheckBox();
        this.jCheckBoxAbn = new JCheckBox();
        this.jCheckBoxSpecType = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Sort occurrences by:", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupSort.add(this.jRadioButtonSortCat);
        this.jRadioButtonSortCat.setText("Category");
        this.buttonGroupSort.add(this.jRadioButtonSortAbund);
        this.jRadioButtonSortAbund.setText("Abundance");
        this.buttonGroupSort.add(this.jRadioButtonSortGenus);
        this.jRadioButtonSortGenus.setText("Genus");
        this.buttonGroupSort.add(this.jRadioButtonSortCode);
        this.jRadioButtonSortCode.setText("Code");
        this.jRadioButtonSortCode.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPrintLoggingSheetProperties this$0;
            {
                DialogPrintLoggingSheetProperties dialogPrintLoggingSheetProperties = this$0;
                Objects.requireNonNull(dialogPrintLoggingSheetProperties);
                this.this$0 = dialogPrintLoggingSheetProperties;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSortCodeActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonSortCat).add((Component)this.jRadioButtonSortGenus).add((Component)this.jRadioButtonSortAbund).add((Component)this.jRadioButtonSortCode)).addContainerGap(24, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonSortCat).addPreferredGap(0).add((Component)this.jRadioButtonSortGenus).addPreferredGap(0).add((Component)this.jRadioButtonSortAbund).addPreferredGap(0).add((Component)this.jRadioButtonSortCode)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Font size", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupFont.add(this.jRadioButtonSmallFont);
        this.jRadioButtonSmallFont.setText("Small");
        this.buttonGroupFont.add(this.jRadioButtonLargeFont);
        this.jRadioButtonLargeFont.setText("Large");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jRadioButtonSmallFont).add((Component)this.jRadioButtonLargeFont)).addContainerGap(50, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jRadioButtonSmallFont).addPreferredGap(1).add((Component)this.jRadioButtonLargeFont).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPrintLoggingSheetProperties this$0;
            {
                DialogPrintLoggingSheetProperties dialogPrintLoggingSheetProperties = this$0;
                Objects.requireNonNull(dialogPrintLoggingSheetProperties);
                this.this$0 = dialogPrintLoggingSheetProperties;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPrintLoggingSheetProperties this$0;
            {
                DialogPrintLoggingSheetProperties dialogPrintLoggingSheetProperties = this$0;
                Objects.requireNonNull(dialogPrintLoggingSheetProperties);
                this.this$0 = dialogPrintLoggingSheetProperties;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jCheckBoxWellCode.setText("Well code");
        this.jCheckBoxItalics.setText("Italic taxon names");
        this.jCheckBoxComments.setText("Comments");
        this.jCheckBoxImages.setText("Images");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Taxon names", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupNames.add(this.jRadioButtonNames);
        this.jRadioButtonNames.setText("Names");
        this.buttonGroupNames.add(this.jRadioButtonCodes);
        this.jRadioButtonCodes.setText("Codes");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jRadioButtonNames).add((Component)this.jRadioButtonCodes)).addContainerGap(46, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jRadioButtonNames).addPreferredGap(0).add((Component)this.jRadioButtonCodes).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPrintLoggingSheetProperties this$0;
            {
                DialogPrintLoggingSheetProperties dialogPrintLoggingSheetProperties = this$0;
                Objects.requireNonNull(dialogPrintLoggingSheetProperties);
                this.this$0 = dialogPrintLoggingSheetProperties;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jCheckBoxBSComments.setText("Biostrat. comments");
        this.jCheckBoxBSComments.setToolTipText("Biostratigraphic comments (from selected version)");
        this.jCheckBoxAbn.setText("Always show semi-quant abundance");
        this.jCheckBoxAbn.setToolTipText("Abundance scheme must be set in analyst suite");
        this.jCheckBoxSpecType.setSelected(true);
        this.jCheckBoxSpecType.setText("Show species type");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 322, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jCheckBoxWellCode).add((Component)this.jCheckBoxItalics).add((Component)this.jCheckBoxImages).add((Component)this.jCheckBoxComments).add((Component)this.jCheckBoxBSComments).add((Component)this.jCheckBoxAbn).add((Component)this.jCheckBoxSpecType)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((Component)this.jCheckBoxImages).addPreferredGap(1).add((Component)this.jCheckBoxWellCode).addPreferredGap(1).add((Component)this.jCheckBoxItalics).addPreferredGap(1).add((Component)this.jCheckBoxSpecType).addPreferredGap(1).add((Component)this.jCheckBoxComments).addPreferredGap(0).add((Component)this.jCheckBoxBSComments).addPreferredGap(0).add((Component)this.jCheckBoxAbn))).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator1, -1, 5, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        boolean wellCode = this.jCheckBoxWellCode.isSelected();
        boolean comments = this.jCheckBoxComments.isSelected();
        boolean images = this.jCheckBoxImages.isSelected();
        boolean italics = this.jCheckBoxItalics.isSelected();
        boolean smallFont = this.jRadioButtonSmallFont.isSelected();
        boolean bsComments = this.jCheckBoxBSComments.isSelected();
        boolean semiQuant = this.jCheckBoxAbn.isSelected();
        boolean specType = this.jCheckBoxSpecType.isSelected();
        if (!smallFont) {
            comments = false;
            images = false;
        }
        boolean useCodes = this.jRadioButtonCodes.isSelected() || this.getSort() == 2;
        for (LoggingSheet logSheet : this.logSheets) {
            logSheet.setProperties(wellCode, comments, images, italics, smallFont, useCodes, this.getSort(), bsComments, semiQuant, specType);
        }
        this.encodeProperties();
        this.setVisible(false);
    }

    private void jRadioButtonSortCodeActionPerformed(ActionEvent evt) {
        if (this.jRadioButtonSortCode.isSelected()) {
            this.jRadioButtonCodes.setSelected(true);
            this.jRadioButtonNames.setSelected(false);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtoprintloggingsheets.html");
    }

    private int getSort() {
        int sort = 1;
        if (this.jRadioButtonSortGenus.isSelected()) {
            sort = 1;
        } else if (this.jRadioButtonSortCode.isSelected()) {
            sort = 2;
        } else if (this.jRadioButtonSortCat.isSelected()) {
            sort = 3;
        } else if (this.jRadioButtonSortAbund.isSelected()) {
            sort = 4;
        }
        return sort;
    }

    private void encodeProperties() {
        System.out.println("Encoding LoggingSheet properties...");
        Object string = new String();
        String[] props = new String[]{"" + (this.jRadioButtonCodes.isSelected() ? 1 : 0), "" + (this.jRadioButtonSmallFont.isSelected() ? 1 : 0), "" + (this.jCheckBoxComments.isSelected() ? 1 : 0), "" + (this.jCheckBoxImages.isSelected() ? 1 : 0), "" + (this.jCheckBoxWellCode.isSelected() ? 1 : 0), "" + (this.jCheckBoxItalics.isSelected() ? 1 : 0), "" + this.getSort(), "" + (this.jCheckBoxBSComments.isSelected() ? 1 : 0), "" + (this.jCheckBoxAbn.isSelected() ? 1 : 0), "" + (this.jCheckBoxSpecType.isSelected() ? 1 : 0)};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        System.out.println("log sheet prefs: " + (String)string);
        try {
            Lastval.putString(this.db, "LOGSHTPREF", (String)string);
            this.db.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

