/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jsbugs.DialogSelectSample;
import jsbugs.DialogTable;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSurfaces;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.Lastval;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.Surface;
import model3.Well;
import model3.WellInterp;
import model3.wellinterp.InterpEdit;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogSQPick
extends SBDialog {
    private final SBdb db;
    private final Well well;
    private final WellInterp wellInterp;
    private final char units;
    private Sample sample;
    private Surface surface = null;
    private static Surface lastSurface = null;
    private SQPick pick;
    private final DefaultComboBoxModel comboModelScheme = new DefaultComboBoxModel();
    private static final int INF_LEN = 80;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSample;
    private JButton jButtonSurface;
    private JCheckBox jCheckBoxObserved;
    private JCheckBox jCheckBoxQuestionable;
    private JComboBox jComboBoxBoundary;
    private JComboBox jComboBoxScheme;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDepth;
    private JTextField jTextFieldInformal;
    private JTextField jTextFieldSurface;
    private JTextField jTextFieldSurfaceType;

    public DialogSQPick(Frame parent, boolean modal, SBdb db, IGDScheme scheme, Well well, WellInterp wellInterp, char units, SQPick pick, Sample sample, Surface surface) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.units = units;
        this.wellInterp = wellInterp;
        this.sample = sample;
        this.surface = surface;
        this.pick = pick;
        this.initComponents();
        this.init(scheme);
    }

    public DialogSQPick(Dialog parent, boolean modal, SBdb db, IGDScheme scheme, Well well, WellInterp wellInterp, char units, SQPick pick, Sample sample, Surface surface) throws SQLException {
        super((Window)parent, modal);
        this.db = db;
        this.well = well;
        this.units = units;
        this.wellInterp = wellInterp;
        this.sample = sample;
        this.surface = surface;
        this.pick = pick;
        this.initComponents();
        this.init(scheme);
    }

    private void init(IGDScheme scheme) throws SQLException {
        if (this.pick == null) {
            this.setTitle("Sequence Pick : Add to Well");
        } else {
            this.sample = this.pick.getSample();
            this.surface = this.pick.getSurface();
            this.jCheckBoxQuestionable.setSelected(this.pick.isQuestionable());
            this.setTitle("Sequence Pick : Edit in well");
            if (this.pick.getInfName() != null) {
                this.jTextFieldInformal.setText(this.pick.getInfName());
            } else {
                this.jTextFieldInformal.setText("");
            }
            this.jCheckBoxObserved.setSelected(this.pick.isObserved());
        }
        if (this.sample != null) {
            this.jTextFieldDepth.setText(this.sample.toString(this.units));
        }
        if (this.surface != null) {
            this.jTextFieldSurface.setText(this.surface.toString());
            this.jTextFieldSurfaceType.setText(this.surface.getTypeString());
            if (this.pick != null) {
                this.jComboBoxBoundary.setSelectedItem(this.pick.getBnd());
            } else {
                this.setBndDefault();
            }
        }
        this.fillSchemeCombo();
        if (this.pick != null) {
            this.jComboBoxScheme.setSelectedItem(this.db.getIGDScheme(this.pick.getSurface().getSchID()));
        } else if (scheme != null) {
            this.jComboBoxScheme.setSelectedItem(scheme);
        } else {
            IGDScheme lastScheme;
            int lastSchID = Lastval.getInt(this.db, "SCH_ID:21");
            if (lastSchID > 0 && (lastScheme = this.db.getIGDScheme(lastSchID)) != null) {
                this.jComboBoxScheme.setSelectedItem(lastScheme);
            }
        }
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
        this.pack();
    }

    private void fillSchemeCombo() throws SQLException {
        List<IGDScheme> coll = this.db.getIGDSchemes(10, this.wellInterp.getIGDSchemes(10));
        LinkedList<IGDScheme> sortedList = new LinkedList<IGDScheme>(coll);
        Collections.sort(sortedList);
        for (IGDScheme scheme : sortedList) {
            this.jComboBoxScheme.addItem(scheme);
        }
        this.jComboBoxScheme.repaint();
    }

    private void setBndDefault() {
        switch (this.surface.getType()) {
            case CC: 
            case SB: {
                this.jComboBoxBoundary.setSelectedItem(IGDIntervalZone.getBoundary(4));
                break;
            }
            case MFS: {
                this.jComboBoxBoundary.setSelectedItem(IGDIntervalZone.getBoundary(3));
                break;
            }
            case TS: {
                this.jComboBoxBoundary.setSelectedItem(IGDIntervalZone.getBoundary(2));
            }
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jTextFieldDepth = new JTextField();
        this.jButtonSample = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldSurface = new JTextField();
        this.jButtonSurface = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jComboBoxScheme = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jCheckBoxQuestionable = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jTextFieldSurfaceType = new JTextField();
        this.jComboBoxBoundary = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldInformal = TextFieldUtils.buildLimitedLengthTextField(80);
        this.jCheckBoxObserved = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Sample depth:");
        this.jTextFieldDepth.setEditable(false);
        this.jTextFieldDepth.setBackground(new Color(255, 255, 204));
        this.jButtonSample.setText("...");
        this.jButtonSample.setToolTipText("Select sample");
        this.jButtonSample.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSample.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSQPick this$0;
            {
                DialogSQPick dialogSQPick = this$0;
                Objects.requireNonNull(dialogSQPick);
                this.this$0 = dialogSQPick;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSampleActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Surface:");
        this.jTextFieldSurface.setEditable(false);
        this.jTextFieldSurface.setBackground(new Color(255, 255, 204));
        this.jButtonSurface.setText("...");
        this.jButtonSurface.setToolTipText("Select surface / type");
        this.jButtonSurface.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSurface.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSQPick this$0;
            {
                DialogSQPick dialogSQPick = this$0;
                Objects.requireNonNull(dialogSQPick);
                this.this$0 = dialogSQPick;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSurfaceActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSQPick this$0;
            {
                DialogSQPick dialogSQPick = this$0;
                Objects.requireNonNull(dialogSQPick);
                this.this$0 = dialogSQPick;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSQPick this$0;
            {
                DialogSQPick dialogSQPick = this$0;
                Objects.requireNonNull(dialogSQPick);
                this.this$0 = dialogSQPick;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSQPick this$0;
            {
                DialogSQPick dialogSQPick = this$0;
                Objects.requireNonNull(dialogSQPick);
                this.this$0 = dialogSQPick;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jComboBoxScheme.setMaximumRowCount(30);
        this.jComboBoxScheme.setModel(this.comboModelScheme);
        this.jComboBoxScheme.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText("Scheme:");
        this.jCheckBoxQuestionable.setText("Questionable");
        this.jLabel1.setText("Type:");
        this.jTextFieldSurfaceType.setEditable(false);
        this.jTextFieldSurfaceType.setBackground(new Color(255, 255, 204));
        this.jComboBoxBoundary.setModel(new DefaultComboBoxModel<String>(IGDIntervalZone.bnds));
        this.jComboBoxBoundary.setToolTipText("Select boundary type");
        this.jComboBoxBoundary.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel5.setText("Boundary:");
        this.jLabel6.setText("Informal:");
        this.jTextFieldInformal.setToolTipText("Enter informal name (optional)");
        this.jCheckBoxObserved.setSelected(true);
        this.jCheckBoxObserved.setText("Observed");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jSeparator1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add(2, (Component)this.jLabel4)).add(2, (Component)this.jLabel3).add(2, (Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jTextFieldInformal, -1, 213, Short.MAX_VALUE).add((Component)this.jTextFieldSurface)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel5).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldSurfaceType, -2, 68, -2).addPreferredGap(0).add((Component)this.jButtonSurface, -2, 30, -2)).add((Component)this.jComboBoxBoundary, -2, 102, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBoxObserved).addPreferredGap(1).add((Component)this.jCheckBoxQuestionable)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldDepth, -1, 361, Short.MAX_VALUE).add(7, 7, 7).add((Component)this.jButtonSample, -2, 30, -2)).add(2, (Component)this.jComboBoxScheme, 0, -1, Short.MAX_VALUE)).add(0, 0, Short.MAX_VALUE))).add(0, 0, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jLabel2, this.jLabel3, this.jLabel4}, 1);
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jButtonSample).add((Component)this.jTextFieldDepth, -2, -1, -2)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jComboBoxScheme, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldSurface, -2, -1, -2).add((Component)this.jButtonSurface).add((Component)this.jTextFieldSurfaceType, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxBoundary, -2, -1, -2).add((Component)this.jLabel5).add((Component)this.jTextFieldInformal, -2, -1, -2).add((Component)this.jLabel6)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jCheckBoxQuestionable).add((Component)this.jCheckBoxObserved)).addPreferredGap(0, 11, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 2, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonSampleActionPerformed(ActionEvent evt) {
        DialogSelectSample dialog;
        try {
            dialog = new DialogSelectSample((JDialog)((Object)this), true, this.db, this.well, this.sample, this.units, true);
            dialog.getTableModel().setInterp(this.well, this.wellInterp, this.db);
        }
        catch (SBException ex) {
            StackError.showStackError((String)"Error opening dialog", (Throwable)ex);
            return;
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error opening dialog", ex, this.db);
            return;
        }
        dialog.setLocation(this.jButtonSample.getLocationOnScreen());
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.sample = dialog.selection;
            this.jTextFieldDepth.setText(this.sample.toString(this.units));
        }
    }

    private void jButtonSurfaceActionPerformed(ActionEvent evt) {
        Surface s;
        TableModelSurfaces model = new TableModelSurfaces((IGDScheme)this.jComboBoxScheme.getSelectedItem());
        DialogTable dialog = new DialogTable((Dialog)((Object)this), true, (AbstractTableModel)model, "Select Surface", true);
        model.setupTable(dialog.getTable());
        try {
            if (this.surface != null && model.getIndexOf(this.surface) >= 0) {
                dialog.setSelectedRow(model.getIndexOf(this.surface));
            } else if (lastSurface != null && model.getIndexOf(lastSurface) >= 0) {
                dialog.setSelectedRow(model.getIndexOf(lastSurface));
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK() && (s = model.scheme.getSurfacesX().get(dialog.getSelectedRow())) != null && s != this.surface) {
            this.surface = lastSurface = s;
            this.jTextFieldSurface.setText(this.surface.toString());
            this.jTextFieldSurfaceType.setText(this.surface.getTypeString());
            this.jTextFieldInformal.setText("");
            this.setBndDefault();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.surface == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a surface", this.getTitle(), 0);
            return;
        }
        if (this.sample == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a sample", this.getTitle(), 0);
            return;
        }
        int bndInt = IGDIntervalZone.getBoundaryTypeFromString((String)this.jComboBoxBoundary.getSelectedItem());
        SQPick.Builder builder = new SQPick.Builder(this.db, this.surface, this.sample, bndInt);
        builder.informalName(this.jTextFieldInformal.getText()).questionable(this.jCheckBoxQuestionable.isSelected()).observed(this.jCheckBoxObserved.isSelected());
        try {
            if (this.pick != null) {
                InterpEdit<SQPick> edit = this.wellInterp.updateSQPick(this.pick, this.well, builder);
                this.pick = edit.getNotifier();
            } else {
                this.pick = this.wellInterp.addSQPick(this.well, builder);
            }
            this.db.commit();
            this.wellInterp.notifyObservers(this.pick);
            Lastval.putInt(this.db, "SCH_ID:21", this.pick.getSurface().getSchID());
            this.db.commit();
            this.setOK();
        }
        catch (RuntimeException | SQLException | InvalidFieldException | SBException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError("Error saving pick", e, (Component)((Object)this));
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogsqpick.html");
    }

    SQPick getPick() {
        return this.pick;
    }
}

