/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.list.SampleTypeListRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Lastval;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogSample
extends SBDialog {
    private static final int DEPTHLEN = 10;
    private static final int LABELEN = 30;
    private static SampleType lastType = null;
    private static Double lastBaseDepth = null;
    private final DefaultComboBoxModel typeModel = new DefaultComboBoxModel<SampleType>(SampleType.values());
    private final Well well;
    private final SBdb db;
    private final char units;
    private final Sample original;
    Sample sample;
    private final boolean allowAnalysis;
    private static Boolean autoFill = null;
    private static Logger LOGGER = Logger.getLogger(DialogSample.class.getName());
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAnalysis;
    private JCheckBox jCheckBoxAutoFill;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelBaseDepth;
    private JLabel jLabelTD;
    private JLabel jLabelTopDepth;
    private JLabel jLabelUnitsBase;
    private JLabel jLabelUnitsTop;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldCreated;
    private JTextField jTextFieldCreator;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldModified;
    private JTextField jTextFieldModifier;
    private JTextField jTextFieldTopDepth;

    public DialogSample(Frame parent, boolean modal, SBdb db, Well well, char units, Sample sample, boolean allowAddAnalysis) {
        this((Window)parent, modal, db, well, sample, units, allowAddAnalysis);
    }

    public DialogSample(Dialog parent, boolean modal, SBdb db, Well well, char units, Sample sample) {
        this(parent, modal, db, well, sample, units, false);
    }

    public DialogSample(JDialog parent, boolean modal, SBdb db, Well well, char units) {
        this(parent, modal, db, well, null, units, false);
    }

    private DialogSample(Window parent, boolean modal, SBdb db, Well well, Sample sample, char units, boolean allowAddAnalysis) {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.original = sample;
        this.units = units;
        this.initComponents();
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.allowAnalysis = allowAddAnalysis;
        this.init();
    }

    private void init() {
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (this.db.useSampleTops()) {
            this.jTextFieldTopDepth.requestFocusInWindow();
        } else {
            this.jTextFieldBaseDepth.requestFocusInWindow();
        }
        if (autoFill == null) {
            if (this.db.isConnected()) {
                try {
                    autoFill = Lastval.getInt(this.db, "SMPFILL", 1) == 1;
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "Error getting sample dialog autofill val: ", e);
                    autoFill = true;
                }
            } else {
                autoFill = true;
            }
        } else {
            this.jCheckBoxAutoFill.setSelected(autoFill);
        }
        if (this.original == null) {
            this.setTitle("Sample : Add");
            if (lastType != null) {
                this.jComboBoxType.setSelectedItem(lastType);
                if (lastType == SampleType.CU && lastBaseDepth != null && autoFill.booleanValue()) {
                    this.jTextFieldTopDepth.setText(SB.floatString((double)lastBaseDepth, (int)this.getDepthPrec()).trim());
                    this.jTextFieldTopDepth.setForeground(Color.gray);
                }
            } else if (this.well.getType() == 'O') {
                this.jComboBoxType.setSelectedItem(SampleType.OC);
            }
            if (this.allowAnalysis) {
                try {
                    int add = Lastval.getInt(this.db, "ADDANALY");
                    this.jCheckBoxAnalysis.setSelected(add > 0);
                }
                catch (SQLException add) {}
            } else {
                this.jCheckBoxAnalysis.setEnabled(false);
            }
        } else {
            this.setTitle("Sample : Edit");
            this.jCheckBoxAnalysis.setEnabled(false);
            this.jComboBoxType.setSelectedItem(this.original.getType());
            if (!this.original.getType().isDepthRange()) {
                this.setSingleField();
            }
            if (this.original.hasTopDepth()) {
                this.jTextFieldTopDepth.setText(SB.floatString((double)this.original.getTopDepth(this.units), (int)this.getDepthPrec()).trim());
            }
            if (this.original.hasBaseDepth()) {
                this.jTextFieldBaseDepth.setText(SB.floatString((double)this.original.getBaseDepth(this.units), (int)this.getDepthPrec()).trim());
            }
            this.jTextFieldLabel.setText(this.original.getLabel());
            if (this.original.getModified() != null) {
                this.jTextFieldModified.setText(SB.df.format(this.original.getModified()));
            }
            if (this.original.getModifierID() > 0) {
                try {
                    this.jTextFieldModifier.setText(this.db.getUser(this.original.getModifierID()).getAbr());
                }
                catch (SQLException add) {
                    // empty catch block
                }
            }
            if (this.original.getCreated() != null) {
                this.jTextFieldCreated.setText(SB.df.format(this.original.getCreated()));
            }
            if (this.original.getCreatorID() > 0) {
                try {
                    this.jTextFieldCreator.setText(this.db.getUser(this.original.getCreatorID()).getAbr());
                }
                catch (SQLException add) {
                    // empty catch block
                }
            }
        }
        if (this.units != 'M') {
            this.jLabelUnitsTop.setText("ft");
            this.jLabelUnitsBase.setText("ft");
        }
        try {
            if (!this.well.canWrite(this.db, null)) {
                this.jButtonOK.setEnabled(false);
                this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
        if (this.well.getType() == 'W') {
            this.jLabelTD.setText("<html><strong>TD: </strong>" + SB.floatString((double)DepthUtils.convFromM((double)this.well.getTD(), (char)this.units), (int)this.getDepthPrec()) + " " + DepthUnits.getUnits((char)this.units).getAbr() + "</html>");
        } else {
            this.jLabelTD.setText("");
        }
        this.jComboBoxType.setRenderer(new SampleTypeListRenderer());
    }

    public void setDepth(double depth) {
        if (this.db.useSampleTops()) {
            this.jTextFieldTopDepth.setText(SB.floatString((double)DepthUtils.convFromM((double)depth, (char)this.units, (char)this.well.getType()), (int)this.getDepthPrec()));
        } else {
            this.jTextFieldBaseDepth.setText(SB.floatString((double)DepthUtils.convFromM((double)depth, (char)this.units, (char)this.well.getType()), (int)this.getDepthPrec()));
        }
    }

    public void setType(SampleType type) {
        this.jComboBoxType.setSelectedItem(type);
    }

    private int getDepthPrec() {
        return this.units == 'F' ? 2 : 3;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelTopDepth = new JLabel();
        this.jTextFieldTopDepth = new JTextField();
        this.jLabelUnitsTop = new JLabel();
        this.jLabelUnitsBase = new JLabel();
        this.jTextFieldBaseDepth = new JTextField();
        this.jLabelBaseDepth = new JLabel();
        this.jLabel4 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jComboBoxType.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jTextFieldLabel = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jTextFieldCreated = new JTextField();
        this.jLabel12 = new JLabel();
        this.jTextFieldCreator = new JTextField();
        this.jLabel11 = new JLabel();
        this.jTextFieldModified = new JTextField();
        this.jLabel13 = new JLabel();
        this.jTextFieldModifier = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jCheckBoxAnalysis = new JCheckBox();
        this.jLabelTD = new JLabel();
        this.jCheckBoxAutoFill = new JCheckBox();
        this.jLabel1.setText("jLabel1");
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSample this$0;
            {
                DialogSample dialogSample = this$0;
                Objects.requireNonNull(dialogSample);
                this.this$0 = dialogSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSample this$0;
            {
                DialogSample dialogSample = this$0;
                Objects.requireNonNull(dialogSample);
                this.this$0 = dialogSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabelTopDepth.setHorizontalAlignment(11);
        this.jLabelTopDepth.setText("Top depth:");
        this.jTextFieldTopDepth.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSample this$0;
            {
                DialogSample dialogSample = this$0;
                Objects.requireNonNull(dialogSample);
                this.this$0 = dialogSample;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldTopDepthFocusGained(evt);
            }
        });
        this.jTextFieldTopDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSample this$0;
            {
                DialogSample dialogSample = this$0;
                Objects.requireNonNull(dialogSample);
                this.this$0 = dialogSample;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldTopDepthKeyTyped(evt);
            }
        });
        this.jLabelUnitsTop.setText("m");
        this.jLabelUnitsBase.setText("m");
        this.jTextFieldBaseDepth.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSample this$0;
            {
                DialogSample dialogSample = this$0;
                Objects.requireNonNull(dialogSample);
                this.this$0 = dialogSample;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldBaseDepthFocusGained(evt);
            }
        });
        this.jTextFieldBaseDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSample this$0;
            {
                DialogSample dialogSample = this$0;
                Objects.requireNonNull(dialogSample);
                this.this$0 = dialogSample;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldBaseDepthKeyTyped(evt);
            }
        });
        this.jLabelBaseDepth.setHorizontalAlignment(11);
        this.jLabelBaseDepth.setText("Base depth:");
        this.jLabel4.setText("Type:");
        this.jComboBoxType.setModel(this.typeModel);
        this.jComboBoxType.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSample this$0;
            {
                DialogSample dialogSample = this$0;
                Objects.requireNonNull(dialogSample);
                this.this$0 = dialogSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxTypeActionPerformed(evt);
            }
        });
        this.jTextFieldLabel.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSample this$0;
            {
                DialogSample dialogSample = this$0;
                Objects.requireNonNull(dialogSample);
                this.this$0 = dialogSample;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldLabelKeyTyped(evt);
            }
        });
        this.jLabel5.setText("Label:");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Dates", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel10.setText("Created:");
        this.jTextFieldCreated.setEditable(false);
        this.jLabel12.setText("By user:");
        this.jTextFieldCreator.setEditable(false);
        this.jLabel11.setText("Modified:");
        this.jTextFieldModified.setEditable(false);
        this.jLabel13.setText("By user:");
        this.jTextFieldModifier.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel10).add((Component)this.jLabel11)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jTextFieldCreated, -1, 134, Short.MAX_VALUE).add((Component)this.jTextFieldModified)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel12).add((Component)this.jLabel13)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jTextFieldModifier).add((Component)this.jTextFieldCreator)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.jTextFieldCreated, -2, -1, -2).add((Component)this.jTextFieldCreator, -2, -1, -2).add((Component)this.jLabel12)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.jTextFieldModifier, -2, -1, -2).add((Component)this.jLabel13).add((Component)this.jTextFieldModified, -2, -1, -2)).addContainerGap(39, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSample this$0;
            {
                DialogSample dialogSample = this$0;
                Objects.requireNonNull(dialogSample);
                this.this$0 = dialogSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jCheckBoxAnalysis.setText("Add analysis");
        this.jLabelTD.setText("TD: 9999m");
        this.jCheckBoxAutoFill.setText("Auto-fill top depth");
        this.jCheckBoxAutoFill.setToolTipText("Make the default top depth of Cutting samples the base depth of the previous sample entered");
        this.jCheckBoxAutoFill.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSample this$0;
            {
                DialogSample dialogSample = this$0;
                Objects.requireNonNull(dialogSample);
                this.this$0 = dialogSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxAutoFillActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBoxAnalysis).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabelTD).add(18, 18, 18).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jSeparator1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel4).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabelTopDepth)).add((Component)this.jLabelBaseDepth))).add(2, (Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldLabel, -2, 115, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jComboBoxType, 0, -1, Short.MAX_VALUE).add(1, (Component)this.jTextFieldBaseDepth, -1, 97, Short.MAX_VALUE).add(1, (Component)this.jTextFieldTopDepth)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jLabelUnitsBase).add(2, (Component)this.jLabelUnitsTop)))).add(18, 18, 18).add((Component)this.jPanel2, -2, -1, -2)).add((Component)this.jCheckBoxAutoFill)).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxType, -2, -1, -2).add((Component)this.jLabel4)).add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelTopDepth).add((Component)this.jTextFieldTopDepth, -2, -1, -2).add((Component)this.jLabelUnitsTop)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelBaseDepth).add((Component)this.jTextFieldBaseDepth, -2, -1, -2).add((Component)this.jLabelUnitsBase)).add(8, 8, 8).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldLabel, -2, -1, -2).add((Component)this.jLabel5))).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxAutoFill).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonHelp).add((Component)this.jButtonCancel).add((Component)this.jLabelTD)).add((Component)this.jCheckBoxAnalysis)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldLabelKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldLabel, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTopDepthKeyTyped(KeyEvent evt) {
        if (lastBaseDepth != null) {
            this.jTextFieldTopDepth.setForeground(Color.black);
            lastBaseDepth = null;
        }
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopDepth, (int)10, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTopDepthFocusGained(FocusEvent evt) {
        this.jTextFieldTopDepth.setSelectionStart(0);
        this.jTextFieldTopDepth.setSelectionEnd(this.jTextFieldTopDepth.getText().length());
    }

    private void jTextFieldBaseDepthFocusGained(FocusEvent evt) {
        this.jTextFieldBaseDepth.setSelectionStart(0);
        this.jTextFieldBaseDepth.setSelectionEnd(this.jTextFieldBaseDepth.getText().length());
    }

    private void jTextFieldBaseDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseDepth, (int)10, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            SampleType type = (SampleType)this.jComboBoxType.getSelectedItem();
            Double topDepth = null;
            Double baseDepth = null;
            if (this.jTextFieldTopDepth.getText().length() > 0 && !this.well.depthInScope(topDepth = Double.valueOf(Double.parseDouble(this.jTextFieldTopDepth.getText())), this.units, type) && JOptionPane.showConfirmDialog((Component)((Object)this), "Top depth is out of depth range for section, Continue?", this.getTitle(), 0, 2) == 1) {
                return;
            }
            if (this.jTextFieldBaseDepth.getText().length() > 0 && !this.well.depthInScope(baseDepth = Double.valueOf(Double.parseDouble(this.jTextFieldBaseDepth.getText())), this.units, type) && JOptionPane.showConfirmDialog((Component)((Object)this), "Base depth is out of depth range for section, Continue?", this.getTitle(), 0, 2) == 1) {
                return;
            }
            if (topDepth == null && baseDepth == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No depth entered", this.getTitle(), 2);
                return;
            }
            if (topDepth != null && baseDepth != null) {
                String msg = "";
                if (this.well.getType() == 'W' && topDepth > baseDepth) {
                    msg = "Top depth is greater than base depth";
                } else if (this.well.getType() == 'O' && topDepth < baseDepth) {
                    msg = "Top height is less than base";
                }
                if (!msg.isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 2);
                    return;
                }
            }
            Sample.Builder builder = new Sample.Builder().topDepth(topDepth != null ? Double.valueOf(DepthUtils.convToM((double)topDepth, (char)this.units, (char)this.well.getType())) : null).baseDepth(baseDepth != null ? Double.valueOf(DepthUtils.convToM((double)baseDepth, (char)this.units, (char)this.well.getType())) : null).type(type).label(this.jTextFieldLabel.getText());
            Sample existingSample = this.well.getSample(builder);
            if (this.original == null) {
                if (existingSample != null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "A sample already exists at this depth/type", this.getTitle(), 1);
                    return;
                }
                this.sample = this.well.addSample(builder, 0, null);
                this.sample.displayUnits = this.units;
                lastBaseDepth = baseDepth;
            } else {
                if (this.original != null && existingSample != null && existingSample != this.original) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Another sample already exists at this depth/type", this.getTitle(), 1);
                    return;
                }
                this.well.updateSample(this.original, builder);
                this.sample = this.original;
                this.sample.displayUnits = this.units;
                lastBaseDepth = null;
            }
            if (this.jCheckBoxAnalysis.isEnabled() && this.db.isConnected()) {
                Lastval.putInt(this.db, "ADDANALY", this.addAnalysis() ? 1 : 0);
            }
            lastType = type;
            this.well.notifyObservers(this.sample);
            if (this.db.isConnected()) {
                this.db.commit();
            }
            this.setOK();
        }
        catch (RuntimeException | SQLException | SBException | SBPermissionException e) {
            SbugsExceptionHandler.showDialogStackError(e, (Component)((Object)this));
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxTypeActionPerformed(ActionEvent evt) {
        SampleType type = (SampleType)this.jComboBoxType.getSelectedItem();
        if (type.isDepthRange()) {
            this.setDualField();
        } else {
            this.setSingleField();
        }
        this.jCheckBoxAnalysis.setEnabled(type.isAnalysis());
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtoaddsamples.html#dialogsample");
    }

    private void jCheckBoxAutoFillActionPerformed(ActionEvent evt) {
        boolean b = this.jCheckBoxAutoFill.isSelected();
        if (b != autoFill) {
            autoFill = b;
            if (this.db.isConnected()) {
                try {
                    Lastval.putInt(this.db, "SMPFILL", autoFill != false ? 1 : 0);
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "Error setting sample dialog autofill val: ", e);
                }
            }
            if (!autoFill.booleanValue() && lastBaseDepth != null) {
                if (this.jTextFieldTopDepth.getForeground() == Color.gray) {
                    this.jTextFieldTopDepth.setText("");
                }
                this.jTextFieldTopDepth.setForeground(Color.black);
                lastBaseDepth = null;
            }
        }
    }

    private void setSingleField() {
        if (this.db.useSampleTops()) {
            this.jTextFieldBaseDepth.setText("");
            this.jTextFieldBaseDepth.setEnabled(false);
            this.jLabelBaseDepth.setEnabled(false);
            this.jLabelUnitsBase.setEnabled(false);
        } else {
            this.jTextFieldTopDepth.setText("");
            this.jTextFieldTopDepth.setEnabled(false);
            this.jLabelTopDepth.setEnabled(false);
            this.jLabelUnitsTop.setEnabled(false);
        }
    }

    private void setDualField() {
        if (this.db.useSampleTops()) {
            if (!this.jTextFieldBaseDepth.isEnabled()) {
                this.jTextFieldBaseDepth.setEnabled(true);
                this.jLabelBaseDepth.setEnabled(true);
                this.jLabelUnitsBase.setEnabled(true);
            }
        } else if (!this.jTextFieldTopDepth.isEnabled()) {
            this.jTextFieldTopDepth.setEnabled(true);
            this.jLabelTopDepth.setEnabled(true);
            this.jLabelUnitsTop.setEnabled(true);
        }
    }

    public boolean addAnalysis() {
        if (!((SampleType)this.jComboBoxType.getSelectedItem()).isAnalysis()) {
            return false;
        }
        return this.jCheckBoxAnalysis.isSelected();
    }
}

