/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogInterval;
import jsbugs.DialogSQPick;
import jsbugs.DialogSearchUnit;
import jsbugs.DialogSelectScheme;
import jsbugs.FrameJsbugs;
import jsbugs.ZonesTableModel;
import jsbugs.model2.wellinterp.SQPickTableModel;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Audit;
import model3.IGDHdr;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.InterpHdr;
import model3.Lastval;
import model3.SBdb;
import model3.SQPick;
import model3.Surface;
import model3.Well;
import model3.WellInterp;
import model3.WellOccRec;
import model3.wellinterp.InterpItem;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.exception.StackError;

public class DialogSchemeUsage
extends JDialog {
    DefaultListModel wellModel = new DefaultListModel();
    DefaultListModel versionModel = new DefaultListModel();
    AbstractTableModel model = new ZonesTableModel();
    IGDScheme scheme;
    JTable jTableUsage;
    private JButton jButtonClose;
    private JButton jButtonDeleteInterval;
    private JButton jButtonFind;
    private JButton jButtonHelp;
    private JButton jButtonReassign;
    private JButton jButtonReassign1;
    private JButton jButtonSaveAs;
    private JButton jButtonSelectAll;
    private JButton jButtonShow;
    private JButton jButtonShowInterval;
    private JButton jButtonShowZones;
    private JButton jButtonTranslate;
    private JButton jButtonTranslateInterp;
    private JList jListVersion;
    private JList jListWell;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneVersions;
    private JScrollPane jScrollPaneWell;
    private JSeparator jSeparator1;

    public DialogSchemeUsage(Frame parent, boolean modal, IGDScheme scheme) throws SQLException, SBException {
        super(parent, modal);
        this.initComponents();
        this.scheme = scheme;
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Stratigraphic Scheme Usage : " + String.valueOf(this.scheme));
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.model = this.scheme.getIGDType() == 10 ? new SQPickTableModel() : new ZonesTableModel();
        this.jTableUsage = new JTable(this.model);
        this.jTableUsage.setRowSorter(new TableRowSorter<AbstractTableModel>(this.model));
        new ColumnSortResetHandler(this.jTableUsage).attach();
        if (this.scheme.getIGDType() == 10) {
            ((SQPickTableModel)this.model).setupTable(this.jTableUsage, null);
        } else {
            ((ZonesTableModel)this.model).setupTable(this.jTableUsage, null);
        }
        this.jScrollPane1.setViewportView(this.jTableUsage);
        this.jTableUsage.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.mClicked(evt);
            }
        });
        JLabel wellColumnLabel = new JLabel("Well");
        wellColumnLabel.setHorizontalAlignment(0);
        wellColumnLabel.setBorder(new BevelBorder(0));
        this.jScrollPaneWell.setColumnHeaderView(wellColumnLabel);
        JLabel versionColumnLabel = new JLabel("Version");
        versionColumnLabel.setHorizontalAlignment(0);
        versionColumnLabel.setBorder(new BevelBorder(0));
        this.jScrollPaneVersions.setColumnHeaderView(versionColumnLabel);
        this.jButtonShow.setVisible(false);
        this.jButtonShowZones.setVisible(false);
        this.initWells();
    }

    private void initWells() throws SQLException, SBException {
        this.wellModel.clear();
        List<WellOccRec> wells = this.scheme.getWellOccs();
        for (WellOccRec well : wells) {
            this.wellModel.addElement(well);
        }
    }

    private void mClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowIntervalActionPerformed(null);
        }
    }

    private void initComponents() {
        this.jButtonShow = new JButton();
        this.jButtonSelectAll = new JButton();
        this.jButtonReassign = new JButton();
        this.jButtonSaveAs = new JButton();
        this.jButtonShowZones = new JButton();
        this.jButtonShowInterval = new JButton();
        this.jButtonDeleteInterval = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jScrollPaneWell = new JScrollPane();
        this.jListWell = new JList();
        this.jScrollPaneVersions = new JScrollPane();
        this.jListVersion = new JList();
        this.jButtonReassign1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jButtonFind = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonTranslate = new JButton();
        this.jButtonTranslateInterp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(800, 300));
        this.jButtonShow.setText("Show >");
        this.jButtonShow.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowActionPerformed(evt);
            }
        });
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonReassign.setText("Reassign...");
        this.jButtonReassign.setToolTipText("<html>Reassign all units in selected wells<br>\n to matching units from another scheme</html>");
        this.jButtonReassign.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonReassign.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReassignActionPerformed(evt);
            }
        });
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setToolTipText("Save list of wells to CSV file");
        this.jButtonSaveAs.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonSaveAs.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jButtonShowZones.setText("Show >");
        this.jButtonShowZones.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowZonesActionPerformed(evt);
            }
        });
        this.jButtonShowInterval.setText("Show...");
        this.jButtonShowInterval.setToolTipText("Show interval dialog for this unit");
        this.jButtonShowInterval.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowIntervalActionPerformed(evt);
            }
        });
        this.jButtonDeleteInterval.setText("Delete");
        this.jButtonDeleteInterval.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteIntervalActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jListWell.setModel(this.wellModel);
        this.jListWell.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListWellMouseClicked(evt);
            }
        });
        this.jListWell.addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                this.this$0.jListWellValueChanged(evt);
            }
        });
        this.jScrollPaneWell.setViewportView(this.jListWell);
        this.jListVersion.setModel(this.versionModel);
        this.jListVersion.setSelectionMode(0);
        this.jListVersion.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListVersionMouseClicked(evt);
            }
        });
        this.jListVersion.addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                this.this$0.jListVersionValueChanged(evt);
            }
        });
        this.jScrollPaneVersions.setViewportView(this.jListVersion);
        this.jButtonReassign1.setText("Reassign...");
        this.jButtonReassign1.setToolTipText("<html>Reassign all units in selected version<br>\n to matching units from another scheme</html>");
        this.jButtonReassign1.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonReassign1.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReassign1ActionPerformed(evt);
            }
        });
        this.jButtonFind.setText("Find...");
        this.jButtonFind.setToolTipText("Find schemes containing selected unit(s)");
        this.jButtonFind.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFindActionPerformed(evt);
            }
        });
        this.jButtonTranslate.setText("Translate...");
        this.jButtonTranslate.setToolTipText("<html>Translate all units in selected wells<br>\n to matching age and hierachy units from another scheme</html>");
        this.jButtonTranslate.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonTranslate.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTranslateActionPerformed(evt);
            }
        });
        this.jButtonTranslateInterp.setText("Translate...");
        this.jButtonTranslateInterp.setToolTipText("<html>Translate all units in selected version<br>\n to matching age and hierachy units from another scheme</html>\n");
        this.jButtonTranslateInterp.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonTranslateInterp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSchemeUsage this$0;
            {
                DialogSchemeUsage dialogSchemeUsage = this$0;
                Objects.requireNonNull(dialogSchemeUsage);
                this.this$0 = dialogSchemeUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTranslateInterpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPaneWell, -2, 162, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonShow, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSaveAs, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAll, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonReassign).add((Component)this.jButtonTranslate)).addPreferredGap(0).add((Component)this.jScrollPaneVersions, -2, 156, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonShowZones).add((Component)this.jButtonReassign1).add((Component)this.jButtonTranslateInterp)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 452, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonShowInterval).add((Component)this.jButtonHelp, -2, 71, -2).add((Component)this.jButtonClose, -2, 71, -2).add((Component)this.jButtonFind).add((Component)this.jSeparator1).add((Component)this.jButtonDeleteInterval, -2, 71, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jScrollPaneVersions, this.jScrollPaneWell}, 1);
        layout.linkSize(new Component[]{this.jButtonReassign1, this.jButtonShowZones}, 1);
        layout.linkSize(new Component[]{this.jButtonDeleteInterval, this.jButtonFind, this.jButtonShowInterval, this.jSeparator1}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(13, 13, 13).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 478, Short.MAX_VALUE).add((Component)this.jScrollPaneVersions, -1, 478, Short.MAX_VALUE).add((Component)this.jScrollPaneWell, -1, 478, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonShowInterval).addPreferredGap(0).add((Component)this.jButtonDeleteInterval).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonFind).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonShowZones).addPreferredGap(0).add((Component)this.jButtonReassign1).addPreferredGap(0).add((Component)this.jButtonTranslateInterp)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonShow).addPreferredGap(0).add((Component)this.jButtonSelectAll).addPreferredGap(0).add((Component)this.jButtonReassign).addPreferredGap(0).add((Component)this.jButtonTranslate).addPreferredGap(0).add((Component)this.jButtonSaveAs))).add(0, 344, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogschemeusage.html");
    }

    private void jButtonShowActionPerformed(ActionEvent evt) {
        try {
            InterpHdr previousSelection = null;
            if (this.jListVersion.getSelectedIndex() >= 0 && this.jListVersion.getSelectedIndices().length == 1) {
                previousSelection = (InterpHdr)this.jListVersion.getSelectedValue();
            }
            this.versionModel.clear();
            WellInterp toSelect = null;
            List selectedWells = this.jListWell.getSelectedValuesList();
            for (Object o : selectedWells) {
                WellOccRec wellRef = (WellOccRec)o;
                Well well = this.scheme.getDatabase().getWell(wellRef.wellID());
                List versions = this.scheme.getWellInterps(well);
                for (WellInterp interp : versions) {
                    if (this.versionModel.contains(interp.getHeader())) continue;
                    this.versionModel.addElement(interp.getHeader());
                    if (interp.getHeader() != previousSelection) continue;
                    toSelect = interp;
                }
            }
            this.jListVersion.repaint();
            if (toSelect != null) {
                this.jListVersion.setSelectedValue(toSelect, true);
            }
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jListWellMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowActionPerformed(null);
        }
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jListWell.setSelectionInterval(0, this.wellModel.getSize() - 1);
    }

    private void jButtonShowZonesActionPerformed(ActionEvent evt) {
        boolean clearTable = false;
        if (this.jListWell.getSelectedIndex() < 0 || this.jListWell.getSelectedIndices().length > 1) {
            clearTable = true;
        }
        if (this.jListVersion.getSelectedIndex() < 0 || this.jListVersion.getSelectedIndices().length > 1) {
            clearTable = true;
        }
        if (clearTable) {
            if (this.scheme.getIGDType() == 10) {
                ((SQPickTableModel)this.model).setItems(null);
            } else if (((ZonesTableModel)this.model).getZones() != null) {
                ((ZonesTableModel)this.model).getZones().clear();
            }
            this.model.fireTableDataChanged();
            return;
        }
        try {
            InterpHdr interpHdr = (InterpHdr)this.jListVersion.getSelectedValue();
            WellOccRec wellRef = (WellOccRec)this.jListWell.getSelectedValue();
            Well well = this.scheme.getDatabase().getWell(wellRef.wellID());
            WellInterp interp = well.getInterp(interpHdr.getInterpID());
            well.getSamples();
            well.loadInterp(interp);
            if (this.scheme.getIGDType() == 10) {
                ((SQPickTableModel)this.model).setItems(interp.getInterpListViewer(21, this.scheme.getID()));
            } else {
                ((ZonesTableModel)this.model).setZones(interp.getIGDList(this.scheme.getIGDType(), this.scheme.getID()), well);
            }
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jListVersionMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowZonesActionPerformed(null);
        }
    }

    private void jButtonShowIntervalActionPerformed(ActionEvent evt) {
        if (this.jTableUsage.getSelectedRowCount() != 1) {
            String type = this.scheme.getIGDType() == 10 ? "pick" : "interval";
            JOptionPane.showMessageDialog(this, "Select one " + type, this.getTitle(), 1);
            return;
        }
        Object obj = this.scheme.getIGDType() == 10 ? ((SQPickTableModel)this.model).getItems().get(this.jTableUsage.convertRowIndexToModel(this.jTableUsage.getSelectedRow())) : ((ZonesTableModel)this.model).getZones().get(this.jTableUsage.convertRowIndexToModel(this.jTableUsage.getSelectedRow()));
        try {
            SBDialog dialog;
            InterpHdr interp = (InterpHdr)this.jListVersion.getSelectedValue();
            WellOccRec wellRef = (WellOccRec)this.jListWell.getSelectedValue();
            Well well = this.scheme.getDatabase().getWell(wellRef.wellID());
            if (well == null) {
                JOptionPane.showMessageDialog(this, "Select a Well", this.getTitle(), 1);
                return;
            }
            WellInterp wellInterp = well.getInterp(interp.getInterpID());
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this, "Select a Version", this.getTitle(), 1);
                return;
            }
            if (obj instanceof SQPick) {
                dialog = new DialogSQPick(this, true, this.scheme.getDatabase(), this.scheme, well, wellInterp, well.getWellUnits(), (SQPick)obj, null, null);
            } else {
                IGDIntervalZone zone = (IGDIntervalZone)obj;
                dialog = new DialogInterval(this, true, zone.getIGDType(), this.scheme.getDatabase(), well, wellInterp, well.getWellUnits(), zone);
            }
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            int index = -1;
            if (obj instanceof SQPick) {
                ((SQPickTableModel)this.model).setItems(wellInterp.getInterpListViewer(21, this.scheme.getID()));
                int i = ((SQPickTableModel)this.model).getItems().indexOf(((DialogSQPick)dialog).getPick());
                if (i >= 0) {
                    index = this.jTableUsage.convertRowIndexToView(i);
                }
            } else {
                ((ZonesTableModel)this.model).setZones(wellInterp.getIGDList(this.scheme.getIGDType(), this.scheme.getID()), well);
                int i = ((ZonesTableModel)this.model).getZones().indexOf(((DialogInterval)dialog).zone);
                if (i >= 0) {
                    index = this.jTableUsage.convertRowIndexToView(i);
                }
            }
            this.model.fireTableDataChanged();
            if (index >= 0) {
                this.jTableUsage.getSelectionModel().setSelectionInterval(index, index);
            } else {
                this.jTableUsage.clearSelection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error opening dialog: " + e.getMessage(), this.getTitle(), 0);
        }
    }

    private void jButtonDeleteIntervalActionPerformed(ActionEvent evt) {
        try {
            InterpHdr interpHdr;
            WellOccRec wellRef = (WellOccRec)this.jListWell.getSelectedValue();
            if (wellRef == null) {
                JOptionPane.showMessageDialog(this, "Select a Well", this.getTitle(), 1);
                return;
            }
            Well well = this.scheme.getDatabase().getWell(wellRef.wellID());
            WellInterp wellInterp = well.getInterp((interpHdr = (InterpHdr)this.jListVersion.getSelectedValue()).getInterpID());
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this, "Select a Version", this.getTitle(), 1);
                return;
            }
            int nRows = this.jTableUsage.getSelectedRowCount();
            String type = this.scheme.getIGDType() == 10 ? "pick" : "interval";
            Object msg = "Really delete ";
            msg = nRows == 1 ? (String)msg + "this " + type + "?" : (String)msg + "these " + nRows + " " + type + "s?";
            if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) {
                return;
            }
            Object notifyArg = null;
            if (this.scheme.getIGDType() == 10) {
                LinkedList<SQPick> toKill = new LinkedList<SQPick>();
                for (int row : this.jTableUsage.getSelectedRows()) {
                    toKill.add((SQPick)((SQPickTableModel)this.model).getItems().get(this.jTableUsage.convertRowIndexToModel(row)));
                }
                wellInterp.delete(toKill, well.getWellID());
                this.scheme.getDatabase().commit();
            } else {
                LinkedList<IGDIntervalZone> toKill = new LinkedList<IGDIntervalZone>();
                for (int row : this.jTableUsage.getSelectedRows()) {
                    toKill.add(((ZonesTableModel)this.model).getZones().get(this.jTableUsage.convertRowIndexToModel(row)));
                }
                Object object = toKill.iterator();
                while (object.hasNext()) {
                    IGDIntervalZone zone = (IGDIntervalZone)object.next();
                    if (notifyArg == null || notifyArg instanceof IGDIntervalZone && ((IGDInterval)notifyArg).getIGDType() == zone.getIGDType() && (zone.getIGDType() != 4 || ((IGDIntervalZone)notifyArg).getSchID() == zone.getSchID())) {
                        notifyArg = zone;
                        continue;
                    }
                    notifyArg = zone.getIGDType();
                }
                wellInterp.deleteZones(well, toKill);
                this.scheme.getDatabase().commit();
                ((ZonesTableModel)this.model).getZones().removeAll(toKill);
            }
            this.model.fireTableDataChanged();
            this.jTableUsage.clearSelection();
            System.out.println("wellinterp hasChanged: " + wellInterp.hasChanged());
            System.out.println("observers of wellInterp: " + wellInterp.countObservers());
            well.getAddInterp(wellInterp.getHeader()).notifyObservers(this.scheme.getIGDType());
            wellInterp.notifyObservers(this.scheme.getIGDType());
        }
        catch (SQLException | SBException | SBPermissionException e) {
            this.scheme.getDatabase().doRollback();
            FrameJsbugs.showStackError("Error deleting", (Exception)e, this.scheme.getDatabase());
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        SBdb db = this.scheme.getDatabase();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(db, "JLISTFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("csv");
        filter.setDescription("CSV files");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = new Date();
        if (0 == jFileChooser1.showSaveDialog(this)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Object fileName = jFileChooser1.getSelectedFile().getPath();
                if (!((String)fileName).toLowerCase().endsWith(".csv")) {
                    fileName = (String)fileName + ".csv";
                }
                try (FileWriter out = new FileWriter((String)fileName);){
                    out.write("StrataBugs output: " + df.format(date) + "\r\n");
                    out.write("Well Code,Well Name\r\n");
                    for (int i = 0; i < this.wellModel.size(); ++i) {
                        WellOccRec well = (WellOccRec)this.wellModel.get(i);
                        out.write(well.wellCode() + "," + well.wellName() + "\r\n");
                    }
                }
                if (JOptionPane.showConfirmDialog(this, "File '" + (String)fileName + "' written", "File Saved", 2) == 0) {
                    Lastval.putString(db, "JLISTFILE", (String)fileName);
                    db.commit();
                }
            }
            catch (IOException | RuntimeException | SQLException ex) {
                SbugsExceptionHandler.showStackError(ex, this);
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonReassignActionPerformed(ActionEvent evt) {
        this.reassign(false, null);
    }

    private void jButtonReassign1ActionPerformed(ActionEvent evt) {
        if (this.jListVersion.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a version", this.getTitle(), 2);
            return;
        }
        InterpHdr interpHdr = (InterpHdr)this.jListVersion.getSelectedValue();
        this.reassign(false, interpHdr);
    }

    private void jListWellValueChanged(ListSelectionEvent evt) {
        this.jButtonShowActionPerformed(null);
    }

    private void jListVersionValueChanged(ListSelectionEvent evt) {
        this.jButtonShowZonesActionPerformed(null);
    }

    private void jButtonFindActionPerformed(ActionEvent evt) {
        if (this.model instanceof ZonesTableModel) {
            ZonesTableModel zm = (ZonesTableModel)this.model;
            if (this.jTableUsage.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No intervals selected", this.getTitle(), 2);
                return;
            }
            int[] rows = this.jTableUsage.getSelectedRows();
            Object unit = "";
            for (int i = 0; i < rows.length; ++i) {
                IGDIntervalZone zone = zm.getZones().get(this.jTableUsage.convertRowIndexToModel(rows[i]));
                if (!((String)unit).toUpperCase().contains(zone.getUppInf().toUpperCase())) {
                    if (!((String)unit).isEmpty()) {
                        unit = (String)unit + ";";
                    }
                    unit = (String)unit + zone.getUppInf();
                }
                if (zone.getLowInf() == null || zone.getLowInf().isEmpty() || ((String)unit).toUpperCase().contains(zone.getLowInf().toUpperCase())) continue;
                if (!((String)unit).isEmpty()) {
                    unit = (String)unit + ";";
                }
                unit = (String)unit + zone.getLowInf();
            }
            DialogSearchUnit dialog = new DialogSearchUnit(this, true, this.scheme.getDatabase(), (String)unit);
            dialog.setLocationRelativeTo(this);
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            dialog.setVisible(true);
        }
    }

    private void jButtonTranslateActionPerformed(ActionEvent evt) {
        this.reassign(true, null);
    }

    private void jButtonTranslateInterpActionPerformed(ActionEvent evt) {
        if (this.jListVersion.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a version", this.getTitle(), 2);
            return;
        }
        InterpHdr interpHdr = (InterpHdr)this.jListVersion.getSelectedValue();
        this.reassign(true, interpHdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reassign(boolean translate, InterpHdr restrictToInterp) {
        block65: {
            String actioned;
            String action = translate ? "Translate" : "Reassign";
            String string = actioned = translate ? "translated" : "reassigned";
            if (this.jListWell.getSelectedIndex() < 0) {
                JOptionPane.showMessageDialog(this, "You need to select well(s) to " + action, "Select Wells", 1);
                return;
            }
            SBdb db = this.scheme.getDatabase();
            String joptTitle = action + " Scheme";
            try {
                DialogSelectScheme dialog = new DialogSelectScheme(this, true, this.scheme.getDatabase(), this.scheme.getIGDType(), null);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection == null) break block65;
                int nIntervals = 0;
                int nNotAssigned = 0;
                FileWriter out = null;
                IGDScheme newScheme = dialog.selection;
                boolean reassignAll = false;
                if (newScheme.getID() == this.scheme.getID()) {
                    JOptionPane.showMessageDialog(this, "New scheme is the same as current scheme", "Select Wells", 1);
                    return;
                }
                if (JOptionPane.showConfirmDialog(this, "Do you want to create a log file?", joptTitle, 0) == 0) {
                    JFileChooser jFileChooser1 = new JFileChooser();
                    jFileChooser1.setCurrentDirectory(null);
                    SbugsFileFilter filter = new SbugsFileFilter();
                    filter.addExtension("log");
                    filter.setDescription("Log files");
                    jFileChooser1.addChoosableFileFilter((FileFilter)filter);
                    if (0 == jFileChooser1.showSaveDialog(this)) {
                        Object fileName = jFileChooser1.getSelectedFile().getPath();
                        if (((String)fileName).indexOf(".") < 0) {
                            fileName = (String)fileName + ".log";
                        }
                        out = new FileWriter((String)fileName);
                        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
                        Date date = new Date();
                        out.write("\nStrataBugs " + IGDInterval.getIGDName(this.scheme.getIGDType()) + " Scheme units " + actioned + "\n");
                        out.write("From scheme: " + String.valueOf(this.scheme) + ",scheme ID: " + this.scheme.getID() + "\n");
                        out.write("To scheme: " + String.valueOf(newScheme) + ",scheme ID: " + newScheme.getID() + "\n");
                        out.write("By user: " + db.getUser().getName() + "," + db.getUser().getAbr() + ", on " + df.format(date) + "\n\n");
                    }
                }
                this.scheme.loadUnits();
                newScheme.loadUnits();
                if (this.scheme.getIGDType() == 10) {
                    this.scheme.getSurfaces();
                    newScheme.getSurfaces();
                }
                int[] selectedWells = this.jListWell.getSelectedIndices();
                this.clearPanelDisplay();
                this.versionModel.clear();
                this.jListVersion.repaint();
                class WellException {
                    Well well;
                    WellInterp interp;
                    Exception e;

                    WellException(DialogSchemeUsage this$0, Well w, WellInterp i, Exception e) {
                        Objects.requireNonNull(this$0);
                        this.well = w;
                        this.interp = i;
                        this.e = e;
                    }

                    public String toString() {
                        return this.well.toString() + " (" + this.interp.toString() + ") " + this.e.toString();
                    }
                }
                LinkedList<WellException> exceptions = new LinkedList<WellException>();
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (int i = 0; i < selectedWells.length; ++i) {
                    WellOccRec wellRef = (WellOccRec)this.jListWell.getModel().getElementAt(selectedWells[i]);
                    Well well = this.scheme.getDatabase().getWell(wellRef.wellID());
                    if (out != null) {
                        out.write("Well: " + well.getWellName() + " (" + well.getWellCode() + ")\n");
                    }
                    well.getSamples();
                    List versions = this.scheme.getWellInterps(well);
                    Iterator iterator = versions.iterator();
                    while (iterator.hasNext()) {
                        InterpItem updateArg = null;
                        WellInterp interp = (WellInterp)iterator.next();
                        well.loadInterp(interp);
                        if (restrictToInterp != null && restrictToInterp.getInterpID() != interp.getHeader().getInterpID()) continue;
                        if (out != null) {
                            out.write("\tVersion: " + interp.toString() + "\n");
                        }
                        if (this.scheme.getIGDType() == 10) {
                            List<SQPick> picks = interp.getSQPicks(this.scheme.getID());
                            List<SQPick> newPicks = interp.getSQPicks(newScheme.getID());
                            if (!newPicks.isEmpty() && JOptionPane.showConfirmDialog(this, "Warning: picks already exist in version '" + String.valueOf(interp) + "' for the scheme '" + String.valueOf(newScheme) + "'.\nContinue with this version?", joptTitle, 0, 3) != 0) continue;
                            Iterator<SQPick> itPick = picks.iterator();
                            int nRejections = 0;
                            while (itPick.hasNext()) {
                                SQPick pick = itPick.next();
                                int newSurfaceID = translate ? this.getTranslatedSurface(this.scheme, newScheme, pick.getSurfaceID(), pick.getInfName()) : this.getReplacementSurface(this.scheme, newScheme, pick.getSurfaceID(), pick.getInfName());
                                if (newSurfaceID != 0) continue;
                                ++nRejections;
                            }
                            if (nRejections > 0 && JOptionPane.showConfirmDialog(this, nRejections + " surfaces in " + well.getWellName() + "/" + interp.toString() + " cannot be reassigned (no matching surfaces found).\nDo you want to reassign the remaining surfaces?", joptTitle, 0) != 0) continue;
                            LinkedList<SQPick> pickList = new LinkedList<SQPick>();
                            itPick = picks.listIterator(0);
                            while (itPick.hasNext()) {
                                SQPick pick = itPick.next();
                                String newInf = null;
                                int newSurfaceID = 0;
                                if (translate) {
                                    String origName;
                                    newSurfaceID = this.getTranslatedSurface(this.scheme, newScheme, pick.getSurfaceID(), pick.getInfName());
                                    if (newSurfaceID > 0 && pick.getSurfaceID() > 0 && (origName = this.scheme.findSurface(pick.getSurfaceID()).getName()).equalsIgnoreCase(pick.getInfName())) {
                                        newInf = newScheme.findSurface(newSurfaceID).getName();
                                    }
                                } else {
                                    newSurfaceID = this.getReplacementSurface(this.scheme, newScheme, pick.getSurfaceID(), pick.getInfName());
                                }
                                if (newSurfaceID > 0) {
                                    if (out != null) {
                                        out.write("\t\t");
                                        out.write(pick.getSample().toString() + "\t");
                                        out.write(pick.getSurface().getName() + "\t");
                                        this.writeLogIDs(out, pick.getSurfaceID(), newSurfaceID, newInf);
                                        out.write("\n");
                                    }
                                    pickList.clear();
                                    pickList.add(pick);
                                    interp.delete(pickList, well.getWellID());
                                    Audit audit = new Audit(pick.getCreator(), pick.getCreated(), pick.getModifier(), pick.getModified());
                                    SQPick.Builder pickBuilder = new SQPick.Builder(db, newScheme.getSurface(newSurfaceID), pick.getSample(), pick.getBndInt()).informalName(pick.getInfName()).questionable(pick.isQuestionable()).observed(true).audit(audit);
                                    if (newInf != null) {
                                        pickBuilder.informalName(newInf);
                                    }
                                    updateArg = interp.addSQPick(well, pickBuilder);
                                    ++nIntervals;
                                    continue;
                                }
                                ++nNotAssigned;
                            }
                        } else {
                            List<IGDIntervalZone> zones = interp.getIGDList(this.scheme.getIGDType(), this.scheme.getID());
                            List<IGDIntervalZone> newZones = interp.getIGDList(newScheme.getIGDType(), newScheme.getID());
                            if (!newZones.isEmpty() && JOptionPane.showConfirmDialog(this, "Warning: intervals already exist in version '" + String.valueOf(interp) + "' for the scheme '" + String.valueOf(newScheme) + "'.\nContinue with this version?", well.getWellName() + "/" + interp.toString(), 0, 3) != 0) continue;
                            for (IGDIntervalZone zone : zones) {
                                int newLowZone;
                                int newUppZone;
                                String newUppInf = null;
                                String newLowInf = null;
                                boolean doAction = true;
                                if (translate) {
                                    String origUnitName;
                                    newUppZone = this.getTranslatedUnit(this.scheme, newScheme, zone.getUppZone(), zone.getUppInf());
                                    newLowZone = this.getTranslatedUnit(this.scheme, newScheme, zone.getLowZone(), zone.getLowInf());
                                    if (newUppZone > 0 && zone.getUppZone() > 0 && (origUnitName = this.scheme.findUnit(zone.getUppZone()).getName()).equalsIgnoreCase(zone.getUppInf())) {
                                        newUppInf = newScheme.findUnit(newUppZone).getName();
                                    }
                                    if (newLowZone > 0 && zone.getLowZone() > 0 && (origUnitName = this.scheme.findUnit(zone.getLowZone()).getName()).equalsIgnoreCase(zone.getLowInf())) {
                                        newLowInf = newScheme.findUnit(newLowZone).getName();
                                    }
                                } else {
                                    newUppZone = this.getReplacementUnit(this.scheme, newScheme, zone.getUppZone(), zone.getUppInf());
                                    newLowZone = this.getReplacementUnit(this.scheme, newScheme, zone.getLowZone(), zone.getLowInf());
                                }
                                if ((newUppZone == 0 || newLowZone == 0 && zone.getLowZone() > 0) && !reassignAll) {
                                    Object zoneString = zone.toString();
                                    if (zone.getUppZone() > 0) {
                                        IGDUnitBase unit = this.scheme.findUnitBase(zone.getUppZone());
                                        zoneString = (String)zoneString + " (" + (String)(unit != null ? unit.toString() : "ID=" + zone.getUppZone());
                                        if (zone.getLowZone() > 0 && zone.getLowZone() != zone.getUppZone()) {
                                            unit = this.scheme.findUnit(zone.getUppZone());
                                            zoneString = (String)zoneString + " - " + (String)(unit != null ? unit.toString() : "ID=" + zone.getLowZone());
                                        }
                                        zoneString = (String)zoneString + ")";
                                    }
                                    Object[] buttons = new String[]{"Yes", "Yes for All", "No", "Cancel"};
                                    int opt = JOptionPane.showOptionDialog(this, "The interval '" + (String)zoneString + "' is not found it the new scheme. " + action + " as informal?", well.getWellName() + "/" + interp.toString(), 1, 3, null, buttons, null);
                                    if (opt == 3 || opt == -1) {
                                        db.doRollback();
                                        if (out != null) {
                                            out.write("\n\nOperation CANCELLED");
                                        }
                                        JOptionPane.showMessageDialog(this, "Close StrataBugs and reopen the control panel to flush partially changed data", this.getTitle(), 1);
                                        out.close();
                                        break;
                                    }
                                    if (opt == 2) {
                                        doAction = false;
                                    } else if (opt == 1) {
                                        reassignAll = true;
                                        doAction = true;
                                    }
                                }
                                if (doAction) {
                                    if (out != null) {
                                        out.write("\t\t");
                                        if (zone.getTopSample() != null) {
                                            out.write(zone.getTopSample().toString() + "\t");
                                        }
                                        if (zone.getBaseSample() != null) {
                                            out.write(" - " + zone.getBaseSample().toString() + "\t");
                                        }
                                        out.write(zone.getUppInf());
                                        this.writeLogIDs(out, zone.getUppZone(), newUppZone, newUppInf);
                                        if (zone.getLowZone() > 0) {
                                            out.write("\t" + zone.getLowInf());
                                            this.writeLogIDs(out, zone.getLowZone(), newLowZone, newLowInf);
                                        }
                                        out.write("\n");
                                    }
                                    try {
                                        IGDIntervalZone.Builder builder = IGDIntervalZone.Builder.copyOf(zone, newScheme.getID());
                                        builder.uppZone(newUppZone);
                                        builder.lowZone(newLowZone);
                                        if (translate) {
                                            if (newUppInf != null) {
                                                builder.uppInf(newUppInf);
                                            }
                                            if (newLowInf != null) {
                                                builder.lowInf(newLowInf);
                                            }
                                        }
                                        interp.updateZone(zone, builder, well, false, true);
                                        interp.setChanged(zone);
                                        updateArg = zone;
                                        ++nIntervals;
                                    }
                                    catch (SBException sbe) {
                                        exceptions.add(new WellException(this, well, interp, (Exception)((Object)sbe)));
                                    }
                                    catch (InvalidFieldException sbe) {
                                        exceptions.add(new WellException(this, well, interp, (Exception)((Object)sbe)));
                                    }
                                    continue;
                                }
                                ++nNotAssigned;
                            }
                        }
                        if (updateArg == null) continue;
                        interp.notifyObservers(updateArg);
                        List<IGDHdr> hdrs = interp.getHeaders(well.getWellID());
                        boolean newHdrUpdated = false;
                        boolean oldHdrUpdated = false;
                        String oldSchemeHeaderComment = "Data " + actioned + " to scheme: " + newScheme.getName();
                        String newSchemeHeaderComment = "Data " + actioned + " from scheme: " + this.scheme.getName();
                        boolean finished = false;
                        block16: do {
                            finished = true;
                            for (IGDHdr h : hdrs) {
                                if (!oldHdrUpdated && h.getSchID() == this.scheme.getID()) {
                                    Object comments = h.getComments();
                                    if (comments == null || ((String)comments).isEmpty()) {
                                        comments = oldSchemeHeaderComment;
                                    } else if (((String)(comments = (String)comments + " " + oldSchemeHeaderComment)).length() > 240) {
                                        comments = ((String)comments).substring(0, 240);
                                    }
                                    interp.updateIGDHdr(well.getID(), h, (String)comments, h.getSource(), h.getAuthorised());
                                    oldHdrUpdated = true;
                                    finished = false;
                                    continue block16;
                                }
                                if (newHdrUpdated || h.getSchID() != newScheme.getID()) continue;
                                Object comments = h.getComments();
                                if (comments == null || ((String)comments).isEmpty()) {
                                    comments = newSchemeHeaderComment;
                                } else if (((String)(comments = (String)comments + " " + newSchemeHeaderComment)).length() > 240) {
                                    comments = ((String)comments).substring(0, 240);
                                }
                                interp.updateIGDHdr(well.getID(), h, (String)comments, h.getSource(), h.getAuthorised());
                                newHdrUpdated = true;
                                finished = false;
                                continue block16;
                            }
                        } while (!finished);
                        if (!oldHdrUpdated) {
                            interp.addIGDHdr(well.getWellID(), this.scheme.getID(), oldSchemeHeaderComment, "", "");
                        }
                        if (newHdrUpdated) continue;
                        interp.addIGDHdr(well.getWellID(), newScheme.getID(), newSchemeHeaderComment, "", "");
                    }
                }
                this.setCursor(Cursor.getDefaultCursor());
                String type = this.scheme.getIGDType() == 10 ? "pick" : "interval";
                String type2 = this.scheme.getIGDType() == 10 ? "surface" : "unit";
                String msg = nIntervals + " " + type + (nIntervals == 1 ? "" : "s") + " updated. " + (String)(nNotAssigned > 0 ? "\n" + nNotAssigned + (nNotAssigned == 1 ? " was" : " were") + " not updated because the " + type2 + " did not exist in the new scheme.\n" : "");
                if (exceptions.size() > 0) {
                    msg = msg + "\nThe following exceptions were caught:";
                    for (Object e : exceptions) {
                        msg = msg + "\n" + e.toString();
                    }
                    msg = msg + "\n\nYou should manually reassign these intervals by editing the well data.";
                }
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
                db.commit();
                this.initWells();
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException | RuntimeException | SQLException | SBException | SBPermissionException ex) {
                db.doRollback();
                SbugsExceptionHandler.showStackError(ex, this);
            }
            catch (InvalidFieldException ex) {
                ex.printStackTrace();
                db.doRollback();
                JOptionPane.showMessageDialog(this, "Can't save " + actioned + " intervals due to error: " + ex.toString() + "\nNone of the intervals have been " + actioned + ".", this.getTitle(), 0);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void clearPanelDisplay() {
        if (this.scheme.getIGDType() == 10) {
            ((SQPickTableModel)this.model).setItems(null);
        } else {
            ((ZonesTableModel)this.model).setZones(null, null);
        }
        this.model.fireTableDataChanged();
    }

    void writeLogIDs(FileWriter out, int ID, int newID, String newInf) throws IOException {
        if (ID > 0) {
            out.write(", ID=" + ID + " -> " + newID + "\t" + (newInf != null ? newInf : ""));
        } else {
            out.write(", (no Formal term) ");
            if (newID > 0) {
                out.write(" -> " + newID);
            }
        }
    }

    int getReplacementUnit(IGDScheme scheme, IGDScheme newScheme, int oldUnitID, String informalTerm) throws SBException, SQLException {
        IGDUnitBase oldUnit = scheme.findUnitBase(oldUnitID);
        IGDUnitBase newUnit = null;
        if (oldUnit == null) {
            if (informalTerm != null) {
                newUnit = newScheme.findUnitBase(informalTerm);
                if (newUnit == null) {
                    return 0;
                }
                return newUnit.getUnitID();
            }
            return -1;
        }
        newUnit = newScheme.findUnitBase(oldUnit.getName());
        if (newUnit == null) {
            if (informalTerm != null) {
                newUnit = newScheme.findUnitBase(informalTerm);
                if (newUnit == null) {
                    return 0;
                }
                return newUnit.getUnitID();
            }
            return 0;
        }
        return newUnit.getUnitID();
    }

    int getTranslatedUnit(IGDScheme scheme, IGDScheme newScheme, int oldUnitID, String informalTerm) throws SBException, SQLException {
        IGDUnit oldUnit = (IGDUnit)scheme.findUnitBase(oldUnitID);
        IGDUnitBase newUnit = null;
        if (oldUnit == null) {
            return 0;
        }
        if (!oldUnit.hasAges() || Math.abs(oldUnit.getLage() - oldUnit.getUage()) < 1.0E-4) {
            return 0;
        }
        if (oldUnit.getUage() != null && oldUnit.getLage() != null) {
            newUnit = newScheme.findUnit(oldUnit.getHier(), (double)oldUnit.getUage(), oldUnit.getLage());
        }
        if (newUnit == null) {
            return 0;
        }
        return newUnit.getUnitID();
    }

    int getReplacementSurface(IGDScheme scheme, IGDScheme newScheme, int oldSurfaceID, String informalTerm) throws SBException, SQLException {
        Surface oldSurface = scheme.getSurface(oldSurfaceID);
        if (oldSurface == null) {
            return 0;
        }
        Surface newSurface = newScheme.getSurface(oldSurface.getName(), oldSurface.getType());
        if (newSurface == null && (newSurface = newScheme.getSurface(informalTerm, oldSurface.getType())) == null) {
            return 0;
        }
        return newSurface.getSurfaceID();
    }

    int getTranslatedSurface(IGDScheme scheme, IGDScheme newScheme, int oldSurfaceID, String informalTerm) throws SBException, SQLException {
        Surface oldSurface = scheme.getSurface(oldSurfaceID);
        if (oldSurface == null) {
            return 0;
        }
        Surface newSurface = newScheme.getSurface(oldSurface.getAge(), oldSurface.getName(), oldSurface.getType());
        if (newSurface == null) {
            return 0;
        }
        return newSurface.getSurfaceID();
    }
}

