/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;

public class DialogSelectChartDatum
extends SBDialog {
    static final String[] tableTitles = new String[]{"Line", "Primary", "Secondary"};
    static final int[] tableWidths = new int[]{80, 70, 70};
    private final Correlation correlation;
    private final List<CorrelationLine> cLines;
    private CorrelationLine datum1;
    private CorrelationLine datum2;
    private final TableModelCorrLines model = new TableModelCorrLines(this);
    private JButton jButtonCancel;
    private JButton jButtonClear;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTableCorrelationLines;

    public DialogSelectChartDatum(Frame parent, boolean modal, Correlation correlation) {
        super(parent, modal);
        this.correlation = correlation;
        this.cLines = new LinkedList<CorrelationLine>(correlation.getLines());
        Collections.sort(this.cLines);
        this.datum1 = correlation.getDatumPrimary();
        this.datum2 = correlation.getDatumSecondary();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Select Chart Datum");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        TableCellRenderer centreRenderer = new TableCellRenderer(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)((Object)table.getTableHeader().getDefaultRenderer());
                label.setHorizontalAlignment(0);
                label.setText(tableTitles[column]);
                return label;
            }
        };
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.jTableCorrelationLines.getColumnModel().getColumn(i).setHeaderValue(tableTitles[i]);
            this.jTableCorrelationLines.getColumnModel().getColumn(i).setWidth(tableWidths[i]);
            if (i <= 0) continue;
            this.jTableCorrelationLines.getColumnModel().getColumn(i).setMaxWidth(tableWidths[i]);
            this.jTableCorrelationLines.getColumnModel().getColumn(i).setHeaderRenderer(centreRenderer);
        }
        this.jTableCorrelationLines.setGridColor(Color.LIGHT_GRAY);
        this.jTableCorrelationLines.getTableHeader().setReorderingAllowed(false);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCorrelationLines = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonClear = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 200));
        this.jTableCorrelationLines.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCorrelationLines);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectChartDatum this$0;
            {
                DialogSelectChartDatum dialogSelectChartDatum = this$0;
                Objects.requireNonNull(dialogSelectChartDatum);
                this.this$0 = dialogSelectChartDatum;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectChartDatum this$0;
            {
                DialogSelectChartDatum dialogSelectChartDatum = this$0;
                Objects.requireNonNull(dialogSelectChartDatum);
                this.this$0 = dialogSelectChartDatum;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonClear.setText("Clear");
        this.jButtonClear.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectChartDatum this$0;
            {
                DialogSelectChartDatum dialogSelectChartDatum = this$0;
                Objects.requireNonNull(dialogSelectChartDatum);
                this.this$0 = dialogSelectChartDatum;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 113, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonClear, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 289, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonClear)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setOK();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.datum1 = null;
        this.datum2 = null;
        this.model.fireTableDataChanged();
    }

    public CorrelationLine getDatumPrimary() {
        return this.datum1;
    }

    public CorrelationLine getDatumSecondary() {
        return this.datum2;
    }

    private class TableModelCorrLines
    extends AbstractTableModel {
        final /* synthetic */ DialogSelectChartDatum this$0;

        private TableModelCorrLines(DialogSelectChartDatum dialogSelectChartDatum) {
            DialogSelectChartDatum dialogSelectChartDatum2 = dialogSelectChartDatum;
            Objects.requireNonNull(dialogSelectChartDatum2);
            this.this$0 = dialogSelectChartDatum2;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.correlation == null) {
                return 0;
            }
            return this.this$0.cLines.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.this$0.cLines.get(rowIndex).toString();
                }
                case 1: {
                    return this.this$0.datum1 != null && this.this$0.datum1 == this.this$0.cLines.get(rowIndex);
                }
                case 2: {
                    return this.this$0.datum2 != null && this.this$0.datum2 == this.this$0.cLines.get(rowIndex);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                default: {
                    return String.class;
                }
                case 1: 
                case 2: 
            }
            return Boolean.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Boolean select = (Boolean)value;
            CorrelationLine line = this.this$0.cLines.get(row);
            if (select.booleanValue()) {
                if (col == 1) {
                    this.this$0.datum1 = line;
                } else {
                    this.this$0.datum2 = line;
                }
            } else if (col == 1) {
                if (this.this$0.datum1 == line) {
                    this.this$0.datum1 = null;
                }
            } else if (this.this$0.datum2 == line) {
                this.this$0.datum2 = null;
            }
            this.this$0.jTableCorrelationLines.repaint();
        }
    }
}

