/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.TableRowSorter;
import jsbugs.GenusTableModel;
import jsbugs.list.CategoryComboBox;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.ItemSelectorDialog;
import model3.SBdb;
import model3.exception.SuppressedSQLException;
import org.apache.commons.lang3.StringUtils;

public class DialogSelectGenus
extends ItemSelectorDialog<Genus> {
    private final GenusTableModel model;
    private final SBdb sbdb;
    private static Integer dialogWidth;
    private static Integer dialogHeight;
    private final List<Genus> selection = new ArrayList<Genus>();
    private CategoryComboBox categoryComboBox;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonClear;
    private JButton jButtonOK;
    private JButton jButtonSearch;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTable1;
    private JTextField jTextFieldGenus;
    private JTextField jTextFieldSubGen;

    public DialogSelectGenus(Frame parent, boolean modal, SBdb sbdb, boolean singleSelect) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.model = new GenusTableModel(null);
        this.initComponents();
        this.init(singleSelect, null);
    }

    public DialogSelectGenus(Dialog parent, boolean modal, SBdb sbdb, boolean singleSelect, Genus initial) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.model = new GenusTableModel(null);
        this.initComponents();
        this.init(singleSelect, initial);
    }

    private void init(boolean singleSelect, Genus initial) {
        this.model.setupTable(this.jTable1, this.sbdb);
        this.jTable1.setRowSorter(new TableRowSorter<GenusTableModel>(this.model));
        new ColumnSortResetHandler(this.jTable1).attach();
        this.categoryComboBox.setCategoryService(this.sbdb.getCategoryService());
        this.categoryComboBox.fill();
        if (initial != null) {
            this.jTextFieldGenus.setText(initial.getGenusName());
            this.jTextFieldSubGen.setText(initial.getSubGenus());
        }
        if (singleSelect) {
            this.jTable1.setSelectionMode(0);
        }
        this.setTitle("Select Genera");
        if (dialogWidth != null && dialogHeight != null) {
            this.setSize(dialogWidth, dialogHeight);
        }
        this.getRootPane().setDefaultButton(this.jButtonSearch);
        this.jButtonAdd.setVisible(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldGenus = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldSubGen = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jButtonSearch = new JButton();
        this.jButtonClear = new JButton();
        this.jButtonAdd = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.categoryComboBox = new CategoryComboBox();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Category:");
        this.jLabel2.setText("Genus:");
        this.jTextFieldGenus.setText("%");
        this.jTextFieldGenus.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSelectGenus this$0;
            {
                DialogSelectGenus dialogSelectGenus = this$0;
                Objects.requireNonNull(dialogSelectGenus);
                this.this$0 = dialogSelectGenus;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldGenusFocusGained(evt);
            }
        });
        this.jLabel3.setText("Sub-genus:");
        this.jTextFieldSubGen.setText("%");
        this.jTextFieldSubGen.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSelectGenus this$0;
            {
                DialogSelectGenus dialogSelectGenus = this$0;
                Objects.requireNonNull(dialogSelectGenus);
                this.this$0 = dialogSelectGenus;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldSubGenFocusGained(evt);
            }
        });
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectGenus this$0;
            {
                DialogSelectGenus dialogSelectGenus = this$0;
                Objects.requireNonNull(dialogSelectGenus);
                this.this$0 = dialogSelectGenus;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonClear.setText("Clear");
        this.jButtonClear.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectGenus this$0;
            {
                DialogSelectGenus dialogSelectGenus = this$0;
                Objects.requireNonNull(dialogSelectGenus);
                this.this$0 = dialogSelectGenus;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectGenus this$0;
            {
                DialogSelectGenus dialogSelectGenus = this$0;
                Objects.requireNonNull(dialogSelectGenus);
                this.this$0 = dialogSelectGenus;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jTable1.setModel(this.model);
        this.jTable1.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectGenus this$0;
            {
                DialogSelectGenus dialogSelectGenus = this$0;
                Objects.requireNonNull(dialogSelectGenus);
                this.this$0 = dialogSelectGenus;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectGenus this$0;
            {
                DialogSelectGenus dialogSelectGenus = this$0;
                Objects.requireNonNull(dialogSelectGenus);
                this.this$0 = dialogSelectGenus;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectGenus this$0;
            {
                DialogSelectGenus dialogSelectGenus = this$0;
                Objects.requireNonNull(dialogSelectGenus);
                this.this$0 = dialogSelectGenus;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 196, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldGenus, -1, 213, Short.MAX_VALUE).addComponent(this.jTextFieldSubGen).addComponent(this.categoryComboBox, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jButtonClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearch))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.jButtonAdd, this.jButtonClear, this.jButtonSearch);
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.categoryComboBox, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldGenus, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldSubGen, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSearch).addComponent(this.jButtonClear).addComponent(this.jButtonAdd)).addGap(11, 11, 11).addComponent(this.jScrollPane1, -1, 182, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldGenusFocusGained(FocusEvent evt) {
        this.jTextFieldGenus.setCaretPosition(0);
    }

    private void jTextFieldSubGenFocusGained(FocusEvent evt) {
        this.jTextFieldSubGen.setCaretPosition(0);
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.categoryComboBox.setSelectedIndex(0);
        this.jTextFieldGenus.setText("%");
        this.jTextFieldSubGen.setText("%");
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.selection.clear();
        for (int i : this.jTable1.getSelectedRows()) {
            this.selection.add(this.model.getGenus(this.jTable1.convertRowIndexToModel(i)));
        }
        dialogWidth = this.getWidth();
        dialogHeight = this.getHeight();
        this.dispose();
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
    }

    private Genus getGenusFromFields() {
        Genus genus = new Genus();
        genus.setCategory((Category)this.categoryComboBox.getSelectedCategory().orElse(null));
        genus.setGenusName(this.jTextFieldGenus.getText());
        genus.setSubGenus(this.jTextFieldSubGen.getText());
        return genus;
    }

    private void search() {
        if (this.categoryComboBox.getSelectedCategory().isEmpty() && StringUtils.isBlank((CharSequence)this.jTextFieldGenus.getText()) && StringUtils.isBlank((CharSequence)this.jTextFieldSubGen.getText())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter search parameters", this.getTitle(), 2);
            return;
        }
        try {
            List found = this.sbdb.getGenusService().findMatchingGenera(this.getGenusFromFields(), SearchMode.SEARCH);
            if (found.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No genera found!", this.getTitle(), 2);
                return;
            }
            Collections.sort(found);
            this.model.clear();
            for (Genus genus : found) {
                this.model.addGenus(genus, this.sbdb.getTaxonService().getTaxonCountForGenus(genus.getGenID()));
            }
            this.model.fireTableDataChanged();
        }
        catch (SuppressedSQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
        new SwingWorker(this){
            final /* synthetic */ DialogSelectGenus this$0;
            {
                DialogSelectGenus dialogSelectGenus = this$0;
                Objects.requireNonNull(dialogSelectGenus);
                this.this$0 = dialogSelectGenus;
            }

            protected Object doInBackground() throws Exception {
                for (Genus genus : this.this$0.model.getGenera()) {
                    this.this$0.sbdb.getTaxa(genus.getGenID());
                    this.this$0.model.updateNTaxa(genus, this.this$0.sbdb.getTaxonService().getTaxonCountForGenus(genus.getGenID()));
                }
                this.this$0.jTable1.repaint();
                return null;
            }
        }.execute();
    }

    @Override
    public List<Genus> getSelectedItems() {
        return this.selection;
    }
}

