/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplate;
import jsbchart.core.ChartManager;
import jsbugs.JPanelSelectList;
import model3.Lastval;
import model3.SBdb;
import model3.TxGroup;
import model3.TxGroupSet;
import util.exception.StackError;

public class DialogSelectGlobals
extends JDialog {
    int SELECTION_LIMIT = 50;
    SBdb db;
    ChartManager chartManager;
    boolean isOK = false;
    List<BlockTemplate> listWellBlockSelected = new LinkedList<BlockTemplate>();
    List<BlockTemplate> listSchemeBlockSelected = new LinkedList<BlockTemplate>();
    List<TxGroupSet> listSetSelected = new LinkedList<TxGroupSet>();
    List<TxGroup> listGroupSelected = new LinkedList<TxGroup>();
    JPanelSelectList panelWellBlock;
    JPanelSelectList panelSchemeBlock;
    JPanelSelectList panelSet;
    JPanelSelectList panelGroup;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JTabbedPane jTabbedPane1;

    public DialogSelectGlobals(JDialog parent, SBdb db, ChartManager chartManager, boolean modal) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.chartManager = chartManager;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Select Globals");
        List<BlockTemplate> listWellBlockAvailable = this.chartManager.getBlocks(BlockType.WELL, 0, true);
        Collections.sort(listWellBlockAvailable);
        String IDstring = Lastval.getString(this.db, "DXGBWB");
        if (!IDstring.isEmpty()) {
            this.fillSelectedBlocks(IDstring, listWellBlockAvailable, this.listWellBlockSelected);
        }
        this.panelWellBlock = new JPanelSelectList(this.listWellBlockSelected, listWellBlockAvailable, this.SELECTION_LIMIT);
        this.jTabbedPane1.addTab("Well Block Templates", this.panelWellBlock);
        List<BlockTemplate> listSchemeBlockAvailable = this.chartManager.getBlocks(BlockType.SCHEME, 0, true);
        Collections.sort(listSchemeBlockAvailable);
        IDstring = Lastval.getString(this.db, "DXGBSB");
        if (!IDstring.isEmpty()) {
            this.fillSelectedBlocks(IDstring, listSchemeBlockAvailable, this.listSchemeBlockSelected);
        }
        this.panelSchemeBlock = new JPanelSelectList(this.listSchemeBlockSelected, listSchemeBlockAvailable, this.SELECTION_LIMIT);
        this.jTabbedPane1.addTab("Scheme Block Templates", this.panelSchemeBlock);
        List<TxGroupSet> listSetsAvailable = this.db.getTxGroupSets(0, true);
        Collections.sort(listSetsAvailable);
        IDstring = Lastval.getString(this.db, "DXGBSET");
        if (!IDstring.isEmpty()) {
            this.fillSelectedSets(IDstring, listSetsAvailable, this.listSetSelected);
        }
        this.panelSet = new JPanelSelectList(this.listSetSelected, listSetsAvailable, this.SELECTION_LIMIT);
        this.jTabbedPane1.addTab("Group Sets", this.panelSet);
        LinkedList<TxGroup> listGroupsAvailable = new LinkedList<TxGroup>(this.db.getTxGroups(0, true));
        Collections.sort(listGroupsAvailable);
        IDstring = Lastval.getString(this.db, "DXGBGRP");
        if (!IDstring.isEmpty()) {
            this.fillSelectedGroups(IDstring, listGroupsAvailable, this.listGroupSelected);
        }
        this.panelGroup = new JPanelSelectList(this.listGroupSelected, listGroupsAvailable, this.SELECTION_LIMIT);
        this.jTabbedPane1.addTab("Groups", this.panelGroup);
        this.pack();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectGlobals this$0;
            {
                DialogSelectGlobals dialogSelectGlobals = this$0;
                Objects.requireNonNull(dialogSelectGlobals);
                this.this$0 = dialogSelectGlobals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectGlobals this$0;
            {
                DialogSelectGlobals dialogSelectGlobals = this$0;
                Objects.requireNonNull(dialogSelectGlobals);
                this.this$0 = dialogSelectGlobals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 172, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 425, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addGap(10, 10, 10)));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.panelWellBlock.getSelected(this.listWellBlockSelected);
            this.panelSchemeBlock.getSelected(this.listSchemeBlockSelected);
            this.panelSet.getSelected(this.listSetSelected);
            this.panelGroup.getSelected(this.listGroupSelected);
            Lastval.putString(this.db, "DXGBWB", this.getSelectedBlockIDs(this.listWellBlockSelected));
            Lastval.putString(this.db, "DXGBSB", this.getSelectedBlockIDs(this.listSchemeBlockSelected));
            Lastval.putString(this.db, "DXGBSET", this.getSelectedSets(this.listSetSelected));
            Lastval.putString(this.db, "DXGBGRP", this.getSelectedGroups(this.listGroupSelected));
            this.db.commit();
            this.isOK = true;
            this.dispose();
        }
        catch (SQLException sqle) {
            StackError.showStackError((Exception)sqle);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public String getSelectedWellBlockIDs() {
        if (this.listWellBlockSelected.isEmpty()) {
            return null;
        }
        return "(" + this.getSelectedBlockIDs(this.listWellBlockSelected) + ")";
    }

    public String getSelectedSchemeBlockIDs() {
        if (this.listSchemeBlockSelected.isEmpty()) {
            return null;
        }
        return "(" + this.getSelectedBlockIDs(this.listSchemeBlockSelected) + ")";
    }

    public String getSelectedBlockTemplateIDs() {
        if (this.listWellBlockSelected.isEmpty() && this.listSchemeBlockSelected.isEmpty()) {
            return null;
        }
        LinkedList<BlockTemplate> combinedBlocks = new LinkedList<BlockTemplate>(this.listWellBlockSelected);
        return "(" + this.getSelectedBlockIDs(combinedBlocks) + ")";
    }

    private String getSelectedBlockIDs(List<BlockTemplate> selected) {
        Object IDstring = "";
        for (BlockTemplate b : selected) {
            IDstring = (String)IDstring + (((String)IDstring).isEmpty() ? "" : ",");
            IDstring = (String)IDstring + b.getID();
        }
        return IDstring;
    }

    public String getSelectedGroups(List<TxGroup> selected) {
        Object IDstring = "";
        for (TxGroup b : selected) {
            IDstring = (String)IDstring + (((String)IDstring).isEmpty() ? "" : ",");
            IDstring = (String)IDstring + b.getID();
        }
        return IDstring;
    }

    public HashSet getSelectedGroupHashSet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (TxGroup b : this.listGroupSelected) {
            hashSet.add(b.getID());
        }
        return hashSet;
    }

    public String getSelectedSets(List<TxGroupSet> selected) {
        Object IDstring = "";
        for (TxGroupSet b : selected) {
            IDstring = (String)IDstring + (((String)IDstring).isEmpty() ? "" : ",");
            IDstring = (String)IDstring + b.getID();
        }
        return IDstring;
    }

    public HashSet getSelectedSetHashSet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (TxGroupSet b : this.listSetSelected) {
            hashSet.add(b.getID());
        }
        return hashSet;
    }

    private void fillSelectedBlocks(String IDstring, List<BlockTemplate> listAvailable, List<BlockTemplate> listSelected) {
        String[] IDs;
        block0: for (String ID : IDs = IDstring.split(",")) {
            int blockID = Integer.parseInt(ID);
            for (BlockTemplate t : listAvailable) {
                if (t.getID() != blockID) continue;
                listAvailable.remove(t);
                listSelected.add(t);
                continue block0;
            }
        }
    }

    private void fillSelectedSets(String IDstring, List<TxGroupSet> listAvailable, List<TxGroupSet> listSelected) {
        String[] IDs;
        block0: for (String ID : IDs = IDstring.split(",")) {
            int blockID = Integer.parseInt(ID);
            for (TxGroupSet t : listAvailable) {
                if (t.getID() != blockID) continue;
                listAvailable.remove(t);
                listSelected.add(t);
                continue block0;
            }
        }
    }

    private void fillSelectedGroups(String IDstring, List<TxGroup> listAvailable, List<TxGroup> listSelected) {
        String[] IDs;
        block0: for (String ID : IDs = IDstring.split(",")) {
            int blockID = Integer.parseInt(ID);
            for (TxGroup t : listAvailable) {
                if (t.getID() != blockID) continue;
                listAvailable.remove(t);
                listSelected.add(t);
                continue block0;
            }
        }
    }
}

