/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jsbugs.FrameJsbugs;
import jsbugs.list.RestrictableProjectListCellRenderer;
import model3.SBRestrictable;
import model3.SBdb;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.project.Project;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogSelectGroup
extends JDialog {
    private final SBdb db;
    private final DefaultListModel model = new DefaultListModel();
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel setModel = new DefaultComboBoxModel();
    private boolean nameCleared = false;
    TxGroup selection;
    List<TxGroup> multiSelection = null;
    private static final String PROJ_ALL = "<all>";
    private static final String PROJ_GLOBAL = "Global";
    private static final String SET_ANY = "<any>";
    private static final int NAME_LEN = 30;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxProject;
    private JComboBox<String> jComboBoxSet;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jListGroups;
    private JScrollPane jScrollPane1;

    public DialogSelectGroup(Frame parent, boolean modal, SBdb db, TxGroup preselect, boolean allowAdd, boolean isMultiSelection) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(preselect, allowAdd, isMultiSelection);
    }

    public DialogSelectGroup(JDialog parent, boolean modal, SBdb db, boolean allowAdd) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(null, allowAdd, false);
    }

    private void init(TxGroup preselect, boolean allowAdd, boolean isMultiSelection) throws SQLException {
        this.setTitle("Group : Select");
        this.projectModel.addElement(PROJ_ALL);
        this.projectModel.addElement(PROJ_GLOBAL);
        this.db.loadProjectCombo(this.projectModel, false);
        this.jComboBoxProject.addItemListener(new ItemListener(this){
            final /* synthetic */ DialogSelectGroup this$0;
            {
                DialogSelectGroup dialogSelectGroup = this$0;
                Objects.requireNonNull(dialogSelectGroup);
                this.this$0 = dialogSelectGroup;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        this.this$0.fillGroups();
                    }
                    catch (SQLException sql) {
                        FrameJsbugs.showStackError("SQL Error", sql, this.this$0.db);
                    }
                }
            }
        });
        this.setModel.addElement(SET_ANY);
        if (isMultiSelection) {
            this.jComboBoxSet.addItemListener(new ItemListener(this){
                final /* synthetic */ DialogSelectGroup this$0;
                {
                    DialogSelectGroup dialogSelectGroup = this$0;
                    Objects.requireNonNull(dialogSelectGroup);
                    this.this$0 = dialogSelectGroup;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        try {
                            this.this$0.selectSetGroups();
                        }
                        catch (SQLException sql) {
                            FrameJsbugs.showStackError("SQL Error", sql, this.this$0.db);
                        }
                    }
                }
            });
        } else {
            this.jComboBoxSet.setEnabled(false);
        }
        this.jListGroups.setCellRenderer(new RestrictableProjectListCellRenderer());
        this.jListGroups.setSelectionMode(isMultiSelection ? 2 : 0);
        if (isMultiSelection) {
            this.multiSelection = new LinkedList<TxGroup>();
        }
        this.fillGroups();
        if (preselect != null) {
            this.jListGroups.setSelectedValue(preselect, true);
        }
        this.jListGroups.repaint();
        if (!allowAdd) {
            this.jButtonAdd.setVisible(false);
            this.pack();
        } else if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonAdd.setEnabled(false);
            this.jButtonAdd.setToolTipText(SBRestrictable.getDeniedReason(false));
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private Integer getProj() {
        Object o = this.jComboBoxProject.getSelectedItem();
        if (o == PROJ_ALL) {
            return null;
        }
        if (o == PROJ_GLOBAL) {
            return 0;
        }
        return ((Project)((Object)o)).getID();
    }

    private void fillGroups() throws SQLException {
        Object selected = this.jListGroups.getSelectedValue();
        this.model.clear();
        LinkedList<TxGroup> groups = new LinkedList<TxGroup>(this.db.getTxGroups(this.getProj(), false));
        Collections.sort(groups);
        for (TxGroup group : groups) {
            this.model.addElement(group);
        }
        if (selected != null) {
            this.jListGroups.setSelectedValue(selected, true);
        }
        if (this.multiSelection != null) {
            this.setModel.removeAllElements();
            this.setModel.addElement(SET_ANY);
            Integer projId = this.getProj();
            for (TxGroupSet set : this.db.getTxGroupSets(projId == null ? 0 : projId, false)) {
                this.setModel.addElement(set);
            }
        }
    }

    private void selectSetGroups() throws SQLException {
        Object selected = this.jComboBoxSet.getSelectedItem();
        if (selected instanceof String) {
            return;
        }
        List<TxGroup> groups = ((TxGroupSet)selected).getGroups();
        for (int i = 0; i < groups.size(); ++i) {
            if (this.model.indexOf(groups.get(i)) >= 0) continue;
            this.model.addElement(groups.get(i));
        }
        int[] ind = new int[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            ind[i] = this.model.indexOf(groups.get(i));
        }
        this.jListGroups.setSelectedIndices(ind);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListGroups = new JList();
        this.jLabel1 = new JLabel();
        this.jButtonAdd = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jComboBoxProject = new JComboBox();
        this.jComboBoxSet = new JComboBox();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.jListGroups.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListGroups.setModel(this.model);
        this.jListGroups.setToolTipText("Select a group name if you want to overwrite or add to it");
        this.jListGroups.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectGroup this$0;
            {
                DialogSelectGroup dialogSelectGroup = this$0;
                Objects.requireNonNull(dialogSelectGroup);
                this.this$0 = dialogSelectGroup;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListGroupsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListGroups);
        this.jLabel1.setText("Project:");
        this.jButtonAdd.setText("New group...");
        this.jButtonAdd.setToolTipText("Add new group to list");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectGroup this$0;
            {
                DialogSelectGroup dialogSelectGroup = this$0;
                Objects.requireNonNull(dialogSelectGroup);
                this.this$0 = dialogSelectGroup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectGroup this$0;
            {
                DialogSelectGroup dialogSelectGroup = this$0;
                Objects.requireNonNull(dialogSelectGroup);
                this.this$0 = dialogSelectGroup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectGroup this$0;
            {
                DialogSelectGroup dialogSelectGroup = this$0;
                Objects.requireNonNull(dialogSelectGroup);
                this.this$0 = dialogSelectGroup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.projectModel);
        this.jComboBoxSet.setModel(this.setModel);
        this.jLabel2.setText("Set:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 382, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(this.jComboBoxSet, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxProject, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxProject, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add(this.jComboBoxSet, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 191, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonCancel).add((Component)this.jButtonAdd)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.selection = (TxGroup)this.jListGroups.getSelectedValue();
        if (this.selection == null) {
            JOptionPane.showMessageDialog(this, "No group selected", this.getTitle(), 1);
            return;
        }
        if (this.multiSelection != null) {
            this.multiSelection.addAll(this.jListGroups.getSelectedValuesList());
        }
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        String groupName = JOptionPane.showInputDialog(this, (Object)"Group name: ");
        if (groupName.length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a group name", this.getTitle(), 1);
            return;
        }
        int projID = this.getProj() == null ? 0 : this.getProj();
        try {
            String reason = this.db.isTxGroupNameAllowed(groupName, projID);
            if (reason != null) {
                JOptionPane.showMessageDialog(this, reason, this.getTitle(), 1);
                return;
            }
            TxGroup group = this.db.addTxGroup(groupName, null, -1, projID, Color.BLACK);
            this.model.addElement(group);
            this.jListGroups.setSelectedValue(group, true);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), "Permission Error", 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            this.db.doRollback();
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void jListGroupsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    public TxGroup getSelection() {
        return this.selection;
    }
}

