/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jsbchart.core.ChartManager;
import jsbugs.DialogDBInfo;
import jsbugs.DialogDeleteProject;
import jsbugs.DialogProject;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBRestrictable;
import model3.SBdb;
import model3.project.Project;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogSelectProject
extends JDialog {
    private final SBdb sbdb;
    private final ChartManager chartManager;
    private final DefaultListModel model = new DefaultListModel();
    Project selection = null;
    private final boolean allowAdd;
    private JButton jButtonAbout;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JList jListProjects;
    private JScrollPane jScrollPane1;

    public DialogSelectProject(Frame parent, boolean modal, SBdb sbdb, boolean allowAdd, ChartManager chartManager) throws SQLException, SBException {
        super(parent, modal);
        this.sbdb = sbdb;
        this.chartManager = chartManager;
        this.allowAdd = allowAdd;
        this.initComponents();
        this.init();
    }

    public DialogSelectProject(JDialog parent, boolean modal, SBdb sbdb) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.sbdb = sbdb;
        this.allowAdd = true;
        this.chartManager = null;
        this.initComponents();
        this.init();
    }

    private void update() throws SQLException, SBException {
        Object pSelection = this.jListProjects.getSelectedValue();
        this.model.clear();
        this.initProjectList();
        this.jListProjects.repaint();
        if (pSelection != null) {
            this.jListProjects.setSelectedValue(pSelection, true);
        }
    }

    private void init() throws SQLException {
        this.setTitle("Project : Select");
        this.initProjectList();
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jListProjects.updateUI();
        if (!this.allowAdd) {
            this.jButtonAdd.setEnabled(false);
        }
        if (this.chartManager == null) {
            this.jButtonDelete.setVisible(false);
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            this.jButtonAdd.setEnabled(false);
            this.jButtonEdit.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void initProjectList() {
        try {
            List<Project> projects = this.sbdb.getProjects();
            for (Project p : projects) {
                this.model.addElement(p);
            }
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    public Project getProject() {
        return this.selection;
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListProjects = new JList();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonAbout = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 300));
        this.jButtonAdd.setFont(this.jButtonAdd.getFont());
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProject this$0;
            {
                DialogSelectProject dialogSelectProject = this$0;
                Objects.requireNonNull(dialogSelectProject);
                this.this$0 = dialogSelectProject;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setFont(this.jButtonEdit.getFont());
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProject this$0;
            {
                DialogSelectProject dialogSelectProject = this$0;
                Objects.requireNonNull(dialogSelectProject);
                this.this$0 = dialogSelectProject;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setFont(this.jButtonDelete.getFont());
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProject this$0;
            {
                DialogSelectProject dialogSelectProject = this$0;
                Objects.requireNonNull(dialogSelectProject);
                this.this$0 = dialogSelectProject;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setFont(this.jButtonClose.getFont());
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProject this$0;
            {
                DialogSelectProject dialogSelectProject = this$0;
                Objects.requireNonNull(dialogSelectProject);
                this.this$0 = dialogSelectProject;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jListProjects.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListProjects.setModel(this.model);
        this.jListProjects.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectProject this$0;
            {
                DialogSelectProject dialogSelectProject = this$0;
                Objects.requireNonNull(dialogSelectProject);
                this.this$0 = dialogSelectProject;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListProjectsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListProjects);
        this.jButtonOK.setFont(this.jButtonOK.getFont());
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProject this$0;
            {
                DialogSelectProject dialogSelectProject = this$0;
                Objects.requireNonNull(dialogSelectProject);
                this.this$0 = dialogSelectProject;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setFont(this.jButtonHelp.getFont());
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProject this$0;
            {
                DialogSelectProject dialogSelectProject = this$0;
                Objects.requireNonNull(dialogSelectProject);
                this.this$0 = dialogSelectProject;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonAbout.setText("About...");
        this.jButtonAbout.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProject this$0;
            {
                DialogSelectProject dialogSelectProject = this$0;
                Objects.requireNonNull(dialogSelectProject);
                this.this$0 = dialogSelectProject;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAboutActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 175, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jButtonDelete, -2, 92, -2).add(2, (Component)this.jButtonAdd, -2, 94, -2).add(2, (GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonHelp, -2, 94, -2).add((Component)this.jButtonClose, -2, 94, -2).add((Component)this.jButtonAbout).add((Component)this.jButtonOK, -2, 94, -2)).add(2, (Component)this.jButtonEdit, -2, 94, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAbout, this.jButtonAdd, this.jButtonClose, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 251, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonAbout).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).add(7, 7, 7).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.selection = (Project)((Object)this.jListProjects.getSelectedValue());
        if (this.selection == null) {
            JOptionPane.showMessageDialog(this, "No project selected", this.getTitle(), 0);
            return;
        }
        this.dispose();
    }

    private void jListProjectsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        try {
            Project project = (Project)((Object)this.jListProjects.getSelectedValue());
            if (project == null) {
                JOptionPane.showMessageDialog(this, "No project selected", this.getTitle(), 0);
                return;
            }
            DialogProject dialog = new DialogProject(this, "Project : Edit", project.getName(), project.getDescription(), true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                project.update(this.sbdb, dialog.getProjectName(), dialog.getDescr());
                this.sbdb.commit();
                this.jListProjects.repaint();
            }
        }
        catch (SQLException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogProject dialog = new DialogProject(this, "Project : Add", null, null, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                this.selection = this.sbdb.addProject(dialog.getProjectName(), dialog.getDescr());
                this.sbdb.commit();
                this.dispose();
            }
            catch (InvalidFieldException | SBPermissionException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError(sql, this);
            }
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        Project project = (Project)((Object)this.jListProjects.getSelectedValue());
        if (project == null) {
            JOptionPane.showMessageDialog(this, "No project selected", this.getTitle(), 0);
            return;
        }
        try {
            try {
                this.chartManager.checkProjectDelete(project.getID());
            }
            catch (InvalidFieldException ife) {
                JOptionPane.showMessageDialog(this, "Can't delete project:\n" + ife.getMessage(), this.getTitle(), 2);
                return;
            }
            int nGroups = this.sbdb.getTxGroups(project.getID(), false).size();
            int nSets = this.sbdb.getTxGroupSets(project.getID(), false).size();
            int nCharts = this.chartManager.getnElements("CHART", "chart_id", project.getID());
            int nBlocks = this.chartManager.getnElements("CHTBLOCK", "block_id", project.getID());
            int nPanels = this.chartManager.getnElements("CHTPANL", "panel_id", project.getID());
            int nCorr = this.chartManager.getnElements("CHARTCORR", "corrsch_id", project.getID());
            String delMsg = "Delete project: '" + String.valueOf((Object)project) + "'?\n(This will not delete the project's wells.)";
            if (nGroups > 0 || nSets > 0 || nCharts > 0 || nBlocks > 0 || nPanels > 0 || nCorr > 0) {
                delMsg = delMsg + "\n\n'" + String.valueOf((Object)project) + "' also contains: ";
                delMsg = delMsg + (String)(nGroups > 0 ? "\n" + nGroups + " taxon group" + (nGroups > 1 ? "s" : "") : "");
                delMsg = delMsg + (String)(nSets > 0 ? "\n" + nSets + " group set" + (nSets > 1 ? "s" : "") : "");
                delMsg = delMsg + (String)(nCharts > 0 ? "\n" + nCharts + " chart template" + (nCharts > 1 ? "s" : "") : "");
                delMsg = delMsg + (String)(nBlocks > 0 ? "\n" + nBlocks + " block template" + (nBlocks > 1 ? "s" : "") : "");
                delMsg = delMsg + (String)(nPanels > 0 ? "\n" + nPanels + " panel template" + (nPanels > 1 ? "s" : "") : "");
                delMsg = delMsg + (String)(nCorr > 0 ? "\n" + nCorr + " correlation template" + (nCorr > 1 ? "s" : "") : "");
                delMsg = delMsg + "\n\nThese items can be deleted or made global.\nIf you continue, you will be given an option for each.";
            }
            if (JOptionPane.showConfirmDialog(this, delMsg, this.getTitle(), 0, 3) != 0) {
                return;
            }
            if (nGroups > 0 || nSets > 0 || nCharts > 0 || nBlocks > 0 || nPanels > 0 || nCorr > 0) {
                DialogDeleteProject dialog = new DialogDeleteProject(this, true, nGroups, nSets, nCharts, nBlocks, nPanels, nCorr);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    return;
                }
                ArrayList<String> readOnlyChartElements = new ArrayList<String>();
                if (this.chartManager.getProjectReadOnlyElements(project.getID(), readOnlyChartElements, dialog.deletePanels, dialog.deleteBlocks, dialog.deleteCharts, dialog.deleteCorr)) {
                    Object msg = "As a non Super User, you can't delete these project chart elements, because they are read-only: ";
                    for (String s : readOnlyChartElements) {
                        msg = (String)msg + "\n" + s;
                    }
                    JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                    return;
                }
                try {
                    this.chartManager.deleteProjectDB(project.getID(), dialog.deletePanels, dialog.deleteBlocks, dialog.deleteCharts, dialog.deleteCorr);
                    this.sbdb.deleteProject(project.getID(), dialog.deleteGroups != null ? dialog.deleteGroups : false, dialog.deleteSets != null ? dialog.deleteSets : false);
                    this.chartManager.deleteProjectModel(project.getID(), dialog.deletePanels, dialog.deleteBlocks, dialog.deleteCharts, dialog.deleteCorr);
                }
                catch (InvalidFieldException | SBException e) {
                    this.sbdb.doRollback();
                    JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
                    return;
                }
                catch (RuntimeException re) {
                    this.sbdb.doRollback();
                    StackError.showStackError((String)"Error deleting: ", (Throwable)re);
                    return;
                }
            } else {
                this.sbdb.deleteProject(project.getID(), false, false);
            }
            this.sbdb.commit();
            this.update();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            this.sbdb.doRollback();
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtouseprojects.html");
    }

    private void jButtonAboutActionPerformed(ActionEvent evt) {
        Project project = (Project)((Object)this.jListProjects.getSelectedValue());
        if (project == null) {
            JOptionPane.showMessageDialog(this, "No project selected", this.getTitle(), 0);
            return;
        }
        try {
            DialogDBInfo dialog = new DialogDBInfo((Dialog)this, true, this.sbdb, project.getID());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showStackError("Error getting database info", e, this);
        }
    }

    public Project getSelection() {
        return this.selection;
    }
}

