/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogSample;
import jsbugs.FrameJsbugs;
import jsbugs.SampleLithologyCellRenderer;
import jsbugs.TableModelSamples;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.DepthRenderer;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsOptionToggle;
import util.exception.StackError;

public class DialogSelectSample
extends SBDialog
implements Observer {
    private static Sample lastSelection = null;
    private final Well well;
    private final SBdb db;
    private final TableModelSamples model = new TableModelSamples(true);
    Sample selection = null;
    static boolean toggleOptions = false;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTableSamples;
    private JToggleButton jToggleButton1;

    public DialogSelectSample(Frame parent, boolean modal, SBdb db, Well well, Sample sample, char units) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.db = db;
        this.initComponents();
        this.init(units, sample, false);
    }

    public DialogSelectSample(JDialog parent, boolean modal, SBdb db, Well well, Sample sample, char units, boolean showLOCage) throws SQLException, SBException {
        super((Window)parent, modal);
        this.well = well;
        this.db = db;
        this.initComponents();
        this.init(units, sample, showLOCage);
    }

    TableModelSamples getTableModel() {
        return this.model;
    }

    public Sample getSelection() {
        return this.selection;
    }

    @Override
    public void update(Observable obs, Object obj) {
        boolean update = false;
        if (obs instanceof Well && obs == this.well) {
            update = true;
        } else if (obs instanceof Sample) {
            update = true;
        }
        if (update) {
            this.model.fireTableDataChanged();
        }
    }

    private void init(char units, Sample sample, boolean showLOCage) throws SQLException, SBException {
        this.setTitle("Sample : Select");
        SB.setTableHeaderBold((JTable)this.jTableSamples);
        this.model.setUnits(units);
        this.jTableSamples.setRowSorter(new TableRowSorter<TableModelSamples>(this.model));
        new ColumnSortResetHandler(this.jTableSamples).attach();
        TableColumnModel columnModel = this.jTableSamples.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelSamples.columnHeaders[i]);
            columnModel.getColumn(i).setWidth(this.model.getDefaultColumnWidths()[i]);
        }
        if (showLOCage) {
            columnModel.getColumn(6).setCellRenderer(new ColouredRenderer(false, new Color(220, 220, 220)));
        } else {
            columnModel.getColumn(6).setHeaderValue("");
            columnModel.getColumn(6).setPreferredWidth(0);
            columnModel.getColumn(6).setMinWidth(0);
            columnModel.getColumn(6).setMaxWidth(0);
        }
        this.jTableSamples.getColumnModel().getColumn(2).setCellRenderer(new DepthRenderer());
        this.jTableSamples.getColumnModel().getColumn(0).setCellRenderer(new DepthRenderer());
        DepthRenderer dr = new DepthRenderer();
        dr.setBackground(ColouredRenderer.GREY);
        this.jTableSamples.getColumnModel().getColumn(3).setCellRenderer(dr);
        dr = new DepthRenderer();
        dr.setBackground(ColouredRenderer.GREY);
        this.jTableSamples.getColumnModel().getColumn(1).setCellRenderer(dr);
        this.jTableSamples.setDefaultRenderer(List.class, new SampleLithologyCellRenderer());
        this.model.setSamples(this.well, this);
        if (sample == null && this.model.getSamples().indexOf(lastSelection) >= 0) {
            sample = lastSelection;
        }
        this.model.fireTableDataChanged();
        if (sample != null) {
            int index = this.model.getSamples().indexOf(sample);
            this.jTableSamples.setRowSelectionInterval(index, index);
            if ((index += 10) > this.model.getRowCount() - 1) {
                index = this.model.getRowCount() - 1;
            }
            this.jTableSamples.scrollRectToVisible(this.jTableSamples.getCellRect(index, 0, true));
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
        ((SbugsOptionToggle)this.jToggleButton1).addComponents(toggleOptions, new JComponent[]{this.jButtonAdd, this.jButtonEdit, this.jButtonDelete});
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableSamples = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jToggleButton1 = new SbugsOptionToggle();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.jTableSamples.setModel(this.model);
        this.jTableSamples.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectSample this$0;
            {
                DialogSelectSample dialogSelectSample = this$0;
                Objects.requireNonNull(dialogSelectSample);
                this.this$0 = dialogSelectSample;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableSamplesMouseClicked(evt);
            }
        });
        this.jTableSamples.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSelectSample this$0;
            {
                DialogSelectSample dialogSelectSample = this$0;
                Objects.requireNonNull(dialogSelectSample);
                this.this$0 = dialogSelectSample;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableSamplesKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableSamples);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSample this$0;
            {
                DialogSelectSample dialogSelectSample = this$0;
                Objects.requireNonNull(dialogSelectSample);
                this.this$0 = dialogSelectSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSample this$0;
            {
                DialogSelectSample dialogSelectSample = this$0;
                Objects.requireNonNull(dialogSelectSample);
                this.this$0 = dialogSelectSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSample this$0;
            {
                DialogSelectSample dialogSelectSample = this$0;
                Objects.requireNonNull(dialogSelectSample);
                this.this$0 = dialogSelectSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSample this$0;
            {
                DialogSelectSample dialogSelectSample = this$0;
                Objects.requireNonNull(dialogSelectSample);
                this.this$0 = dialogSelectSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSample this$0;
            {
                DialogSelectSample dialogSelectSample = this$0;
                Objects.requireNonNull(dialogSelectSample);
                this.this$0 = dialogSelectSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSample this$0;
            {
                DialogSelectSample dialogSelectSample = this$0;
                Objects.requireNonNull(dialogSelectSample);
                this.this$0 = dialogSelectSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jToggleButton1.setText(">");
        this.jToggleButton1.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSample this$0;
            {
                DialogSelectSample dialogSelectSample = this$0;
                Objects.requireNonNull(dialogSelectSample);
                this.this$0 = dialogSelectSample;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jToggleButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 356, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK).add(1, (Component)this.jToggleButton1, -2, 40, -2).add(1, (GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonDelete))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToggleButton1).addPreferredGap(0).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 344, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselectsample.html");
    }

    private void jTableSamplesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int row = this.jTableSamples.getSelectedRow();
        if (this.jTableSamples.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one sample from the table, or add one", this.getTitle(), 1);
            return;
        }
        try {
            lastSelection = this.selection = this.model.getSamples().get(this.jTableSamples.convertRowIndexToModel(row));
            toggleOptions = this.jToggleButton1.isSelected();
            this.setOK();
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableSamples.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one sample to edit", this.getTitle(), 1);
            return;
        }
        try {
            Sample selected = this.model.getSamples().get(this.jTableSamples.convertRowIndexToModel(this.jTableSamples.getSelectedRow()));
            DialogSample dialog = new DialogSample((Dialog)((Object)this), true, this.db, this.well, this.model.getUnits(), selected);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.jTableSamples.clearSelection();
                this.model.fireTableDataChanged();
                int index = this.jTableSamples.convertRowIndexToView(this.model.getSamples().indexOf(dialog.sample));
                if (index >= 0) {
                    this.jTableSamples.getSelectionModel().setSelectionInterval(index, index);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogSample dialog = new DialogSample((JDialog)((Object)this), true, this.db, this.well, this.model.getUnits());
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                int index = this.model.getSamples().indexOf(dialog.sample);
                index = this.jTableSamples.convertRowIndexToView(index);
                this.jTableSamples.setRowSelectionInterval(index, index);
            }
            catch (RuntimeException | SQLException | SBException ex) {
                System.out.println("Error getting index of newly added sample: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] selected = this.jTableSamples.getSelectedRows();
        if (selected.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No samples selected", this.getTitle(), 1);
            return;
        }
        LinkedList<Sample> samples = new LinkedList<Sample>();
        try {
            for (int i : selected) {
                samples.add(this.model.getSamples().get(this.jTableSamples.convertRowIndexToModel(i)));
            }
            Object object = samples.iterator();
            while (object.hasNext()) {
                Sample sampleToDelete = (Sample)object.next();
                int dType = this.well.hasSampleIGD(sampleToDelete);
                if (dType == 0) continue;
                String msg = "Can't delete sample '" + String.valueOf(sampleToDelete) + "' because of associated interpreted data, which should be deleted first.\nData type: " + SBdb.dTypeNames[dType];
                JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 1);
                return;
            }
            if (JOptionPane.showConfirmDialog((Component)((Object)this), "Really delete " + (samples.size() > 1 ? "these " : "this ") + samples.size() + (samples.size() > 1 ? " samples?" : " sample?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
            this.well.deleteSamples(samples);
            this.well.notifyObservers();
            this.jTableSamples.clearSelection();
            if (this.db.isConnected()) {
                this.db.commit();
            }
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void jTableSamplesKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 127) {
            this.jButtonDeleteActionPerformed(null);
        }
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
    }

    public void hideSamples(List<Sample> samplesToHide) {
        this.model.hideSamples(samplesToHide);
    }
}

