/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.model3.well.analysis.SpeciesTypeService;
import com.stratadata.util.ui.HelpUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;

public class DialogSpecType
extends JDialog {
    private final DefaultListModel model = new DefaultListModel();
    private final SBdb db;
    private final SpeciesTypeService speciesTypeService;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonInfo;
    private JList jListSpecType;
    private JScrollPane jScrollPane1;

    public DialogSpecType(Frame parent, boolean modal, SBdb db) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.speciesTypeService = db.getSpeciesTypeService();
        this.initComponents();
        this.init();
        this.setTitle("Species Sub-Types");
    }

    private void init() {
        this.model.clear();
        this.model.addAll(this.speciesTypeService.getAllSpeciesTypes());
        this.jListSpecType.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListSpecType = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonInfo = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 250));
        this.jListSpecType.setModel(this.model);
        this.jListSpecType.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jListSpecType);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSpecType this$0;
            {
                DialogSpecType dialogSpecType = this$0;
                Objects.requireNonNull(dialogSpecType);
                this.this$0 = dialogSpecType;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSpecType this$0;
            {
                DialogSpecType dialogSpecType = this$0;
                Objects.requireNonNull(dialogSpecType);
                this.this$0 = dialogSpecType;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSpecType this$0;
            {
                DialogSpecType dialogSpecType = this$0;
                Objects.requireNonNull(dialogSpecType);
                this.this$0 = dialogSpecType;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSpecType this$0;
            {
                DialogSpecType dialogSpecType = this$0;
                Objects.requireNonNull(dialogSpecType);
                this.this$0 = dialogSpecType;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSpecType this$0;
            {
                DialogSpecType dialogSpecType = this$0;
                Objects.requireNonNull(dialogSpecType);
                this.this$0 = dialogSpecType;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonInfo.setText("Info...");
        this.jButtonInfo.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSpecType this$0;
            {
                DialogSpecType dialogSpecType = this$0;
                Objects.requireNonNull(dialogSpecType);
                this.this$0 = dialogSpecType;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInfoActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 279, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAdd).addComponent(this.jButtonEdit).addComponent(this.jButtonHelp).addComponent(this.jButtonClose).addComponent(this.jButtonDelete)).addComponent(this.jButtonInfo)).addContainerGap()));
        layout.linkSize(0, this.jButtonAdd, this.jButtonClose, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp, this.jButtonInfo);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addGap(7, 7, 7).addComponent(this.jButtonInfo).addGap(18, 18, 18).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 103, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 278, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogspectype.html");
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            String newType = JOptionPane.showInputDialog(this, "Enter new species sub-type: ", null);
            if (newType != null) {
                while (this.speciesTypeService.findSpeciesType(newType).isPresent()) {
                    if (!StringUtils.isBlank((CharSequence)(newType = JOptionPane.showInputDialog(this, "Sub-type already exists, re-enter: ", newType)))) continue;
                    return;
                }
                SpeciesType added = this.speciesTypeService.getAddSpeciesType(newType);
                this.init();
                this.jListSpecType.setSelectedValue(added, true);
            }
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        SpeciesType specType = (SpeciesType)this.jListSpecType.getSelectedValue();
        if (specType == null) {
            JOptionPane.showMessageDialog(this, "No type selected", this.getTitle(), 1);
            return;
        }
        try {
            int[] nOccs = this.db.getSpecTypeUsage(specType.specTypeID());
            if ((nOccs[0] > 0 || nOccs[1] > 0) && JOptionPane.showConfirmDialog(this, "Warning: " + this.getUsageMessage(nOccs) + ".\nContinue edit?", this.getTitle(), 0, 3) != 0) {
                return;
            }
            String newTypeString = specType.description();
            while (this.speciesTypeService.findSpeciesType(newTypeString).isPresent()) {
                newTypeString = JOptionPane.showInputDialog(this, "Species sub type: ", specType);
                if (StringUtils.isBlank((CharSequence)newTypeString)) {
                    return;
                }
                if (newTypeString.equals(specType.description())) {
                    return;
                }
                while (this.speciesTypeService.findSpeciesType(newTypeString).isPresent()) {
                    if (StringUtils.isBlank((CharSequence)(newTypeString = JOptionPane.showInputDialog(this, "Sub-type already exists, re-enter: ", newTypeString)))) {
                        return;
                    }
                    if (!newTypeString.equals(specType.description())) continue;
                    return;
                }
            }
            SpeciesType updatedSpeciesType = this.speciesTypeService.updateSpeciesTypeDescription(specType.specTypeID(), newTypeString);
            this.init();
            this.jListSpecType.setSelectedValue(updatedSpeciesType, true);
        }
        catch (RuntimeException | SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void jButtonInfoActionPerformed(ActionEvent evt) {
        SpeciesType specType = (SpeciesType)this.jListSpecType.getSelectedValue();
        if (specType == null) {
            JOptionPane.showMessageDialog(this, "No type selected", this.getTitle(), 1);
            return;
        }
        try {
            if (specType.specTypeID() > 0) {
                int[] nOccs = this.db.getSpecTypeUsage(specType.specTypeID());
                JOptionPane.showMessageDialog(this, this.getUsageMessage(nOccs) + ".", this.getTitle(), 3);
            } else {
                JOptionPane.showMessageDialog(this, "This is the default setting.", this.getTitle(), 3);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        SpeciesType specType = (SpeciesType)this.jListSpecType.getSelectedValue();
        if (specType == null) {
            JOptionPane.showMessageDialog(this, "No type selected", this.getTitle(), 1);
            return;
        }
        try {
            if (specType.specTypeID() == 0) {
                JOptionPane.showMessageDialog(this, "You can't delete the default setting.", this.getTitle(), 1);
                return;
            }
            int[] nOccs = this.db.getSpecTypeUsage(specType.specTypeID());
            if (nOccs[0] > 0 || nOccs[1] > 0) {
                String msg = this.getUsageMessage(nOccs) + ", and can't be deleted.";
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
                return;
            }
            this.speciesTypeService.deleteSpeciesType(specType);
            this.init();
            this.jListSpecType.clearSelection();
        }
        catch (RuntimeException | SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private String getUsageMessage(int[] nOccs) {
        Object msg = "";
        if (nOccs[0] > 0 || nOccs[1] > 0) {
            if (nOccs[0] > 0) {
                msg = (String)msg + nOccs[0] + " occurrence" + (nOccs[0] > 1 ? "s" : "");
            }
            if (nOccs[1] > 0) {
                msg = (String)msg + (((String)msg).isEmpty() ? "" : " and ") + nOccs[1] + " chart panel template" + (nOccs[1] > 1 ? "s" : "");
            }
            return "This sub-type is used by " + (String)msg;
        }
        return "This sub-type is not used.";
    }
}

