/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.WellDatum;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.DialogTVDHeader;
import jsbugs.DialogTVDReader;
import jsbugs.FrameJsbugs;
import model3.Lastval;
import model3.TVDList;
import model3.TVDepth;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogTVD
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(DialogTVD.class.getName());
    Well well;
    char units;
    TVDTableModel modelActual = new TVDTableModel();
    TVDTableModel modelPlanned = new TVDTableModel();
    String headerActual = null;
    boolean TVDSSactual = false;
    String headerPlanned = null;
    boolean TVDSSplanned = false;
    boolean isPlan = false;
    private ButtonGroup buttonGroupCalc;
    private ButtonGroup buttonGroupPlan;
    private JButton jButtonAddRows;
    private JButton jButtonCalc;
    private JButton jButtonCalcCancel;
    private JButton jButtonCalcOK;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonHeader;
    private JButton jButtonHelp;
    private JButton jButtonInsertRow;
    private JButton jButtonOK;
    private JButton jButtonRead;
    private JButton jButtonSelectAll;
    private JDialog jDialogTVDCalc;
    private JLabel jLabel1;
    private JLabel jLabelUnits;
    private JRadioButton jRadioButtonActual;
    private JRadioButton jRadioButtonCalc1;
    private JRadioButton jRadioButtonCalc2;
    private JRadioButton jRadioButtonCalc3;
    private JRadioButton jRadioButtonCalc4;
    private JRadioButton jRadioButtonPlanned;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableTVD;

    public DialogTVD(Frame parent, boolean modal, Well well, char units) throws SQLException {
        super(parent, modal);
        this.well = well;
        this.units = units;
        this.initComponents();
        this.init();
    }

    public DialogTVD(JDialog parent, boolean modal, Well well, char units) throws SQLException {
        super((Dialog)parent, modal);
        this.well = well;
        this.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Deviation Survey : Edit");
        SB.setTableHeaderBold((JTable)this.jTableTVD);
        this.jLabelUnits.setText("Depth units are : " + DepthUnits.getUnits((char)this.units).getFullName());
        if (!this.well.getDataModel().hasTVDplan()) {
            this.jRadioButtonActual.setEnabled(false);
            this.jRadioButtonActual.setSelected(true);
            this.jRadioButtonPlanned.setEnabled(false);
        } else {
            this.jRadioButtonActual.setSelected(true);
            this.modelPlanned.load(this.well.getTVDlist(true), this.units);
            this.headerPlanned = this.well.getTVDlist(true).getHeaderText();
            this.TVDSSplanned = this.well.getTVDlist(true).isIsTVDSS();
        }
        this.modelActual.load(this.well.getTVDlist(false), this.units);
        this.headerActual = this.well.getTVDlist(false).getHeaderText();
        this.TVDSSactual = this.well.getTVDlist(false).isIsTVDSS();
        this.modelActual.fireTableDataChanged();
        if (!this.well.canWrite(this.well.getDataModel(), null)) {
            this.jButtonRead.setEnabled(false);
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.well.getDataModel(), "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void initComponents() {
        this.buttonGroupPlan = new ButtonGroup();
        this.jDialogTVDCalc = new JDialog();
        this.jButtonCalcOK = new JButton();
        this.jButtonCalcCancel = new JButton();
        this.jRadioButtonCalc4 = new JRadioButton();
        this.jRadioButtonCalc3 = new JRadioButton();
        this.jRadioButtonCalc2 = new JRadioButton();
        this.jRadioButtonCalc1 = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.buttonGroupCalc = new ButtonGroup();
        this.jButtonRead = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonSelectAll = new JButton();
        this.jButtonInsertRow = new JButton();
        this.jButtonAddRows = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableTVD = new JTable();
        this.jButtonHelp = new JButton();
        this.jButtonCalc = new JButton();
        this.jLabelUnits = new JLabel();
        this.jButtonHeader = new JButton();
        this.jRadioButtonActual = new JRadioButton();
        this.jRadioButtonPlanned = new JRadioButton();
        this.jDialogTVDCalc.setModal(true);
        this.jDialogTVDCalc.setResizable(false);
        this.jButtonCalcOK.setText("OK");
        this.jButtonCalcOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCalcOKActionPerformed(evt);
            }
        });
        this.jButtonCalcCancel.setText("Cancel");
        this.jButtonCalcCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCalcCancelActionPerformed(evt);
            }
        });
        this.buttonGroupCalc.add(this.jRadioButtonCalc4);
        this.jRadioButtonCalc4.setText("North & East offsets from Azimuth & Horizontal Length");
        this.buttonGroupCalc.add(this.jRadioButtonCalc3);
        this.jRadioButtonCalc3.setText("Horizontal Length from Inclination");
        this.buttonGroupCalc.add(this.jRadioButtonCalc2);
        this.jRadioButtonCalc2.setText("Horizontal Length from TVD");
        this.buttonGroupCalc.add(this.jRadioButtonCalc1);
        this.jRadioButtonCalc1.setText("TVD from Inclination");
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1));
        this.jLabel1.setText("Calculate:");
        GroupLayout jDialogTVDCalcLayout = new GroupLayout(this.jDialogTVDCalc.getContentPane());
        this.jDialogTVDCalc.getContentPane().setLayout((LayoutManager)jDialogTVDCalcLayout);
        jDialogTVDCalcLayout.setHorizontalGroup((GroupLayout.Group)jDialogTVDCalcLayout.createParallelGroup(1).add((GroupLayout.Group)jDialogTVDCalcLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jDialogTVDCalcLayout.createParallelGroup(2).add(1, (Component)this.jSeparator1).add(1, (GroupLayout.Group)jDialogTVDCalcLayout.createParallelGroup(1, false).add((Component)this.jRadioButtonCalc4, -1, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonCalc3).add((Component)this.jRadioButtonCalc2).add((GroupLayout.Group)jDialogTVDCalcLayout.createSequentialGroup().add((GroupLayout.Group)jDialogTVDCalcLayout.createParallelGroup(2).add((GroupLayout.Group)jDialogTVDCalcLayout.createSequentialGroup().add((Component)this.jRadioButtonCalc1).addPreferredGap(0, -1, Short.MAX_VALUE)).add((GroupLayout.Group)jDialogTVDCalcLayout.createSequentialGroup().add((Component)this.jButtonCalcOK).addPreferredGap(0))).add((Component)this.jButtonCalcCancel)).add((Component)this.jLabel1))).addContainerGap(-1, Short.MAX_VALUE)));
        jDialogTVDCalcLayout.linkSize(new Component[]{this.jButtonCalcCancel, this.jButtonCalcOK}, 1);
        jDialogTVDCalcLayout.setVerticalGroup((GroupLayout.Group)jDialogTVDCalcLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jDialogTVDCalcLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(1).add((Component)this.jRadioButtonCalc1).addPreferredGap(1).add((Component)this.jRadioButtonCalc2).addPreferredGap(1).add((Component)this.jRadioButtonCalc3).addPreferredGap(1).add((Component)this.jRadioButtonCalc4).add(9, 9, 9).add((Component)this.jSeparator1, -2, 5, -2).addPreferredGap(0).add((GroupLayout.Group)jDialogTVDCalcLayout.createParallelGroup(3).add((Component)this.jButtonCalcCancel).add((Component)this.jButtonCalcOK)).addContainerGap()));
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 400));
        this.jButtonRead.setText("Read...");
        this.jButtonRead.setToolTipText("Read deviation survey from file");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonSelectAll.setText("Select All");
        this.jButtonSelectAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonInsertRow.setText("Insert Row");
        this.jButtonInsertRow.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonInsertRow.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertRowActionPerformed(evt);
            }
        });
        this.jButtonAddRows.setText("Add Rows...");
        this.jButtonAddRows.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonAddRows.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddRowsActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jTableTVD.setModel(this.modelActual);
        this.jTableTVD.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jTableTVDKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableTVD);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCalc.setText("Calculate...");
        this.jButtonCalc.setToolTipText("Calculate values for empty columns");
        this.jButtonCalc.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCalc.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCalcActionPerformed(evt);
            }
        });
        this.jLabelUnits.setFont(this.jLabelUnits.getFont().deriveFont(this.jLabelUnits.getFont().getStyle() | 1));
        this.jLabelUnits.setText("Depth units are : Metres");
        this.jButtonHeader.setText("Header...");
        this.jButtonHeader.setToolTipText("Edit stored header information");
        this.jButtonHeader.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHeaderActionPerformed(evt);
            }
        });
        this.buttonGroupPlan.add(this.jRadioButtonActual);
        this.jRadioButtonActual.setText("Actual");
        this.jRadioButtonActual.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonActualActionPerformed(evt);
            }
        });
        this.buttonGroupPlan.add(this.jRadioButtonPlanned);
        this.jRadioButtonPlanned.setText("Planned");
        this.jRadioButtonPlanned.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTVD this$0;
            {
                DialogTVD dialogTVD = this$0;
                Objects.requireNonNull(dialogTVD);
                this.this$0 = dialogTVD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPlannedActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelUnits).addPreferredGap(0, 183, Short.MAX_VALUE).add((Component)this.jRadioButtonActual).addPreferredGap(1).add((Component)this.jRadioButtonPlanned)).add((Component)this.jScrollPane1, -1, 464, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonRead, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAll, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddRows, -2, 0, Short.MAX_VALUE).add(1, (Component)this.jButtonInsertRow, -2, 83, -2).add((Component)this.jButtonHeader, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonCalc, -2, 83, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAddRows, this.jButtonCalc, this.jButtonDelete, this.jButtonHeader, this.jButtonInsertRow, this.jButtonRead, this.jButtonSelectAll}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelUnits).add((Component)this.jRadioButtonPlanned).add((Component)this.jRadioButtonActual)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonRead).addPreferredGap(0).add((Component)this.jButtonAddRows).add(8, 8, 8).add((Component)this.jButtonInsertRow).addPreferredGap(0).add((Component)this.jButtonSelectAll).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonCalc).addPreferredGap(0).add((Component)this.jButtonHeader).addPreferredGap(0, 96, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 376, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAddRows, this.jButtonCalc, this.jButtonDelete, this.jButtonHeader, this.jButtonInsertRow, this.jButtonRead, this.jButtonSelectAll}, 2);
        this.pack();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        TVDTableModel model = this.isPlan ? this.modelPlanned : this.modelActual;
        int[] exclusions = this.jTableTVD.getSelectedRows();
        if (exclusions.length == 0) {
            JOptionPane.showMessageDialog(this, "Select rows to delete");
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Really delete " + (exclusions.length > 1 ? "these " : "this ") + exclusions.length + (exclusions.length > 1 ? " rows?" : " row?"), this.getTitle(), 0, 3) != 0) {
            return;
        }
        int newSize = model.rowCount - exclusions.length;
        Double[] newDepth = new Double[newSize];
        Double[] newTVD = new Double[newSize];
        Double[] newInclination = new Double[newSize];
        Double[] newAzumith = new Double[newSize];
        Double[] newvs = new Double[newSize];
        Double[] newnorth = new Double[newSize];
        Double[] neweast = new Double[newSize];
        for (int i = 0; i < exclusions.length; ++i) {
            model.depth[exclusions[i]] = null;
        }
        int j = 0;
        for (int i = 0; i < model.rowCount; ++i) {
            if (model.depth[i] == null) continue;
            newDepth[j] = model.depth[i];
            newTVD[j] = model.tvd[i];
            newInclination[j] = model.inclination[i];
            newAzumith[j] = model.azimuth[i];
            newvs[j] = model.vs[i];
            newnorth[j] = model.north[i];
            neweast[j] = model.east[i];
            ++j;
        }
        model.depth = newDepth;
        model.tvd = newTVD;
        model.azimuth = newAzumith;
        model.vs = newvs;
        model.north = newnorth;
        model.east = neweast;
        model.rowCount = newDepth.length;
        model.isDirty = true;
        this.jTableTVD.clearSelection();
        model.fireTableDataChanged();
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jTableTVD.selectAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonReadActionPerformed(ActionEvent evt) {
        String sFilter;
        TVDTableModel model = this.isPlan ? this.modelPlanned : this.modelActual;
        boolean clearValues = true;
        if (model.rowCount > 0) {
            Object[] buttons = new String[]{"Clear values", "Continue anyway", "Cancel"};
            int opt = JOptionPane.showOptionDialog(this, "The current entries should be cleared.\nIf not, new values will be added at end.", this.getTitle(), 1, 3, null, buttons, null);
            if (opt == 2) {
                return;
            }
            if (opt == 1) {
                clearValues = false;
            }
        }
        if ((sFilter = JOptionPane.showInputDialog(this, "Enter depth filter value\n(reduces the number of stored values to improve performance)\n\nSuccessive records within the current depth + filter value will be skipped.\nA value of 10 will read values at least 10 m/ft apart.", 1.0)) == null) {
            return;
        }
        Double depthFilter = Double.parseDouble(sFilter);
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.well.getDataModel(), "WINTVDIMP", "UNXTVDIMP"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                DialogTVDReader dialog = new DialogTVDReader(this, true, file);
                dialog.setLocationRelativeTo(this);
                this.setCursor(Cursor.getDefaultCursor());
                dialog.setVisible(true);
                if (dialog.isOK) {
                    String buff;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    file = dialog.file;
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    String header = dialog.header;
                    boolean inHeader = header != null && !header.isEmpty();
                    double lastDepth = -100.0;
                    LinkedList<TVDepth> values = new LinkedList<TVDepth>();
                    block11: while ((buff = in.readLine()) != null) {
                        if (inHeader && header.contains(buff)) continue;
                        inHeader = false;
                        StringTokenizer tok = new StringTokenizer(buff, " ,;\t");
                        if (tok.countTokens() != dialog.nColumns) continue;
                        try {
                            double[] tokvalues = new double[dialog.nColumns];
                            int nTok = 0;
                            while (tok.hasMoreTokens()) {
                                try {
                                    double valueRead = Double.parseDouble(tok.nextToken());
                                    if (dialog.useCol(nTok + 1) && valueRead >= -999.99 && valueRead <= -999.0) continue block11;
                                    tokvalues[nTok++] = valueRead;
                                }
                                catch (NumberFormatException e) {
                                    if (dialog.useCol(nTok)) {
                                        throw e;
                                    }
                                    LOGGER.log(Level.FINE, "Ignored number format exception in unused column: " + e.getMessage());
                                }
                            }
                            double depth1 = tokvalues[dialog.depCol - 1];
                            double tvd = 0.0;
                            if (dialog.tvdCol > 0) {
                                tvd = tokvalues[dialog.tvdCol - 1];
                            }
                            Float incl = null;
                            if (dialog.inclCol > 0) {
                                incl = Float.valueOf(Double.valueOf(tokvalues[dialog.inclCol - 1]).floatValue());
                            }
                            Float az = null;
                            if (dialog.azCol > 0) {
                                az = Float.valueOf(Double.valueOf(tokvalues[dialog.azCol - 1]).floatValue());
                            }
                            Double vs = null;
                            if (dialog.vsCol > 0) {
                                vs = tokvalues[dialog.vsCol - 1];
                            }
                            Double north = null;
                            if (dialog.northCol > 0) {
                                north = tokvalues[dialog.northCol - 1];
                            }
                            Double east = null;
                            if (dialog.eastCol > 0) {
                                east = tokvalues[dialog.eastCol - 1];
                            }
                            if (!(depth1 - lastDepth > depthFilter)) continue;
                            values.add(new TVDepth(depth1, tvd, incl, az, vs, north, east));
                            lastDepth = depth1;
                        }
                        catch (Exception sbe) {
                            int opt = JOptionPane.showConfirmDialog(this, "Error inserting values for row: " + buff + "\n" + sbe.getMessage() + "\nContinue import?", "Error", 0, 3);
                            if (opt == 1) break;
                            System.out.println("Error inserting values for row: " + buff + "\n" + sbe.getMessage());
                        }
                    }
                    int initialRow = 0;
                    if (!clearValues) {
                        initialRow = model.rowCount;
                        this.resizeTable(model, values.size());
                    } else {
                        model.setSize(values.size());
                    }
                    for (int i = 0; i < values.size(); ++i) {
                        TVDepth tvd = (TVDepth)values.get(i);
                        int row = initialRow + i;
                        model.setValueAt(tvd.getDDepth(), row, 0);
                        model.setValueAt(tvd.getTVDepth(), row, 1);
                        if (tvd.getInclination() != null) {
                            model.setValueAt(tvd.getInclination().floatValue(), row, 2);
                        }
                        if (tvd.getAzumith() != null) {
                            model.setValueAt(tvd.getAzumith().floatValue(), row, 3);
                        }
                        if (tvd.getVS() != null) {
                            model.setValueAt(tvd.getVS(), row, 4);
                        }
                        if (tvd.getNorth() != null) {
                            model.setValueAt(tvd.getNorth(), row, 5);
                        }
                        if (tvd.getEast() == null) continue;
                        model.setValueAt(tvd.getEast(), row, 6);
                    }
                    this.jTableTVD.clearSelection();
                    model.fireTableDataChanged();
                    Lastval.putString(this.well.getDataModel(), "WINTVDIMP", "UNXTVDIMP", file.getPath());
                    this.well.getDataModel().commit();
                    if (header != null && !header.isEmpty()) {
                        boolean replaceHeader = true;
                        if (this.isPlan) {
                            if (this.headerPlanned != null && !this.headerPlanned.isEmpty() && JOptionPane.showConfirmDialog(this, "Replace header?", this.getTitle(), 0, 3) != 0) {
                                replaceHeader = false;
                            }
                            if (replaceHeader) {
                                this.headerPlanned = dialog.header;
                                this.TVDSSplanned = dialog.TVDSS;
                            }
                        } else {
                            if (this.headerActual != null && !this.headerActual.isEmpty() && JOptionPane.showConfirmDialog(this, "Replace header?", this.getTitle(), 0, 3) != 0) {
                                replaceHeader = false;
                            }
                            if (replaceHeader) {
                                this.headerActual = dialog.header;
                                this.TVDSSactual = dialog.TVDSS;
                            }
                        }
                    }
                }
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void jButtonInsertRowActionPerformed(ActionEvent evt) {
        int i;
        if (this.jTableTVD.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Select a row insertion point.");
            return;
        }
        int insertionPoint = this.jTableTVD.getSelectedRow();
        TVDTableModel model = this.isPlan ? this.modelPlanned : this.modelActual;
        Double[] oldDepth = model.depth;
        Double[] oldTvd = model.tvd;
        Double[] oldIncl = model.inclination;
        Double[] oldAz = model.azimuth;
        Double[] oldVs = model.vs;
        Double[] oldN = model.north;
        Double[] oldE = model.east;
        model.setSize(model.rowCount + 1);
        for (i = 0; i < insertionPoint; ++i) {
            model.depth[i] = oldDepth[i];
            model.tvd[i] = oldTvd[i];
            model.inclination[i] = oldIncl[i];
            model.azimuth[i] = oldAz[i];
            model.vs[i] = oldVs[i];
            model.north[i] = oldN[i];
            model.east[i] = oldE[i];
        }
        for (i = insertionPoint + 1; i < model.rowCount; ++i) {
            model.depth[i] = oldDepth[i - 1];
            model.tvd[i] = oldTvd[i - 1];
            model.inclination[i] = oldIncl[i - 1];
            model.azimuth[i] = oldAz[i - 1];
            model.vs[i] = oldVs[i - 1];
            model.north[i] = oldN[i - 1];
            model.east[i] = oldE[i - 1];
        }
        model.isDirty = true;
        this.jTableTVD.clearSelection();
        model.fireTableDataChanged();
    }

    private void jButtonAddRowsActionPerformed(ActionEvent evt) {
        TVDTableModel model = this.isPlan ? this.modelPlanned : this.modelActual;
        try {
            String rows = JOptionPane.showInputDialog(this, "Enter number of rows to add", 1);
            if (rows != null) {
                int nRows = Integer.parseInt(rows);
                this.resizeTable(model, nRows);
                this.jTableTVD.clearSelection();
                model.fireTableDataChanged();
                this.jTableTVD.setRowSelectionInterval(model.rowCount - nRows, model.rowCount - 1);
                this.jScrollPane1.getViewport().setViewPosition(new Point(0, this.jTableTVD.getBounds().getSize().height));
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private boolean saveData() throws SBException, SQLException {
        int opt;
        int saveThreshold = 10000;
        if (this.modelActual.isDirty) {
            if (this.modelActual.rowCount > saveThreshold && ((opt = JOptionPane.showConfirmDialog(this, "There are over " + saveThreshold + " values, which will take a long time to store and plot. Consider using a depth filter to re-read the data.\nDo you want to continue to save?", this.getTitle(), 1, 3)) == 1 || opt == 2 || opt == -1)) {
                return false;
            }
            this.saveData(this.modelActual, this.headerActual, this.TVDSSactual, false);
        }
        if (this.modelPlanned != null && this.modelPlanned.isDirty) {
            if (this.modelPlanned.rowCount > saveThreshold && ((opt = JOptionPane.showConfirmDialog(this, "There are over " + saveThreshold + " values, which will take a long time to store and plot. Consider using a depth filter to re-read the data.\nDo you want to continue to save?", this.getTitle(), 1, 3)) == 1 || opt == 2 || opt == -1)) {
                return false;
            }
            this.saveData(this.modelPlanned, this.headerPlanned, this.TVDSSplanned, true);
        }
        return true;
    }

    private void resizeTable(TVDTableModel model, int nRows) {
        Double[] oldDepth = model.depth;
        Double[] oldTvd = model.tvd;
        Double[] oldIncl = model.inclination;
        Double[] oldAz = model.azimuth;
        Double[] oldVs = model.vs;
        Double[] oldN = model.north;
        Double[] oldE = model.east;
        model.setSize(model.rowCount + nRows);
        for (int i = 0; i < oldDepth.length; ++i) {
            model.depth[i] = oldDepth[i];
            model.tvd[i] = oldTvd[i];
            model.inclination[i] = oldIncl[i];
            model.azimuth[i] = oldAz[i];
            model.vs[i] = oldVs[i];
            model.north[i] = oldN[i];
            model.east[i] = oldE[i];
        }
    }

    private void saveData(TVDTableModel model, String header, boolean TVDSS, boolean isPlan) throws SBException, SQLException {
        TVDList newList = new TVDList(this.well.getDataModel(), isPlan);
        model.save(newList);
        if (header != null) {
            newList.setHeader(header, TVDSS ? WellDatum.SEA_LEVEL.getDbInt() : WellDatum.ROTARY_TABLE.getDbInt());
        }
        newList.store(this.well.getWellID());
        this.well.getDataModel().commit();
        this.well.getTVDlist(isPlan).setHeader(header, TVDSS ? WellDatum.SEA_LEVEL.getDbInt() : WellDatum.ROTARY_TABLE.getDbInt());
        model.save(this.well.getTVDlist(isPlan));
        this.well.getTVDlist(isPlan).notifyObservers();
        this.well.setDataChanged();
        this.well.notifyObservers((Object)this.well.getTVDlist(isPlan));
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.saveData()) {
                this.dispose();
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.well.getDataModel());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtvd.html");
    }

    private void jButtonCalcActionPerformed(ActionEvent evt) {
        this.jDialogTVDCalc.setLocationRelativeTo(this);
        this.jDialogTVDCalc.pack();
        this.jDialogTVDCalc.setVisible(true);
    }

    private void jButtonHeaderActionPerformed(ActionEvent evt) {
        DialogTVDHeader dialog = new DialogTVDHeader(this, true, this.isPlan ? this.headerPlanned : this.headerActual, this.isPlan ? this.TVDSSplanned : this.TVDSSactual);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            if (this.isPlan) {
                if (!dialog.getHeader().equals(this.headerPlanned)) {
                    this.headerPlanned = dialog.getHeader();
                    this.modelPlanned.isDirty = true;
                }
                if (this.TVDSSplanned != dialog.getTVDSS()) {
                    this.TVDSSplanned = dialog.getTVDSS();
                    this.modelPlanned.isDirty = true;
                }
            } else {
                if (!dialog.getHeader().equals(this.headerActual)) {
                    this.headerActual = dialog.getHeader();
                    this.modelActual.isDirty = true;
                }
                if (this.TVDSSactual != dialog.getTVDSS()) {
                    this.TVDSSactual = dialog.getTVDSS();
                    this.modelActual.isDirty = true;
                }
            }
        }
    }

    private void jTableTVDKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 127) {
            this.jButtonDeleteActionPerformed(null);
        }
    }

    private void jRadioButtonActualActionPerformed(ActionEvent evt) {
        if (this.isPlan) {
            this.isPlan = false;
            this.jTableTVD.setModel(this.modelActual);
            this.modelActual.fireTableDataChanged();
        }
    }

    private void jRadioButtonPlannedActionPerformed(ActionEvent evt) {
        if (!this.isPlan) {
            this.isPlan = true;
            this.jTableTVD.setModel(this.modelPlanned);
            this.modelActual.fireTableDataChanged();
        }
    }

    private void jButtonCalcOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupCalc.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "No selection", this.getTitle(), 2);
            return;
        }
        TVDTableModel model = this.isPlan ? this.modelPlanned : this.modelActual;
        try {
            int[] selectedRows = null;
            if (this.jTableTVD.getSelectedRowCount() > 0) {
                int opt = JOptionPane.showConfirmDialog(this, "Restrict calculation to selected rows only?", this.getTitle(), 1, 3);
                if (opt == 2 || opt == -1) {
                    return;
                }
                if (opt == 0) {
                    selectedRows = this.jTableTVD.getSelectedRows();
                }
            }
            if (this.jRadioButtonCalc1.isSelected()) {
                model.calcTVDVS("TVD", this, selectedRows);
            } else if (this.jRadioButtonCalc2.isSelected()) {
                model.calcVS(this, selectedRows);
            } else if (this.jRadioButtonCalc3.isSelected()) {
                model.calcTVDVS("VS", this, selectedRows);
            } else if (this.jRadioButtonCalc4.isSelected()) {
                model.calcNE(this, selectedRows);
            }
            model.isDirty = true;
        }
        catch (RuntimeException ex) {
            JOptionPane.showMessageDialog(this, "There was an error in the calculation. Check values", this.getTitle(), 2);
            ex.printStackTrace();
        }
        model.fireTableDataChanged();
        this.jDialogTVDCalc.setVisible(false);
    }

    private void jButtonCalcCancelActionPerformed(ActionEvent evt) {
        this.jDialogTVDCalc.setVisible(false);
    }

    private static class TVDTableModel
    extends AbstractTableModel {
        Double[] depth;
        Double[] tvd;
        Double[] inclination;
        Double[] azimuth;
        Double[] vs;
        Double[] north;
        Double[] east;
        static final String[] colTitles = new String[]{"Depth", "TVD", "Inclination", "Azimuth", "Horizontal Length", "North", "East"};
        static final int COL_DEPTH = 0;
        static final int COL_TVD = 1;
        static final int COL_INCL = 2;
        static final int COL_AZ = 3;
        static final int COL_VS = 4;
        static final int COL_NORTH = 5;
        static final int COL_EAST = 6;
        char units;
        boolean isDirty = false;
        int rowCount = 0;

        private TVDTableModel() {
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public String getColumnName(int col) {
            return colTitles[col];
        }

        public void setSize(int i) {
            this.depth = new Double[i];
            this.tvd = new Double[i];
            this.inclination = new Double[i];
            this.azimuth = new Double[i];
            this.vs = new Double[i];
            this.north = new Double[i];
            this.east = new Double[i];
            this.rowCount = i;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    if (this.depth[row] == null) {
                        return "";
                    }
                    return SB.floatString((double)this.depth[row], (int)2);
                }
                case 1: {
                    if (this.tvd[row] == null) {
                        return "";
                    }
                    return SB.floatString((double)this.tvd[row], (int)2);
                }
                case 2: {
                    if (this.inclination[row] == null) {
                        return "";
                    }
                    return SB.floatString((double)this.inclination[row], (int)2);
                }
                case 3: {
                    if (this.azimuth[row] == null) {
                        return "";
                    }
                    return SB.floatString((double)this.azimuth[row], (int)2);
                }
                case 4: {
                    if (this.vs[row] == null) {
                        return "";
                    }
                    return SB.floatString((double)this.vs[row], (int)2);
                }
                case 5: {
                    if (this.north[row] == null) {
                        return "";
                    }
                    return SB.floatString((double)this.north[row], (int)2);
                }
                case 6: {
                    if (this.east[row] == null) {
                        return "";
                    }
                    return SB.floatString((double)this.east[row], (int)2);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            try {
                if (obj.getClass().getName().contains("String")) {
                    obj = Double.parseDouble((String)obj);
                }
                switch (col) {
                    case 0: {
                        this.depth[row] = (Double)obj;
                        break;
                    }
                    case 1: {
                        this.tvd[row] = (Double)obj;
                        break;
                    }
                    case 3: {
                        this.azimuth[row] = (Double)obj;
                        break;
                    }
                    case 4: {
                        this.vs[row] = (Double)obj;
                        break;
                    }
                    case 2: {
                        this.inclination[row] = (Double)obj;
                        break;
                    }
                    case 5: {
                        this.north[row] = (Double)obj;
                        break;
                    }
                    case 6: {
                        this.east[row] = (Double)obj;
                        break;
                    }
                }
                this.isDirty = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void load(TVDList TVDs, char units) {
            this.rowCount = TVDs.getSize();
            this.setSize(this.rowCount);
            this.units = units;
            for (int i = 0; i < this.rowCount; ++i) {
                TVDepth tvdTemp = TVDs.get(i);
                this.setValueAt(DepthUtils.convFromM((double)tvdTemp.getDDepth(), (char)units), i, 0);
                if (tvdTemp.getTVDepth() != null) {
                    this.setValueAt(DepthUtils.convFromM((double)tvdTemp.getTVDepth(), (char)units), i, 1);
                }
                if (tvdTemp.getInclination() != null) {
                    this.setValueAt(tvdTemp.getInclination().floatValue(), i, 2);
                }
                if (tvdTemp.getAzumith() != null) {
                    this.setValueAt(tvdTemp.getAzumith().floatValue(), i, 3);
                }
                if (tvdTemp.getVS() != null) {
                    this.setValueAt(DepthUtils.convFromM((double)tvdTemp.getVS(), (char)units), i, 4);
                }
                if (tvdTemp.getNorth() != null) {
                    this.setValueAt(DepthUtils.convFromM((double)tvdTemp.getNorth(), (char)units), i, 5);
                }
                if (tvdTemp.getEast() == null) continue;
                this.setValueAt(DepthUtils.convFromM((double)tvdTemp.getEast(), (char)units), i, 6);
            }
            this.isDirty = false;
        }

        public void save(TVDList TVDs) throws SBException {
            TVDs.clear();
            if (this.rowCount > 0) {
                int i;
                for (i = 0; i < this.rowCount; ++i) {
                    if (this.depth[i] == null || !(this.tvd[i] > this.depth[i])) continue;
                    throw new SBException("TVD value of: " + SB.floatString((double)this.tvd[i], (int)2) + " cannot be greater than drilled depth: " + SB.floatString((double)this.depth[i], (int)2));
                }
                for (i = 0; i < this.rowCount; ++i) {
                    try {
                        if (this.depth[i] == null || !(this.depth[i] >= 0.0) || this.tvd[i] == null) continue;
                        TVDs.add(new TVDepth(DepthUtils.convToM((double)this.depth[i], (char)this.units), DepthUtils.convToM((double)this.tvd[i], (char)this.units), this.inclination[i] != null ? Float.valueOf(this.inclination[i].floatValue()) : null, this.azimuth[i] != null ? Float.valueOf(this.azimuth[i].floatValue()) : null, this.vs[i] != null ? Double.valueOf(DepthUtils.convToM((double)this.vs[i], (char)this.units)) : null, this.north[i] != null ? Double.valueOf(DepthUtils.convToM((double)this.north[i], (char)this.units)) : null, this.east[i] != null ? Double.valueOf(DepthUtils.convToM((double)this.east[i], (char)this.units)) : null));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        void calcTVDVS(String option, JDialog parent, int[] selectedRows) {
            boolean hasIncl = false;
            double lastDepth = this.rowCount > 0 ? this.depth[0] : 0.0;
            for (int row = 0; row < this.rowCount; ++row) {
                if (this.inclination[row] != null) {
                    hasIncl = true;
                }
                if (this.depth[row] == null) {
                    JOptionPane.showMessageDialog(parent, "There are spaces in the measured depths.", parent.getTitle(), 1);
                    return;
                }
                if (this.depth[row] >= lastDepth) continue;
                JOptionPane.showMessageDialog(parent, "The measured depths do not increase at: " + this.depth[row], parent.getTitle(), 1);
                return;
            }
            if (!hasIncl) {
                JOptionPane.showMessageDialog(parent, "There are no inclination data.", parent.getTitle(), 1);
                return;
            }
            if (option.equals("TVD")) {
                this.tvd[0] = this.depth[0];
            } else {
                this.vs[0] = 0.0;
            }
            float incl = this.inclination[0] != null ? this.inclination[0].floatValue() : 0.0f;
            for (int row = 1; row < this.rowCount; ++row) {
                if (this.depth[row] == null) continue;
                float incl1 = incl;
                if (this.inclination[row - 1] != null) {
                    incl1 = this.inclination[row - 1].floatValue();
                }
                float incl2 = incl1;
                if (this.inclination[row] != null) {
                    incl2 = this.inclination[row].floatValue();
                }
                incl = (incl1 + incl2) / 2.0f;
                double depthincr = this.depth[row] - this.depth[row - 1];
                boolean assignRow = true;
                if (selectedRows != null) {
                    assignRow = false;
                    for (int i : selectedRows) {
                        if (row != i) continue;
                        assignRow = true;
                        if (this.vs[row - 1] != null) break;
                        JOptionPane.showMessageDialog(parent, "Cannot calculate: the selected rows must not be preceded by missing VS values.", parent.getTitle(), 1);
                        return;
                    }
                }
                if (option.equals("TVD")) {
                    double tvdincr = depthincr * Math.cos(Math.toRadians(incl));
                    if (!assignRow) continue;
                    this.tvd[row] = this.tvd[row - 1] + tvdincr;
                    continue;
                }
                double vsincr = depthincr * Math.sin(Math.toRadians(incl));
                if (!assignRow) continue;
                this.vs[row] = this.vs[row - 1] + vsincr;
            }
        }

        void calcVS(JDialog parent, int[] selectedRows) {
            int row;
            double lastDepth = this.rowCount > 0 ? this.depth[0] : 0.0;
            for (row = 0; row < this.rowCount; ++row) {
                if (this.depth[row] == null) {
                    JOptionPane.showMessageDialog(parent, "Cannot calculate: there are spaces in the measured depths.", parent.getTitle(), 1);
                    return;
                }
                if (this.tvd[row] == null) {
                    JOptionPane.showMessageDialog(parent, "Cannot calculate: there are spaces in the TV depths.", parent.getTitle(), 1);
                    return;
                }
                if (this.depth[row] >= lastDepth) continue;
                JOptionPane.showMessageDialog(parent, "Cannot calculate: the measured depths do not increase at: " + this.depth[row], parent.getTitle(), 1);
                return;
            }
            this.vs[0] = 0.0;
            for (row = 1; row < this.rowCount; ++row) {
                if (this.depth[row] == null) continue;
                double depthincr = this.depth[row] - this.depth[row - 1];
                double tvdincr = this.tvd[row] - this.tvd[row - 1];
                double vsincr = 0.0;
                if (depthincr - tvdincr > 0.0) {
                    vsincr = Math.sqrt(depthincr * depthincr - tvdincr * tvdincr);
                }
                boolean assignRow = true;
                if (selectedRows != null) {
                    assignRow = false;
                    for (int i : selectedRows) {
                        if (row != i) continue;
                        assignRow = true;
                        if (this.vs[row - 1] != null) break;
                        JOptionPane.showMessageDialog(parent, "Cannot calculate: the selected rows must not be preceded by missing VS values.", parent.getTitle(), 1);
                        return;
                    }
                }
                if (!assignRow) continue;
                this.vs[row] = this.vs[row - 1] + vsincr;
            }
        }

        void calcNE(JDialog parent, int[] selectedRows) {
            boolean hasAz = false;
            if (this.vs == null || this.vs[0] == null) {
                JOptionPane.showMessageDialog(parent, "No vertical section values. these must be calculated first.", parent.getTitle(), 1);
                return;
            }
            double lastVS = this.rowCount > 0 ? this.vs[0] : 0.0;
            for (int row = 0; row < this.rowCount; ++row) {
                if (this.azimuth[row] != null) {
                    hasAz = true;
                }
                if (this.vs[row] == null) {
                    JOptionPane.showMessageDialog(parent, "Cannot calculate: there are gaps in the vertical section.", parent.getTitle(), 1);
                    return;
                }
                if (this.vs[row] >= lastVS) continue;
                JOptionPane.showMessageDialog(parent, "The vertical section does not increase at: " + this.vs[row], parent.getTitle(), 1);
                return;
            }
            if (!hasAz) {
                JOptionPane.showMessageDialog(parent, "There are no azimuth data.", parent.getTitle(), 1);
                return;
            }
            this.north[0] = 0.0;
            this.east[0] = 0.0;
            for (int row = 1; row < this.rowCount; ++row) {
                if (this.depth[row] == null) continue;
                float az = this.azimuth[row].floatValue();
                double vsincr = this.vs[row] - this.vs[row - 1];
                boolean assignRow = true;
                if (selectedRows != null) {
                    assignRow = false;
                    for (int i : selectedRows) {
                        if (row != i) continue;
                        assignRow = true;
                        break;
                    }
                }
                if (!assignRow) continue;
                double nincr = vsincr * Math.cos(Math.toRadians(az));
                this.north[row] = this.north[row - 1] + nincr;
                double eincr = vsincr * Math.sin(Math.toRadians(az));
                this.east[row] = this.east[row - 1] + eincr;
            }
        }
    }
}

