/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.taxon.process.TaxonDelete;
import com.stratadata.util.process.ProgressMonitor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Taxon;

public class DialogTaxaUnusedDelete
extends JDialog {
    private final SBdb db;
    private final ProgressMonitor monitor;
    private int nPresses;
    private List<Integer> taxaToDie;
    private SwingWorker task;
    private TaxonDelete taxonDelete;
    private JButton jButtonCancel;
    private JButton jButtonNext;
    private JLabel jLabel1;
    private JLabel jLabelInfo;
    private JProgressBar jProgressBar1;

    public DialogTaxaUnusedDelete(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.setTitle("Delete all non-occurring taxa");
        this.initComponents();
        this.monitor = new ProgressMonitor(() -> this.updateProgressBar());
    }

    private void updateProgressBar() {
        this.jLabelInfo.setText(this.monitor.getMessage());
        System.out.println("updating progress bar..." + this.monitor.getValue());
        this.jProgressBar1.setMaximum(this.monitor.getMax());
        this.jProgressBar1.setValue(this.monitor.getValue());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabelInfo = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jButtonNext = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1));
        this.jLabel1.setForeground(new Color(255, 0, 51));
        this.jLabel1.setText("Delete all taxa which have no well/outcrop occurrences and no linked events?");
        this.jLabelInfo.setText("Press Next to find number of taxa which will be deleted...");
        this.jButtonNext.setText("Next");
        this.jButtonNext.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxaUnusedDelete this$0;
            {
                DialogTaxaUnusedDelete dialogTaxaUnusedDelete = this$0;
                Objects.requireNonNull(dialogTaxaUnusedDelete);
                this.this$0 = dialogTaxaUnusedDelete;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonNextActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxaUnusedDelete this$0;
            {
                DialogTaxaUnusedDelete dialogTaxaUnusedDelete = this$0;
                Objects.requireNonNull(dialogTaxaUnusedDelete);
                this.this$0 = dialogTaxaUnusedDelete;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelInfo).addComponent(this.jProgressBar1, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonNext).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonNext);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelInfo).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jProgressBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 24, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonNext)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.task != null) {
            if (!this.task.isDone()) {
                this.monitor.interrupt();
                this.task.cancel(true);
            }
            if (this.taxonDelete != null) {
                JOptionPane.showMessageDialog(this, this.taxonDelete.getnSpeciesDeleted() + " species deleted\n0 genera deleted", this.getTitle(), 1);
            }
        }
        this.dispose();
    }

    /*
     * Unable to fully structure code
     */
    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.nPresses == 0) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.taxaToDie = Taxon.getUnusedSpecies(this.db);
                if (this.taxaToDie.isEmpty()) {
                    this.jLabelInfo.setText("There are no unused taxa. Press Cancel to finish");
                    this.jButtonNext.setEnabled(false);
                }
                this.jLabelInfo.setText("Number of taxa to be deleted is: " + this.taxaToDie.size() + ". Press Next to continue");
                if (SBRestrictable.canWrite(this.db)) ** GOTO lbl24
                this.jButtonNext.setEnabled(false);
                this.jButtonNext.setToolTipText("You do not have permission to delete taxa.");
            }
            catch (SQLException ex) {
                SbugsExceptionHandler.showStackError("Error getting unused species", ex, this);
                return;
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.task = new SwingWorker(this){
                final /* synthetic */ DialogTaxaUnusedDelete this$0;
                {
                    DialogTaxaUnusedDelete dialogTaxaUnusedDelete = this$0;
                    Objects.requireNonNull(dialogTaxaUnusedDelete);
                    this.this$0 = dialogTaxaUnusedDelete;
                }

                @Override
                public void done() {
                    this.this$0.jButtonCancel.setText("Finish");
                    this.this$0.setCursor(Cursor.getDefaultCursor());
                }

                protected Object doInBackground() throws Exception {
                    this.this$0.setCursor(Cursor.getPredefinedCursor(3));
                    this.this$0.deleteSpecies();
                    return "OK";
                }
            };
            this.task.execute();
            this.jButtonNext.setEnabled(false);
        }
lbl24:
        // 4 sources

        ++this.nPresses;
    }

    void deleteSpecies() {
        try {
            this.taxonDelete = TaxonDelete.deleteSpeciesAndUnusedGenera((ProgressMonitor)this.monitor, (TaxonService)this.db.getTaxonService(), (SynonymService)this.db.getSynonymService(), (GenusService)this.db.getGenusService(), this.taxaToDie);
            this.db.deleteSpeciesModel(this.taxaToDie, this.taxonDelete.getDeletedGenera());
            if (!this.monitor.isInterrupted()) {
                this.jLabelInfo.setText("Finished");
            }
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
            this.jLabelInfo.setText("Error");
        }
    }
}

