/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.sbdb.ProjectUtils;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.CountRenderer;
import jsbugs.table.ImageIconRenderer;
import jsbugs.table.MarkerRenderer;
import jsbugs.uiutil.FileOverwriteCheck;
import jsbugs.uiutil.ImageCacheTooltip;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Lastval;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.Well;
import model3.WellHeader;
import model3.WellInterp;
import model3.project.Project;
import util.DepthUtils;
import util.FilePathUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.gridwriter.CellFormat;
import util.gridwriter.GridSheet;
import util.gridwriter.GridWriter;

public class DialogTaxonWellOcc
extends JDialog {
    private static final int DEPTHLEN = 8;
    private final DefaultListModel modelWells = new DefaultListModel();
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private final TableModelTaxonWellOcc model = new TableModelTaxonWellOcc();
    private final SBdb db;
    private final Taxon taxon;
    private boolean addWarn = false;
    TableModelTaxonWellOcc.TaxonWellOccItem selectedItem = null;
    Well well = null;
    private Box.Filler filler1;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JButton jButtonSaveAs;
    private JButton jButtonSearch;
    private JButton jButtonShowAllWells;
    private JButton jButtonShowSample;
    private JButton jButtonShowWell;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxUnits;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelTotalOcc;
    private JList jListWell;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTable jTableWellOcc;
    private JTextArea jTextAreaSql;
    private JTextField jTextFieldAbundance;
    private JTextField jTextFieldDepth1;
    private JTextField jTextFieldDepth2;
    private JTextField jTextFieldTaxon;

    public DialogTaxonWellOcc(Frame parent, boolean modal, SBdb db, Taxon taxon) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.taxon = taxon;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.jTextFieldTaxon.setText(this.taxon.toString());
        ProjectUtils.loadProjectCombo(this.db, this.projectModel, true);
        this.model.setupTable(this.jTableWellOcc);
        this.jTableWellOcc.setRowSorter(new TableRowSorter<TableModelTaxonWellOcc>(this.model));
        new ColumnSortResetHandler(this.jTableWellOcc).attach();
        this.setTitle("Well Occurrences : " + this.taxon.toString(true, false, true));
        this.jLabelTotalOcc.setText("");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        ImageCacheTooltip tooltip = new ImageCacheTooltip(this.jTableWellOcc, 8, this.db.getImageRecordService(), this.db.getImageLoader());
        this.jTableWellOcc.addMouseMotionListener(tooltip);
        this.jTableWellOcc.addMouseListener(tooltip);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListWell = new JList();
        this.jButtonShowWell = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableWellOcc = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanel1 = new JPanel();
        this.jComboBoxProject = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldDepth1 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldDepth2 = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextFieldAbundance = new JTextField();
        this.jLabel7 = new JLabel();
        this.jComboBoxUnits = new JComboBox();
        this.jScrollPane3 = new JScrollPane();
        this.jTextAreaSql = new JTextArea();
        this.filler1 = new Box.Filler(new Dimension(10, 20), new Dimension(10, 20), new Dimension(10, 20));
        this.jButtonShowSample = new JButton();
        this.jButtonShowAllWells = new JButton();
        this.jLabel5 = new JLabel();
        this.jButtonSaveAs = new JButton();
        this.jLabelTotalOcc = new JLabel();
        this.jTextFieldTaxon = new JTextField();
        this.jButtonSearch = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(715, 400));
        this.jListWell.setModel(this.modelWells);
        this.jListWell.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListWellMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListWell);
        this.jButtonShowWell.setText("Show >");
        this.jButtonShowWell.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowWell.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowWellActionPerformed(evt);
            }
        });
        this.jTableWellOcc.setModel(this.model);
        this.jTableWellOcc.setToolTipText("");
        this.jTableWellOcc.setAutoResizeMode(0);
        this.jTableWellOcc.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableWellOccMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableWellOcc);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Search Parameters"));
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.projectModel);
        this.jLabel2.setText("Within project:");
        this.jLabel3.setText("Between depths:");
        this.jTextFieldDepth1.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldDepth1FocusGained(evt);
            }
        });
        this.jTextFieldDepth1.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldDepth1KeyTyped(evt);
            }
        });
        this.jLabel4.setText("to:");
        this.jTextFieldDepth2.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldDepth2FocusGained(evt);
            }
        });
        this.jTextFieldDepth2.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldDepth2KeyTyped(evt);
            }
        });
        this.jLabel6.setText("With abundance greater than:");
        this.jTextFieldAbundance.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldAbundanceKeyTyped(evt);
            }
        });
        this.jLabel7.setText("Additional SQL parameters:");
        this.jComboBoxUnits.setModel(new DefaultComboBoxModel<String>(new String[]{"m", "ft"}));
        this.jTextAreaSql.setColumns(20);
        this.jTextAreaSql.setRows(3);
        this.jScrollPane3.setViewportView(this.jTextAreaSql);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldAbundance)).addGroup(jPanel1Layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxProject, 0, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDepth1, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDepth2, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxUnits, -2, 41, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler1, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane3)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jTextFieldDepth1, this.jTextFieldDepth2);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.filler1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxProject, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldDepth1, -2, -1, -2).addComponent(this.jLabel3).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldDepth2, -2, -1, -2).addComponent(this.jComboBoxUnits, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextFieldAbundance, -2, -1, -2)))))).addGap(65, 65, 65)));
        this.jButtonShowSample.setText("Go to sample...");
        this.jButtonShowSample.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowSampleActionPerformed(evt);
            }
        });
        this.jButtonShowAllWells.setText("Show all >");
        this.jButtonShowAllWells.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowAllWells.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowAllWellsActionPerformed(evt);
            }
        });
        this.jLabel5.setText("* note: age and stratigraphy are from the default version");
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setToolTipText("Save the list of occurrences to a file");
        this.jButtonSaveAs.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jLabelTotalOcc.setFont(new Font("Tahoma", 1, 11));
        this.jLabelTotalOcc.setText("jLabel8");
        this.jTextFieldTaxon.setEditable(false);
        this.jTextFieldTaxon.setBackground(new Color(255, 255, 204));
        this.jButtonSearch.setFont(new Font("Segoe UI", 1, 12));
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOcc this$0;
            {
                DialogTaxonWellOcc dialogTaxonWellOcc = this$0;
                Objects.requireNonNull(dialogTaxonWellOcc);
                this.this$0 = dialogTaxonWellOcc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldTaxon).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 195, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonShowAllWells, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonShowWell, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSearch, -1, -1, Short.MAX_VALUE))).addComponent(this.jLabelTotalOcc)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addGap(35, 35, 35).addComponent(this.jButtonSaveAs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonShowSample).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane2)))))).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonHelp, this.jButtonSaveAs);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldTaxon, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonSearch).addGap(18, 18, 18).addComponent(this.jButtonShowWell).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonShowAllWells).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1).addComponent(this.jScrollPane2, -1, 376, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHelp).addComponent(this.jButtonShowSample).addComponent(this.jButtonSaveAs)).addComponent(this.jButtonClose).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabelTotalOcc))).addContainerGap()));
        this.pack();
    }

    private void jTextFieldDepth2FocusGained(FocusEvent evt) {
        this.jTextFieldDepth2.setSelectionStart(0);
        this.jTextFieldDepth2.setSelectionEnd(this.jTextFieldDepth2.getText().length());
    }

    private void jTextFieldDepth2KeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepth2, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldDepth1FocusGained(FocusEvent evt) {
        this.jTextFieldDepth1.setSelectionStart(0);
        this.jTextFieldDepth1.setSelectionEnd(this.jTextFieldDepth1.getText().length());
    }

    private void jTextFieldDepth1KeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepth1, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldAbundanceKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldAbundance, (int)5, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogtaxonwellocc.html");
    }

    private void jListWellMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowWellActionPerformed(null);
        }
    }

    private void jButtonShowWellActionPerformed(ActionEvent evt) {
        if (this.jListWell.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select a well", this.getTitle(), 2);
            return;
        }
        if (!(this.jListWell.getSelectedValue() instanceof TaxonWellOccWellTotal)) {
            this.model.occs = null;
            this.model.fireTableDataChanged();
            return;
        }
        this.well = ((TaxonWellOccWellTotal)this.jListWell.getSelectedValue()).well;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.well.loadAnalyses();
            this.model.occs = new LinkedList<TableModelTaxonWellOcc.TaxonWellOccItem>();
            this.searchWell(this.well);
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private Double getDepth(JTextField field) {
        Double depth = null;
        if (field.getText().length() > 0) {
            depth = Double.parseDouble(field.getText());
        }
        if (this.jComboBoxUnits.getSelectedItem().equals("ft") && depth != null) {
            depth = DepthUtils.convToM((double)depth, (char)'F');
        }
        return depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSearchActionPerformed(ActionEvent evt) {
        try {
            String addSql;
            Double lower;
            Double upper;
            List<Taxon.TaxonWellOccTotal> selection;
            this.modelWells.clear();
            this.jLabelTotalOcc.setText("");
            this.setCursor(Cursor.getPredefinedCursor(3));
            Project project = this.jComboBoxProject.getSelectedItem() instanceof Project ? (Project)((Object)this.jComboBoxProject.getSelectedItem()) : null;
            int abund = -1;
            if (this.jTextFieldAbundance.getText().length() > 0) {
                abund = Integer.parseInt(this.jTextFieldAbundance.getText());
            }
            if ((selection = this.taxon.search(this.db, project, upper = this.getDepth(this.jTextFieldDepth1), lower = this.getDepth(this.jTextFieldDepth2), abund, addSql = this.jTextAreaSql.getText())) == null || selection.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No occurrences found", this.getTitle(), 2);
                return;
            }
            LinkedList<Object> sortWells = new LinkedList<Object>();
            for (Taxon.TaxonWellOccTotal i : selection) {
                try {
                    Well well = this.db.getWell(i.getWellID());
                    TaxonWellOccWellTotal wt = new TaxonWellOccWellTotal(this);
                    wt.well = well;
                    wt.nOcc = i.getNOcc();
                    sortWells.add(wt);
                }
                catch (WellHeader.MissingWellException missingWellException) {
                    sortWells.add("<Not visible> (" + i.getNOcc() + ")");
                }
                catch (SBException sBException) {
                    if (sBException.getCause() instanceof SBPermissionException) {
                        sortWells.add("<Restricted> (" + i.getNOcc() + ")");
                        continue;
                    }
                    if (sBException.getMessage().contains("Cannot create well")) {
                        sortWells.add("<Not visible> (" + i.getNOcc() + ")");
                        continue;
                    }
                    throw sBException;
                }
            }
            this.jLabelTotalOcc.setText(sortWells.size() + " wells/outcrops");
            Collections.sort(sortWells, new Comparator<Object>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            boolean first = true;
            for (Object e : sortWells) {
                if (first && e instanceof TaxonWellOccWellTotal) {
                    first = false;
                    ((TaxonWellOccWellTotal)e).isFirstInList = true;
                }
                this.modelWells.addElement(e);
            }
            this.jListWell.repaint();
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonShowSampleActionPerformed(ActionEvent evt) {
        if (this.jTableWellOcc.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one occurrence.", this.getTitle(), 2);
            return;
        }
        this.selectedItem = this.model.occs.get(this.jTableWellOcc.convertRowIndexToModel(this.jTableWellOcc.getSelectedRow()));
        this.dispose();
    }

    private void jTableWellOccMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowSampleActionPerformed(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonShowAllWellsActionPerformed(ActionEvent evt) {
        if (this.jListWell.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(this, "No wells to show", this.getTitle(), 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.model.occs = new LinkedList<TableModelTaxonWellOcc.TaxonWellOccItem>();
        try {
            for (int i = 0; i < this.jListWell.getModel().getSize(); ++i) {
                Object o = this.jListWell.getModel().getElementAt(i);
                if (!(o instanceof TaxonWellOccWellTotal)) continue;
                this.well = ((TaxonWellOccWellTotal)o).well;
                this.searchWell(this.well);
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean csvFileSelected(File file) {
        boolean isCSV = !FilePathUtils.isFileExtension((String)file.getName(), (String[])FileChooserUtils.EXCEL_FILTER.getExtensions()) && !FilePathUtils.isFileExtension((String)file.getName(), (String[])FileChooserUtils.LEGACY_EXCEL_FILTER.getExtensions());
        return isCSV;
    }

    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        if (this.model == null || this.model.occs == null || this.model.occs.isEmpty()) {
            JOptionPane.showMessageDialog(this, "There are no occurrence data to save", this.getTitle(), 1);
            return;
        }
        try {
            String fileName = Lastval.getString(this.db, "OCCCSVFILE");
            File file = FileChooserUtils.saveAsGridDataDialog((Component)this.jPanel1, (String)fileName);
            if (file == null) {
                return;
            }
            fileName = file.getPath();
            boolean isCSVFile = this.csvFileSelected(file);
            GridWriter gw = new GridWriter();
            gw.getXLSOptions().setSheetName("StrataBugs Occurrences");
            gw.getXLSOptions().setAuthorName(this.db.getUser().getName());
            boolean continueSave = FileOverwriteCheck.checkForGridFileOverwriting(this, (Component)this, file, gw);
            if (!continueSave) {
                return;
            }
            boolean csvOutput = FilePathUtils.isFileExtension((String)fileName, (String[])FileChooserUtils.CSV_FILTER.getExtensions());
            GridSheet gb = new GridSheet();
            CellFormat format = new CellFormat().setBold(true).setBorder(2);
            gb.addRow();
            gb.append(new Object[]{format, "Well name", "Well code", "Sample", "Top Depth", "Base Depth"});
            for (int i = 2; i < this.model.getColumnCount(); ++i) {
                Object[] objectArray = new Object[1];
                objectArray[0] = TableModelTaxonWellOcc.columnTitles[i];
                gb.appendFormatted(format, objectArray);
            }
            gb.append(new Object[]{format, "Taxon"});
            for (int row = 0; row < this.model.getRowCount(); ++row) {
                TableModelTaxonWellOcc.TaxonWellOccItem occ = this.model.occs.get(row);
                gb.addRow(new Object[]{occ.well.getWellName()});
                gb.append(new Object[]{occ.well.getWellCode()});
                gb.append(new Object[]{occ.sample.toString()});
                gb.append(new Object[]{occ.sample.hasTopDepth() ? Double.valueOf(occ.sample.getTopDepth(occ.sample.displayUnits)) : ""});
                gb.append(new Object[]{occ.sample.hasBaseDepth() ? Double.valueOf(occ.sample.getBaseDepth(occ.sample.displayUnits)) : ""});
                for (int i = 2; i < this.model.getColumnCount(); ++i) {
                    gb.append(new Object[]{this.model.getValueAt(row, i)});
                }
                gb.append(new Object[]{this.taxon.toString()});
            }
            gw.write(file, gb.getObjectArray());
            Lastval.putString(this.db, "OCCCSVFILE", fileName);
            this.db.commit();
            JOptionPane.showMessageDialog(this, "File written", this.getTitle(), 1);
        }
        catch (IOException | SQLException sqle) {
            SbugsExceptionHandler.showStackError(sqle, this);
        }
    }

    void searchWell(Well well) throws SQLException, SBException {
        well.loadAnalyses();
        List<Smpdtl> list = well.getAnalyses('\u0000', null, 0);
        if (this.jTextAreaSql.getText().length() > 0 && !this.addWarn) {
            JOptionPane.showMessageDialog(this, "Note: additional SQL parameters are not used in occurrence display", this.getTitle(), 2);
            this.addWarn = true;
        }
        int abund = -1;
        if (this.jTextFieldAbundance.getText().length() > 0) {
            abund = Integer.parseInt(this.jTextFieldAbundance.getText());
        }
        Double upper = this.getDepth(this.jTextFieldDepth1);
        Double lower = this.getDepth(this.jTextFieldDepth2);
        for (Smpdtl smpdtl : list) {
            for (TaxonOcc occ : smpdtl.getOccurSorted()) {
                if (occ.getTaxon() != this.taxon) continue;
                boolean include = true;
                if (abund > 0 && occ.getTotalCount() < abund) {
                    include = false;
                }
                if (upper != null && smpdtl.getSample().getDepth() < upper) {
                    include = false;
                }
                if (lower != null && smpdtl.getSample().getDepth() > lower) {
                    include = false;
                }
                if (!include) continue;
                if (!well.hasInterpLoaded(0)) {
                    well.loadInterps();
                    well.loadInterp(well.getInterp(0));
                }
                TableModelTaxonWellOcc.TaxonWellOccItem item = new TableModelTaxonWellOcc.TaxonWellOccItem(well, smpdtl.getSample(), well.getInterp(0), smpdtl, occ);
                item.sample.displayUnits = well.getWellUnits();
                this.model.occs.add(item);
            }
        }
    }

    public Smpdtl getSelectedSmpdtl() {
        if (this.selectedItem != null) {
            return this.selectedItem.smpdtl;
        }
        return null;
    }

    private static class TableModelTaxonWellOcc
    extends AbstractTableModel {
        List<TaxonWellOccItem> occs;
        static final String[] columnTitles = new String[]{"Well", "Sample", "Age", "Stratigraphy", "Discipline", "Analyst", "Suite", "Mkr?", "Image", "Situation", "?", "Abund.", "Coarse", "Medium", "Fine", "Type", "Preserv.", "Colour", "Comments"};
        static final int[] columnWidths = new int[]{50, 60, 25, 80, 20, 20, 10, 20, 20, 20, 20, 20, 20, 20, 20, 40, 50, 20, 80};
        static final int COL_WELL = 0;
        static final int COL_SAMPLE = 1;
        static final int COL_LOCAGE = 2;
        static final int COL_LOCSTRAT = 3;
        static final int COL_DISC = 4;
        static final int COL_ANALYST = 5;
        static final int COL_SUITE = 6;
        static final int COL_MARKER = 7;
        static final int COL_IMAGE = 8;
        static final int COL_SITUATION = 9;
        static final int COL_QUESTION = 10;
        static final int COL_ABUND = 11;
        static final int COL_COARSE = 12;
        static final int COL_MEDIUM = 13;
        static final int COL_FINE = 14;
        static final int COL_SPECTYPE = 15;
        static final int COL_PRESERV = 16;
        static final int COL_COLOUR = 17;
        static final int COL_COMMENTS = 18;

        private TableModelTaxonWellOcc() {
        }

        @Override
        public int getColumnCount() {
            return columnTitles.length;
        }

        @Override
        public int getRowCount() {
            if (this.occs == null) {
                return 0;
            }
            return this.occs.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.occs == null) {
                return null;
            }
            TaxonWellOccItem item = this.occs.get(row);
            TaxonOcc fss = item.occ;
            Sample sample = item.sample;
            WellInterp wellInterp = item.wellInterp;
            switch (col) {
                case 0: {
                    return this.occs.get((int)row).well.getWellName();
                }
                case 1: {
                    return sample;
                }
                case 4: {
                    return this.occs.get((int)row).smpdtl.getHeader().getDiscipline().getAbr(true);
                }
                case 5: {
                    try {
                        return this.occs.get((int)row).smpdtl.getAnalystAbr();
                    }
                    catch (Exception ex) {
                        return ex.getMessage();
                    }
                }
                case 6: {
                    try {
                        return this.occs.get((int)row).smpdtl.getAnalyNo();
                    }
                    catch (Exception ex) {
                        return ex.getMessage();
                    }
                }
                case 7: {
                    return fss.isMarker();
                }
                case 9: {
                    return fss.getSituation().getAbr();
                }
                case 10: {
                    if (fss.getIdentType() == '?') {
                        return "?";
                    }
                    return "";
                }
                case 11: {
                    if (fss.isOutsideCount()) {
                        return "+";
                    }
                    return fss.getSubAbund();
                }
                case 12: {
                    return fss.getCoarse();
                }
                case 13: {
                    return fss.getMedium();
                }
                case 14: {
                    return fss.getFine();
                }
                case 15: {
                    try {
                        return fss.getSpecTypeString();
                    }
                    catch (Exception e) {
                        return e.getMessage();
                    }
                }
                case 16: {
                    return fss.getPreservation();
                }
                case 17: {
                    return fss.getColour();
                }
                case 18: {
                    return fss.getComment();
                }
                case 8: {
                    return item.occ.getImageSetID();
                }
                case 2: {
                    if (wellInterp != null && wellInterp.getLOC() != null) {
                        double age = wellInterp.getLOC().getAge(sample.getDepth(), false);
                        if (age > 0.0) {
                            return SB.floatString((double)age, (int)3);
                        }
                        return "";
                    }
                    return "";
                }
                case 3: {
                    try {
                        return sample.getStratigraphy(wellInterp, false);
                    }
                    catch (Exception ex) {
                        return ex.getMessage();
                    }
                }
            }
            return "Error col: " + col;
        }

        public Class getColumnClass(int col) {
            return switch (col) {
                default -> String.class;
                case 12, 13, 14 -> Integer.class;
                case 8 -> Integer.class;
                case 1 -> Sample.class;
            };
        }

        void setupTable(JTable jTableOccurrences) {
            TableUtils.setTableHeaderBold((JTable)jTableOccurrences);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                jTableOccurrences.getColumnModel().getColumn(i).setHeaderValue(columnTitles[i]);
                jTableOccurrences.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i] * 2);
            }
            jTableOccurrences.getColumnModel().getColumn(7).setCellRenderer(new MarkerRenderer());
            jTableOccurrences.getColumnModel().getColumn(12).setCellRenderer(new CountRenderer(false));
            jTableOccurrences.getColumnModel().getColumn(13).setCellRenderer(new CountRenderer(false));
            jTableOccurrences.getColumnModel().getColumn(14).setCellRenderer(new CountRenderer(false));
            jTableOccurrences.getColumnModel().getColumn(2).setCellRenderer(new ColouredRenderer(true, new Color(220, 220, 220)));
            jTableOccurrences.getColumnModel().getColumn(3).setCellRenderer(new ColouredRenderer(true, new Color(220, 220, 220)));
            Icon cameraOutlineIcon = IconFactory.getIcon("camera_bw.svg", 14);
            Icon cameraOutlineIconSelected = IconFactory.getIcon("camera_w.svg", 14);
            jTableOccurrences.getColumnModel().getColumn(8).setCellRenderer(new ImageIconRenderer(cameraOutlineIcon, cameraOutlineIconSelected));
            jTableOccurrences.getTableHeader().setToolTipText("(age and Stratigraphy from Default Version)");
        }

        record TaxonWellOccItem(Well well, Sample sample, WellInterp wellInterp, Smpdtl smpdtl, TaxonOcc occ) {
        }
    }

    class TaxonWellOccWellTotal {
        Well well;
        int nOcc;
        boolean isFirstInList;

        TaxonWellOccWellTotal(DialogTaxonWellOcc this$0) {
            Objects.requireNonNull(this$0);
            this.isFirstInList = false;
        }

        public String toString() {
            return this.well.getWellName() + " (" + this.nOcc + (String)(this.isFirstInList ? " sample" + (this.nOcc != 1 ? "s" : "") + ")" : ")");
        }
    }
}

