/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.SectionType;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.table.DepthRenderer;
import jsbugs.table.ImageIconRenderer;
import jsbugs.table.MarkerRenderer;
import jsbugs.uiutil.ImageCacheTooltip;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.TaxonOcc;
import model3.Well;
import util.SBException;

public class DialogTaxonWellOccFiltered
extends JDialog {
    private final TableModelTaxonOccurrence model = new TableModelTaxonOccurrence();
    private final Well well;
    static final int FILTER_MKR = 0;
    static final int FILTER_COMM = 1;
    static final int FILTER_IMG = 2;
    private ImageCacheTooltip tooltip;
    private ButtonGroup buttonGroup1;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonComms;
    private JRadioButton jRadioButtonImgs;
    private JRadioButton jRadioButtonMkrs;
    private JScrollPane jScrollPane1;
    private JTable jTableOccs;

    public DialogTaxonWellOccFiltered(Frame parent, boolean modal, Well well, DepthUnits units) {
        super(parent, modal);
        this.well = well;
        this.initComponents();
        this.init(units);
    }

    private void init(DepthUnits units) {
        this.setTitle("Filtered Taxon Occurrences : " + this.well.getWellName());
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.model.setupTable(this.jTableOccs);
        this.model.setUnits(units);
        this.jTableOccs.setRowSorter(new TableRowSorter<TableModelTaxonOccurrence>(this.model));
        new ColumnSortResetHandler(this.jTableOccs).attach();
        this.filterButton();
        this.model.fireTableDataChanged();
        this.initImageTooltip();
        this.jScrollPane1.scrollRectToVisible(this.jTableOccs.getVisibleRect());
    }

    private void initImageTooltip() {
        if (this.tooltip == null) {
            this.tooltip = new ImageCacheTooltip(this.jTableOccs, 12, this.well.getDataModel().getImageRecordService(), this.well.getDataModel().getImageLoader());
            this.jTableOccs.addMouseMotionListener(this.tooltip);
            this.jTableOccs.addMouseListener(this.tooltip);
        }
    }

    private void filterButton() {
        int i = this.jRadioButtonComms.isSelected() ? 1 : (this.jRadioButtonImgs.isSelected() ? 2 : 0);
        this.filter(i);
    }

    private void filter(int filter) {
        LinkedList<Occurrence> occs = new LinkedList<Occurrence>();
        try {
            List<Smpdtl> allSmpdtls = this.well.getAnalyses(null, null, 0);
            switch (filter) {
                case 0: {
                    for (Smpdtl smpdtl : allSmpdtls) {
                        for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                            if (!occ.isMarker()) continue;
                            occs.add(new Occurrence(smpdtl, occ));
                        }
                    }
                    break;
                }
                case 1: {
                    for (Smpdtl smpdtl : allSmpdtls) {
                        for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                            if (occ.getComment().isEmpty()) continue;
                            occs.add(new Occurrence(smpdtl, occ));
                        }
                    }
                    break;
                }
                case 2: {
                    for (Smpdtl smpdtl : allSmpdtls) {
                        for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                            if (occ.getImageSetID() <= 0) continue;
                            occs.add(new Occurrence(smpdtl, occ));
                        }
                    }
                    break;
                }
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
        this.model.setList(occs);
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTableOccs = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMkrs = new JRadioButton();
        this.jRadioButtonImgs = new JRadioButton();
        this.jRadioButtonComms = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.jTableOccs.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableOccs);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOccFiltered this$0;
            {
                DialogTaxonWellOccFiltered dialogTaxonWellOccFiltered = this$0;
                Objects.requireNonNull(dialogTaxonWellOccFiltered);
                this.this$0 = dialogTaxonWellOccFiltered;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOccFiltered this$0;
            {
                DialogTaxonWellOccFiltered dialogTaxonWellOccFiltered = this$0;
                Objects.requireNonNull(dialogTaxonWellOccFiltered);
                this.this$0 = dialogTaxonWellOccFiltered;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Show all:", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroup1.add(this.jRadioButtonMkrs);
        this.jRadioButtonMkrs.setSelected(true);
        this.jRadioButtonMkrs.setText("Markers");
        this.jRadioButtonMkrs.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOccFiltered this$0;
            {
                DialogTaxonWellOccFiltered dialogTaxonWellOccFiltered = this$0;
                Objects.requireNonNull(dialogTaxonWellOccFiltered);
                this.this$0 = dialogTaxonWellOccFiltered;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMkrsActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonImgs);
        this.jRadioButtonImgs.setText("Images");
        this.jRadioButtonImgs.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOccFiltered this$0;
            {
                DialogTaxonWellOccFiltered dialogTaxonWellOccFiltered = this$0;
                Objects.requireNonNull(dialogTaxonWellOccFiltered);
                this.this$0 = dialogTaxonWellOccFiltered;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonImgsActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonComms);
        this.jRadioButtonComms.setText("Comments");
        this.jRadioButtonComms.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTaxonWellOccFiltered this$0;
            {
                DialogTaxonWellOccFiltered dialogTaxonWellOccFiltered = this$0;
                Objects.requireNonNull(dialogTaxonWellOccFiltered);
                this.this$0 = dialogTaxonWellOccFiltered;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonCommsActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonMkrs).addComponent(this.jRadioButtonComms).addComponent(this.jRadioButtonImgs)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonMkrs).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonComms).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonImgs).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 629, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jRadioButtonMkrsActionPerformed(ActionEvent evt) {
        this.filterButton();
    }

    private void jRadioButtonCommsActionPerformed(ActionEvent evt) {
        this.filterButton();
    }

    private void jRadioButtonImgsActionPerformed(ActionEvent evt) {
        this.filterButton();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogtaxonwelloccfiltered.html");
    }

    private static class TableModelTaxonOccurrence
    extends AbstractTableModel {
        LinkedList<Occurrence> occs = null;
        DepthUnits units = DepthUnits.M;
        static final String[] columnTitles = new String[]{"Top Depth", "Base Depth", "Type", "Disc.", "Analyst", "Suite", "Name", "Abund.", "Situation", "?", "Mkr", "Comments", "Images"};
        static final int[] columnWidths = new int[]{25, 25, 10, 20, 20, 10, 100, 20, 15, 10, 10, 100, 50};
        static final int COL_TOP_DEPTH = 0;
        static final int COL_BASE_DEPTH = 1;
        static final int COL_TYPE = 2;
        static final int COL_DISC = 3;
        static final int COL_ANALYST = 4;
        static final int COL_SUITE = 5;
        static final int COL_NAME = 6;
        static final int COL_ABUND = 7;
        static final int COL_SITUATION = 8;
        static final int COL_QUEST = 9;
        static final int COL_MKR = 10;
        static final int COL_COMMENTS = 11;
        static final int COL_IMAGE = 12;

        private TableModelTaxonOccurrence() {
        }

        @Override
        public int getColumnCount() {
            return columnTitles.length;
        }

        @Override
        public int getRowCount() {
            if (this.occs == null) {
                return 0;
            }
            return this.occs.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.occs == null) {
                return null;
            }
            Occurrence occ = this.occs.get(row);
            Sample sample = occ.smpdtl.getSample();
            try {
                switch (col) {
                    case 0: {
                        if (sample.hasTopDepth()) {
                            return DepthUtils.depthString((double)sample.getTopDepth(), (DepthUnits)this.units, (int)2, (SectionType)sample.getSectionType());
                        }
                        return "";
                    }
                    case 1: {
                        if (sample.hasBaseDepth()) {
                            return DepthUtils.depthString((double)sample.getBaseDepth(), (DepthUnits)this.units, (int)2, (SectionType)sample.getSectionType());
                        }
                        return "";
                    }
                    case 2: {
                        return sample.getType().getAbr();
                    }
                    case 3: {
                        return SBdb.getDiscAbr(occ.smpdtl.getDiscID());
                    }
                    case 4: {
                        return occ.smpdtl.getAnalystAbr();
                    }
                    case 5: {
                        return "" + occ.smpdtl.getAnalyNo();
                    }
                    case 6: {
                        return occ.occ.getTaxon().toString(false, false, false);
                    }
                    case 7: {
                        Object abn = occ.occ.getSubAbund(true);
                        if (((String)abn).isEmpty()) {
                            abn = (String)abn + occ.occ.getSplitCountString();
                        }
                        return abn;
                    }
                    case 8: {
                        return occ.occ.getSituation().getAbr();
                    }
                    case 9: {
                        if (occ.occ.getIdentType() == '?') {
                            return "?";
                        }
                        return "";
                    }
                    case 11: {
                        return occ.occ.getComment();
                    }
                    case 10: {
                        return occ.occ.isMarker();
                    }
                    case 12: {
                        return occ.occ.getImageSetID();
                    }
                }
                return "Error col: " + col;
            }
            catch (SQLException | SBException e) {
                return e.getMessage();
            }
        }

        public Class getColumnClass(int col) {
            return switch (col) {
                default -> String.class;
                case 12 -> Integer.class;
            };
        }

        void setList(LinkedList<Occurrence> occs) {
            this.occs = occs;
        }

        void setUnits(DepthUnits units) {
            this.units = units;
        }

        void setupTable(JTable jTableOccs) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                jTableOccs.getColumnModel().getColumn(i).setHeaderValue(columnTitles[i]);
                jTableOccs.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
            }
            jTableOccs.getColumnModel().getColumn(0).setCellRenderer(new DepthRenderer());
            jTableOccs.getColumnModel().getColumn(1).setCellRenderer(new DepthRenderer());
            jTableOccs.getColumnModel().getColumn(10).setCellRenderer(new MarkerRenderer());
            Icon cameraOutlineIcon = IconFactory.getIcon("camera_bw.svg", 14);
            Icon cameraOutlineIconSelected = IconFactory.getIcon("camera_w.svg", 14);
            jTableOccs.getColumnModel().getColumn(12).setCellRenderer(new ImageIconRenderer(cameraOutlineIcon, cameraOutlineIconSelected));
            TableUtils.setTableHeaderBold((JTable)jTableOccs);
        }
    }

    private record Occurrence(Smpdtl smpdtl, TaxonOcc occ) {
    }
}

