/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import model3.SBRestrictable;
import model3.SBdb;
import model3.TxGroup;
import model3.project.Project;
import util.SB;

public class DialogTxGroup
extends SBDialog {
    private final DefaultComboBoxModel projModel = new DefaultComboBoxModel();
    private static final int NAMELEN = 30;
    private static final int DESCRLEN = 255;
    int projID;
    String name;
    Color colour;
    String descr;
    private JButton jButtonCancel;
    private JButton jButtonColour;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxProject;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaDescr;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldCreated;
    private JTextField jTextFieldCreator;
    private JTextField jTextFieldModified;
    private JTextField jTextFieldModifier;
    private JTextField jTextFieldName;

    public DialogTxGroup(Frame parent, boolean modal, TxGroup group, SBdb sbdb, Project project) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.init(group, sbdb, project);
    }

    private void init(TxGroup group, SBdb sbdb, Project project) throws SQLException {
        if (group == null) {
            this.setTitle("Taxon Group : Add");
        } else {
            this.setTitle("Taxon Group : Edit : " + group.getName());
            this.jTextFieldName.setText(group.getName());
            this.jTextFieldColour.setBackground(group.getColour());
            this.jTextFieldCreated.setText(this.name);
            this.jTextAreaDescr.setText(group.getDescr());
            if (group.getAudit().getModified() != null) {
                this.jTextFieldModified.setText(SB.df.format(group.getAudit().getModified()));
            }
            if (group.getAudit().getCreated() != null) {
                this.jTextFieldCreated.setText(SB.df.format(group.getAudit().getCreated()));
            }
            try {
                if (group.getAudit().getModifier() > 0) {
                    this.jTextFieldModifier.setText(sbdb.getUser(group.getAudit().getModifier()).getAbr());
                }
                if (group.getAudit().getCreator() > 0) {
                    this.jTextFieldCreator.setText(sbdb.getUser(group.getAudit().getCreator()).getAbr());
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, sbdb);
            }
        }
        this.jComboBoxProject.addItem("Global");
        try {
            sbdb.loadProjectCombo(this.projModel, false);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, sbdb);
        }
        if (project != null) {
            this.jComboBoxProject.setSelectedItem((Object)project);
        } else {
            this.jComboBoxProject.setSelectedIndex(0);
        }
        if (group != null && !group.canWrite(sbdb, null) || !SBRestrictable.canWrite(sbdb)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText("You do not have permission to " + (group != null ? "edit this group." : " add a group."));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldColour = new JTextField();
        this.jButtonColour = new JButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextFieldCreated = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldCreator = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextFieldModified = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextFieldModifier = new JTextField();
        this.jLabel7 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescr = new JTextArea();
        this.jLabel8 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Name:");
        this.jTextFieldName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogTxGroup this$0;
            {
                DialogTxGroup dialogTxGroup = this$0;
                Objects.requireNonNull(dialogTxGroup);
                this.this$0 = dialogTxGroup;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jButtonColour.setText("...");
        this.jButtonColour.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTxGroup this$0;
            {
                DialogTxGroup dialogTxGroup = this$0;
                Objects.requireNonNull(dialogTxGroup);
                this.this$0 = dialogTxGroup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonColourActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Project:");
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.projModel);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel3.setText("Created:");
        this.jTextFieldCreated.setEditable(false);
        this.jLabel4.setText("by user:");
        this.jTextFieldCreator.setEditable(false);
        this.jLabel5.setText("Modified:");
        this.jTextFieldModified.setEditable(false);
        this.jLabel6.setText("by user:");
        this.jTextFieldModifier.setEditable(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldCreated).addComponent(this.jTextFieldModified, -1, 120, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCreator, -2, 70, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldModifier))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldCreated, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jTextFieldCreator, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextFieldModified, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jTextFieldModifier, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel7.setText("Colour:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTxGroup this$0;
            {
                DialogTxGroup dialogTxGroup = this$0;
                Objects.requireNonNull(dialogTxGroup);
                this.this$0 = dialogTxGroup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTxGroup this$0;
            {
                DialogTxGroup dialogTxGroup = this$0;
                Objects.requireNonNull(dialogTxGroup);
                this.this$0 = dialogTxGroup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTxGroup this$0;
            {
                DialogTxGroup dialogTxGroup = this$0;
                Objects.requireNonNull(dialogTxGroup);
                this.this$0 = dialogTxGroup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jTextAreaDescr.setColumns(20);
        this.jTextAreaDescr.setFont(this.jTextAreaDescr.getFont());
        this.jTextAreaDescr.setLineWrap(true);
        this.jTextAreaDescr.setRows(3);
        this.jTextAreaDescr.setWrapStyleWord(true);
        this.jTextAreaDescr.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogTxGroup this$0;
            {
                DialogTxGroup dialogTxGroup = this$0;
                Objects.requireNonNull(dialogTxGroup);
                this.this$0 = dialogTxGroup;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextAreaDescrKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaDescr);
        this.jLabel8.setText("Description:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel7).addComponent(this.jLabel2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldName).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldColour, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonColour, -2, 40, -2)).addComponent(this.jComboBoxProject, -2, 207, -2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxProject, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldColour, -2, -1, -2).addComponent(this.jButtonColour).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jScrollPane1, -1, 70, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.name = this.jTextFieldName.getText().trim();
        if (this.name.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter a group name", "Name", 2);
            return;
        }
        if (this.name.length() > 30) {
            this.name = this.name.substring(0, 30);
        }
        this.colour = this.jTextFieldColour.getBackground();
        this.projID = this.jComboBoxProject.getSelectedItem() instanceof Project ? ((Project)((Object)this.jComboBoxProject.getSelectedItem())).getID() : 0;
        this.descr = this.jTextAreaDescr.getText().trim();
        if (this.descr.isEmpty()) {
            this.descr = null;
        }
        this.setOK();
    }

    private void jButtonColourActionPerformed(ActionEvent evt) {
        Color c = this.jTextFieldColour.getBackground();
        if ((c = JColorChooser.showDialog((Component)((Object)this), "Colour", c)) != null) {
            this.jTextFieldColour.setBackground(c);
        }
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtousegroupsandsets.html");
    }

    private void jTextAreaDescrKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaDescr, (int)255, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }
}

