/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.scheme.Confidence;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jsbugs.DialogIGDAge;
import jsbugs.FrameJsbugs;
import model3.Chron;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.LithostratUnit;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogUnit
extends SBDialog {
    private final IGDScheme scheme;
    private static final int AGELEN = 8;
    private static final int NAMELEN = 80;
    private static final int ABBLEN = 80;
    private final DefaultComboBoxModel modelHier = new DefaultComboBoxModel();
    private final DefaultComboBoxModel modelPolarity = new DefaultComboBoxModel<Chron.Polarity>(Chron.Polarity.values());
    private final DefaultComboBoxModel modelConfidence1 = new DefaultComboBoxModel<Confidence>(Confidence.values());
    private final DefaultComboBoxModel modelConfidence2 = new DefaultComboBoxModel<Confidence>(Confidence.values());
    IGDUnitBase unit;
    private IGDUnitBase.Builder builder;
    private JButton jButtonCancel;
    private JButton jButtonChooseColour;
    private JButton jButtonOK;
    private JButton jButtonOldestRef;
    private JButton jButtonYoungestRef;
    private JComboBox jComboBoxOldestConf;
    private JComboBox jComboBoxPolarity;
    private JComboBox jComboBoxUnitType;
    private JComboBox jComboBoxYoungestConf;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelAbr;
    private JLabel jLabelColour;
    private JLabel jLabelOldestConf;
    private JLabel jLabelOldestRef;
    private JLabel jLabelPolarity;
    private JLabel jLabelYoungestConf;
    private JLabel jLabelYoungestRef;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaComments;
    private JTextField jTextFieldAbbreviation;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldOldest;
    private JTextField jTextFieldOldestRef;
    private JTextField jTextFieldUnitName;
    private JTextField jTextFieldYoungest;
    private JTextField jTextFieldYoungestRef;

    public DialogUnit(JDialog parent, boolean modal, IGDScheme scheme, IGDUnitBase unit) {
        super((Window)parent, modal);
        this.unit = unit;
        this.scheme = scheme;
        this.initComponents();
        this.init();
    }

    public DialogUnit(JFrame parent, boolean modal, IGDScheme scheme, IGDUnitBase unit) {
        super((Frame)parent, modal);
        this.unit = unit;
        this.scheme = scheme;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setHierCombo();
        if (this.unit == null) {
            this.setTitle("Unit : Add");
            switch (this.scheme.getIGDType()) {
                case 26: {
                    this.builder = new Chron.Builder(this.scheme.getDatabase());
                    break;
                }
                case 2: {
                    this.builder = new LithostratUnit.Builder(this.scheme.getDatabase());
                    break;
                }
                default: {
                    this.builder = new IGDUnit.Builder(this.scheme.getDatabase());
                    break;
                }
            }
        } else {
            this.setTitle("Unit : Edit");
            try {
                this.builder = IGDUnitBase.Builder.copyOf(this.unit, this.scheme.getDatabase());
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.scheme.getDatabase());
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            this.jComboBoxUnitType.setSelectedIndex(this.unit.getHier() - 1);
            this.jTextFieldUnitName.setText(this.unit.getName());
            if (this.unit instanceof IGDUnit) {
                this.jTextFieldAbbreviation.setText(((IGDUnit)this.unit).getAbr());
                this.jTextAreaComments.setText(((IGDUnit)this.unit).getComments());
            } else if (this.unit instanceof LithostratUnit) {
                this.jTextFieldAbbreviation.setText(((LithostratUnit)this.unit).getAbr());
            }
            if (this.unit.getUage() != null) {
                this.jTextFieldYoungest.setText("" + this.unit.getUage());
            }
            if (this.unit.getLage() != null) {
                this.jTextFieldOldest.setText("" + this.unit.getLage());
            }
            try {
                IGDScheme parentScheme;
                IGDUnit.Builder b;
                if (this.unit instanceof IGDUnit && ((IGDUnit)this.unit).isAgeDerived(true)) {
                    b = (IGDUnit.Builder)this.builder;
                    b.u_age_ref = this.scheme.findUnit(((IGDUnit)this.unit).getAgeRef(true));
                    if (b.u_age_ref == null) {
                        parentScheme = this.scheme.getDatabase().getIGDScheme(this.scheme.getParentSchID());
                        b.u_age_ref = parentScheme.findUnit(((IGDUnit)this.unit).getAgeRef(true));
                    }
                    this.jTextFieldYoungestRef.setText(((IGDUnit)this.unit).getAgePercent(true) + "% " + String.valueOf(b.u_age_ref));
                    this.jTextFieldYoungest.setText("" + SB.roundToSignificantFigures((double)this.unit.getUage(), (int)4));
                }
                if (this.unit instanceof IGDUnit && ((IGDUnit)this.unit).isAgeDerived(false)) {
                    b = (IGDUnit.Builder)this.builder;
                    b.l_age_ref = this.scheme.findUnit(((IGDUnit)this.unit).getAgeRef(false));
                    if (b.l_age_ref == null) {
                        parentScheme = this.scheme.getDatabase().getIGDScheme(this.scheme.getParentSchID());
                        b.l_age_ref = parentScheme.findUnit(((IGDUnit)this.unit).getAgeRef(false));
                    }
                    this.jTextFieldOldestRef.setText(((IGDUnit)this.unit).getAgePercent(false) + "% " + String.valueOf(b.l_age_ref));
                    this.jTextFieldOldest.setText("" + SB.roundToSignificantFigures((double)this.unit.getLage(), (int)4));
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.scheme.getDatabase());
            }
            this.jTextFieldColour.setBackground(this.unit.getColour());
            if (this.unit instanceof Chron) {
                this.jComboBoxPolarity.setSelectedItem((Object)((Chron)this.unit).getPolarity());
            } else if (this.unit instanceof LithostratUnit) {
                this.jComboBoxYoungestConf.setEnabled(false);
                this.jComboBoxOldestConf.setEnabled(false);
            } else {
                this.jComboBoxYoungestConf.setSelectedItem(((IGDUnit)this.unit).getConfidence(true));
                this.jComboBoxOldestConf.setSelectedItem(((IGDUnit)this.unit).getConfidence(false));
            }
        }
        try {
            if (!this.scheme.canWrite(this.scheme.getDatabase(), null)) {
                this.jButtonOK.setEnabled(false);
                this.jButtonOK.setToolTipText("You do not have permission to edit this scheme");
            } else {
                this.getRootPane().setDefaultButton(this.jButtonOK);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        switch (this.scheme.getIGDType()) {
            case 26: {
                this.jTextFieldAbbreviation.setVisible(false);
                this.jTextAreaComments.setVisible(false);
                this.jLabelAbr.setVisible(false);
                this.jTextFieldColour.setVisible(false);
                this.jButtonChooseColour.setVisible(false);
                this.jLabelColour.setVisible(false);
                this.jTextFieldYoungestRef.setVisible(false);
                this.jButtonYoungestRef.setVisible(false);
                this.jLabelYoungestRef.setVisible(false);
                this.jTextFieldOldestRef.setVisible(false);
                this.jButtonOldestRef.setVisible(false);
                this.jLabelOldestRef.setVisible(false);
                this.jLabelOldestConf.setVisible(false);
                this.jLabelYoungestConf.setVisible(false);
                this.jComboBoxOldestConf.setVisible(false);
                this.jComboBoxYoungestConf.setVisible(false);
                break;
            }
            case 2: {
                this.jComboBoxOldestConf.setEnabled(false);
                this.jComboBoxYoungestConf.setEnabled(false);
            }
            default: {
                this.jComboBoxPolarity.setVisible(false);
                this.jLabelPolarity.setVisible(false);
            }
        }
        this.pack();
        this.enableRefFields();
    }

    private void setHierCombo() {
        int nHier = IGDIntervalZone.getNHier(this.scheme.getIGDType(), true);
        for (int hier = 1; hier <= nHier; ++hier) {
            this.modelHier.addElement(IGDIntervalZone.getHierName(this.scheme.getIGDType(), hier));
        }
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jComboBoxUnitType = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jTextFieldUnitName = new JTextField();
        this.jLabelAbr = new JLabel();
        this.jTextFieldAbbreviation = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldYoungest = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextFieldOldest = new JTextField();
        this.jLabelColour = new JLabel();
        this.jTextFieldColour = new JTextField();
        this.jButtonChooseColour = new JButton();
        this.jLabelPolarity = new JLabel();
        this.jComboBoxPolarity = new JComboBox();
        this.jLabelYoungestRef = new JLabel();
        this.jTextFieldYoungestRef = new JTextField();
        this.jButtonYoungestRef = new JButton();
        this.jLabelOldestRef = new JLabel();
        this.jTextFieldOldestRef = new JTextField();
        this.jButtonOldestRef = new JButton();
        this.jLabelYoungestConf = new JLabel();
        this.jComboBoxYoungestConf = new JComboBox();
        this.jLabelOldestConf = new JLabel();
        this.jComboBoxOldestConf = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComments = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Unit type:");
        this.jComboBoxUnitType.setModel(this.modelHier);
        this.jLabel2.setText("Unit name:");
        this.jTextFieldUnitName.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldUnitNameFocusGained(evt);
            }
        });
        this.jTextFieldUnitName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldUnitNameKeyTyped(evt);
            }
        });
        this.jLabelAbr.setText("Abbreviation:");
        this.jTextFieldAbbreviation.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldAbbreviationFocusGained(evt);
            }
        });
        this.jTextFieldAbbreviation.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldAbbreviationKeyTyped(evt);
            }
        });
        this.jLabel4.setText("Youngest:");
        this.jTextFieldYoungest.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldYoungestFocusGained(evt);
            }
        });
        this.jTextFieldYoungest.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldYoungestKeyTyped(evt);
            }
        });
        this.jLabel5.setText("Oldest:");
        this.jTextFieldOldest.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldOldestFocusGained(evt);
            }
        });
        this.jTextFieldOldest.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldOldestKeyTyped(evt);
            }
        });
        this.jLabelColour.setText("Colour:");
        this.jTextFieldColour.setEditable(false);
        this.jButtonChooseColour.setText("...");
        this.jButtonChooseColour.setToolTipText("Select colour");
        this.jButtonChooseColour.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonChooseColourActionPerformed(evt);
            }
        });
        this.jLabelPolarity.setText("Polarity:");
        this.jComboBoxPolarity.setModel(this.modelPolarity);
        this.jComboBoxPolarity.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxPolarityActionPerformed(evt);
            }
        });
        this.jLabelYoungestRef.setText("Derived:");
        this.jTextFieldYoungestRef.setEditable(false);
        this.jButtonYoungestRef.setText("...");
        this.jButtonYoungestRef.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonYoungestRefActionPerformed(evt);
            }
        });
        this.jLabelOldestRef.setText("Derived:");
        this.jTextFieldOldestRef.setEditable(false);
        this.jTextFieldOldestRef.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jTextFieldOldestRefActionPerformed(evt);
            }
        });
        this.jButtonOldestRef.setText("...");
        this.jButtonOldestRef.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnit this$0;
            {
                DialogUnit dialogUnit = this$0;
                Objects.requireNonNull(dialogUnit);
                this.this$0 = dialogUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOldestRefActionPerformed(evt);
            }
        });
        this.jLabelYoungestConf.setText("Confidence:");
        this.jComboBoxYoungestConf.setModel(this.modelConfidence1);
        this.jLabelOldestConf.setText("Confidence:");
        this.jComboBoxOldestConf.setModel(this.modelConfidence2);
        this.jLabel3.setText("Comments:");
        this.jTextAreaComments.setColumns(20);
        this.jTextAreaComments.setLineWrap(true);
        this.jTextAreaComments.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaComments);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel).add(10, 10, 10)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jLabelPolarity).add(2, (Component)this.jLabelColour).add(2, (Component)this.jLabel3).add(2, (Component)this.jLabel5).add(2, (Component)this.jLabel4).add(2, (Component)this.jLabel2).add(2, (Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jTextFieldOldest, -2, 54, -2).add((Component)this.jTextFieldYoungest, -2, 1, Short.MAX_VALUE)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelYoungestRef).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jTextFieldYoungestRef, -2, 92, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelOldestRef).addPreferredGap(0).add((Component)this.jTextFieldOldestRef, -2, 92, -2))).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonYoungestRef, -2, 30, -2).addPreferredGap(0).add((Component)this.jLabelYoungestConf).addPreferredGap(0).add((Component)this.jComboBoxYoungestConf, 0, 70, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOldestRef, -2, 30, -2).addPreferredGap(0).add((Component)this.jLabelOldestConf).addPreferredGap(0).add((Component)this.jComboBoxOldestConf, 0, 70, Short.MAX_VALUE)))).add(2, (Component)this.jComboBoxUnitType, 0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldUnitName, -2, 192, -2).add(18, 18, 18).add((Component)this.jLabelAbr).addPreferredGap(0).add((Component)this.jTextFieldAbbreviation)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jComboBoxPolarity, 0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldColour, -2, 54, -2).addPreferredGap(0).add((Component)this.jButtonChooseColour, -2, 32, -2))).add(0, 0, Short.MAX_VALUE)).add((Component)this.jScrollPane1)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxUnitType, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldUnitName, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jLabelAbr).add((Component)this.jTextFieldAbbreviation, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldYoungest, -2, -1, -2).add((Component)this.jLabelYoungestRef).add((Component)this.jTextFieldYoungestRef, -2, -1, -2).add((Component)this.jButtonYoungestRef).add((Component)this.jLabelYoungestConf).add((Component)this.jComboBoxYoungestConf, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jTextFieldOldest, -2, -1, -2).add((Component)this.jLabelOldestRef).add((Component)this.jTextFieldOldestRef, -2, -1, -2).add((Component)this.jButtonOldestRef).add((Component)this.jLabelOldestConf).add((Component)this.jComboBoxOldestConf, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelColour).add((Component)this.jTextFieldColour, -2, -1, -2).add((Component)this.jButtonChooseColour)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelPolarity).add((Component)this.jComboBoxPolarity, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jScrollPane1, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonChooseColourActionPerformed(ActionEvent evt) {
        Color colour = JColorChooser.showDialog((Component)((Object)this), "Unit Colour : Select", this.jTextFieldColour.getBackground());
        if (colour != null) {
            this.jTextFieldColour.setBackground(colour);
        }
    }

    private void jTextFieldAbbreviationFocusGained(FocusEvent evt) {
        this.jTextFieldAbbreviation.setSelectionStart(0);
        this.jTextFieldAbbreviation.setSelectionEnd(this.jTextFieldAbbreviation.getText().length());
    }

    private void jTextFieldAbbreviationKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldAbbreviation, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldUnitNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldUnitName, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldUnitNameFocusGained(FocusEvent evt) {
        this.jTextFieldUnitName.setSelectionStart(0);
        this.jTextFieldUnitName.setSelectionEnd(this.jTextFieldUnitName.getText().length());
    }

    private void jTextFieldOldestKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldOldest, (int)8, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldOldestFocusGained(FocusEvent evt) {
        this.jTextFieldOldest.setSelectionStart(0);
        this.jTextFieldOldest.setSelectionEnd(this.jTextFieldOldest.getText().length());
    }

    private void jTextFieldYoungestFocusGained(FocusEvent evt) {
        this.jTextFieldYoungest.setSelectionStart(0);
        this.jTextFieldYoungest.setSelectionEnd(this.jTextFieldYoungest.getText().length());
    }

    private void jTextFieldYoungestKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldYoungest, (int)8, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            Double lAge;
            String name = this.jTextFieldUnitName.getText();
            if (name.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Enter a unit name", "Warning", 2);
                return;
            }
            this.builder.name(name);
            this.builder.hier(this.jComboBoxUnitType.getSelectedIndex() + 1);
            Double uAge = this.jTextFieldYoungest.getText().isBlank() ? null : Double.valueOf(this.jTextFieldYoungest.getText());
            Double d = lAge = this.jTextFieldOldest.getText().isBlank() ? null : Double.valueOf(this.jTextFieldOldest.getText());
            if (lAge != null && uAge != null && lAge < uAge) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Oldest age is less than youngest age", "Warning", 2);
                return;
            }
            LinkedList<IGDUnit> toUpdateUageToNewTop = null;
            LinkedList<IGDUnit> toUpdateUageToNewBase = null;
            LinkedList<IGDUnit> toUpdateLageToNewTop = null;
            LinkedList<IGDUnit> toUpdateLageToNewBase = null;
            boolean updateTopAge = false;
            boolean updateBaseAge = false;
            double origUage = 0.0;
            double origLage = 0.0;
            double AGEMIN = 1.0E-6;
            if (this.builder instanceof IGDUnit.Builder) {
                IGDUnit.Builder unitBuilder = (IGDUnit.Builder)this.builder;
                unitBuilder.abr(this.jTextFieldAbbreviation.getText()).colour(this.jTextFieldColour.getBackground()).comments(this.jTextAreaComments.getText());
                unitBuilder.getigdAge(true).setConfidence((Confidence)this.jComboBoxYoungestConf.getSelectedItem());
                unitBuilder.getigdAge(false).setConfidence((Confidence)this.jComboBoxOldestConf.getSelectedItem());
                if (unitBuilder.getigdAge(true).getRefID() == 0) {
                    unitBuilder.age(true, uAge);
                }
                if (unitBuilder.getigdAge(false).getRefID() == 0) {
                    unitBuilder.age(false, lAge);
                }
                if (unitBuilder.u_age_ref != null && this.scheme.findUnit(unitBuilder.u_age_ref.getName()) != null && unitBuilder.u_age_ref.getHier() >= this.builder.getHier()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Illegal youngest boundary unit reference: boundary age must be derived from higher level unit.\nUpdate unit type or youngest boundary unit relationship", this.getTitle(), 2);
                    return;
                }
                if (unitBuilder.l_age_ref != null && this.scheme.findUnit(unitBuilder.l_age_ref.getName()) != null && unitBuilder.l_age_ref.getHier() >= this.builder.getHier()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Illegal oldest boundary unit reference: boundary age must be derived from higher level unit.\nUpdate unit type or oldest boundary unit relationship", this.getTitle(), 2);
                    return;
                }
                if (this.unit != null) {
                    for (IGDUnit iGDUnit : this.scheme.getUnits()) {
                        for (boolean b : new boolean[]{true, false}) {
                            if (iGDUnit.getAgeRef(b) != this.unit.getUnitID() || iGDUnit.getHier() > this.builder.getHier()) continue;
                            JOptionPane.showMessageDialog((Component)((Object)this), "Can't change unit type because this unit is referenced by '" + String.valueOf(iGDUnit) + "' at " + IGDIntervalZone.getHierName(this.scheme.getIGDType(), iGDUnit.getHier()) + " level\n(boundary age must be derived from higher level unit)", this.getTitle(), 2);
                            return;
                        }
                    }
                    if (this.unit.hasAges()) {
                        Object msg;
                        origUage = ((IGDUnit)this.unit).getUage();
                        origLage = ((IGDUnit)this.unit).getLage();
                        updateTopAge = Math.abs(origUage - this.builder.getUage()) > 1.0E-6;
                        boolean bl = updateBaseAge = Math.abs(origLage - this.builder.getLage()) > 1.0E-6;
                        if (updateTopAge) {
                            toUpdateUageToNewTop = new LinkedList<IGDUnit>();
                            toUpdateLageToNewTop = new LinkedList<IGDUnit>();
                            for (IGDUnit iGDUnit : this.scheme.getUnits()) {
                                if (iGDUnit.getUnitID() == this.builder.getOriginalID() || iGDUnit.isAgeDerived(true)) continue;
                                if (iGDUnit.getUage() != null && Math.abs(origUage - iGDUnit.getUage()) < 1.0E-6 && !iGDUnit.isAgeDerived(true)) {
                                    toUpdateUageToNewTop.add(iGDUnit);
                                }
                                if (iGDUnit.getLage() == null || !(Math.abs(origUage - iGDUnit.getLage()) < 1.0E-6) || iGDUnit.isAgeDerived(false)) continue;
                                toUpdateLageToNewTop.add(iGDUnit);
                            }
                            if (!toUpdateUageToNewTop.isEmpty() || !toUpdateLageToNewTop.isEmpty()) {
                                msg = "Update other unit ages to new upper age?\n";
                                for (IGDUnit u : toUpdateUageToNewTop) {
                                    msg = (String)msg + "Top: " + u.getName() + "\n";
                                }
                                for (IGDUnit u : toUpdateLageToNewTop) {
                                    msg = (String)msg + "Base: " + u.getName() + "\n";
                                }
                                int n = JOptionPane.showConfirmDialog((Component)((Object)this), msg, this.getTitle(), 1, 3);
                                if (n == 2) {
                                    return;
                                }
                                if (n == 0) {
                                    if (origUage > this.builder.getUage()) {
                                        this.updateAgeList(false, this.builder.getUage(), toUpdateLageToNewTop);
                                    } else if (origUage < this.builder.getUage()) {
                                        this.updateAgeList(true, this.builder.getUage(), toUpdateUageToNewTop);
                                    }
                                } else {
                                    toUpdateUageToNewTop.clear();
                                    toUpdateLageToNewTop.clear();
                                }
                            }
                        }
                        if (updateBaseAge) {
                            toUpdateUageToNewBase = new LinkedList<IGDUnit>();
                            toUpdateLageToNewBase = new LinkedList<IGDUnit>();
                            for (IGDUnit iGDUnit : this.scheme.getUnits()) {
                                if (iGDUnit.getUnitID() == this.builder.getOriginalID()) continue;
                                if (Math.abs(origLage - iGDUnit.getUage()) < 1.0E-6 && !iGDUnit.isAgeDerived(true)) {
                                    toUpdateUageToNewBase.add(iGDUnit);
                                }
                                if (!(Math.abs(origLage - iGDUnit.getLage()) < 1.0E-6) || iGDUnit.isAgeDerived(false)) continue;
                                toUpdateLageToNewBase.add(iGDUnit);
                            }
                            if (!toUpdateUageToNewBase.isEmpty() || !toUpdateLageToNewBase.isEmpty()) {
                                msg = "Update other unit ages to new lower age?\n";
                                for (IGDUnit u : toUpdateUageToNewBase) {
                                    msg = (String)msg + "Top: " + u.getName() + "\n";
                                }
                                for (IGDUnit u : toUpdateLageToNewBase) {
                                    msg = (String)msg + "Base: " + u.getName() + "\n";
                                }
                                int n = JOptionPane.showConfirmDialog((Component)((Object)this), msg, this.getTitle(), 1, 3);
                                if (n == 2) {
                                    return;
                                }
                                if (n == 0) {
                                    if (origLage < this.builder.getLage()) {
                                        this.updateAgeList(true, this.builder.getLage(), toUpdateUageToNewBase);
                                    } else if (origLage > this.builder.getLage()) {
                                        this.updateAgeList(false, this.builder.getLage(), toUpdateLageToNewBase);
                                    }
                                } else {
                                    toUpdateUageToNewBase.clear();
                                    toUpdateLageToNewBase.clear();
                                }
                            }
                        }
                    }
                }
            } else if (this.builder instanceof LithostratUnit.Builder) {
                LithostratUnit.Builder unitBuilder = (LithostratUnit.Builder)this.builder;
                unitBuilder.abr(this.jTextFieldAbbreviation.getText()).colour(this.jTextFieldColour.getBackground());
                double[] age = new double[4];
                age[1] = uAge == null ? 0.0 : uAge;
                age[0] = age[1];
                age[3] = lAge == null ? 0.0 : lAge;
                age[2] = age[3];
                unitBuilder.age(age);
            } else if (this.builder instanceof Chron.Builder) {
                Chron.Builder chronBuilder = (Chron.Builder)this.builder;
                chronBuilder.polarity((Chron.Polarity)((Object)this.jComboBoxPolarity.getSelectedItem()));
                chronBuilder.uAge(uAge).lAge(lAge);
            }
            if (this.unit == null) {
                this.unit = this.scheme.addUnit(this.builder);
            } else {
                this.unit = this.scheme.updateUnit(this.builder);
                if (updateTopAge) {
                    if (origUage > this.builder.getUage()) {
                        this.updateAgeList(true, this.builder.getUage(), toUpdateUageToNewTop);
                    } else if (origUage < this.builder.getUage()) {
                        this.updateAgeList(false, this.builder.getUage(), toUpdateLageToNewTop);
                    }
                }
                if (updateBaseAge) {
                    if (origLage < this.builder.getLage()) {
                        this.updateAgeList(false, this.builder.getLage(), toUpdateLageToNewBase);
                    } else if (origLage > this.builder.getLage()) {
                        this.updateAgeList(true, this.builder.getLage(), toUpdateUageToNewBase);
                    }
                }
            }
            this.scheme.getDatabase().commit();
            this.scheme.notifyObservers();
            this.setOK();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Cannot update unit:\n" + e.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException ex) {
            this.scheme.getDatabase().doRollback();
            FrameJsbugs.showStackError("SQL Error", ex, this.scheme.getDatabase());
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void updateAgeList(boolean updateTop, double newAge, List<IGDUnit> toUpdate) throws SQLException, SBException, InvalidFieldException {
        if (toUpdate == null) {
            return;
        }
        Iterator<IGDUnit> it = toUpdate.iterator();
        while (it.hasNext()) {
            IGDUnit u = it.next();
            IGDUnit.Builder updateBuilder = (IGDUnit.Builder)IGDUnit.Builder.copyOf(u, this.scheme.getDatabase());
            updateBuilder.age(updateTop, (Double)newAge);
            this.scheme.updateUnit(updateBuilder);
            it.remove();
        }
    }

    private void jButtonYoungestRefActionPerformed(ActionEvent evt) {
        this.setAgeRef(true);
    }

    private void jButtonOldestRefActionPerformed(ActionEvent evt) {
        this.setAgeRef(false);
    }

    private void jTextFieldOldestRefActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxPolarityActionPerformed(ActionEvent evt) {
    }

    private void setAgeRef(boolean upper) {
        try {
            if (this.scheme.getIGDType() == 2) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Derived ages are not available for Lithostratigraphy schemes.", this.getTitle(), 2);
                return;
            }
            IGDScheme parentScheme = this.scheme.getDatabase().getIGDScheme(this.scheme.getParentSchID());
            if (parentScheme == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You must set a parent scheme.", this.getTitle(), 2);
                return;
            }
            IGDUnit ageRef = null;
            if (this.unit != null && ((IGDUnit)this.unit).isAgeDerived(upper) && (ageRef = this.scheme.findUnit(((IGDUnit)this.unit).getAgeRef(upper))) == null) {
                ageRef = parentScheme.findUnit(((IGDUnit)this.unit).getAgeRef(upper));
            }
            parentScheme.loadUnits();
            DialogIGDAge dialog = new DialogIGDAge((Window)((Object)this), true, parentScheme, this.scheme, null, this.scheme.getName(), ageRef, this.unit == null ? (upper ? 100 : 0) : ((IGDUnit)this.unit).getAgePercent(upper), this.unit);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                Double currentAge;
                IGDUnit.Builder unitBuilder = (IGDUnit.Builder)this.builder;
                Double d = currentAge = upper ? unitBuilder.getUage() : unitBuilder.getLage();
                if (dialog.ageRef instanceof IGDUnit) {
                    unitBuilder.ageRef(upper, ((IGDUnit)dialog.ageRef).getUnitID());
                } else {
                    unitBuilder.ageRef(upper, 0);
                    if (upper) {
                        unitBuilder.age(true, currentAge);
                    } else {
                        unitBuilder.age(false, currentAge);
                    }
                }
                unitBuilder.ageVal(upper, dialog.refVal);
                if (dialog.ageRef != null) {
                    unitBuilder.getigdAge(upper).calcAge(dialog.ageRef);
                }
                (upper ? this.jTextFieldYoungest : this.jTextFieldOldest).setText("" + unitBuilder.getigdAge(upper).getAge());
                (upper ? this.jTextFieldYoungestRef : this.jTextFieldOldestRef).setText((String)(unitBuilder.getigdAge(upper).getRefID() > 0 ? unitBuilder.getigdAge(upper).getPercent() + "% " + String.valueOf(dialog.ageRef) : ""));
                if (upper) {
                    unitBuilder.u_age_ref = dialog.ageRef;
                } else {
                    unitBuilder.l_age_ref = dialog.ageRef;
                }
            }
            this.enableRefFields();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.scheme.getDatabase());
        }
    }

    private void enableRefFields() {
        this.jTextFieldYoungest.setEditable(!(this.builder instanceof IGDUnit.Builder) || ((IGDUnit.Builder)this.builder).getigdAge(true).getRefID() == 0);
        this.jTextFieldOldest.setEditable(!(this.builder instanceof IGDUnit.Builder) || ((IGDUnit.Builder)this.builder).getigdAge(false).getRefID() == 0);
    }
}

