/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectProjectWellList;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.wellheader.DialogSelectWell;
import model3.SBdb;
import model3.TxGroupSet;
import model3.Well;
import model3.project.WellList;
import org.jdesktop.layout.GroupLayout;
import util.SBException;

public class DialogWellDisc
extends JDialog {
    boolean isOK = false;
    SBdb db;
    LinkedList<Well> wells = new LinkedList();
    char discID;
    String analyst;
    TxGroupSet set;
    private final DefaultComboBoxModel analystModel = new DefaultComboBoxModel();
    private static final String ALL_STRING = "<All analyses>";
    private static final String NONITEM = "<none>";
    private final DefaultComboBoxModel comboBoxModelProjects = new DefaultComboBoxModel();
    private ButtonGroup buttonGroupDisc;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSelectWell;
    private JButton jButtonSelectWellList;
    private JComboBox jComboBoxAnalyst;
    private JComboBox jComboBoxExcludeSet;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonMacro;
    private JRadioButton jRadioButtonMicro;
    private JRadioButton jRadioButtonNanno;
    private JRadioButton jRadioButtonPaly;
    private JSeparator jSeparator1;
    private JTextField jTextFieldWellList;
    private JTextField jTextFieldWellName;

    public DialogWellDisc(Frame parent, boolean modal, SBdb db, Well well, boolean showGroupSets) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(well, showGroupSets);
    }

    private void init(Well well, boolean showGroupSets) {
        this.analystModel.addElement(ALL_STRING);
        this.jComboBoxAnalyst.repaint();
        this.setTitle("Well/Discipline : Select");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.comboBoxModelProjects.removeAllElements();
        try {
            this.db.loadProjectCombo(this.comboBoxModelProjects, true);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            this.comboBoxModelProjects.addElement(ex.getMessage());
        }
        if (well != null) {
            this.wells.add(well);
            this.setWell();
        }
        this.jButtonSelectWell.putClientProperty("JComponent.sizeVariant", "small");
        this.jComboBoxAnalyst.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxExcludeSet.removeAllItems();
        this.jComboBoxExcludeSet.addItem(NONITEM);
        if (showGroupSets) {
            try {
                for (TxGroupSet set : this.db.getTxGroupSetsSorted()) {
                    this.jComboBoxExcludeSet.addItem(set);
                }
            }
            catch (SQLException ex) {
                FrameJsbugs.showStackError("Error loading group sets", ex, this.db);
            }
        } else {
            this.jComboBoxExcludeSet.setEnabled(false);
            this.jLabel3.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroupDisc = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldWellName = new JTextField();
        this.jButtonSelectWell = new JButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxAnalyst = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel3 = new JLabel();
        this.jComboBoxExcludeSet = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMicro = new JRadioButton();
        this.jRadioButtonNanno = new JRadioButton();
        this.jRadioButtonPaly = new JRadioButton();
        this.jRadioButtonMacro = new JRadioButton();
        this.jTextFieldWellList = new JTextField();
        this.jButtonSelectWellList = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Wells/outcrops:");
        this.jTextFieldWellName.setEditable(false);
        this.jTextFieldWellName.setBackground(new Color(255, 255, 204));
        this.jButtonSelectWell.setText("...");
        this.jButtonSelectWell.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDisc this$0;
            {
                DialogWellDisc dialogWellDisc = this$0;
                Objects.requireNonNull(dialogWellDisc);
                this.this$0 = dialogWellDisc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectWellActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Analyst:");
        this.jComboBoxAnalyst.setModel(this.analystModel);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDisc this$0;
            {
                DialogWellDisc dialogWellDisc = this$0;
                Objects.requireNonNull(dialogWellDisc);
                this.this$0 = dialogWellDisc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDisc this$0;
            {
                DialogWellDisc dialogWellDisc = this$0;
                Objects.requireNonNull(dialogWellDisc);
                this.this$0 = dialogWellDisc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Excluding Set:");
        this.jComboBoxExcludeSet.setMaximumRowCount(30);
        this.jComboBoxExcludeSet.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxExcludeSet.setToolTipText("Exclude from the search all species in group set");
        this.jLabel4.setText("Project/Well list:");
        this.buttonGroupDisc.add(this.jRadioButtonMicro);
        this.jRadioButtonMicro.setText("Microfauna");
        this.jRadioButtonMicro.setEnabled(false);
        this.jRadioButtonMicro.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDisc this$0;
            {
                DialogWellDisc dialogWellDisc = this$0;
                Objects.requireNonNull(dialogWellDisc);
                this.this$0 = dialogWellDisc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMicroActionPerformed(evt);
            }
        });
        this.buttonGroupDisc.add(this.jRadioButtonNanno);
        this.jRadioButtonNanno.setText("Nannoflora");
        this.jRadioButtonNanno.setEnabled(false);
        this.jRadioButtonNanno.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDisc this$0;
            {
                DialogWellDisc dialogWellDisc = this$0;
                Objects.requireNonNull(dialogWellDisc);
                this.this$0 = dialogWellDisc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonNannoActionPerformed(evt);
            }
        });
        this.buttonGroupDisc.add(this.jRadioButtonPaly);
        this.jRadioButtonPaly.setText("Palynoflora");
        this.jRadioButtonPaly.setEnabled(false);
        this.jRadioButtonPaly.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDisc this$0;
            {
                DialogWellDisc dialogWellDisc = this$0;
                Objects.requireNonNull(dialogWellDisc);
                this.this$0 = dialogWellDisc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPalyActionPerformed(evt);
            }
        });
        this.buttonGroupDisc.add(this.jRadioButtonMacro);
        this.jRadioButtonMacro.setText("Macrofauna");
        this.jRadioButtonMacro.setEnabled(false);
        this.jRadioButtonMacro.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDisc this$0;
            {
                DialogWellDisc dialogWellDisc = this$0;
                Objects.requireNonNull(dialogWellDisc);
                this.this$0 = dialogWellDisc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMacroActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonMicro).add((Component)this.jRadioButtonNanno).add((Component)this.jRadioButtonPaly).add((Component)this.jRadioButtonMacro)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonMicro).addPreferredGap(1).add((Component)this.jRadioButtonNanno).addPreferredGap(1).add((Component)this.jRadioButtonPaly).addPreferredGap(1).add((Component)this.jRadioButtonMacro).add(0, 6, Short.MAX_VALUE)));
        this.jTextFieldWellList.setEditable(false);
        this.jButtonSelectWellList.setText("...");
        this.jButtonSelectWellList.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellDisc this$0;
            {
                DialogWellDisc dialogWellDisc = this$0;
                Objects.requireNonNull(dialogWellDisc);
                this.this$0 = dialogWellDisc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectWellListActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jSeparator1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(9, 9, 9).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel3)).add(9, 9, 9).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jComboBoxAnalyst, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxExcludeSet, 0, -1, Short.MAX_VALUE)))))).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jTextFieldWellList).add(1, (Component)this.jTextFieldWellName, -2, 183, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonSelectWell, -2, 30, -2).add((Component)this.jButtonSelectWellList, -2, 30, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(23, 23, 23).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldWellList, -2, -1, -2).add((Component)this.jButtonSelectWellList)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldWellName, -2, -1, -2).add((Component)this.jButtonSelectWell)).add(18, 18, 18).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBoxAnalyst, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxExcludeSet, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 8, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonSelectWellActionPerformed(ActionEvent evt) {
        DialogSelectWell dialog = new DialogSelectWell(this, true, this.db, true, null);
        dialog.setVisible(true);
        if (dialog.getSelection() != null) {
            for (Well well : dialog.getSelection()) {
                this.wells.add(well);
            }
            this.setWell();
        }
    }

    private void setWell() {
        try {
            List<String> analysts;
            Object names = "";
            for (Well well : this.wells) {
                if (!((String)names).isEmpty()) {
                    names = (String)names + ", ";
                }
                names = (String)names + well.getWellName();
            }
            this.jTextFieldWellName.setText((String)names);
            JRadioButton selection = null;
            JRadioButton[] rbs = new JRadioButton[]{this.jRadioButtonMacro, this.jRadioButtonMicro, this.jRadioButtonNanno, this.jRadioButtonPaly};
            int discID = 0;
            int nSelected = 0;
            for (JRadioButton jb : rbs) {
                jb.setEnabled(false);
                jb.setSelected(false);
            }
            for (Well well : this.wells) {
                analysts = well.getAnalysts(Discipline.MICRO);
                if (analysts.isEmpty()) continue;
                this.jRadioButtonMicro.setEnabled(true);
                selection = this.jRadioButtonMicro;
                discID = 77;
                ++nSelected;
                break;
            }
            for (Well well : this.wells) {
                analysts = well.getAnalysts(Discipline.NANNO);
                if (analysts.isEmpty()) continue;
                this.jRadioButtonNanno.setEnabled(true);
                selection = this.jRadioButtonNanno;
                discID = 78;
                ++nSelected;
                break;
            }
            for (Well well : this.wells) {
                analysts = well.getAnalysts(Discipline.PALY);
                if (analysts.isEmpty()) continue;
                this.jRadioButtonPaly.setEnabled(true);
                selection = this.jRadioButtonPaly;
                discID = 80;
                ++nSelected;
                break;
            }
            for (Well well : this.wells) {
                analysts = well.getAnalysts(Discipline.MACRO);
                if (analysts.isEmpty()) continue;
                this.jRadioButtonMacro.setEnabled(true);
                selection = this.jRadioButtonMacro;
                discID = 65;
                ++nSelected;
                break;
            }
            if (nSelected == 1) {
                selection.setSelected(true);
                this.selectAnalysts((char)discID);
            } else {
                this.buttonGroupDisc.clearSelection();
                this.analystModel.removeAllElements();
                this.jComboBoxAnalyst.repaint();
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Problem getting discipline data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Problem getting discipline data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.wells.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No well(s) selected", this.getTitle(), 1);
            return;
        }
        if (this.buttonGroupDisc.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select a discipline", this.getTitle(), 1);
            return;
        }
        if (this.jRadioButtonMacro.isSelected()) {
            this.discID = (char)65;
        } else if (this.jRadioButtonMicro.isSelected()) {
            this.discID = (char)77;
        } else if (this.jRadioButtonNanno.isSelected()) {
            this.discID = (char)78;
        } else if (this.jRadioButtonPaly.isSelected()) {
            this.discID = (char)80;
        }
        if (!this.jComboBoxAnalyst.getSelectedItem().equals(ALL_STRING)) {
            this.analyst = (String)this.jComboBoxAnalyst.getSelectedItem();
        }
        this.set = null;
        try {
            if (this.jComboBoxExcludeSet.getSelectedIndex() > 0) {
                this.set = (TxGroupSet)this.jComboBoxExcludeSet.getSelectedItem();
                this.set.getGroups();
            }
            this.isOK = true;
            this.dispose();
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Problem getting discipline data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void selectAnalysts(char discID) {
        try {
            TreeSet<String> analysts = new TreeSet<String>();
            for (Well well : this.wells) {
                analysts.addAll(well.getAnalysts(Discipline.getDisc((char)discID)));
            }
            this.analystModel.removeAllElements();
            this.analystModel.addElement(ALL_STRING);
            for (Object e : analysts) {
                this.analystModel.addElement(e);
            }
            this.jComboBoxAnalyst.repaint();
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Problem getting discipline data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Problem getting discipline data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jRadioButtonNannoActionPerformed(ActionEvent evt) {
        this.selectAnalysts('N');
    }

    private void jRadioButtonMicroActionPerformed(ActionEvent evt) {
        this.selectAnalysts('M');
    }

    private void jRadioButtonPalyActionPerformed(ActionEvent evt) {
        this.selectAnalysts('P');
    }

    private void jRadioButtonMacroActionPerformed(ActionEvent evt) {
        this.selectAnalysts('A');
    }

    private void jButtonSelectWellListActionPerformed(ActionEvent evt) {
        try {
            DialogSelectProjectWellList dialog = new DialogSelectProjectWellList((Window)this, this.db, null, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                WellList wellList = dialog.getSelection();
                this.jTextFieldWellList.setText(wellList.toString());
                this.wells.clear();
                Iterator<Well> it = this.db.getWellIterator(wellList.getID());
                while (it.hasNext()) {
                    this.wells.add(it.next());
                }
                this.setWell();
            }
        }
        catch (SQLException | SBException sSql) {
            SbugsExceptionHandler.showDialogStackError(sSql, this);
        }
    }
}

