/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.DialogSelectEvent;
import jsbugs.DialogSelectSample;
import jsbugs.FrameJsbugs;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.uiutil.audit.JPanelAuditColumn;
import jsbugs.userconnect.DialogSelectAnalyst;
import model3.SBEvent;
import model3.SBdb;
import model3.Sample;
import model3.Taxon;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogWellEvent
extends SBDialog {
    private static final int NAMELEN = 100;
    private static final int SOURCELEN = 5;
    private static final int COMLEN = 240;
    private static final int QUALLEN = 16;
    private static final int ERRLEN = 6;
    private static final int COMPANYLEN = 20;
    private final SBdb db;
    private final Well well;
    private final WellInterp wellInterp;
    private final char units;
    private Sample sample;
    private SBEvent event;
    private EventType eventType;
    private WellEvent wellEvent;
    private final DefaultComboBoxModel comboModelDiscipline = new DefaultComboBoxModel<Discipline>(Discipline.values());
    private final DefaultComboBoxModel confModel = new DefaultComboBoxModel<Confidence>(Confidence.values());
    private ButtonGroup buttonGroupType;
    private JButton jButtonAnalyst;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEvent;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSample;
    private JButton jButtonErrDefault;
    private JButton jButtonClearErr;
    private JComboBox jComboBoxConfidence;
    private JComboBox jComboBoxDiscipline;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanelAuditColumn jPanelAudit;
    private JRadioButton jRadioButtonBase;
    private JRadioButton jRadioButtonSingle;
    private JRadioButton jRadioButtonTop;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextArea jTextAreaComment;
    private JTextField jTextFieldAnalyst;
    private JTextField jTextFieldCompany;
    private JTextField jTextFieldDepth;
    private JTextField jTextFieldErrMinus;
    private JTextField jTextFieldErrPlus;
    private JTextField jTextFieldEventName;
    private JTextField jTextFieldQual;
    private JTextField jTextFieldSource;

    public DialogWellEvent(Frame parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, char units, WellEvent wellEvent, Sample sample, SBEvent event, EventType eventType) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.units = units;
        this.wellInterp = wellInterp;
        this.sample = sample;
        this.event = event;
        this.wellEvent = wellEvent;
        this.eventType = eventType;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        Discipline discID;
        this.comboModelDiscipline.insertElementAt("", 0);
        if (this.wellEvent == null) {
            this.setTitle("Event : Add to Well");
            this.jComboBoxDiscipline.setSelectedIndex(0);
            this.jPanelAudit.setVisible(false);
        } else {
            this.sample = this.wellEvent.getSample();
            this.event = this.wellEvent.getEvent();
            this.eventType = this.wellEvent.getTypeObj();
            this.jTextAreaComment.setText(this.wellEvent.getComments());
            this.jTextFieldAnalyst.setText(this.wellEvent.getAnalystString());
            discID = this.wellEvent.getDiscipline();
            if (discID != null) {
                this.jComboBoxDiscipline.setSelectedItem(discID);
            } else {
                this.jComboBoxDiscipline.setSelectedIndex(0);
            }
            this.jTextFieldQual.setText(this.wellEvent.getQualifier());
            this.jTextFieldSource.setText(this.wellEvent.getSource());
            this.jTextFieldCompany.setText(this.wellEvent.getCompany());
            this.jComboBoxConfidence.setSelectedItem(this.wellEvent.getConfidence());
            if (this.wellEvent.getErrMinus() != null) {
                this.jTextFieldErrMinus.setText("" + DepthUtils.convFromM((double)this.wellEvent.getErrMinus(), (char)this.units));
            }
            if (this.wellEvent.getErrPlus() != null) {
                this.jTextFieldErrPlus.setText("" + DepthUtils.convFromM((double)this.wellEvent.getErrPlus(), (char)this.units));
            }
            this.jPanelAudit.setAuditText(this.wellEvent.getCreator(), this.wellEvent.getCreated(), this.wellEvent.getModifier(), this.wellEvent.getModified());
            this.jSeparator1.setVisible(false);
            this.setTitle("Event : Edit in well");
        }
        this.jComboBoxDiscipline.repaint();
        if (this.sample != null) {
            this.jTextFieldDepth.setText(this.sample.toString(this.units, true, true));
        }
        if (this.event != null) {
            this.jTextFieldEventName.setText(this.event.toString());
            this.setEventType();
            if (this.jComboBoxDiscipline.getSelectedIndex() < 1) {
                Discipline discipline = discID = this.event.getTaxon() != null ? this.event.getTaxon().getDisc() : null;
                if (discID != null) {
                    this.jComboBoxDiscipline.setSelectedItem(discID);
                } else {
                    this.jComboBoxDiscipline.setSelectedIndex(0);
                }
            }
        }
        if (this.eventType != null) {
            switch (this.eventType) {
                case TOP: {
                    this.jRadioButtonTop.setSelected(true);
                    break;
                }
                case BASE: {
                    this.jRadioButtonBase.setSelected(true);
                    break;
                }
                case SINGLE: {
                    this.jRadioButtonSingle.setSelected(true);
                }
            }
        }
        this.jRadioButtonTop.setText(EventType.TOP.toString(EventContext.WELL) + " event");
        this.jRadioButtonBase.setText(EventType.BASE.toString(EventContext.WELL) + " event");
        this.jButtonDelete.setVisible(this.wellEvent != null);
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.jButtonDelete.setEnabled(false);
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
        this.pack();
    }

    private void setEventType() {
        this.jRadioButtonTop.setEnabled(this.event.hasEvType(EventType.TOP));
        if (this.jRadioButtonTop.isSelected() && !this.event.hasEvType(EventType.TOP)) {
            this.jRadioButtonTop.setSelected(false);
        }
        this.jRadioButtonBase.setEnabled(this.event.hasEvType(EventType.BASE));
        if (this.jRadioButtonBase.isSelected() && !this.event.hasEvType(EventType.BASE)) {
            this.jRadioButtonBase.setSelected(false);
        }
        this.jRadioButtonSingle.setEnabled(this.event.hasEvType(EventType.SINGLE));
        if (this.jRadioButtonSingle.isSelected() && !this.event.hasEvType(EventType.SINGLE)) {
            this.jRadioButtonSingle.setSelected(false);
        }
    }

    private void initComponents() {
        this.buttonGroupType = new ButtonGroup();
        this.jButtonSample = new JButton();
        this.jButtonEvent = new JButton();
        this.jTextFieldDepth = new JTextField();
        this.jTextFieldEventName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonTop = new JRadioButton();
        this.jRadioButtonBase = new JRadioButton();
        this.jRadioButtonSingle = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel3 = new JLabel();
        this.jComboBoxDiscipline = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldAnalyst = new JTextField();
        this.jButtonAnalyst = new JButton();
        this.jTextFieldQual = TextFieldUtils.buildLimitedLengthTextField(16);
        this.jTextFieldSource = TextFieldUtils.buildLimitedLengthTextField(5);
        this.jTextFieldCompany = TextFieldUtils.buildLimitedLengthTextField(20);
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = TextFieldUtils.buildLimitedLengthTextArea(240);
        this.jLabel9 = new JLabel();
        this.jComboBoxConfidence = new JComboBox();
        this.jButtonDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jTextFieldErrPlus = TextFieldUtils.buildDecimalOnlyTextField(false, null, 5);
        this.jLabel11 = new JLabel();
        this.jTextFieldErrMinus = TextFieldUtils.buildDecimalOnlyTextField(false, null, 5);
        this.jButtonErrDefault = new JButton();
        this.jButtonClearErr = new JButton();
        this.jPanelAudit = new JPanelAuditColumn();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonSample.setText("...");
        this.jButtonSample.setToolTipText("Select sample");
        this.jButtonSample.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSample.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSampleActionPerformed(evt);
            }
        });
        this.jButtonEvent.setText("...");
        this.jButtonEvent.setToolTipText("Select event from event dictionary");
        this.jButtonEvent.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonEvent.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEventActionPerformed(evt);
            }
        });
        this.jTextFieldDepth.setEditable(false);
        this.jTextFieldDepth.setBackground(new Color(255, 255, 204));
        this.jTextFieldDepth.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldDepthFocusGained(evt);
            }
        });
        this.jTextFieldEventName.setEditable(false);
        this.jTextFieldEventName.setBackground(new Color(255, 255, 204));
        this.jTextFieldEventName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldEventNameKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Sample depth:");
        this.jLabel2.setText("Event name:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Event Type", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupType.add(this.jRadioButtonTop);
        this.jRadioButtonTop.setText("Top event");
        this.jRadioButtonTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonTop.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupType.add(this.jRadioButtonBase);
        this.jRadioButtonBase.setText("Base event");
        this.jRadioButtonBase.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonBase.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupType.add(this.jRadioButtonSingle);
        this.jRadioButtonSingle.setText("Single event");
        this.jRadioButtonSingle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSingle.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonTop).addPreferredGap(1).add((Component)this.jRadioButtonBase).addPreferredGap(1).add((Component)this.jRadioButtonSingle).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonBase).add((Component)this.jRadioButtonSingle).add((Component)this.jRadioButtonTop)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Comment:");
        this.jComboBoxDiscipline.setModel(this.comboModelDiscipline);
        this.jComboBoxDiscipline.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel4.setText("Discipline: ");
        this.jLabel5.setText("Analyst: ");
        this.jTextFieldAnalyst.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldAnalystKeyTyped(evt);
            }
        });
        this.jButtonAnalyst.setText("...");
        this.jButtonAnalyst.setToolTipText("Select analyst");
        this.jButtonAnalyst.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonAnalyst.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAnalystActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Qualifier:");
        this.jLabel7.setText("Source:");
        this.jLabel8.setText("Company:");
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setFont(this.jTextAreaComment.getFont());
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(3);
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        this.jLabel9.setText("Confidence:");
        this.jComboBoxConfidence.setModel(this.confModel);
        this.jComboBoxConfidence.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Depth error", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel10.setHorizontalAlignment(11);
        this.jLabel10.setText("minus:");
        this.jLabel11.setHorizontalAlignment(11);
        this.jLabel11.setText("plus:");
        this.jButtonErrDefault.setText("Use next sample");
        this.jButtonErrDefault.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonErrDefaultActionPerformed(evt);
            }
        });
        this.jButtonClearErr.setText("Clear");
        this.jButtonClearErr.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWellEvent this$0;
            {
                DialogWellEvent dialogWellEvent = this$0;
                Objects.requireNonNull(dialogWellEvent);
                this.this$0 = dialogWellEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearErrActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel10, -2, 41, -2).addPreferredGap(0).add((Component)this.jTextFieldErrMinus, -2, 56, -2).addPreferredGap(1).add((Component)this.jLabel11).addPreferredGap(0).add((Component)this.jTextFieldErrPlus, -2, 56, -2).addPreferredGap(1).add((Component)this.jButtonErrDefault).addPreferredGap(0).add((Component)this.jButtonClearErr).addContainerGap(29, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.jTextFieldErrMinus, this.jTextFieldErrPlus}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.jTextFieldErrMinus, -2, -1, -2).add((Component)this.jLabel11).add((Component)this.jTextFieldErrPlus, -2, -1, -2).add((Component)this.jButtonErrDefault).add((Component)this.jButtonClearErr)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelAudit.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(11, 11, 11).add((Component)this.jLabel2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonEvent, -2, 30, -2)).add((Component)this.jSeparator1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jPanel2, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add(2, (Component)this.jLabel9).add(2, (Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldEventName, -2, 305, -2).add(0, 0, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldDepth, -2, 305, -2).addPreferredGap(0, 22, Short.MAX_VALUE).add((Component)this.jButtonSample, -2, 30, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jComboBoxConfidence, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxDiscipline, 0, -1, Short.MAX_VALUE)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jLabel5).add(2, (Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldAnalyst, -2, 102, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonAnalyst, -2, 30, -2)).add((Component)this.jTextFieldQual, -2, 139, -2))))).add((Component)this.jPanelAudit, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonDelete).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jLabel8)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).add(0, 0, Short.MAX_VALUE))).addPreferredGap(0)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 36, Short.MAX_VALUE).add((Component)this.jLabel7).add(4, 4, 4))).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jScrollPane1).add((Component)this.jTextFieldCompany, -2, 360, -2).add((Component)this.jTextFieldSource, -2, 90, -2)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonDelete, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jButtonSample).add((Component)this.jTextFieldDepth, -2, -1, -2)).add(4, 4, 4).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jButtonEvent).add((Component)this.jTextFieldEventName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxConfidence, -2, -1, -2).add((Component)this.jTextFieldQual, -2, -1, -2).add((Component)this.jLabel6).add((Component)this.jLabel9)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jComboBoxDiscipline, -2, -1, -2).add((Component)this.jLabel5).add((Component)this.jTextFieldAnalyst, -2, -1, -2).add((Component)this.jButtonAnalyst)).addPreferredGap(1).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jScrollPane1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldCompany, -2, -1, -2).add((Component)this.jLabel8)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldSource, -2, -1, -2).add((Component)this.jLabel7)).addPreferredGap(1).add((Component)this.jPanelAudit, -2, 66, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK).add((Component)this.jButtonDelete)).addContainerGap(20, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTextFieldAnalystKeyTyped(KeyEvent evt) {
        if (SB.uCaseField((JTextField)this.jTextFieldAnalyst, (int)5, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonEventActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            DialogSelectEvent dialog = new DialogSelectEvent((JDialog)((Object)this), true, this.db, this.event, null, true);
            dialog.setLocationRelativeTo((Component)((Object)this));
            this.setCursor(Cursor.getDefaultCursor());
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.event = dialog.selection;
                this.jTextFieldEventName.setText(this.event.toString());
                this.setEventType();
                Taxon t = this.event.getTaxon();
                if (t != null) {
                    char discID = t.getDisc().getChar();
                    this.jComboBoxDiscipline.setSelectedItem(SBdb.getDiscNoun(discID));
                }
            }
        }
        catch (SBException e) {
            StackError.showStackError((String)"Error opening Select Event dialog", (Throwable)e);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error opening Select Event dialog", sql, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonSampleActionPerformed(ActionEvent evt) {
        DialogSelectSample dialog;
        try {
            dialog = new DialogSelectSample((JDialog)((Object)this), true, this.db, this.well, this.sample, this.units, false);
        }
        catch (SBException ex) {
            StackError.showStackError((String)"Error opening dialog", (Throwable)ex);
            return;
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error opening dialog", ex, this.db);
            return;
        }
        dialog.setLocation(this.jButtonSample.getLocationOnScreen());
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.sample = dialog.selection;
            this.jTextFieldDepth.setText(this.sample.toString(this.units));
        }
    }

    private void jTextFieldDepthFocusGained(FocusEvent evt) {
        this.jTextFieldDepth.setSelectionStart(0);
        this.jTextFieldDepth.setSelectionEnd(this.jTextFieldDepth.getText().length());
    }

    private void jTextFieldEventNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldEventName, (int)100, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String analyst;
        Double errPlus;
        Double errMinus;
        String comment;
        String company;
        String source;
        String qualifier;
        Discipline discID;
        block16: {
            if (this.buttonGroupType.getSelection() == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select an event type", this.getTitle(), 0);
                return;
            }
            if (this.event == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select an event", this.getTitle(), 0);
                return;
            }
            if (this.sample == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select a sample", this.getTitle(), 0);
                return;
            }
            discID = null;
            if (this.jComboBoxDiscipline.getSelectedIndex() != 0) {
                discID = (Discipline)this.jComboBoxDiscipline.getSelectedItem();
            }
            qualifier = this.jTextFieldQual.getText();
            source = this.jTextFieldSource.getText();
            company = this.jTextFieldCompany.getText();
            comment = this.jTextAreaComment.getText();
            errMinus = this.jTextFieldErrMinus.getText().isEmpty() ? null : Double.valueOf(DepthUtils.convToM((double)Double.valueOf(this.jTextFieldErrMinus.getText()), (char)this.units));
            Double d = errPlus = this.jTextFieldErrPlus.getText().isEmpty() ? null : Double.valueOf(DepthUtils.convToM((double)Double.valueOf(this.jTextFieldErrPlus.getText()), (char)this.units));
            this.eventType = this.jRadioButtonTop.isSelected() ? EventType.TOP : (this.jRadioButtonBase.isSelected() ? EventType.BASE : EventType.SINGLE);
            analyst = this.jTextFieldAnalyst.getText();
            if (analyst != null && analyst.length() > 0) {
                try {
                    if (this.db.getUser(analyst) == null) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Analyst not recognised.", this.getTitle(), 0);
                        return;
                    }
                    break block16;
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("Error checking analyst", sql, this.db);
                    return;
                }
            }
            analyst = null;
        }
        try {
            if (this.wellEvent != null) {
                WellEvent.Builder builder = new WellEvent.Builder().event(this.event).sample(this.sample).type(this.eventType).confidence((Confidence)this.jComboBoxConfidence.getSelectedItem());
                builder.analyst(this.db.getUserID(analyst)).qualifier(qualifier).source(source).comments(comment).company(company).audit(this.wellEvent.getAudit()).discID(discID);
                if (errMinus != null) {
                    builder.errMinus(errMinus);
                }
                if (errPlus != null) {
                    builder.errPlus(errPlus);
                }
                this.wellEvent = this.wellInterp.updateEvent(this.wellEvent, builder, this.well.getWellID());
            } else {
                this.wellEvent = this.wellInterp.addEvent(this.well, this.sample, this.event, this.eventType, discID, analyst, comment, qualifier, source, company, (Confidence)this.jComboBoxConfidence.getSelectedItem(), errPlus, errMinus);
            }
            this.db.commit();
            this.wellInterp.notifyObservers(this.wellEvent);
            this.setOK();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), "Cannot save event", 2);
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error saving event", e, this.db);
            this.db.doRollback();
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error saving event", (Throwable)sbe);
            this.db.doRollback();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAnalystActionPerformed(ActionEvent evt) {
        DialogSelectAnalyst dialog;
        try {
            dialog = new DialogSelectAnalyst((JDialog)((Object)this), true, this.db, true);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error getting analyst", ex, this.db);
            return;
        }
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.selectedUser != null) {
            this.jTextFieldAnalyst.setText(dialog.selectedUser.getAbr());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogwellevent.html");
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.event == null) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Really delete this event?", this.getTitle(), 0);
        if (opt != 0) {
            return;
        }
        LinkedList<WellEvent> list = new LinkedList<WellEvent>();
        list.add(this.wellEvent);
        try {
            this.wellInterp.deleteEvents(list, this.well.getWellID());
            this.db.commit();
            this.wellInterp.notifyObservers(this.wellEvent);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        this.dispose();
    }

    private void jButtonErrDefaultActionPerformed(ActionEvent evt) {
        this.jTextFieldErrPlus.setText("");
        this.jTextFieldErrMinus.setText("");
        Discipline discID = null;
        if (this.jComboBoxDiscipline.getSelectedIndex() != 0) {
            discID = (Discipline)this.jComboBoxDiscipline.getSelectedItem();
        }
        try {
            Double errPlus;
            Double errMinus;
            if (this.jRadioButtonTop.isSelected() && (errMinus = WellEvent.getEventError(this.well, this.sample, discID, EventType.TOP)) != null) {
                this.jTextFieldErrMinus.setText(SB.floatString((double)DepthUtils.convFromM((double)errMinus, (char)this.units), (int)2).trim());
            }
            if (this.jRadioButtonBase.isSelected() && (errPlus = WellEvent.getEventError(this.well, this.sample, discID, EventType.BASE)) != null) {
                this.jTextFieldErrPlus.setText(SB.floatString((double)DepthUtils.convFromM((double)errPlus, (char)this.units), (int)2).trim());
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    private void jButtonClearErrActionPerformed(ActionEvent evt) {
        this.jTextFieldErrPlus.setText("");
        this.jTextFieldErrMinus.setText("");
    }

    void setSmpdtl(char discID, String analyst) {
        this.jComboBoxDiscipline.setSelectedItem(SBdb.getDiscNoun(discID));
        this.jTextFieldAnalyst.setText(analyst);
    }
}

