/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import model3.CompositeStandardEvent;
import model3.SBEvent;
import util.SB;

class EventStdOccTableModel
extends AbstractTableModel {
    List<SBEvent.CmpstdEventQueryResult> events;
    private static final String[] columnTitles = new String[]{"Composite", "Age/CSU", "Type"};
    private static final int[] columnWidths = new int[]{50, 50, 50};
    private static final int COL_INTERP = 0;
    private static final int COL_AGE = 1;
    private static final int COL_TYPE = 2;

    EventStdOccTableModel() {
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.events == null) {
            return "";
        }
        SBEvent.CmpstdEventQueryResult event = this.events.get(row);
        switch (col) {
            case 0: {
                return event.stdName;
            }
            case 1: {
                return event.csu;
            }
            case 2: {
                return CompositeStandardEvent.getEvTypeString(event.type);
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        if (this.events == null) {
            return 0;
        }
        return this.events.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 1: {
                return Double.class;
            }
        }
        return String.class;
    }

    void setupTable(JTable jTableCmpstds) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTableCmpstds.getColumnModel().getColumn(i).setHeaderValue(columnTitles[i]);
            jTableCmpstds.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        SB.setTableHeaderBold((JTable)jTableCmpstds);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(2);
        jTableCmpstds.getColumnModel().getColumn(1).setCellRenderer(rightRenderer);
        jTableCmpstds.setRowSorter(new TableRowSorter<EventStdOccTableModel>(this));
        new ColumnSortResetHandler(jTableCmpstds).attach();
    }
}

