/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.event.MouseMotionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import model3.SBdb;
import model3.Sample;
import model3.WellEvent;
import model3.WellInterp;
import model3.WellOccQueryResult;
import util.SB;
import util.SBException;
import util.table.ColumnHeaderToolTips;

class EventWellOccTableModel
extends AbstractTableModel {
    private static final String[] columnTitles = new String[]{"Well", "Version", "Sample", "Type", "Age (Ma)", "Stratigraphy"};
    private static final String[] columnTooltips = new String[]{null, null, null, null, "Derived from well/version LOC if present", null};
    private static final int[] columnWidths = new int[]{80, 50, 50, 50, 50, 70};
    private static final int COL_WELL = 0;
    private static final int COL_INTERP = 1;
    private static final int COL_SAMP = 2;
    private static final int COL_TYPE = 3;
    private static final int COL_AGE = 4;
    private static final int COL_STRAT = 5;
    private SBdb db;
    List<WellOccQueryResult> events;

    EventWellOccTableModel() {
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    String getAgeString(WellOccQueryResult event) throws SQLException, SBException {
        if (this.db == null) {
            return "";
        }
        WellInterp wellInterp = null;
        try {
            wellInterp = this.db.getWell(event.wellID).getInterp(event.interpID);
        }
        catch (SBException ex) {
            System.out.println("Exception: " + String.valueOf((Object)ex));
        }
        if (wellInterp != null) {
            wellInterp.loadLOC(event.wellID);
            if (wellInterp.getLOC() != null) {
                double age = wellInterp.getLOC().getAge(event.sample.getDepth(), false);
                if (age > 0.0) {
                    return SB.floatString((double)age, (int)3);
                }
                return "";
            }
            return "";
        }
        return "";
    }

    void loadStratigraphy() {
        if (this.db == null) {
            return;
        }
        System.out.println("Loading Stratigraphy ....");
        for (WellOccQueryResult event : this.events) {
            WellInterp wellInterp = null;
            try {
                wellInterp = this.db.getWell(event.wellID).getInterp(event.interpID);
                this.db.getWell(event.wellID).loadInterp(wellInterp);
            }
            catch (SQLException | SBException ex) {
                System.out.println("Exception: " + String.valueOf(ex));
            }
        }
        System.out.println("Loading Stratigraphy .... done");
    }

    String getStratigraphy(WellOccQueryResult event) throws SQLException, SBException {
        if (this.db == null) {
            return "";
        }
        WellInterp wellInterp = null;
        try {
            wellInterp = this.db.getWell(event.wellID).getInterp(event.interpID);
        }
        catch (SBException ex) {
            System.out.println("Exception: " + String.valueOf((Object)ex));
        }
        if (wellInterp != null) {
            return event.sample.getStratigraphy(wellInterp, true);
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.events == null) {
            return "";
        }
        WellOccQueryResult event = this.events.get(row);
        try {
            switch (col) {
                case 1: {
                    return event.interpName;
                }
                case 0: {
                    return event.wellName;
                }
                case 2: {
                    return event.sample;
                }
                case 3: {
                    return WellEvent.getType(event.type);
                }
                case 4: {
                    return this.getAgeString(event);
                }
                case 5: {
                    return this.getStratigraphy(event);
                }
            }
        }
        catch (SQLException | SBException e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public int getRowCount() {
        if (this.events == null) {
            return 0;
        }
        return this.events.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 2: {
                return Sample.class;
            }
        }
        return String.class;
    }

    void setupTable(JTable jTableWells, SBdb sbdb) {
        this.db = sbdb;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTableWells.getColumnModel().getColumn(i).setHeaderValue(columnTitles[i]);
            jTableWells.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        SB.setTableHeaderBold((JTable)jTableWells);
        jTableWells.setRowSorter(new TableRowSorter<EventWellOccTableModel>(this));
        new ColumnSortResetHandler(jTableWells).attach();
        jTableWells.getTableHeader().addMouseMotionListener((MouseMotionListener)ColumnHeaderToolTips.createColumnHeaderToolTips((String[])columnTooltips, (JTable)jTableWells));
    }
}

