/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.scheme.Confidence;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import jsbugs.TableModelSB;
import jsbugs.table.DateRenderer;
import jsbugs.table.IGetValue;
import jsbugs.table.SampleRenderer;
import jsbugs.table.SimpleTableColumn;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellEvent;
import util.DepthUtils;
import util.SB;

public class EventsTableModel
extends TableModelSB {
    List<WellEvent> events = null;
    private char units = (char)77;
    private SimpleTableColumn<WellEvent> errorMinusColumn = new SimpleTableColumn<WellEvent>("Error -", 22, String.class, new IGetValue<WellEvent>(this){
        final /* synthetic */ EventsTableModel this$0;
        {
            EventsTableModel eventsTableModel = this$0;
            Objects.requireNonNull(eventsTableModel);
            this.this$0 = eventsTableModel;
        }

        @Override
        public Object getValue(WellEvent event) {
            if (event.getErrMinus() != null) {
                return "-" + SB.floatString((double)DepthUtils.convFromM((double)event.getErrMinus(), (char)this.this$0.units), (int)2);
            }
            return null;
        }
    });
    private SimpleTableColumn<WellEvent> sampleColumn = new SimpleTableColumn<WellEvent>("Sample", 55, Sample.class, new IGetValue<WellEvent>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(WellEvent event) {
            return event.getSample();
        }
    });
    private SimpleTableColumn<WellEvent> errorPlusColumn = new SimpleTableColumn<WellEvent>("Error +", 20, String.class, new IGetValue<WellEvent>(this){
        final /* synthetic */ EventsTableModel this$0;
        {
            EventsTableModel eventsTableModel = this$0;
            Objects.requireNonNull(eventsTableModel);
            this.this$0 = eventsTableModel;
        }

        @Override
        public Object getValue(WellEvent event) {
            if (event.getErrPlus() != null) {
                return "+" + SB.floatString((double)DepthUtils.convFromM((double)event.getErrPlus(), (char)this.this$0.units), (int)2);
            }
            return null;
        }
    });
    private SimpleTableColumn<WellEvent> typeColumn = new SimpleTableColumn<WellEvent>("Event Type", 55, String.class, new IGetValue<WellEvent>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(WellEvent event) {
            return event.getTypeObj().toStringStandalone(EventContext.WELL);
        }
    });
    private SimpleTableColumn<WellEvent> eventAbrColumn = new SimpleTableColumn<WellEvent>("Abr.", 40, String.class, new IGetValue<WellEvent>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(WellEvent event) {
            return event.getEvent().getAbr();
        }
    });
    private SimpleTableColumn<WellEvent> eventColumn = new SimpleTableColumn<WellEvent>("Event Name", 120, String.class, new IGetValue<WellEvent>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(WellEvent event) {
            return event.getEvent().toString(event.getTypeObj(), true, false, false);
        }
    });
    private SimpleTableColumn<WellEvent> qualifierColumn = new SimpleTableColumn<WellEvent>("Qualifier", 45, String.class, new IGetValue<WellEvent>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(WellEvent event) {
            return event.getQualifier();
        }
    });
    private SimpleTableColumn<WellEvent> disciplineColumn = new SimpleTableColumn<WellEvent>("Discipline", 35, String.class, new IGetValue<WellEvent>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(WellEvent event) {
            char discID = event.getDiscID();
            if (discID != '\u0000') {
                return SBdb.getDiscAbr(discID);
            }
            return "";
        }
    });
    private SimpleTableColumn<WellEvent> commentsColumn = new SimpleTableColumn<WellEvent>("Comments", 100, String.class, new IGetValue<WellEvent>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(WellEvent event) {
            return event.getComments();
        }
    });
    private SimpleTableColumn<WellEvent> confidenceColumn = new SimpleTableColumn<WellEvent>("Confidence", 45, Confidence.class, new IGetValue<WellEvent>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(WellEvent event) {
            return event.getConfidence();
        }
    });
    private SimpleTableColumn<WellEvent> modifiedByColumn = new SimpleTableColumn<WellEvent>("Mod. By", 30, String.class, new IGetValue<WellEvent>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(WellEvent event) {
            return event.getModifierAbr();
        }
    });
    private SimpleTableColumn<WellEvent> modifiedOnColumn = new SimpleTableColumn<WellEvent>("Modified", 30, Date.class, new IGetValue<WellEvent>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(WellEvent event) {
            return event.getModified();
        }
    });
    List<SimpleTableColumn<WellEvent>> columns = new ArrayList<SimpleTableColumn>(Arrays.asList(this.errorMinusColumn, this.sampleColumn, this.errorPlusColumn, this.typeColumn, this.eventAbrColumn, this.eventColumn, this.qualifierColumn, this.disciplineColumn, this.commentsColumn, this.confidenceColumn, this.modifiedByColumn, this.modifiedOnColumn));
    private SampleRenderer sampleRenderer = new SampleRenderer(this.units);

    public void setEvents(List<WellEvent> events, Well well) {
        this.events = events;
    }

    @Override
    void setUnits(char units) {
        if (this.units != units) {
            this.units = units;
            if (this.sampleRenderer != null) {
                this.sampleRenderer.setUnits(units);
            }
        }
    }

    public char getUnits() {
        return this.units;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.events == null) {
            return null;
        }
        WellEvent event = this.events.get(row);
        SimpleTableColumn<WellEvent> columnValue = this.columns.get(col);
        return columnValue.getValueFromRow(event);
    }

    public Class getColumnClass(int col) {
        SimpleTableColumn<WellEvent> columnValue = this.columns.get(col);
        return columnValue.getValueClass();
    }

    @Override
    public int getRowCount() {
        if (this.events == null) {
            return 0;
        }
        return this.events.size();
    }

    @Override
    public void setupTable(JTable table, SBdb sbdb) {
        this.init(table, sbdb);
        table.setDefaultRenderer(Sample.class, this.sampleRenderer);
        table.setDefaultRenderer(Date.class, new DateRenderer());
        ActionListener copyAction = new ActionListener(this){
            final /* synthetic */ EventsTableModel this$0;
            {
                EventsTableModel eventsTableModel = this$0;
                Objects.requireNonNull(eventsTableModel);
                this.this$0 = eventsTableModel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(e.getSource() instanceof JTable)) {
                    return;
                }
                JTable jTable1 = (JTable)e.getSource();
                if (e.getActionCommand().compareTo("Copy") == 0) {
                    int[] rowsselected;
                    StringBuilder sbf = new StringBuilder();
                    int[] nArray = rowsselected = jTable1.getSelectedRows();
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        Integer i2 = nArray[i];
                        for (int j = 0; j < this.this$0.getColumnCount(); ++j) {
                            sbf.append(jTable1.getValueAt(i2, j));
                            if (j >= this.this$0.getColumnCount() - 1) continue;
                            sbf.append("\t");
                        }
                        sbf.append("\n");
                    }
                    StringSelection stsel = new StringSelection(sbf.toString());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stsel, stsel);
                }
            }
        };
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        table.registerKeyboardAction(copyAction, "Copy", copy, 0);
        this.restoreColumnOrder(table);
    }

    @Override
    public String[] getColumnTitles() {
        String[] titles = new String[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            titles[i] = this.columns.get(i).getTitle();
        }
        return titles;
    }

    @Override
    public int[] getDefaultColumnWidths() {
        int[] widths = new int[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            widths[i] = this.columns.get(i).getDefaultWidth();
        }
        return widths;
    }

    @Override
    public String getPrefString() {
        return "TMEVENTS";
    }

    @Override
    public String getPrefOrderString() {
        return "TOEVENTS";
    }

    @Override
    public String getAutoResizeString() {
        return "TAREVENTS";
    }
}

