/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dimension;
import java.awt.Point;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FrameWellsSession {
    private static Logger LOGGER = Logger.getLogger(FrameWellsSession.class.getName());
    private Dimension frameDimension = null;
    private Point frameLocation = null;
    private Boolean mapVisible = null;
    private Integer projectId = null;
    private Integer wellListId = null;

    public FrameWellsSession(Dimension frameDimension, Point frameLocation, Boolean mapVisible, Integer projectId, Integer wellListId) {
        this.frameDimension = frameDimension;
        this.frameLocation = frameLocation;
        this.mapVisible = mapVisible;
        this.projectId = projectId;
        this.wellListId = wellListId;
    }

    public boolean isFrameDimensionSet() {
        return this.frameDimension != null;
    }

    public Dimension getFrameDimension() {
        return this.frameDimension;
    }

    public boolean isFrameLocationSet() {
        return this.frameLocation != null;
    }

    public Point getFrameLocation() {
        return this.frameLocation;
    }

    public boolean isMapVisibleSet() {
        return this.mapVisible != null;
    }

    public boolean getMapVisible() {
        return this.mapVisible;
    }

    public boolean isProjectIdSet() {
        return this.projectId != null;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public boolean isWellListIdSet() {
        return this.wellListId != null;
    }

    public Integer getWellListId() {
        return this.wellListId;
    }

    public String encodeSession() {
        Object uiParams = "";
        if (this.isFrameDimensionSet() && this.isFrameLocationSet() && this.isMapVisibleSet()) {
            uiParams = this.frameDimension.width + " " + this.frameDimension.height + "," + this.frameLocation.x + " " + this.frameLocation.y;
            uiParams = this.mapVisible != false ? (String)uiParams + ",1" : (String)uiParams + ",0";
        }
        Object selectionParams = "";
        if (this.isProjectIdSet() && this.isWellListIdSet()) {
            selectionParams = this.projectId + "," + this.wellListId;
        }
        String params = (String)uiParams + "|" + (String)selectionParams;
        return params;
    }

    public static FrameWellsSession decodeSession(String params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        Dimension frameSize = null;
        Point frameLocation = null;
        Boolean showMap = null;
        Integer projectId = null;
        Integer wellListId = null;
        try {
            String[] tokens = params.split("\\|");
            String[] uiTokens = tokens[0].split(",");
            block11: for (int i = 0; i < uiTokens.length; ++i) {
                String tok = uiTokens[i];
                switch (i) {
                    case 0: {
                        String[] dimensions = tok.split(" ");
                        int w = Integer.parseInt(dimensions[0]);
                        int h = Integer.parseInt(dimensions[1]);
                        frameSize = new Dimension(w, h);
                        continue block11;
                    }
                    case 1: {
                        String[] location = tok.split(" ");
                        int x = Integer.parseInt(location[0]);
                        int y = Integer.parseInt(location[1]);
                        frameLocation = new Point(x, y);
                        continue block11;
                    }
                    case 2: {
                        showMap = Integer.parseInt(tok) == 1;
                    }
                }
            }
            String[] selectionTokens = tokens[1].split(",");
            block12: for (int i = 0; i < selectionTokens.length; ++i) {
                String tok = selectionTokens[i];
                switch (i) {
                    case 0: {
                        int projID = Integer.parseInt(tok);
                        if (projID <= 0) continue block12;
                        projectId = projID;
                        continue block12;
                    }
                    case 1: {
                        int id = Integer.parseInt(tok);
                        if (id <= 0) continue block12;
                        wellListId = id;
                    }
                }
            }
        }
        catch (RuntimeException re) {
            LOGGER.log(Level.WARNING, "Error decoding session [" + params + "]", re);
        }
        return new FrameWellsSession(frameSize, frameLocation, showMap, projectId, wellListId);
    }
}

