/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventType;
import com.stratadata.util.ui.SBDialog;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbchart.block.ChartBlock;
import jsbchart.block.SchemeBlock;
import jsbchart.core.Chart;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelCompositeStandard;
import jsbchart.panel.PanelLithostratScheme;
import jsbchart.panel.PanelRange;
import jsbchart.panel.PanelSurfaces;
import jsbchart.panel.panelIGDScheme.PanelIGDScheme;
import jsbugs.ChartJPanel;
import jsbugs.DialogSurface;
import jsbugs.DialogUnit;
import jsbugs.FrameJsbugs;
import jsbugs.InternalFrameChart;
import jsbugs.igdunits.DialogLithostratUnit;
import jsbugs.model2.event.DialogCmpStdEvent;
import jsbugs.uiutil.CursorFactory;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.LithostratUnit;
import model3.Surface;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class InteractiveChartJPanelScheme
extends ChartJPanel {
    private final InternalFrameChart parent;
    private CompositeStandardEvent dragOriginEvent;
    private Point2D.Float lastDragPoint;
    private String lastAgeString;
    private UndoManager undoManager = null;
    private UndoableEditSupport undoSupport = null;

    public InteractiveChartJPanelScheme(Chart chart, InternalFrameChart parent) {
        super(chart);
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ InteractiveChartJPanelScheme this$0;
            {
                InteractiveChartJPanelScheme interactiveChartJPanelScheme = this$0;
                Objects.requireNonNull(interactiveChartJPanelScheme);
                this.this$0 = interactiveChartJPanelScheme;
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                this.this$0.mMoved(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ InteractiveChartJPanelScheme this$0;
            {
                InteractiveChartJPanelScheme interactiveChartJPanelScheme = this$0;
                Objects.requireNonNull(interactiveChartJPanelScheme);
                this.this$0 = interactiveChartJPanelScheme;
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                this.this$0.mDragged(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InteractiveChartJPanelScheme this$0;
            {
                InteractiveChartJPanelScheme interactiveChartJPanelScheme = this$0;
                Objects.requireNonNull(interactiveChartJPanelScheme);
                this.this$0 = interactiveChartJPanelScheme;
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.mReleased(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InteractiveChartJPanelScheme this$0;
            {
                InteractiveChartJPanelScheme interactiveChartJPanelScheme = this$0;
                Objects.requireNonNull(interactiveChartJPanelScheme);
                this.this$0 = interactiveChartJPanelScheme;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.mPressed(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InteractiveChartJPanelScheme this$0;
            {
                InteractiveChartJPanelScheme interactiveChartJPanelScheme = this$0;
                Objects.requireNonNull(interactiveChartJPanelScheme);
                this.this$0 = interactiveChartJPanelScheme;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.mClicked(evt);
            }
        });
    }

    private void mMoved(MouseEvent evt) {
        if (this.hasMarquee() || evt.isAltDown()) {
            return;
        }
        if (this.parent.isInteractive() && this.dragOriginEvent == null) {
            Object obj = this.getObject(evt);
            if (obj instanceof CompositeStandardEvent) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        String tooltipString = this.getTooltip(evt);
        this.parent.setTooltip(tooltipString);
        this.setToolTipText(tooltipString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mClicked(MouseEvent evt) {
        if (evt.getClickCount() <= 1) {
            return;
        }
        try {
            Point2D.Float pTemp = this.getPoint(evt.getPoint());
            Point2D.Float mmPoint = new Point2D.Float((float)((Point2D)pTemp).getX(), (float)((Point2D)pTemp).getY());
            Object dialog = null;
            Object obj = this.getObject(evt);
            Point2D.Float pInPanel = new Point2D.Float();
            ChartPanel panel = this.chart.getPanel(mmPoint, this.hMode(), this.vMode(), pInPanel);
            if (panel instanceof PanelRange) {
                PanelRange rangePanel = (PanelRange)panel;
                if (obj instanceof CompositeStandardEvent) {
                    CompositeStandardEvent event = (CompositeStandardEvent)obj;
                    dialog = new DialogCmpStdEvent(this.parent.parent, true, this.parent.sbdb, rangePanel.getComposite(), event, null);
                } else if (obj instanceof PanelRange.EventRange) {
                    PanelRange.EventRange er = (PanelRange.EventRange)obj;
                    if (er.singleAge == null) {
                        boolean addBase = true;
                        if (er.minAge == null && er.maxAge != null || er.minAge != null && er.maxAge == null) {
                            if (er.minAge == null) {
                                addBase = false;
                            }
                            double csu = rangePanel.getComposite().getCSU(rangePanel.getAge(pInPanel.y));
                            if (addBase && csu > er.minAge.getCSU() || !addBase && csu < er.maxAge.getCSU()) {
                                dialog = new DialogCmpStdEvent(this.parent.parent, true, this.parent.sbdb, rangePanel.getComposite(), null, new CompositeStandardEvent.Builder().event(er.event).type(addBase ? EventType.BASE : EventType.TOP).csu(SB.round((double)csu, (int)this.getRounding(csu))));
                            }
                        }
                    }
                }
            } else if (obj != null) {
                if (obj instanceof IGDUnitBase && panel instanceof PanelIGDScheme) {
                    dialog = new DialogUnit(this.parent.parent, true, ((PanelIGDScheme)panel).getScheme(), (IGDUnitBase)obj);
                } else if (obj instanceof CompositeStandardEvent && panel instanceof PanelCompositeStandard) {
                    dialog = new DialogCmpStdEvent(this.parent.parent, true, this.parent.sbdb, ((PanelCompositeStandard)panel).getStd(), (CompositeStandardEvent)obj, null);
                } else if (obj instanceof LithostratUnit && panel instanceof PanelLithostratScheme) {
                    dialog = new DialogLithostratUnit(this.parent.parent, true);
                    ((DialogLithostratUnit)((Object)dialog)).setup((LithostratUnit)obj, ((PanelLithostratScheme)panel).getScheme());
                } else if (obj instanceof Surface && panel instanceof PanelSurfaces) {
                    dialog = new DialogSurface(this.parent.parent, true, (Surface)obj, ((PanelSurfaces)panel).getProperties().getScheme());
                }
            }
            if (dialog != null) {
                dialog.setLocationRelativeTo(this.parent);
                ((Dialog)dialog).setVisible(true);
                if (dialog instanceof SBDialog && ((SBDialog)dialog).isOK()) {
                    if (dialog instanceof DialogLithostratUnit && panel instanceof PanelLithostratScheme) {
                        IGDScheme scheme = ((PanelLithostratScheme)panel).getScheme();
                        DialogLithostratUnit lithDialog = (DialogLithostratUnit)((Object)dialog);
                        scheme.updateUnit(lithDialog.getBuilder());
                    }
                    this.parent.sbdb.commit();
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.parent.sbdb);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        catch (InvalidFieldException | SBException ex) {
            Logger.getLogger(InteractiveChartJPanelScheme.class.getName()).log(Level.SEVERE, "Error occurred upating scheme item.", ex);
        }
        finally {
            this.repaint();
        }
    }

    private void postEdit(UndoableEdit edit) {
        if (edit != null) {
            this.undoManager.addEdit(edit);
            this.undoSupport.postEdit(edit);
            this.repaint();
        }
    }

    private void mDragged(MouseEvent evt) {
        if (this.hasMarquee()) {
            return;
        }
        Point2D.Float pTemp = this.getPoint(evt.getPoint());
        Point2D.Float mmPoint = new Point2D.Float((float)((Point2D)pTemp).getX(), (float)((Point2D)pTemp).getY());
        if (!this.parent.isInteractive()) {
            return;
        }
        try {
            Point2D.Float pInPanel = new Point2D.Float();
            ChartPanel panel = this.chart.getPanel(mmPoint, this.hMode(), this.vMode(), pInPanel);
            if (panel != null && panel instanceof PanelRange) {
                PanelRange panelRange = (PanelRange)panel;
                if (this.dragOriginEvent == null) {
                    Object o = this.getObject(evt);
                    if (o instanceof CompositeStandardEvent) {
                        CompositeStandardEvent cse;
                        this.dragOriginEvent = cse = (CompositeStandardEvent)o;
                    }
                    if (this.dragOriginEvent != null) {
                        this.setCursor(CursorFactory.getDragMoveCursor());
                    }
                } else {
                    Graphics g = this.getGraphics();
                    AffineTransform tf = this.setRubberBandMode(g);
                    double age = panelRange.getAge((float)panelRange.getAge(pInPanel.y));
                    age = SB.round((double)age, (int)this.getRounding(age));
                    String ageString = age + " Ma";
                    SchemeBlock sBlock = (SchemeBlock)panel.getBlock();
                    if (this.lastDragPoint != null && this.lastAgeString != null) {
                        this.drawString(g, this.lastDragPoint, this.lastAgeString);
                    }
                    if (age < (double)sBlock.getProp().getMax() && age > (double)sBlock.getProp().getMin()) {
                        this.drawString(g, mmPoint, ageString);
                        this.lastDragPoint = mmPoint;
                        this.lastAgeString = ageString;
                    }
                    this.clearRubberBandMode(g, tf);
                }
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    private void evaluatePopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.parent.showPopup(evt);
        }
    }

    private void mPressed(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mReleased(MouseEvent evt) {
        if (this.hasMarquee()) {
            return;
        }
        this.evaluatePopup(evt);
        try {
            if (this.dragOriginEvent != null) {
                Point2D.Float mmPoint = this.getPoint(evt.getPoint());
                Point2D.Float pInPanel = new Point2D.Float();
                ChartPanel panel = this.chart.getPanel(mmPoint, this.hMode(), this.vMode(), pInPanel);
                if (panel instanceof PanelRange) {
                    PanelRange panelRange = (PanelRange)panel;
                    Point2D.Float panelOrigin = this.chart.getMmPanelOrigin(panelRange, this.hMode(), this.vMode(), mmPoint.x);
                    if ((double)mmPoint.y > ((Point2D)panelOrigin).getY() && (double)mmPoint.y < ((Point2D)panelOrigin).getY() + (double)((SchemeBlock)panel.getBlock()).getHeight()) {
                        try {
                            CompositeStandard std = panelRange.getComposite();
                            double age = panelRange.getAge(pInPanel.y);
                            double newAge = SB.round((double)age, (int)this.getRounding(age));
                            this.postEdit((UndoableEdit)((Object)std.updateEventCsu(this.dragOriginEvent, newAge)));
                            this.parent.sbdb.commit();
                            std.notifyObservers();
                        }
                        catch (SBException sbe) {
                            if (sbe.getMessage().startsWith("Can't update event: ")) {
                                JOptionPane.showMessageDialog(this.parent, sbe.getMessage(), "Update event", 2);
                            }
                            throw sbe;
                        }
                    } else {
                        System.out.println("No longer in Range panel");
                    }
                    this.lastDragPoint = null;
                }
            }
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this.parent, ife.getMessage(), this.parent.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error updating event", (Exception)sql, this.parent.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)(re.getCause() != null ? re.getMessage() + "\n" + re.getCause().getMessage() : ""), (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.dragOriginEvent = null;
            this.repaint();
        }
    }

    private int getRounding(double age) {
        ChartBlock block = (ChartBlock)this.chart.getBlockSingle();
        Float scale = block.getProp().getScale((float)age);
        if (scale == null) {
            scale = Float.valueOf(block.getProp().getScale(block.getProp().getLongestSection()));
        }
        double ageRes = this.zm.getZoom() / 2.0f * 2.8346457f * scale.floatValue() * 10.0f;
        int round = (int)Math.log10(ageRes);
        return round;
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public UndoableEditSupport getUndoSupport() {
        return this.undoSupport;
    }
}

