/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jsbugs.DialogTaxon;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.JPanelGroups;
import jsbugs.SBList;
import jsbugs.TaxonListMember;
import jsbugs.TaxonTransferHandler;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Genus;
import model3.SBdb;
import model3.Taxon;
import model3.TxGroup;
import model3.taxa.TaxonListener;
import org.jdesktop.layout.GroupLayout;
import util.SBPermissionException;
import util.exception.StackError;

public class InternalFrameGroup
extends JInternalFrame
implements Observer,
TaxonListener {
    private final DefaultListModel taxaModel = new DefaultListModel();
    private boolean duringRefresh = false;
    private final SBdb db;
    private final TxGroup group;
    private final JPanelGroups jPanelGroups;
    FrameTaxaDB frameTaxa;
    private ButtonGroup buttonGroupSort;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabelDiscipline;
    private JLabel jLabelModified;
    private JLabel jLabelNTaxa;
    private JLabel jLabelProject;
    private JList jListTaxa;
    private JMenuItem jMenuItemDeleteSelected;
    private JPanel jPanelColour;
    private JPopupMenu jPopupMenuGroup;
    private JRadioButton jRadioButtonCategory;
    private JRadioButton jRadioButtonGenus;
    private JRadioButton jRadioButtonSpecies;
    private JScrollPane jScrollPane1;

    public InternalFrameGroup(FrameTaxaDB frameTaxa, SBdb db, TxGroup group, JPanelGroups jPanelGroups) {
        this.initComponents();
        this.db = db;
        this.group = group;
        this.jPanelGroups = jPanelGroups;
        this.frameTaxa = frameTaxa;
        this.init();
    }

    TxGroup getGroup() {
        return this.group;
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obs == this.group) {
            if (obj == null) {
                Taxon.SortOrder sort = this.jRadioButtonCategory.isSelected() ? Taxon.SortOrder.SORT_CATEGORY : (this.jRadioButtonGenus.isSelected() ? Taxon.SortOrder.SORT_GENUS : Taxon.SortOrder.SORT_SPECIES);
                this.refreshList(sort);
            } else if (obj instanceof Genus) {
                this.jListTaxa.repaint();
            } else {
                this.setDetails();
            }
        }
    }

    SBdb getDatabase() {
        return this.db;
    }

    private void setDetails() {
        this.jPanelColour.setBackground(this.group.getColour());
        this.setTitle("Group: " + this.group.getName());
        try {
            this.jLabelProject.setText(this.group.getProjID() > 0 ? this.db.getProject(this.group.getProjID()).getName() : "Global");
            this.jLabelProject.setIcon(this.group.getProjID() > 0 ? IconFactory.getIconProject() : IconFactory.getIconGlobal());
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        this.setModifiedLabel();
        this.refreshDisciplineLabel();
    }

    private void init() {
        this.refreshList(Taxon.SortOrder.SORT_CATEGORY);
        this.jListTaxa.setDragEnabled(true);
        this.jListTaxa.setTransferHandler(new TaxonTransferHandler(this.db, this.group));
        this.jListTaxa.setDropTarget(null);
        this.setTransferHandler(new TaxonTransferHandler(this.db, this.group));
        this.group.addObserver(this);
        this.setDetails();
        this.taxaModel.addListDataListener(new ListDataListener(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        this.jListTaxa.setCellRenderer(new TxGroupMbrRenderer(this, this.jListTaxa));
    }

    @Override
    public void onTaxonDetailsUpdated(Taxon taxon) {
        try {
            if (!this.group.isMember(taxon.getSpecID(), 0)) {
                taxon.deleteListener(this);
                return;
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
        this.refreshDisciplineLabel();
        this.jListTaxa.repaint();
    }

    @Override
    public void onTaxonDelete(Taxon taxon) {
    }

    private void setModifiedLabel() {
        this.jLabelModified.setText(this.group.getAudit().toString(this.db, false));
    }

    boolean hasList(JComponent comp) {
        return this.jListTaxa == comp;
    }

    private void refreshSizeLabel() throws SQLException {
        int size = this.group.getSize();
        this.jLabelNTaxa.setText("" + size);
    }

    private void refreshDisciplineLabel() {
        try {
            Discipline discipline = this.group.getDiscipline(this.db);
            this.jLabelDiscipline.setVisible(discipline != null);
            if (discipline != null) {
                this.jLabelDiscipline.setText(discipline.getAdj());
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
            this.jLabelDiscipline.setText("Error");
        }
    }

    private void initComponents() {
        this.buttonGroupSort = new ButtonGroup();
        this.jPopupMenuGroup = new JPopupMenu();
        this.jMenuItemDeleteSelected = new JMenuItem();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListTaxa = new SBList(true);
        this.jLabelNTaxa = new JLabel();
        this.jPanelColour = new JPanel();
        this.jLabel3 = new JLabel();
        this.jRadioButtonCategory = new JRadioButton();
        this.jRadioButtonSpecies = new JRadioButton();
        this.jRadioButtonGenus = new JRadioButton();
        this.jLabelModified = new JLabel();
        this.jLabelProject = new JLabel();
        this.jLabelDiscipline = new JLabel();
        this.jMenuItemDeleteSelected.setText("Remove");
        this.jMenuItemDeleteSelected.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameGroup this$0;
            {
                InternalFrameGroup internalFrameGroup = this$0;
                Objects.requireNonNull(internalFrameGroup);
                this.this$0 = internalFrameGroup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeleteSelectedActionPerformed(evt);
            }
        });
        this.jPopupMenuGroup.add(this.jMenuItemDeleteSelected);
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/resources/frameicon/16Taxa.png")));
        this.setMinimumSize(new Dimension(280, 250));
        this.setPreferredSize(new Dimension(400, 150));
        this.setVisible(true);
        this.addInternalFrameListener(new InternalFrameListener(this){
            final /* synthetic */ InternalFrameGroup this$0;
            {
                InternalFrameGroup internalFrameGroup = this$0;
                Objects.requireNonNull(internalFrameGroup);
                this.this$0 = internalFrameGroup;
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
                this.this$0.formInternalFrameActivated(evt);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jLabel1.setText("Taxa:");
        this.jListTaxa.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255), 2));
        this.jListTaxa.setModel(this.taxaModel);
        this.jListTaxa.setToolTipText("Drag and drop taxa to edit groups, hold CTRL and drag to copy");
        this.jListTaxa.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InternalFrameGroup this$0;
            {
                InternalFrameGroup internalFrameGroup = this$0;
                Objects.requireNonNull(internalFrameGroup);
                this.this$0 = internalFrameGroup;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jListTaxaMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jListTaxaMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListTaxaMouseClicked(evt);
            }
        });
        this.jListTaxa.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ InternalFrameGroup this$0;
            {
                InternalFrameGroup internalFrameGroup = this$0;
                Objects.requireNonNull(internalFrameGroup);
                this.this$0 = internalFrameGroup;
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                this.this$0.jListTaxaKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListTaxa);
        this.jLabelNTaxa.setFont(this.jLabelNTaxa.getFont().deriveFont(this.jLabelNTaxa.getFont().getStyle() | 1, this.jLabelNTaxa.getFont().getSize() + 1));
        this.jLabelNTaxa.setText("jLabel3");
        GroupLayout jPanelColourLayout = new GroupLayout((Container)this.jPanelColour);
        this.jPanelColour.setLayout((LayoutManager)jPanelColourLayout);
        jPanelColourLayout.setHorizontalGroup((GroupLayout.Group)jPanelColourLayout.createParallelGroup(1).add(0, 264, Short.MAX_VALUE));
        jPanelColourLayout.setVerticalGroup((GroupLayout.Group)jPanelColourLayout.createParallelGroup(1).add(0, 16, Short.MAX_VALUE));
        this.jLabel3.setText("Sort by:");
        this.buttonGroupSort.add(this.jRadioButtonCategory);
        this.jRadioButtonCategory.setSelected(true);
        this.jRadioButtonCategory.setText("Category");
        this.jRadioButtonCategory.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCategory.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonCategory.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameGroup this$0;
            {
                InternalFrameGroup internalFrameGroup = this$0;
                Objects.requireNonNull(internalFrameGroup);
                this.this$0 = internalFrameGroup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonCategoryActionPerformed(evt);
            }
        });
        this.buttonGroupSort.add(this.jRadioButtonSpecies);
        this.jRadioButtonSpecies.setText("Species");
        this.jRadioButtonSpecies.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSpecies.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonSpecies.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameGroup this$0;
            {
                InternalFrameGroup internalFrameGroup = this$0;
                Objects.requireNonNull(internalFrameGroup);
                this.this$0 = internalFrameGroup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSpeciesActionPerformed(evt);
            }
        });
        this.buttonGroupSort.add(this.jRadioButtonGenus);
        this.jRadioButtonGenus.setText("Genus");
        this.jRadioButtonGenus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonGenus.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonGenus.addActionListener(new ActionListener(this){
            final /* synthetic */ InternalFrameGroup this$0;
            {
                InternalFrameGroup internalFrameGroup = this$0;
                Objects.requireNonNull(internalFrameGroup);
                this.this$0 = internalFrameGroup;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonGenusActionPerformed(evt);
            }
        });
        this.jLabelModified.setForeground(new Color(102, 102, 102));
        this.jLabelModified.setText("Modified by: On:");
        this.jLabelProject.setForeground(new Color(102, 102, 102));
        this.jLabelProject.setText("Project label");
        this.jLabelDiscipline.setForeground(new Color(102, 102, 102));
        this.jLabelDiscipline.setText("Microfaunal");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelColour, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 364, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(1).add((Component)this.jRadioButtonCategory).addPreferredGap(0).add((Component)this.jRadioButtonSpecies).addPreferredGap(0).add((Component)this.jRadioButtonGenus).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jLabelNTaxa).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabelModified)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelDiscipline).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabelProject))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanelColour, -2, -1, -2).add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jRadioButtonCategory).add((Component)this.jRadioButtonSpecies).add((Component)this.jRadioButtonGenus)).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 74, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelProject).add((Component)this.jLabelDiscipline)).add(1, 1, 1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelNTaxa).add((Component)this.jLabel1).add((Component)this.jLabelModified)).addContainerGap()));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList(Taxon.SortOrder sortOrder) {
        this.duringRefresh = true;
        try {
            Collection<Taxon> c = this.db.getTxGroupTaxa(this.group, false);
            LinkedList<Taxon> list = new LinkedList<Taxon>(c);
            Taxon.sort(list, sortOrder);
            this.taxaModel.clear();
            for (Taxon taxon : list) {
                this.taxaModel.addElement(new TaxonListMember(taxon));
                taxon.registerListener(this);
            }
            for (Genus genus : this.db.getTxGroupGenera(this.group)) {
                this.taxaModel.addElement(new TaxonListMember(genus));
            }
            this.jListTaxa.repaint();
            this.refreshSizeLabel();
            this.refreshDisciplineLabel();
            this.setModifiedLabel();
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showStackError("Error refreshing group window", ex, this.frameTaxa);
        }
        finally {
            this.duringRefresh = false;
        }
    }

    private void jRadioButtonCategoryActionPerformed(ActionEvent evt) {
        this.refreshList(Taxon.SortOrder.SORT_CATEGORY);
    }

    private void jRadioButtonSpeciesActionPerformed(ActionEvent evt) {
        this.refreshList(Taxon.SortOrder.SORT_SPECIES);
    }

    private void jRadioButtonGenusActionPerformed(ActionEvent evt) {
        this.refreshList(Taxon.SortOrder.SORT_GENUS);
    }

    private void jListTaxaMouseReleased(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    private void jListTaxaMousePressed(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    private void evaluatePopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            if (this.jListTaxa.getSelectedIndices().length <= 1) {
                this.jListTaxa.setSelectedIndex(this.jListTaxa.locationToIndex(evt.getPoint()));
            }
            Point popupPoint = evt.getPoint();
            this.jPopupMenuGroup.show(evt.getComponent(), (int)popupPoint.getX(), (int)popupPoint.getY());
        }
    }

    private void jMenuItemDeleteSelectedActionPerformed(ActionEvent evt) {
        try {
            if (!this.group.canWrite(this.db, null)) {
                JOptionPane.showMessageDialog(this, this.group.getDeniedReason(this.db, "group", false), this.getTitle(), 2);
                return;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error getting group permissions", sql, this.db);
        }
        int[] selection = this.jListTaxa.getSelectedIndices();
        Object msg = "Really remove";
        msg = selection.length > 1 ? (String)msg + " these " + selection.length + " items " : (String)msg + " this item ";
        msg = (String)msg + " from the group?";
        if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 2) != 0) {
            return;
        }
        LinkedList<TaxonListMember> toDelete = new LinkedList<TaxonListMember>();
        for (int i = selection.length - 1; i >= 0; --i) {
            TaxonListMember taxon = (TaxonListMember)this.taxaModel.get(selection[i]);
            toDelete.add(taxon);
        }
        LinkedList<Taxon> toDeleteTaxa = new LinkedList<Taxon>();
        LinkedList<Genus> toDeleteGenera = new LinkedList<Genus>();
        for (TaxonListMember element : toDelete) {
            if (element.object instanceof Taxon) {
                toDeleteTaxa.add((Taxon)element.object);
                continue;
            }
            if (!(element.object instanceof Genus)) continue;
            toDeleteGenera.add((Genus)element.object);
        }
        try {
            this.group.deleteTaxa(toDeleteTaxa);
            this.group.deleteGenera(toDeleteGenera);
            this.db.commit();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        for (TaxonListMember mbr : toDelete) {
            this.taxaModel.removeElement(mbr);
        }
        this.jListTaxa.repaint();
    }

    private void formInternalFrameActivated(InternalFrameEvent evt) {
        this.jPanelGroups.setSelectedGroup(this.group);
    }

    private void jListTaxaMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            Object o = ((TaxonListMember)this.taxaModel.get((int)this.jListTaxa.getSelectedIndex())).object;
            if (!(o instanceof Taxon)) {
                return;
            }
            Taxon taxon = (Taxon)o;
            try {
                Container parent = this.getParent();
                while (!(parent instanceof FrameTaxaDB)) {
                    if ((parent = parent.getParent()) != null) continue;
                    throw new IllegalStateException("No TaxaDB container parent in InternalFrameGroup");
                }
                DialogTaxon dialog = new DialogTaxon((FrameTaxaDB)parent, true, this.db, taxon, false, ((FrameTaxaDB)parent).parent.getChartManager());
                dialog.setLocationRelativeTo(this.getParent());
                dialog.setVisible(true);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
    }

    private void jListTaxaKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jMenuItemDeleteSelectedActionPerformed(null);
        }
    }

    private class TxGroupMbrRenderer
    extends JLabel
    implements ListCellRenderer {
        private final Font font;
        private final Font italicFont;
        final /* synthetic */ InternalFrameGroup this$0;

        TxGroupMbrRenderer(InternalFrameGroup internalFrameGroup, JList list) {
            InternalFrameGroup internalFrameGroup2 = internalFrameGroup;
            Objects.requireNonNull(internalFrameGroup2);
            this.this$0 = internalFrameGroup2;
            this.font = list.getFont();
            this.italicFont = this.font.deriveFont(2);
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && value instanceof TaxonListMember && ((TaxonListMember)value).object instanceof Genus) {
                Genus genus = (Genus)((TaxonListMember)value).object;
                this.setFont(this.italicFont);
                this.setText(value.toString() + " (" + this.this$0.db.getTaxonService().getTaxonCountForGenus(genus.getGenID()) + " species)");
            } else {
                this.setFont(this.font);
                this.setText(value != null ? value.toString() : "");
            }
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }
}

