/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableRowSorter;
import jsbugs.BiocomTableModel;
import jsbugs.DialogBiocom;
import jsbugs.DialogEnv;
import jsbugs.DialogInterval;
import jsbugs.DialogSQPick;
import jsbugs.DialogWellEvent;
import jsbugs.EnvTableModel;
import jsbugs.EventsTableModel;
import jsbugs.FrameInterpretations;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSB;
import jsbugs.ZonesTableModel;
import jsbugs.model2.wellinterp.SQPickTableModel;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Biocom;
import model3.IGDInterval;
import model3.IGDIntervalEnv;
import model3.IGDIntervalZone;
import model3.SBdb;
import model3.SQPick;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class InternalFrameIGD
extends JInternalFrame {
    private final int igdType;
    private final int interpID;
    private final FrameInterpretations parentFrame;
    private final SBdb sbdb;
    private JTabbedPane jTabbedPane;

    public InternalFrameIGD(FrameInterpretations p, int igdType, int interpID, SBdb sbdb) {
        this.parentFrame = p;
        this.igdType = igdType;
        this.interpID = interpID;
        this.sbdb = sbdb;
        this.initComponents();
    }

    void addPane(Well well) throws SQLException, SBException {
        this.jTabbedPane.add(well.getWellName(), new WellTab(this, well));
    }

    JScrollPane getScrollPane() {
        Component comp = this.jTabbedPane.getSelectedComponent();
        if (comp instanceof JScrollPane) {
            return (JScrollPane)comp;
        }
        return null;
    }

    void addInterval() {
        WellTab tab = (WellTab)this.jTabbedPane.getSelectedComponent();
        if (tab == null) {
            assert (false);
            return;
        }
        char units = this.parentFrame.getUnits() == 'D' ? tab.well.getWellUnits() : this.parentFrame.getUnits();
        try {
            WellInterp wellInterp = tab.well.getInterp(this.interpID);
            SBDialog dialog = null;
            switch (this.igdType) {
                case 10: {
                    dialog = new DialogSQPick(this.parentFrame, true, this.sbdb, null, tab.well, wellInterp, units, null, null, null);
                    break;
                }
                case 20: {
                    dialog = new DialogWellEvent(this.parentFrame, true, this.sbdb, tab.well, wellInterp, units, null, null, null, null);
                    break;
                }
                case 19: {
                    dialog = new DialogBiocom(this.parentFrame, true, this.sbdb, tab.well, wellInterp, units, null, null, null);
                    break;
                }
                case 5: {
                    dialog = new DialogEnv(this.parentFrame, true, this.sbdb, tab.well, wellInterp, units, null, null, null);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    dialog = new DialogInterval(this.parentFrame, true, this.igdType, this.sbdb, tab.well, wellInterp, units, null, null, null, null, null, false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (dialog != null) {
                dialog.setLocationRelativeTo((Component)this.parentFrame);
                dialog.setVisible(true);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    void editInterval() {
        WellTab tab = (WellTab)this.jTabbedPane.getSelectedComponent();
        if (tab == null) {
            assert (false);
            return;
        }
        int nRows = tab.table.getSelectedRowCount();
        if (nRows != 1) {
            JOptionPane.showMessageDialog(this, "Select one interval to edit", this.getTitle(), 2);
            return;
        }
        int row = tab.table.convertRowIndexToModel(tab.table.getSelectedRow());
        char units = this.parentFrame.getUnits() == 'D' ? tab.well.getWellUnits() : this.parentFrame.getUnits();
        try {
            WellInterp wellInterp = tab.well.getInterp(this.interpID);
            SBDialog dialog = null;
            switch (this.igdType) {
                case 2: 
                case 3: 
                case 4: {
                    IGDIntervalZone zone = ((ZonesTableModel)tab.model).getZones().get(row);
                    dialog = new DialogInterval(this.parentFrame, true, zone.getIGDType(), this.sbdb, tab.well, wellInterp, units, zone, null, null, null, null, false);
                    break;
                }
                case 10: {
                    SQPick pick = (SQPick)((SQPickTableModel)tab.model).getItems().get(row);
                    dialog = new DialogSQPick(this.parentFrame, true, this.sbdb, null, tab.well, wellInterp, units, pick, null, null);
                    break;
                }
                case 20: {
                    WellEvent event = ((EventsTableModel)tab.model).events.get(row);
                    dialog = new DialogWellEvent(this.parentFrame, true, this.sbdb, tab.well, wellInterp, units, event, null, null, null);
                    break;
                }
                case 19: {
                    Biocom biocom = ((BiocomTableModel)tab.model).comments.get(row);
                    dialog = new DialogBiocom(this.parentFrame, true, this.sbdb, tab.well, wellInterp, units, biocom, null, null);
                    break;
                }
                case 5: {
                    IGDIntervalEnv env = ((EnvTableModel)tab.model).envs.get(row);
                    dialog = new DialogEnv(this.parentFrame, true, this.sbdb, tab.well, wellInterp, units, env, null, null);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (dialog != null) {
                dialog.setLocationRelativeTo((Component)this.parentFrame);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    wellInterp.notifyObservers(this.igdType);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    void deleteIntervals() {
        WellTab tab = (WellTab)this.jTabbedPane.getSelectedComponent();
        if (tab == null) {
            assert (false);
            return;
        }
        int nRows = tab.table.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select intervals to delete", this.getTitle(), 2);
            return;
        }
        String msg = "Really delete " + (String)(nRows == 1 ? "this interval?" : "these " + nRows + " intervals?");
        if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) {
            return;
        }
        Object arg = null;
        try {
            WellInterp wellInterp = tab.well.getInterp(this.interpID);
            switch (this.igdType) {
                case 2: 
                case 3: 
                case 4: {
                    LinkedList<IGDIntervalZone> toKill = new LinkedList<IGDIntervalZone>();
                    for (int row : tab.table.getSelectedRows()) {
                        toKill.add(((ZonesTableModel)tab.model).getZones().get(tab.table.convertRowIndexToModel(row)));
                    }
                    wellInterp.deleteZones(tab.well, toKill);
                    this.sbdb.commit();
                    Object object = toKill.iterator();
                    while (object.hasNext()) {
                        IGDIntervalZone zone = (IGDIntervalZone)object.next();
                        if (arg == null || arg instanceof IGDIntervalZone && ((IGDInterval)arg).getIGDType() == zone.getIGDType() && (zone.getIGDType() != 4 || ((IGDIntervalZone)arg).getSchID() == zone.getSchID())) {
                            arg = zone;
                            continue;
                        }
                        arg = zone.getIGDType();
                    }
                    break;
                }
                case 10: {
                    LinkedList<SQPick> picksToKill = new LinkedList<SQPick>();
                    for (int row : tab.table.getSelectedRows()) {
                        picksToKill.add((SQPick)((SQPickTableModel)tab.model).getItems().get(tab.table.convertRowIndexToModel(row)));
                    }
                    wellInterp.delete(picksToKill, tab.well.getWellID());
                    this.sbdb.commit();
                    if (picksToKill.isEmpty()) break;
                    arg = picksToKill.get(0);
                    break;
                }
                case 20: {
                    LinkedList<WellEvent> eventsToKill = new LinkedList<WellEvent>();
                    for (int row : tab.table.getSelectedRows()) {
                        eventsToKill.add(((EventsTableModel)tab.model).events.get(tab.table.convertRowIndexToModel(row)));
                    }
                    wellInterp.deleteEvents(eventsToKill, tab.well.getWellID());
                    this.sbdb.commit();
                    break;
                }
                case 19: {
                    LinkedList<Biocom> biocomsToKill = new LinkedList<Biocom>();
                    for (int row : tab.table.getSelectedRows()) {
                        biocomsToKill.add(((BiocomTableModel)tab.model).comments.get(tab.table.convertRowIndexToModel(row)));
                    }
                    wellInterp.deleteBiocoms(biocomsToKill, tab.well.getWellID());
                    this.sbdb.commit();
                    arg = biocomsToKill.get(0);
                    break;
                }
                case 5: {
                    LinkedList<IGDIntervalEnv> envsToKill = new LinkedList<IGDIntervalEnv>();
                    for (int row : tab.table.getSelectedRows()) {
                        envsToKill.add(((EnvTableModel)tab.model).envs.get(tab.table.convertRowIndexToModel(row)));
                    }
                    wellInterp.deleteEnvs(envsToKill, tab.well.getWellID());
                    this.sbdb.commit();
                }
            }
            tab.table.clearSelection();
            wellInterp.notifyObservers(arg);
        }
        catch (SQLException | SBPermissionException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/resources/icon/FrameSamples_IntTab.png")));
        this.setMinimumSize(new Dimension(200, 200));
        this.setVisible(true);
        this.addInternalFrameListener(new InternalFrameListener(this){
            final /* synthetic */ InternalFrameIGD this$0;
            {
                InternalFrameIGD internalFrameIGD = this$0;
                Objects.requireNonNull(internalFrameIGD);
                this.this$0 = internalFrameIGD;
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                this.this$0.internalFrameClosed(evt);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPane, -1, 382, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPane, -1, 285, Short.MAX_VALUE));
        this.pack();
    }

    private void internalFrameClosed(InternalFrameEvent evt) {
        System.out.println("Internal frame deleting observers...");
        for (Component c : this.jTabbedPane.getComponents()) {
            if (!(c instanceof WellTab)) continue;
            try {
                ((WellTab)c).well.getInterp(this.interpID).deleteObserver((WellTab)c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void setUnits(char units) {
        for (Component c : this.jTabbedPane.getComponents()) {
            if (!(c instanceof WellTab)) continue;
            WellTab tab = (WellTab)c;
            if (units == 'D') {
                units = tab.well.getWellUnits();
            }
            tab.model.setUnits(units);
            tab.model.fireTableDataChanged();
        }
    }

    private class WellTab
    extends JScrollPane
    implements Observer {
        final Well well;
        final JTable table;
        final TableModelSB model;
        final /* synthetic */ InternalFrameIGD this$0;

        WellTab(InternalFrameIGD internalFrameIGD, Well well) throws SQLException, SBException {
            InternalFrameIGD internalFrameIGD2 = internalFrameIGD;
            Objects.requireNonNull(internalFrameIGD2);
            this.this$0 = internalFrameIGD2;
            this.well = well;
            well.loadInterps();
            WellInterp wellInterp = well.getAddInterp(internalFrameIGD.sbdb.getInterp(internalFrameIGD.interpID));
            well.loadInterp(wellInterp);
            switch (internalFrameIGD.igdType) {
                case 2: 
                case 3: 
                case 4: {
                    this.model = new ZonesTableModel();
                    ((ZonesTableModel)this.model).setZones(wellInterp.getIGDList(internalFrameIGD.igdType, 0), well);
                    break;
                }
                case 10: {
                    this.model = new SQPickTableModel();
                    ((SQPickTableModel)this.model).setItems(wellInterp.getInterpListViewer(21));
                    break;
                }
                case 20: {
                    this.model = new EventsTableModel();
                    ((EventsTableModel)this.model).events = wellInterp.getEvents();
                    break;
                }
                case 19: {
                    this.model = new BiocomTableModel();
                    ((BiocomTableModel)this.model).comments = wellInterp.getComments();
                    break;
                }
                case 5: {
                    this.model = new EnvTableModel();
                    ((EnvTableModel)this.model).envs = wellInterp.getEnvs();
                    break;
                }
                default: {
                    throw new SBException("Unknown IGD Type for well tab: " + internalFrameIGD.igdType);
                }
            }
            this.table = new JTable(this.model);
            this.table.setRowSorter(new TableRowSorter<TableModelSB>(this.model));
            new ColumnSortResetHandler(this.table).attach();
            this.model.setupTable(this.table, internalFrameIGD.sbdb);
            this.table.setAutoResizeMode(4);
            this.table.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ WellTab this$1;
                {
                    WellTab wellTab = this$1;
                    Objects.requireNonNull(wellTab);
                    this.this$1 = wellTab;
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() > 1) {
                        this.this$1.this$0.editInterval();
                    }
                }
            });
            this.table.addKeyListener(new KeyAdapter(this){
                final /* synthetic */ WellTab this$1;
                {
                    WellTab wellTab = this$1;
                    Objects.requireNonNull(wellTab);
                    this.this$1 = wellTab;
                }

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 127) {
                        this.this$1.this$0.deleteIntervals();
                    }
                }
            });
            this.getViewport().add(this.table);
            this.setViewportView(this.table);
            if (FrameJsbugs.isMacPlatform()) {
                this.setHorizontalScrollBarPolicy(32);
                this.setVerticalScrollBarPolicy(22);
            }
            this.model.fireTableDataChanged();
            wellInterp.addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            if (o instanceof WellInterp) {
                switch (this.this$0.igdType) {
                    case 2: 
                    case 3: 
                    case 4: {
                        if (arg instanceof IGDIntervalZone && ((IGDIntervalZone)arg).getIGDType() == this.this$0.igdType) break;
                        return;
                    }
                    case 10: {
                        if (arg instanceof SQPick) break;
                        return;
                    }
                    case 20: {
                        if (arg instanceof WellEvent) break;
                        return;
                    }
                    case 5: {
                        if (arg instanceof IGDIntervalEnv) break;
                        return;
                    }
                    case 19: {
                        if (arg instanceof Biocom) break;
                        return;
                    }
                    default: {
                        assert (false);
                        return;
                    }
                }
                this.model.fireTableDataChanged();
            }
        }
    }
}

