/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbchart.core.PanelTemplate;
import jsbugs.DialogList;
import jsbugs.DialogPermissions;
import jsbugs.DialogTable;
import jsbugs.DialogTxGroup;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.InternalFrameGroup;
import jsbugs.TableModelPanelTemplates;
import jsbugs.table.ColourRenderer;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.util.UserPrefsHelper;
import model3.SBChart;
import model3.SBRestrictable;
import model3.SBdb;
import model3.TxGroup;
import model3.TxGroupSet;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class JPanelGroups
extends JPanel
implements Observer {
    private static final int COL_NAME = 0;
    private static final int COL_PROJECT = 1;
    private static final int COL_COLOUR = 2;
    private static final String[] COL_TITLES = new String[]{"Group", "Project", "Colour"};
    private static final int[] COL_WIDTHS = new int[]{130, 75, 50};
    private final SBdb sbdb;
    private final FrameTaxaDB parent;
    private final PanelGroupsTableModel modelGroup = new PanelGroupsTableModel(this);
    private Discipline discFilter;
    private TableColumn projectColumn;
    private JMenuItem jMenuItemColour;
    private JMenuItem jMenuItemGroupDelete;
    private JMenuItem jMenuItemGroupEdit;
    private JMenuItem jMenuItemGroupPermissions;
    private JMenuItem jMenuItemGroupUsages;
    private JMenuItem jMenuItemShowCharts;
    private JPopupMenu jPopupMenuGroups;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JTable jTableGroup;

    public JPanelGroups(FrameTaxaDB parent, SBdb db) throws SQLException {
        this.initComponents();
        this.parent = parent;
        this.sbdb = db;
        this.init();
    }

    private void init() throws SQLException {
        this.modelGroup.setupTable(this.jTableGroup);
        this.jTableGroup.setRowSorter(new TableRowSorter<PanelGroupsTableModel>(this.modelGroup));
        new ColumnSortResetHandler(this.jTableGroup).attach();
        this.hideProjectColumn();
        this.sbdb.addObserver(this);
        if (!SBRestrictable.canWrite(this.sbdb)) {
            this.jMenuItemGroupDelete.setEnabled(false);
        }
    }

    public void hideProjectColumn() {
        this.projectColumn = this.jTableGroup.getColumnModel().getColumn(1);
        this.jTableGroup.getColumnModel().removeColumn(this.projectColumn);
    }

    public void showProjectColumn() {
        this.jTableGroup.getColumnModel().addColumn(this.projectColumn);
        this.jTableGroup.moveColumn(this.jTableGroup.getColumnCount() - 1, 1);
    }

    void loadGroups() throws SQLException {
        ArrayList<TxGroup> groups = new ArrayList<TxGroup>();
        if (this.parent.showAllProjects()) {
            groups.addAll(this.sbdb.getTxGroups());
        } else {
            groups.addAll(this.sbdb.getTxGroups(this.parent.getProjID(), this.parent.showGlobal()));
        }
        if (this.discFilter != null) {
            ListIterator it = groups.listIterator();
            while (it.hasNext()) {
                TxGroup group = (TxGroup)it.next();
                if (group.getDiscipline(this.sbdb) == this.discFilter) continue;
                it.remove();
            }
        }
        Collections.sort(groups, new TxGroupComparator());
        this.modelGroup.rows.clear();
        for (TxGroup g : groups) {
            int projectId = g.getProjID();
            String projectName = "Global";
            if (projectId > 0) {
                projectName = this.sbdb.getProject(g.getProjID()).getName();
            }
            this.modelGroup.rows.add(new PanelGroupsTableRow(this, g, projectName));
        }
        this.modelGroup.fireTableDataChanged();
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obs == this.sbdb && obj instanceof TxGroup) {
            TxGroup group = (TxGroup)obj;
            if (!this.parent.isProjectCurrentlyVisible(group.getProjID())) {
                return;
            }
            try {
                this.loadGroups();
                int index = -1;
                if (obj instanceof TxGroup) {
                    index = this.modelGroup.getRowIndexOf((TxGroup)obj);
                }
                if (index >= 0) {
                    index = this.jTableGroup.convertRowIndexToView(index);
                    this.jTableGroup.setRowSelectionInterval(index, index);
                }
                this.modelGroup.fireTableDataChanged();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error loading groups", sql, this.sbdb);
            }
        }
    }

    private int getRowOf(Object o) {
        int modelIndex = -1;
        if (o instanceof TxGroup) {
            modelIndex = this.modelGroup.getRowIndexOf((TxGroup)o);
        }
        if (modelIndex >= 0) {
            return this.jTableGroup.convertRowIndexToView(modelIndex);
        }
        return -1;
    }

    TxGroup getSelectedGroup() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            return null;
        }
        return this.modelGroup.rows.get(this.jTableGroup.convertRowIndexToModel(this.jTableGroup.getSelectedRow())).getGroup();
    }

    void editGroupColour() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to edit", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.getSelectedGroup();
        try {
            Color colour = JColorChooser.showDialog(this, "Select Group Colour", group.getColour());
            if (colour != null && !colour.equals(group.getColour())) {
                group.setColour(colour);
                this.sbdb.commit();
                this.modelGroup.fireTableRowsUpdated(this.jTableGroup.getSelectedRow(), this.jTableGroup.getSelectedRow());
                this.modelGroup.fireTableDataChanged();
                this.selectGroup(group);
            }
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            FrameJsbugs.showStackError("SQL Error saving group colour", (Exception)sql, this.sbdb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showLegacyCharts() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.getSelectedGroup();
        LinkedList<SBChart> groupCharts = new LinkedList<SBChart>();
        try {
            this.parent.setCursor(Cursor.getPredefinedCursor(3));
            this.setCursor(Cursor.getPredefinedCursor(3));
            LinkedList charts = new LinkedList();
            SBChart.load(this.sbdb, charts, "%");
            for (SBChart chart : charts) {
                chart.loadData();
                if (!chart.hasGroup(group.getID())) continue;
                groupCharts.add(chart);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.parent.setCursor(Cursor.getDefaultCursor());
        }
        if (!groupCharts.isEmpty()) {
            DialogList.displayListDialog(this.parent, "Charts containing group: " + group.toString(), new UserPrefsHelper(this.sbdb), groupCharts, null);
        } else {
            JOptionPane.showMessageDialog(this.parent, "Group does not appear in any charts.", group.getName(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteGroup() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to delete", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.getSelectedGroup();
        try {
            if (!group.canWrite(this.sbdb, null)) {
                JOptionPane.showMessageDialog(this, group.getDeniedReason(this.sbdb, "group", false), this.parent.getTitle(), 2);
                return;
            }
            List<String> sets = group.getSets();
            if (!sets.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Group belongs to sets - remove group from the following set(s) first. ", this.parent.getTitle(), 0);
                DialogList.displayListDialog(this.parent, group.toString(), new UserPrefsHelper(this.sbdb), sets, null);
                return;
            }
            if (!this.parent.parent.getChartManager().checkDeleteTxGroup(group.getID())) {
                JOptionPane.showMessageDialog(this, "Group is used in charts and cannot be deleted.", "Delete Group", 2);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Really delete group: " + group.getName() + "?", this.parent.getTitle(), 0, 3) != 0) {
                return;
            }
            int opt = JOptionPane.showConfirmDialog(this, "Check legacy charts for this group?", this.parent.getTitle(), 1, 3);
            if (opt == 2 || opt == -1) {
                return;
            }
            if (opt == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                LinkedList<SBChart> groupCharts = new LinkedList<SBChart>();
                LinkedList charts = new LinkedList();
                SBChart.load(this.sbdb, charts, "%");
                for (SBChart chart : charts) {
                    chart.loadData();
                    if (!chart.hasGroup(group.getID())) continue;
                    groupCharts.add(chart);
                }
                if (!groupCharts.isEmpty()) {
                    DialogList.displayListDialog(this.parent, "Charts containing group: " + group.toString(), new UserPrefsHelper(this.sbdb), groupCharts, null);
                    return;
                }
                if (JOptionPane.showConfirmDialog(this, "Group not linked to charts.\nContinue to delete?", this.parent.getTitle(), 0, 3) != 0) {
                    return;
                }
            }
            this.sbdb.deleteTxGroup(group);
            this.sbdb.commit();
            this.jTableGroup.clearSelection();
            this.jTableGroup.repaint();
            this.parent.removeInternalFrameGroup(group);
        }
        catch (SQLException | SBException | SBPermissionException sbe) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", (Exception)sbe, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void permissions() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.getSelectedGroup();
        try {
            DialogPermissions dialog = new DialogPermissions(this.parent, true, this.sbdb, (SBRestrictable)group, null);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            dialog.setVisible(true);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
    }

    void addGroup() throws SQLException, SBException, SBPermissionException {
        DialogTxGroup dialog;
        try {
            dialog = new DialogTxGroup(this.parent, true, null, this.sbdb, this.parent.getProjID() > 0 ? this.sbdb.getProject(this.parent.getProjID()) : null);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error opening dialog", sql, this.sbdb);
            return;
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        String reason = this.sbdb.isTxGroupNameAllowed(dialog.name, dialog.projID);
        if (reason != null) {
            JOptionPane.showMessageDialog(this, reason, this.parent.getTitle(), 2);
            return;
        }
        if (!this.parent.isProjectCurrentlyVisible(dialog.projID)) {
            this.parent.setProject(dialog.projID);
        }
        TxGroup group = this.sbdb.addTxGroup(dialog.name, null, 0, dialog.projID, dialog.colour);
        this.sbdb.commit();
        if (!this.selectGroup(group)) {
            this.openGroup(group);
        }
    }

    private boolean selectGroup(TxGroup group) {
        int index = this.getRowOf(group);
        if (index < 0) {
            return false;
        }
        this.jTableGroup.setRowSelectionInterval(index, index);
        this.jTableGroup.scrollRectToVisible(this.jTableGroup.getCellRect(index, 0, true));
        this.jTableGroup.repaint();
        return true;
    }

    void editGroup() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to edit", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.getSelectedGroup();
        this.openGroup(group);
    }

    private void openGroup(TxGroup group) {
        try {
            InternalFrameGroup frame = this.parent.getGroupFrame(group);
            if (frame != null) {
                frame.setVisible(true);
                frame.setLocation(50, 50);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.parent.createInternalFrameGroup(group);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void editGroupHeader() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to edit", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.getSelectedGroup();
        try {
            boolean projChange;
            DialogTxGroup dialog = new DialogTxGroup(this.parent, true, group, this.sbdb, group.getProjID() > 0 ? this.sbdb.getProject(group.getProjID()) : null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                return;
            }
            String reason = "A group with that name already exists";
            if (!dialog.name.equalsIgnoreCase(group.getName()) && (reason = this.sbdb.isTxGroupNameAllowed(dialog.name, dialog.projID)) != null) {
                JOptionPane.showMessageDialog(this, reason, "Edit group", 2);
                return;
            }
            boolean bl = projChange = dialog.projID != group.getProjID();
            if (projChange && dialog.projID > 0) {
                ArrayList<TxGroupSet> memberSets = new ArrayList<TxGroupSet>();
                for (TxGroupSet set : this.sbdb.getTxGroupSets(group)) {
                    if (set.getProjID() <= 0 || set.getProjID() == dialog.projID) continue;
                    memberSets.add(set);
                }
                if (!memberSets.isEmpty()) {
                    String msg = "You cannot change the project because this group belongs to project group set" + (memberSets.size() > 1 ? "s:" : ":");
                    for (TxGroupSet set : memberSets) {
                        msg = msg + "\n" + set.getName();
                    }
                    JOptionPane.showMessageDialog(this, msg, "Edit group", 2);
                    return;
                }
                if (!this.parent.parent.getChartManager().checkTxGroupProjChange(group.getID(), dialog.projID)) {
                    JOptionPane.showMessageDialog(this, "You cannot change the project because this group is used in project charts", "Edit group", 2);
                    return;
                }
            }
            group.updateDetails(dialog.name, dialog.colour, dialog.projID, dialog.descr);
            this.sbdb.commit();
            if (projChange && !this.parent.isProjectCurrentlyVisible(group.getProjID())) {
                this.parent.setProject(group.getProjID());
            } else if (projChange) {
                this.loadGroups();
            }
            this.modelGroup.fireTableDataChanged();
            this.selectGroup(group);
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            FrameJsbugs.showStackError("SQL Error updating group name", (Exception)sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    void setSelectedGroup(TxGroup group) {
        if (this.getSelectedGroup() == group) {
            return;
        }
        for (int row = 0; row < this.modelGroup.getRowCount(); ++row) {
            if (this.jTableGroup.getValueAt(row, 0) != group) continue;
            this.jTableGroup.setRowSelectionInterval(row, row);
        }
    }

    void showChartUsages() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.getSelectedGroup();
        try {
            List<PanelTemplate> panels = this.parent.parent.getChartManager().getTxGroupPanels(group.getID());
            if (panels.isEmpty()) {
                JOptionPane.showMessageDialog(this.parent, "This group is not used in any chart panels.", "Group Usage", 2);
                return;
            }
            TableModelPanelTemplates model = new TableModelPanelTemplates(this.sbdb, this.parent.parent.getChartManager());
            model.setTemplates(panels);
            DialogTable dialog = new DialogTable(this.parent, true, (AbstractTableModel)model, "Chart Panels Using Group : " + group.getName(), false);
            model.setupTable(dialog.getTable());
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void initComponents() {
        this.jPopupMenuGroups = new JPopupMenu();
        this.jMenuItemGroupEdit = new JMenuItem();
        this.jMenuItemColour = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemGroupDelete = new JMenuItem();
        this.jMenuItemGroupPermissions = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemGroupUsages = new JMenuItem();
        this.jMenuItemShowCharts = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jTableGroup = new JTable();
        this.jMenuItemGroupEdit.setText("Edit details...");
        this.jMenuItemGroupEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelGroups this$0;
            {
                JPanelGroups jPanelGroups = this$0;
                Objects.requireNonNull(jPanelGroups);
                this.this$0 = jPanelGroups;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGroupEditActionPerformed(evt);
            }
        });
        this.jPopupMenuGroups.add(this.jMenuItemGroupEdit);
        this.jMenuItemColour.setText("Edit group colour");
        this.jMenuItemColour.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelGroups this$0;
            {
                JPanelGroups jPanelGroups = this$0;
                Objects.requireNonNull(jPanelGroups);
                this.this$0 = jPanelGroups;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemColourActionPerformed(evt);
            }
        });
        this.jPopupMenuGroups.add(this.jMenuItemColour);
        this.jPopupMenuGroups.add(this.jSeparator1);
        this.jMenuItemGroupDelete.setText("Delete");
        this.jMenuItemGroupDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelGroups this$0;
            {
                JPanelGroups jPanelGroups = this$0;
                Objects.requireNonNull(jPanelGroups);
                this.this$0 = jPanelGroups;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGroupDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuGroups.add(this.jMenuItemGroupDelete);
        this.jMenuItemGroupPermissions.setText("Permissions...");
        this.jMenuItemGroupPermissions.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelGroups this$0;
            {
                JPanelGroups jPanelGroups = this$0;
                Objects.requireNonNull(jPanelGroups);
                this.this$0 = jPanelGroups;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGroupPermissionsActionPerformed(evt);
            }
        });
        this.jPopupMenuGroups.add(this.jMenuItemGroupPermissions);
        this.jPopupMenuGroups.add(this.jSeparator2);
        this.jMenuItemGroupUsages.setText("Show chart panels...");
        this.jMenuItemGroupUsages.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelGroups this$0;
            {
                JPanelGroups jPanelGroups = this$0;
                Objects.requireNonNull(jPanelGroups);
                this.this$0 = jPanelGroups;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemGroupUsagesActionPerformed(evt);
            }
        });
        this.jPopupMenuGroups.add(this.jMenuItemGroupUsages);
        this.jMenuItemShowCharts.setText("Show legacy charts...");
        this.jMenuItemShowCharts.setToolTipText("Show which charts include a reference to selected group");
        this.jMenuItemShowCharts.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelGroups this$0;
            {
                JPanelGroups jPanelGroups = this$0;
                Objects.requireNonNull(jPanelGroups);
                this.this$0 = jPanelGroups;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemShowChartsActionPerformed(evt);
            }
        });
        this.jPopupMenuGroups.add(this.jMenuItemShowCharts);
        this.setMaximumSize(new Dimension(600, Short.MAX_VALUE));
        this.setMinimumSize(new Dimension(0, 200));
        this.setPreferredSize(new Dimension(100, 436));
        this.jScrollPane1.setPreferredSize(new Dimension(100, 402));
        this.jTableGroup.setModel(this.modelGroup);
        this.jTableGroup.setSelectionMode(0);
        this.jTableGroup.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelGroups this$0;
            {
                JPanelGroups jPanelGroups = this$0;
                Objects.requireNonNull(jPanelGroups);
                this.this$0 = jPanelGroups;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jTableGroupMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jTableGroupMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableGroupMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableGroup);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 80, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 425, Short.MAX_VALUE).addContainerGap()));
    }

    private void jTableGroupMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.editGroup();
        }
    }

    private void jMenuItemGroupEditActionPerformed(ActionEvent evt) {
        this.editGroupHeader();
    }

    private void jTableGroupMouseReleased(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    private void jTableGroupMousePressed(MouseEvent evt) {
        this.evaluatePopup(evt);
    }

    private void evaluatePopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            int rowNumber = this.jTableGroup.rowAtPoint(evt.getPoint());
            this.jTableGroup.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
            Point mousePoint = evt.getPoint();
            this.jPopupMenuGroups.show(evt.getComponent(), (int)mousePoint.getX(), (int)mousePoint.getY());
        }
    }

    private void jMenuItemColourActionPerformed(ActionEvent evt) {
        this.editGroupColour();
    }

    private void jMenuItemGroupDeleteActionPerformed(ActionEvent evt) {
        this.deleteGroup();
    }

    private void jMenuItemGroupPermissionsActionPerformed(ActionEvent evt) {
        this.permissions();
    }

    private void jMenuItemGroupUsagesActionPerformed(ActionEvent evt) {
        this.showChartUsages();
    }

    private void jMenuItemShowChartsActionPerformed(ActionEvent evt) {
        this.showLegacyCharts();
    }

    public void setDiscFilter(Discipline discFilter) throws SQLException {
        if (discFilter != this.discFilter) {
            this.discFilter = discFilter;
            this.loadGroups();
            this.modelGroup.setColumnTitles();
        }
    }

    private class PanelGroupsTableModel
    extends AbstractTableModel {
        List<PanelGroupsTableRow> rows;
        final /* synthetic */ JPanelGroups this$0;

        private PanelGroupsTableModel(JPanelGroups jPanelGroups) {
            JPanelGroups jPanelGroups2 = jPanelGroups;
            Objects.requireNonNull(jPanelGroups2);
            this.this$0 = jPanelGroups2;
            this.rows = new ArrayList<PanelGroupsTableRow>();
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            PanelGroupsTableRow tableRow = this.rows.get(row);
            if (tableRow == null) {
                return null;
            }
            switch (col) {
                case 0: {
                    return tableRow.getGroup();
                }
                case 1: {
                    return tableRow.getProjectName();
                }
                case 2: {
                    return tableRow.getGroup().getColour();
                }
            }
            return null;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return TxGroup.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Color.class;
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return false;
                }
                case 2: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            PanelGroupsTableRow tableRow = this.rows.get(row);
            if (tableRow == null) {
                return;
            }
            switch (col) {
                case 2: {
                    try {
                        tableRow.getGroup().setColour((Color)obj);
                        this.this$0.sbdb.commit();
                        break;
                    }
                    catch (SBPermissionException pe) {
                        JOptionPane.showMessageDialog(this.this$0.parent, pe.getMessage(), "Permission Error", 2);
                        break;
                    }
                    catch (SBException e) {
                        JOptionPane.showMessageDialog(this.this$0.parent, e.getMessage(), "Error", 2);
                        break;
                    }
                    catch (SQLException sql) {
                        FrameJsbugs.showStackError("SQL Error saving colour", sql, this.this$0.sbdb);
                    }
                }
            }
        }

        void setColumnTitles() {
            TableColumnModel columnModel = this.this$0.jTableGroup.getColumnModel();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                Object suffix = "";
                if (i == 0 && this.this$0.discFilter != null) {
                    suffix = " (" + this.this$0.discFilter.getAdj().toLowerCase() + ")";
                }
                columnModel.getColumn(i).setHeaderValue(COL_TITLES[i] + (String)suffix);
            }
        }

        void setupTable(JTable jTableGroup) {
            this.setColumnTitles();
            TableColumnModel columnModel = jTableGroup.getColumnModel();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                columnModel.getColumn(i).setPreferredWidth(COL_WIDTHS[i]);
            }
            columnModel.getColumn(2).setMaxWidth(COL_WIDTHS[2]);
            columnModel.getColumn(2).setMinWidth(COL_WIDTHS[2]);
            SB.setTableHeaderBold((JTable)jTableGroup);
            jTableGroup.setDefaultRenderer(Color.class, new ColourRenderer(true));
            jTableGroup.setDefaultRenderer(TxGroup.class, new DefaultTableCellRenderer(this){
                final /* synthetic */ PanelGroupsTableModel this$1;
                {
                    PanelGroupsTableModel panelGroupsTableModel = this$1;
                    Objects.requireNonNull(panelGroupsTableModel);
                    this.this$1 = panelGroupsTableModel;
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    block5: {
                        if (value instanceof TxGroup) {
                            TxGroup group = (TxGroup)value;
                            try {
                                if (group.getProjID() > 0) {
                                    this.setIcon(group.isReadOnly() ? IconFactory.getIconProjectLocked() : IconFactory.getIconProjectUnlocked());
                                    break block5;
                                }
                                this.setIcon(group.isReadOnly() ? IconFactory.getIconGlobalLocked() : IconFactory.getIconGlobalUnlocked());
                            }
                            catch (SBException sbe) {
                                sbe.printStackTrace();
                                this.setIcon(null);
                            }
                        } else {
                            this.setIcon(null);
                        }
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            });
        }

        public int getRowIndexOf(TxGroup group) {
            for (int i = 0; i < this.rows.size(); ++i) {
                PanelGroupsTableRow row = this.rows.get(i);
                if (!Objects.equals(group, row.group)) continue;
                return i;
            }
            return -1;
        }
    }

    static class TxGroupComparator
    implements Comparator<TxGroup> {
        TxGroupComparator() {
        }

        @Override
        public int compare(TxGroup o1, TxGroup o2) {
            if (o1.getProjID() == 0 && o2.getProjID() == 0) {
                return o1.compareTo(o2);
            }
            if (o1.getProjID() == 0) {
                return -1;
            }
            if (o2.getProjID() == 0) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    private class PanelGroupsTableRow {
        private TxGroup group;
        private String projectName;

        public PanelGroupsTableRow(JPanelGroups jPanelGroups, TxGroup group, String projectName) {
            Objects.requireNonNull(jPanelGroups);
            this.group = group;
            this.projectName = projectName;
        }

        public TxGroup getGroup() {
            return this.group;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

